/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBVariation;
import com.agentpp.smi.IVariation;
import com.agentpp.smi.ext.SMIImplementationSpec;
import com.agentpp.smi.ext.SMIVariation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;

public class MIBSupportedModule
implements Serializable,
SMIImplementationSpec {
    public static final long serialVersionUID = 1000L;
    protected String supports = null;
    protected Vector includes = new Vector();
    protected Vector variations = new Vector();
    protected transient Object userObject;

    public MIBSupportedModule() {
    }

    public MIBSupportedModule(String moduleName) {
        this.supports = moduleName;
    }

    public MIBSupportedModule(MIBSupportedModule other) {
        if (other.supports != null) {
            this.supports = new String(other.supports);
        }
        Enumeration en = other.includes.elements();
        while (en.hasMoreElements()) {
            this.includes.addElement(new String(en.nextElement().toString()));
        }
        en = other.variations.elements();
        while (en.hasMoreElements()) {
            this.variations.addElement(new MIBVariation((MIBVariation)en.nextElement()));
        }
    }

    public String getSupports() {
        return this.supports;
    }

    public void setSupports(String newSupports) {
        this.supports = newSupports;
    }

    public final void setIncludes(Vector newIncludes) {
        this.includes = newIncludes;
    }

    public final Vector getIncludes() {
        return this.includes;
    }

    public final String[] getIncludedGroups() {
        Object[] s = new String[this.includes.size()];
        this.includes.copyInto(s);
        return s;
    }

    public final void setIncludedGroups(String[] includedGroups) {
        this.includes = new Vector<String>(Arrays.asList(includedGroups));
    }

    public final boolean hasVariations() {
        return this.variations.size() > 0;
    }

    public final void setVariations(Vector newVariations) {
        this.variations = newVariations;
    }

    public final Vector getVariationsVector() {
        return this.variations;
    }

    public final void setVariations(SMIVariation[] variations) {
        this.variations = new Vector<SMIVariation>(Arrays.asList(variations));
    }

    public final IVariation[] getVariations() {
        Object[] v = new MIBVariation[this.variations.size()];
        this.variations.copyInto(v);
        return v;
    }

    public String toSMI(int mode, MIBRepository rep, MIBSupportedModule c2, String lineSeparator) {
        StringBuffer buf = new StringBuffer();
        buf.append(lineSeparator);
        buf.append(lineSeparator);
        buf.append("\t");
        MIBObject.addKeyWord(mode, buf, "SUPPORTS ");
        MIBObject.addString(mode, buf, this.supports, c2 == null ? null : c2.supports);
        buf.append(lineSeparator);
        buf.append("\t");
        MIBObject.addKeyWord(mode, buf, "INCLUDES");
        buf.append(" {");
        buf.append(lineSeparator);
        MIBObject.addString(mode, buf, MIBObject.formatObjectRefs(mode, "\t\t", this.includes.iterator(), lineSeparator), c2 == null ? null : MIBObject.formatObjectRefs(mode, "\t\t", c2.includes.iterator(), lineSeparator));
        buf.append(" }");
        buf.append(lineSeparator);
        if (this.variations.size() > 0) {
            Enumeration cen = null;
            if (c2 != null) {
                cen = c2.variations != null && c2.variations.size() > 0 ? c2.variations.elements() : new Vector().elements();
            }
            Enumeration en = this.variations.elements();
            while (en.hasMoreElements()) {
                MIBVariation v = (MIBVariation)en.nextElement();
                MIBVariation cv = null;
                if (cen != null) {
                    cv = cen.hasMoreElements() ? (MIBVariation)cen.nextElement() : new MIBVariation();
                }
                buf.append(v.toSMI(mode, rep, cv, lineSeparator));
            }
        }
        return buf.toString();
    }

    public String toString() {
        return this.supports;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public boolean equals(Object o2) {
        if (o2 instanceof MIBSupportedModule) {
            MIBSupportedModule other = (MIBSupportedModule)o2;
            return MIBObject.saveCompare(this.supports, other.supports) && MIBObject.saveCompare(this.includes, other.includes) && MIBObject.saveCompare(this.variations, other.variations);
        }
        return false;
    }

    public void freeUserObjects() {
        this.userObject = null;
        for (MIBVariation item : this.variations) {
            item.freeUserObjects();
        }
    }
}

