/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.LexicographicPredicate;
import com.agentpp.mib.MIBAgentCaps;
import com.agentpp.mib.MIBCompliance;
import com.agentpp.mib.MIBComplianceModule;
import com.agentpp.mib.MIBEnum;
import com.agentpp.mib.MIBGroup;
import com.agentpp.mib.MIBImport;
import com.agentpp.mib.MIBIndexPart;
import com.agentpp.mib.MIBNotifyType;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectOrderComparator;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBRevision;
import com.agentpp.mib.MIBSupportedModule;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.MIBVariation;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.mib.ObjectIDPredicate;
import com.agentpp.mib.util.EnumerationIterator;
import com.agentpp.smi.IImport;
import com.agentpp.smi.IModule;
import com.agentpp.smi.IObject;
import com.agentpp.smi.IRevision;
import com.agentpp.smi.ext.SMIModule;
import com.agentpp.smiparser.SMI;
import com.objectspace.jgl.OrderedMap;
import com.objectspace.jgl.Pair;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIBModule
extends MIBObject
implements Serializable,
SMIModule {
    public static final long serialVersionUID = 1000L;
    protected String pathName = null;
    protected String moduleName;
    protected Vector<MIBRevision> revisions = null;
    protected Vector<MIBImport> imports = null;
    protected String organization;
    protected String lastUpdated;
    protected String contactInfo;
    protected Date lastChange = null;
    protected int smiVersion = 1;
    protected String copyrightComment;
    protected String copyrightCommentEnd;
    protected transient Map<String, MIBObject> objects = null;
    protected int parseMode = 0;
    protected transient int startPosition = 0;
    private static final String[] STANDARD_MIBS = new String[]{"SNMPv2-SMI", "SNMPv2-TC", "SNMPv2-CONF", "RFC1155-SMI", "RFC1215"};

    public MIBModule() {
        this.objects = new ConcurrentHashMap<String, MIBObject>();
    }

    public MIBModule(String newModuleName, Integer newModuleID) {
        this();
        this.moduleName = newModuleName;
        this.moduleID = newModuleID;
    }

    public MIBModule(ObjectID oid, String name) {
        super(oid, name);
        this.objects = new ConcurrentHashMap<String, MIBObject>();
    }

    public MIBModule(IModule other) {
        super(other);
        this.moduleName = other.getModuleName();
        this.revisions = new Vector<IRevision>(Arrays.asList(other.getRevisions()));
        if (other.hasImports()) {
            IImport[] imp = other.getImports();
            for (int i2 = 0; i2 < imp.length; ++i2) {
                this.addImport(new MIBImport(imp[i2].getSource(), new Vector<String>(Arrays.asList(imp[i2].getImports())), imp[i2].getComment()));
            }
        }
        this.organization = other.getOrganization();
        this.lastChange = new Date();
        this.lastUpdated = other.getLastUpdated();
        this.contactInfo = other.getContactInfo();
        this.smiVersion = other.getSMIVersion();
        this.moduleID = other.getModuleID();
        this.copyrightComment = other.getCopyrightComment();
        this.copyrightCommentEnd = other.getCopyrightCommentEnd();
        this.objects = new ConcurrentHashMap<String, MIBObject>();
        Enumeration en = other.objects();
        while (en.hasMoreElements()) {
            IObject o2 = (IObject)en.nextElement();
            if (!(o2 instanceof MIBObject)) continue;
            this.objects.put(o2.getName(), (MIBObject)o2);
        }
        if (this.objects.containsKey(other.getName())) {
            this.objects.remove(other.getName());
            this.add(this);
        }
    }

    public MIBModule(MIBModule other) {
        super(other);
        this.pathName = other.pathName;
        this.moduleName = other.moduleName;
        this.revisions = other.revisions;
        if (other.hasImports()) {
            Enumeration<MIBImport> en = other.imports.elements();
            while (en.hasMoreElements()) {
                this.addImport(new MIBImport(en.nextElement()));
            }
        }
        this.organization = other.organization;
        this.lastChange = new Date(other.lastChange.getTime());
        this.lastUpdated = other.lastUpdated;
        this.contactInfo = other.contactInfo;
        this.smiVersion = other.smiVersion;
        this.moduleID = other.moduleID;
        this.copyrightComment = other.copyrightComment;
        this.copyrightCommentEnd = other.copyrightCommentEnd;
        this.objects = new HashMap<String, MIBObject>(other.objects);
        if (this.objects.containsKey(other.getName())) {
            this.objects.remove(other.getName());
            this.add(this);
        }
    }

    @Override
    public MIBObject getClone() {
        return new MIBModule(this);
    }

    @Override
    public int compareTo(Object o2) {
        MIBObject other = (MIBObject)o2;
        if (other instanceof MIBModule) {
            return this.getModuleName().compareTo(((MIBModule)other).getModuleName());
        }
        return super.compareTo(o2);
    }

    @Override
    public int size() {
        return this.objects.size();
    }

    @Override
    public String getTypeString() {
        return SMI.ENTRY_TYPES[5];
    }

    public void reinit() {
        this.objects = new ConcurrentHashMap<String, MIBObject>();
    }

    public void add(MIBObject o2) {
        this.objects.put(o2.getName(), o2);
    }

    public boolean remove(MIBObject o2) {
        return this.objects.remove(o2.getName()) != null;
    }

    public MIBObject get(ObjectID oid) {
        for (MIBObject o2 : this.objects.values()) {
            if (!o2.getOid().equals(oid)) continue;
            return o2;
        }
        return null;
    }

    @Override
    public IObject getObject(String objectName) {
        return this.getObjectByName(objectName);
    }

    @Override
    public IObject getObjectByOID(String oid) {
        return this.get(new ObjectID(oid));
    }

    public MIBObject getObjectByName(String objectName) {
        return this.objects.get(objectName);
    }

    @Override
    public int hashCode() {
        return this.moduleID.hashCode();
    }

    @Override
    public Enumeration objects() {
        return new EnumerationIterator(this.objects.values().iterator());
    }

    public Iterator<MIBObject> objectsIterator() {
        return this.objects.values().iterator();
    }

    @Override
    public OrderedMap objectsByOid() {
        return this.objectsByOid(false);
    }

    public OrderedMap objectsByOid(boolean returnDuplicates) {
        Iterator<MIBObject> iobjects = this.objects.values().iterator();
        OrderedMap omap = new OrderedMap(ObjectIDPredicate.instance, returnDuplicates);
        while (iobjects.hasNext()) {
            MIBObject o2 = iobjects.next();
            if (o2.getOid().isEmpty()) continue;
            omap.put(o2.getOid(), o2);
        }
        return omap;
    }

    @Override
    public OrderedMap objectsByName() {
        Iterator<MIBObject> iobjects = this.objects.values().iterator();
        OrderedMap omap = new OrderedMap(new LexicographicPredicate());
        while (iobjects.hasNext()) {
            MIBObject o2 = iobjects.next();
            omap.put(o2.getName(), o2);
        }
        return omap;
    }

    @Override
    public Vector<MIBObject> getObjectsVector() {
        Vector<MIBObject> v = new Vector<MIBObject>(this.objects.size());
        v.addAll(this.objects.values());
        return v;
    }

    public MIBObject[] getObjects() {
        Vector<MIBObject> v = this.getObjectsVector();
        Object[] o2 = new MIBObject[v.size()];
        v.copyInto(o2);
        return o2;
    }

    public void setObjectsVector(Vector objs) {
        this.objects = new ConcurrentHashMap<String, MIBObject>(objs.size());
        Enumeration en = objs.elements();
        while (en.hasMoreElements()) {
            MIBObject o2 = (MIBObject)en.nextElement();
            this.add(o2);
        }
    }

    @Override
    public void setModuleName(String newModuleName) {
        this.moduleName = newModuleName;
    }

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    public void setFileName(String name) {
        this.pathName = name;
    }

    public String getFileName() {
        return this.pathName;
    }

    public void addImport(MIBImport imp) {
        if (this.imports == null) {
            this.imports = new Vector(5);
        }
        this.imports.add(imp);
    }

    @Override
    public IImport[] getImports() {
        if (this.imports == null) {
            return null;
        }
        Object[] i2 = new MIBImport[this.imports.size()];
        this.imports.copyInto(i2);
        return i2;
    }

    @Override
    public boolean imports(String objectName) {
        if (!this.hasImports()) {
            return false;
        }
        Enumeration<MIBImport> en = this.imports.elements();
        while (en.hasMoreElements()) {
            MIBImport i2 = en.nextElement();
            if (!i2.imports(objectName)) continue;
            return true;
        }
        return false;
    }

    public boolean imports(String objectName, String moduleName) {
        if (!this.hasImports()) {
            return false;
        }
        Enumeration<MIBImport> en = this.imports.elements();
        while (en.hasMoreElements()) {
            MIBImport i2 = en.nextElement();
            if (!i2.imports(objectName) || !i2.getSource().equals(moduleName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getImportSources() {
        if (this.imports == null) {
            return new String[0];
        }
        String[] imp = new String[this.imports.size()];
        int i2 = 0;
        Enumeration<MIBImport> en = this.imports.elements();
        while (en.hasMoreElements()) {
            imp[i2] = en.nextElement().getSource();
            ++i2;
        }
        return imp;
    }

    public boolean importsFrom(String moduleName) {
        if (this.imports == null) {
            return false;
        }
        Enumeration<MIBImport> en = this.imports.elements();
        while (en.hasMoreElements()) {
            if (!moduleName.equals(en.nextElement().getSource())) continue;
            return true;
        }
        return false;
    }

    public void setImports(MIBImport[] imports) {
        this.imports = MIBRepository.buildVector(imports);
    }

    public void setImportsVector(Vector v) {
        this.imports = v;
    }

    public Vector<MIBImport> getImportsVector() {
        return this.imports;
    }

    @Override
    public boolean hasImports() {
        return this.imports != null && this.imports.size() > 0;
    }

    @Override
    public String toString() {
        return this.moduleName;
    }

    public boolean isUsedSyntax(MIBTextualConvention tc) {
        for (MIBObject o2 : this.objects.values()) {
            MIBObject ot;
            if (!(o2 instanceof MIBObjectType ? ((MIBObjectType)(ot = (MIBObjectType)o2)).getSyntax().getSyntax().equals(tc.getName()) : o2 instanceof MIBTextualConvention && ((MIBTextualConvention)(ot = (MIBTextualConvention)o2)).getSyntax().getSyntax().equals(tc.getName()))) continue;
            return true;
        }
        return false;
    }

    public boolean isUsedSyntax(String syntax) {
        Enumeration en = this.objects();
        while (en.hasMoreElements()) {
            MIBObject ot;
            MIBObject o2 = (MIBObject)en.nextElement();
            if (o2.getTypeString().equals(syntax) || o2 instanceof MIBObjectType && ((MIBObjectType)o2).getSyntax().getSyntax().equals(syntax) || o2 instanceof MIBTextualConvention && ((MIBTextualConvention)o2).getSyntax().getSyntax().equals(syntax)) {
                return true;
            }
            if (!(o2 instanceof MIBObjectType ? ((MIBObjectType)(ot = (MIBObjectType)o2)).getSyntax().getSyntax().equals(syntax) : o2 instanceof MIBTextualConvention && ((MIBTextualConvention)(ot = (MIBTextualConvention)o2)).getSyntax().getSyntax().equals(syntax))) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toSMI(int mode, int smiversion, MIBRepository rep, String lineSeparator) {
        MIBModule c2 = (MIBModule)this.comparable(mode);
        StringBuffer buf = new StringBuffer();
        MIBModule.addNavigationLinks(this, mode, buf, rep, lineSeparator);
        if (this.hasComment()) {
            MIBModule.addComment(mode, buf, this.asn1Comment, lineSeparator);
            buf.append(lineSeparator);
        }
        if (this.smiVersion != 1 && this.oid.size() > 0 || mode == 8) {
            MIBModule.addObjectRef(null, mode, buf, this.name, c2 == null ? null : c2.name);
            MIBModule.addKeyWord(mode, buf, " MODULE-IDENTITY");
            buf.append(lineSeparator);
            buf.append(this.toPIB(mode, smiversion));
            buf.append("\t");
            MIBModule.addKeyWord(mode, buf, "LAST-UPDATED ");
            if (mode == 8) {
                MIBModule.addText(lineSeparator, mode, buf, "\"\"");
            } else {
                String d2;
                MIBModule.addText(lineSeparator, mode, buf, this.lastUpdated, c2 == null ? null : c2.lastUpdated);
                if ((mode & 0x20) > 0 && (d2 = MIBModule.getTimeFromUTC(MIBModule.getUnquotedString(this.lastUpdated))) != null) {
                    buf.append("\t");
                    MIBModule.addComment(mode, buf, "-- " + d2, lineSeparator);
                }
            }
            buf.append(lineSeparator);
            buf.append("\t");
            MIBModule.addKeyWord(mode, buf, "ORGANIZATION ");
            if (mode == 8) {
                MIBModule.addText(lineSeparator, mode, buf, "\"\"");
            } else {
                MIBModule.addText(lineSeparator, mode, buf, this.organization, c2 == null ? null : c2.organization);
            }
            buf.append(lineSeparator);
            buf.append("\t");
            MIBModule.addKeyWord(mode, buf, "CONTACT-INFO");
            buf.append(lineSeparator);
            if (mode == 8) {
                buf.append("\t\t");
                MIBModule.addText(lineSeparator, mode, buf, "\"\"");
            } else {
                MIBModule.addText(lineSeparator, mode, buf, MIBModule.formatLines("\t\t", this.contactInfo), c2 == null ? null : MIBModule.formatLines("\t\t", c2.contactInfo));
            }
            buf.append(lineSeparator);
            buf.append("\t");
            MIBModule.addKeyWord(mode, buf, "DESCRIPTION");
            buf.append(lineSeparator);
            if (mode == 8) {
                buf.append("\t\t");
                MIBModule.addText(lineSeparator, mode, buf, "\"\"");
            } else {
                MIBModule.addText(lineSeparator, mode, buf, MIBModule.formatLines("\t\t", this.descr), c2 == null ? null : MIBModule.formatLines("\t\t", c2.descr));
            }
            buf.append(lineSeparator);
            if (this.hasRevisions()) {
                Enumeration<MIBRevision> cen = null;
                if (c2 != null) {
                    cen = c2.hasRevisions() ? c2.revisions.elements() : new Vector().elements();
                }
                Enumeration<MIBRevision> en = this.revisions.elements();
                while (en.hasMoreElements()) {
                    MIBRevision cs = null;
                    if (cen != null) {
                        cs = cen.hasMoreElements() ? cen.nextElement() : new MIBRevision("", "");
                    }
                    buf.append(en.nextElement().toSMI(mode, cs, lineSeparator));
                }
            }
            buf.append(this.getSMIDefEnd(mode, rep, this.asn1CommentInline, lineSeparator));
            buf.append(lineSeparator);
        }
        return buf.toString();
    }

    protected String toPIB(int mode, int smiversion) {
        return "";
    }

    public Pair toSMI(int mode, MIBRepository rep, int maxBytes, String lineSeparator) {
        MIBObject obj;
        Enumeration en;
        int lastOK = 0;
        StringBuffer buf = new StringBuffer(65535);
        if (this.hasCopyrightComment()) {
            MIBModule.addComment(mode, buf, this.copyrightComment, lineSeparator);
            buf.append(lineSeparator);
        }
        buf.append(this.getModuleName());
        if (buf.length() >= maxBytes) {
            return new Pair(this, new Integer(0));
        }
        this.toSMIDefinitionsBegin(mode, buf);
        buf.append(lineSeparator);
        buf.append(lineSeparator);
        if (buf.length() >= maxBytes) {
            return new Pair(this, new Integer(0));
        }
        if (this.hasImports()) {
            MIBModule.addKeyWord(mode, buf, "IMPORTS");
            en = this.imports.elements();
            while (en.hasMoreElements()) {
                buf.append(lineSeparator);
                MIBImport mi = en.nextElement();
                buf.append(mi.toSMI(rep, mode, lineSeparator));
                if (en.hasMoreElements() || !mi.hasComment()) continue;
                buf.append(lineSeparator);
            }
            buf.append(";");
            buf.append(lineSeparator);
            buf.append(lineSeparator);
        }
        lastOK = buf.length();
        buf.append(this.toSMI(mode, this.smiVersion, rep, lineSeparator));
        if (buf.length() >= maxBytes) {
            return new Pair(this, new Integer(lastOK));
        }
        en = this.objects();
        while (en.hasMoreElements()) {
            obj = (MIBObject)en.nextElement();
            if (!(obj instanceof MIBTextualConvention)) continue;
            buf.append(lineSeparator);
            lastOK = buf.length();
            buf.append(obj.toSMI(mode, this.smiVersion, rep, lineSeparator));
            if (buf.length() < maxBytes) continue;
            return new Pair(obj, new Integer(lastOK));
        }
        en = this.objectsByOid().elements();
        while (en.hasMoreElements()) {
            obj = (MIBObject)en.nextElement();
            if (!(obj instanceof MIBModule) && !(obj instanceof MIBTextualConvention)) {
                buf.append(lineSeparator);
                lastOK = buf.length();
                buf.append(obj.toSMI(mode, this.smiVersion, rep, lineSeparator));
                if (buf.length() < maxBytes) continue;
                return new Pair(obj, new Integer(lastOK));
            }
            if (!(obj instanceof MIBModule) || this.smiVersion != 1 || !obj.getOid().isValid()) continue;
            buf.append(lineSeparator);
            lastOK = buf.length();
            buf.append(super.toSMI(mode, this.smiVersion, rep, lineSeparator));
            if (buf.length() < maxBytes) continue;
            return new Pair(this, new Integer(lastOK));
        }
        buf.append(lineSeparator);
        MIBModule.addKeyWord(mode, buf, "END");
        buf.append(lineSeparator);
        return null;
    }

    protected void toSMIDefinitionsBegin(int mode, StringBuffer buf) {
        MIBModule.addKeyWord(mode, buf, " DEFINITIONS ::= BEGIN");
    }

    @Override
    public Collection objectsOrderedByOccurance() {
        TreeMap<MIBObject, MIBObject> orderedObjects = new TreeMap<MIBObject, MIBObject>(new MIBObjectOrderComparator(128));
        Enumeration en = this.objects();
        while (en.hasMoreElements()) {
            MIBObject obj = (MIBObject)en.nextElement();
            orderedObjects.put(obj, obj);
        }
        return orderedObjects.values();
    }

    private void objectsToSMI(int mode, StringBuffer buf, MIBRepository rep, String lineSeparator) {
        TreeMap<MIBObject, MIBObject> orderedObjects = new TreeMap<MIBObject, MIBObject>(new MIBObjectOrderComparator(mode));
        Enumeration en = this.objects();
        while (en.hasMoreElements()) {
            MIBObject obj = (MIBObject)en.nextElement();
            orderedObjects.put(obj, obj);
        }
        for (MIBObject o2 : orderedObjects.values()) {
            if (!(o2 instanceof MIBModule)) {
                buf.append(lineSeparator);
                buf.append(o2.toSMI(mode, this.smiVersion, rep, lineSeparator));
                if (o2 instanceof MIBTextualConvention || o2 == null) continue;
                MIBObject[] others = rep.getObjectsByOid(o2.getOid());
                for (int i2 = 0; i2 < others.length; ++i2) {
                    if (o2 == others[i2] || !o2.getModuleID().equals(others[i2].getModuleID())) continue;
                    buf.append(lineSeparator);
                    buf.append(others[i2].toSMI(mode, this.smiVersion, rep, lineSeparator));
                }
                continue;
            }
            if (!(o2 instanceof MIBModule) || this.smiVersion != 1 || !o2.getOid().isValid()) continue;
            buf.append(lineSeparator);
            buf.append(super.toSMI(mode, this.smiVersion, rep, lineSeparator));
        }
    }

    public String toSMI(int mode, MIBRepository rep, String lineSeparator) {
        return this.toSMI(mode, rep, lineSeparator, "Object Definitions");
    }

    public String toSMI(int mode, MIBRepository rep, String lineSeparator, String objectsComment) {
        Enumeration en;
        StringBuffer buf = new StringBuffer(65535);
        if (this.hasCopyrightComment()) {
            MIBModule.addComment(mode, buf, this.copyrightComment, lineSeparator);
            buf.append(lineSeparator);
        }
        buf.append(this.getModuleName());
        this.toSMIDefinitionsBegin(mode, buf);
        buf.append(lineSeparator);
        buf.append(lineSeparator);
        if (this.hasImports()) {
            MIBModule.addKeyWord(mode, buf, "IMPORTS");
            en = this.imports.elements();
            while (en.hasMoreElements()) {
                buf.append(lineSeparator);
                MIBImport mi = en.nextElement();
                buf.append(mi.toSMI(rep, mode, lineSeparator));
                if (en.hasMoreElements() || !mi.hasComment()) continue;
                buf.append(lineSeparator);
            }
            buf.append(";");
            buf.append(lineSeparator);
            buf.append(lineSeparator);
        }
        buf.append(this.toSMI(mode, this.smiVersion, rep, lineSeparator));
        if ((mode & 0x40) == 0) {
            if ((mode & 0x180) > 0) {
                this.objectsToSMI(mode, buf, rep, lineSeparator);
            } else {
                MIBObject obj;
                en = this.objects();
                while (en.hasMoreElements()) {
                    obj = (MIBObject)en.nextElement();
                    if (!(obj instanceof MIBTextualConvention)) continue;
                    buf.append(lineSeparator);
                    buf.append(obj.toSMI(mode, this.smiVersion, rep, lineSeparator));
                }
                en = this.objectsByOid().elements();
                while (en.hasMoreElements()) {
                    obj = (MIBObject)en.nextElement();
                    if (!(obj instanceof MIBModule) && !(obj instanceof MIBTextualConvention)) {
                        buf.append(lineSeparator);
                        buf.append(obj.toSMI(mode, this.smiVersion, rep, lineSeparator));
                        MIBObject[] o2 = rep.getObjectsByOid(obj.getOid());
                        for (int i2 = 0; i2 < o2.length; ++i2) {
                            if (obj == o2[i2] || !obj.getModuleID().equals(o2[i2].getModuleID())) continue;
                            buf.append(lineSeparator);
                            buf.append(o2[i2].toSMI(mode, this.smiVersion, rep, lineSeparator));
                        }
                        continue;
                    }
                    if (!(obj instanceof MIBModule) || this.smiVersion != 1 || !obj.getOid().isValid()) continue;
                    buf.append(lineSeparator);
                    buf.append(super.toSMI(mode, this.smiVersion, rep, lineSeparator));
                }
            }
        } else {
            MIBModule.addComment(mode, buf, "-- " + lineSeparator + "-- " + objectsComment + lineSeparator + "-- " + lineSeparator, lineSeparator);
        }
        buf.append(lineSeparator);
        MIBModule.addKeyWord(mode, buf, "END");
        buf.append(lineSeparator);
        if (this.hasCopyrightCommentEnd()) {
            MIBModule.addComment(mode, buf, this.copyrightCommentEnd, lineSeparator);
            buf.append(lineSeparator);
        }
        return buf.toString();
    }

    public void setOrganization(String newOrganization) {
        this.organization = newOrganization;
    }

    @Override
    public String getOrganization() {
        return this.organization;
    }

    public void setLastUpdated(String newLastUpdated) {
        this.lastUpdated = newLastUpdated;
    }

    @Override
    public String getLastUpdated() {
        return this.lastUpdated;
    }

    public void setContactInfo(String newContactInfo) {
        this.contactInfo = newContactInfo;
    }

    @Override
    public String getContactInfo() {
        return this.contactInfo;
    }

    @Override
    public void setSMIVersion(int newSmiVersion) {
        this.smiVersion = newSmiVersion;
    }

    @Override
    public int getSMIVersion() {
        return this.smiVersion;
    }

    public void addRevision(MIBRevision revision) {
        if (this.revisions == null) {
            this.revisions = new Vector(2);
        }
        this.revisions.addElement(revision);
    }

    public void setRevisions(MIBRevision[] refs) {
        this.revisions = MIBRepository.buildVector(refs);
    }

    @Override
    public boolean hasCopyrightComment() {
        return this.copyrightComment != null && this.copyrightComment.length() > 0;
    }

    public void setCopyrightComment(String copyrightComment) {
        this.copyrightComment = copyrightComment;
    }

    @Override
    public String getCopyrightCommentEnd() {
        return this.copyrightCommentEnd;
    }

    @Override
    public boolean hasCopyrightCommentEnd() {
        return this.copyrightCommentEnd != null && this.copyrightCommentEnd.length() > 0;
    }

    public void setCopyrightCommentEnd(String copyrightCommentEnd) {
        this.copyrightCommentEnd = copyrightCommentEnd;
    }

    @Override
    public String getCopyrightComment() {
        return this.copyrightComment;
    }

    @Override
    public IRevision[] getRevisions() {
        if (this.revisions == null) {
            return null;
        }
        Object[] r2 = new MIBRevision[this.revisions.size()];
        this.revisions.copyInto(r2);
        return r2;
    }

    public void setRevisionsVector(Vector v) {
        this.revisions = v;
    }

    public Vector getRevisionsVector() {
        return this.revisions;
    }

    @Override
    public boolean hasRevisions() {
        return this.revisions != null && this.revisions.size() > 0;
    }

    public Date getLastChange() {
        return this.lastChange;
    }

    public int getParseMode() {
        return this.parseMode;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public void setLastChange(Date d2) {
        this.lastChange = d2;
    }

    public void setParseMode(int parseMode) {
        this.parseMode = parseMode;
    }

    public void setStartPosition(int startPosition) {
        this.startPosition = startPosition;
    }

    public boolean isInitialized() {
        return this.objects != null;
    }

    public Vector<MIBTextualConvention> getTextualConventions() {
        Vector<MIBTextualConvention> v = new Vector<MIBTextualConvention>(this.objects.size() / 50, 10);
        for (MIBObject o2 : this.objects.values()) {
            if (!(o2 instanceof MIBTextualConvention)) continue;
            v.add((MIBTextualConvention)o2);
        }
        return v;
    }

    public boolean isValid() {
        boolean valid;
        boolean bl = valid = this.smiVersion == 1;
        if (valid) {
            return true;
        }
        if (this.getOid() == null || this.getOid().size() == 0) {
            return false;
        }
        Enumeration en = this.objects();
        while (en.hasMoreElements()) {
            MIBObject o2 = (MIBObject)en.nextElement();
            if (!(o2 instanceof MIBModule) || !o2.equals(this)) continue;
            valid = true;
        }
        return valid;
    }

    @Override
    public String getImportSource(String objectName) {
        if (!this.hasImports()) {
            return null;
        }
        Enumeration<MIBImport> en = this.imports.elements();
        while (en.hasMoreElements()) {
            MIBImport i2 = en.nextElement();
            if (!i2.imports(objectName)) continue;
            return i2.getSource();
        }
        return null;
    }

    @Override
    public Vector getImportSources(String objectName) {
        if (!this.hasImports()) {
            return new Vector(1);
        }
        Vector<String> v = new Vector<String>(2);
        Enumeration<MIBImport> en = this.imports.elements();
        while (en.hasMoreElements()) {
            MIBImport i2 = en.nextElement();
            if (!i2.imports(objectName)) continue;
            v.add(i2.getSource());
        }
        return v;
    }

    public MIBImport getImports(String source) {
        Enumeration<MIBImport> en = this.imports.elements();
        while (en.hasMoreElements()) {
            MIBImport i2 = en.nextElement();
            if (!i2.getSource().equals(source)) continue;
            return i2;
        }
        return null;
    }

    public void releaseChangedObjects(int releaseNumber) {
        Enumeration en = this.objects();
        while (en.hasMoreElements()) {
            MIBObject o2 = (MIBObject)en.nextElement();
            if (o2.isReleased()) continue;
            o2.setReleased(releaseNumber);
        }
    }

    public void unreleaseObjects(int releasedNumber) {
        Enumeration en = this.objects();
        while (en.hasMoreElements()) {
            MIBObject o2 = (MIBObject)en.nextElement();
            if (o2.getReleased() < releasedNumber) continue;
            o2.setReleased(0);
        }
    }

    public static GregorianCalendar getDateAndTimeFromUTC(String utc) {
        int year = 0;
        if (utc.length() == 11 || utc.length() == 13) {
            int offset = 2;
            if (utc.length() == 13) {
                offset = 4;
            } else {
                year = 1900;
            }
            int month = Integer.parseInt(utc.substring(offset, offset + 2)) - 1;
            int day = Integer.parseInt(utc.substring(offset + 2, offset + 4));
            int h2 = Integer.parseInt(utc.substring(offset + 4, offset + 6));
            int m2 = Integer.parseInt(utc.substring(offset + 6, offset + 8));
            GregorianCalendar gc = new GregorianCalendar(year += Integer.parseInt(utc.substring(0, offset)), month, day, h2, m2);
            return gc;
        }
        return null;
    }

    public static Date getDateFromUTC(String utc) {
        GregorianCalendar gc = MIBModule.getDateAndTimeFromUTC(utc);
        return gc == null ? null : gc.getTime();
    }

    public static String getTimeFromUTC(String utc) {
        Date d2 = MIBModule.getDateFromUTC(utc);
        if (d2 != null) {
            DateFormat df = DateFormat.getDateTimeInstance(2, 2, Locale.US);
            return df.format(d2);
        }
        return null;
    }

    public void changeObjectReferences(String oldObjectName, String newObjectName) {
        Enumeration en = this.objects();
        while (en.hasMoreElements()) {
            MIBVariation v;
            String s;
            int i2;
            Serializable m2;
            String s2;
            MIBObject o2 = (MIBObject)en.nextElement();
            if (o2 instanceof MIBGroup) {
                MIBGroup g2 = (MIBGroup)o2;
                for (int i3 = 0; i3 < g2.getObjectsVector().size(); ++i3) {
                    s2 = (String)g2.getObjectsVector().elementAt(i3);
                    if (!s2.equals(oldObjectName)) continue;
                    g2.getObjectsVector().setElementAt(newObjectName, i3);
                }
                continue;
            }
            if (o2 instanceof MIBNotifyType) {
                MIBNotifyType n2 = (MIBNotifyType)o2;
                if (!n2.hasVariables()) continue;
                for (int i4 = 0; i4 < n2.getVariablesVector().size(); ++i4) {
                    s2 = (String)n2.getVariablesVector().get(i4);
                    if (!s2.equals(oldObjectName)) continue;
                    n2.getVariablesVector().setElementAt(newObjectName, i4);
                }
                continue;
            }
            if (o2 instanceof MIBObjectType) {
                MIBObjectType ot = (MIBObjectType)o2;
                if (ot.isTable()) {
                    for (int i5 = 0; i5 < ot.getTableEntriesVector().size(); ++i5) {
                        s2 = (String)ot.getTableEntriesVector().get(i5);
                        if (!s2.equals(oldObjectName)) continue;
                        ot.getTableEntriesVector().setElementAt(newObjectName, i5);
                    }
                }
                if (!ot.hasIndexPart()) continue;
                for (int i6 = 0; i6 < ot.getIndexPart().getIndexPartVector().size(); ++i6) {
                    s2 = (String)ot.getIndexPart().getIndexPartVector().get(i6);
                    if (!s2.equals(oldObjectName)) continue;
                    ot.getIndexPart().getIndexPartVector().setElementAt(newObjectName, i6);
                }
                continue;
            }
            if (o2 instanceof MIBAgentCaps) {
                MIBAgentCaps ac = (MIBAgentCaps)o2;
                Enumeration men = ac.getModules().elements();
                while (men.hasMoreElements()) {
                    m2 = (MIBSupportedModule)men.nextElement();
                    for (i2 = 0; i2 < ((MIBSupportedModule)m2).includes.size(); ++i2) {
                        s = (String)((MIBSupportedModule)m2).includes.elementAt(i2);
                        if (!s.equals(oldObjectName)) continue;
                        ((MIBSupportedModule)m2).includes.setElementAt(newObjectName, i2);
                    }
                    if (!((MIBSupportedModule)m2).hasVariations()) continue;
                    for (i2 = 0; i2 < ((MIBSupportedModule)m2).getVariationsVector().size(); ++i2) {
                        v = (MIBVariation)((MIBSupportedModule)m2).getVariationsVector().elementAt(i2);
                        if (!v.getVariation().equals(oldObjectName)) continue;
                        v.setVariation(newObjectName);
                    }
                }
                continue;
            }
            if (!(o2 instanceof MIBCompliance)) continue;
            MIBCompliance c2 = (MIBCompliance)o2;
            Enumeration<MIBComplianceModule> men = c2.getModules().elements();
            while (men.hasMoreElements()) {
                m2 = men.nextElement();
                if (((MIBComplianceModule)m2).hasMandatory()) {
                    for (i2 = 0; i2 < ((MIBComplianceModule)m2).getMandatoryVector().size(); ++i2) {
                        s = (String)((MIBComplianceModule)m2).getMandatoryVector().elementAt(i2);
                        if (!s.equals(oldObjectName)) continue;
                        ((MIBComplianceModule)m2).getMandatoryVector().setElementAt(newObjectName, i2);
                    }
                }
                if (!((MIBComplianceModule)m2).hasVariations()) continue;
                for (i2 = 0; i2 < ((MIBComplianceModule)m2).getVariationsVector().size(); ++i2) {
                    v = (MIBVariation)((MIBComplianceModule)m2).getVariationsVector().elementAt(i2);
                    if (v.getVariation() == null || !v.getVariation().equals(oldObjectName)) continue;
                    v.setVariation(newObjectName);
                }
            }
        }
    }

    public void convertToSMIv1(MIBRepository rep) {
        MIBObject o2;
        if (this.getSMIVersion() == 1) {
            return;
        }
        this.setSMIVersion(1);
        MIBObject mo = new MIBObject(this.getOid(), this.getName(), this.getModuleID());
        this.add(mo);
        rep.removeObject(this);
        this.oid = new ObjectID();
        rep.addObject(this);
        rep.addObject(mo);
        rep.structureChanged();
        Vector<MIBObject> victims = new Vector<MIBObject>();
        Enumeration en = this.objects();
        while (en.hasMoreElements()) {
            o2 = (MIBObject)en.nextElement();
            if (o2.getStatus() != null && o2.getStatus().equals(SMI.STATUS[5])) {
                o2.setStatus(SMI.STATUS[1]);
            }
            MIBSyntax syn = null;
            if (o2 instanceof MIBObjectType) {
                MIBObject entry;
                MIBObjectType ot = (MIBObjectType)o2;
                if (ot.hasIndexPart() && ot.getIndexPart().isAugment() && (entry = rep.getObject(ot.getIndexPart().getIndexPart()[0])) != null && entry instanceof MIBObjectType) {
                    ot.setIndexPart(new MIBIndexPart(((MIBObjectType)entry).getIndexPart()));
                }
                ot.setUnits(null);
                if (ot.getAccess().equals(SMI.ACCESS[3])) {
                    ot.setAccess(SMI.ACCESS[2]);
                }
                syn = ot.getSyntax();
            }
            if (o2 instanceof MIBTextualConvention) {
                syn = ((MIBTextualConvention)o2).getSyntax();
                ((MIBTextualConvention)o2).setStatus(null);
            }
            if (syn != null) {
                if (syn.getSyntax().equals(SMI.SMI_SYNTAX[5]) || syn.getSyntax().equals(SMI.SMI_SYNTAX[6])) {
                    syn.setSyntax(SMI.SMI_SYNTAX[3]);
                }
                if (syn.getSyntax().equals(SMI.SMI_SYNTAX[7])) {
                    syn.setSyntax(SMI.SMI_SYNTAX[4]);
                }
                if (syn.getSyntax().equals(SMI.SMI_SYNTAX[13])) {
                    syn.setSyntax(SMI.SMI_SYNTAX[4]);
                }
                if (syn.getSyntax().equals(SMI.SMI_SYNTAX[8])) {
                    syn.setSyntax(SMI.SMI_SYNTAX[0]);
                }
                if (syn.getSyntax().equals(SMI.SMI_SYNTAX[12])) {
                    syn.setSyntax(SMI.SMI_SYNTAX[1]);
                    if (syn.hasEnums()) {
                        MIBObjectType ot;
                        StringBuffer buf = new StringBuffer();
                        Enumeration<MIBEnum> enumeration = syn.getEnumsVector().elements();
                        while (enumeration.hasMoreElements()) {
                            buf.append("-- " + ((Object)enumeration.nextElement()).toString() + "\n");
                        }
                        String oldComment = "";
                        if (o2.hasComment()) {
                            oldComment = o2.getComment();
                        }
                        o2.setComment(oldComment + "\n" + "-- BITS: " + "\n" + buf.toString());
                        if (o2 instanceof MIBObjectType && (ot = (MIBObjectType)o2).hasDefaultValue()) {
                            byte[] defVal = syn.getBitsEnum(ot.getDefaultValue());
                            StringBuffer b2 = new StringBuffer("'");
                            if (defVal != null) {
                                for (int i2 = 0; i2 < defVal.length; ++i2) {
                                    b2.append(Integer.toHexString(defVal[i2]));
                                }
                            }
                            b2.append("'h");
                            ot.setDefaultValue(b2.toString());
                        }
                        syn.setEnumsVector(null);
                    }
                }
            }
            if (o2 instanceof MIBNotifyType) {
                ((MIBNotifyType)o2).setTrapType(2);
                try {
                    MIBObject obj = rep.getObject(o2.getOid().getPrefix(o2.getOid().size() - 2));
                    if (obj != null) {
                        ((MIBNotifyType)o2).setEnterprise(obj.getName());
                    } else {
                        ((MIBNotifyType)o2).setEnterprise(o2.getOid().getPrefix(o2.getOid().size() - 2).toString());
                    }
                }
                catch (ObjectIDFormatException ex) {
                    // empty catch block
                }
            }
            if (!(o2 instanceof MIBGroup) && !(o2 instanceof MIBCompliance) && !(o2 instanceof MIBAgentCaps)) continue;
            victims.addElement(o2);
        }
        en = victims.elements();
        while (en.hasMoreElements()) {
            o2 = (MIBObject)en.nextElement();
            rep.removeObject(o2);
            this.remove(o2);
        }
        this.autoImportSMIMacros();
    }

    private void autoImportSMIMacros() {
        int i2;
        for (int i3 = 0; i3 < STANDARD_MIBS.length; ++i3) {
            if (!this.getModuleName().equals(STANDARD_MIBS[i3])) continue;
            return;
        }
        int v = this.getSMIVersion();
        Enumeration<MIBImport> en = this.getImportsVector().elements();
        while (en.hasMoreElements()) {
            MIBImport imp = en.nextElement();
            for (i2 = 0; i2 < imp.getImportsVector().size(); ++i2) {
                String s = imp.getImportsVector().get(i2);
                if (SMI.getKeyWordType(1, s) >= 0) {
                    imp.getImportsVector().remove(i2);
                    --i2;
                } else if (SMI.getKeyWordType(2, s) >= 0) {
                    imp.getImportsVector().remove(i2);
                    --i2;
                }
                if (v >= 0 || SMI.getKeyWordType(v, s) < 0) continue;
                imp.getImportsVector().remove(i2);
                --i2;
            }
        }
        String[][] constructs = v > 0 ? SMI.smiConstructs[v - 1] : SMI.pibConstructs[Math.abs(v) - 1];
        String[] mibs = v > 0 ? SMI.smiMIBs[v - 1] : SMI.pibMIBs[Math.abs(v) - 1];
        for (i2 = 0; i2 < constructs.length; ++i2) {
            block4: for (int j2 = 0; j2 < constructs[i2].length; ++j2) {
                Enumeration en2 = this.objects();
                while (en2.hasMoreElements()) {
                    MIBObject o2 = (MIBObject)en2.nextElement();
                    if (!o2.getTypeString().equals(constructs[i2][j2]) && (!(o2 instanceof MIBObjectType) || !((MIBObjectType)o2).getSyntax().getSyntax().equals(constructs[i2][j2])) && (!(o2 instanceof MIBTextualConvention) || !((MIBTextualConvention)o2).getSyntax().getSyntax().equals(constructs[i2][j2]))) continue;
                    MIBImport imp = this.getImports(mibs[i2]);
                    if (imp == null) {
                        imp = new MIBImport(mibs[i2]);
                        this.getImportsVector().add(imp);
                    }
                    imp.addImport(constructs[i2][j2]);
                    continue block4;
                }
            }
        }
        for (i2 = 0; i2 < this.getImportsVector().size(); ++i2) {
            MIBImport imp = this.getImportsVector().get(i2);
            if (imp.getImportsVector().size() != 0) continue;
            this.getImportsVector().remove(i2);
            --i2;
        }
    }

    public Collection<String> getLowerCaseNames() {
        HashSet<String> l2 = new HashSet<String>();
        if (this.imports != null) {
            for (int i2 = 0; i2 < this.imports.size(); ++i2) {
                MIBImport imp = this.imports.get(i2);
                String[] imps = imp.getImports();
                for (int j2 = 0; j2 < imps.length; ++j2) {
                    if (imps[j2].length() <= 0 || !Character.isLowerCase(imps[j2].charAt(0))) continue;
                    l2.add(imps[j2]);
                }
            }
        }
        Iterator<MIBObject> it = this.objectsIterator();
        while (it.hasNext()) {
            MIBObject o2 = it.next();
            if (o2.getName().length() <= 0 || !Character.isLowerCase(o2.getName().charAt(0))) continue;
            l2.add(o2.getName());
        }
        return l2;
    }

    public Collection<String> getUpperCaseNames() {
        HashSet<String> l2 = new HashSet<String>();
        if (this.imports != null) {
            for (int i2 = 0; i2 < this.imports.size(); ++i2) {
                MIBImport imp = this.imports.get(i2);
                String[] imps = imp.getImports();
                for (int j2 = 0; j2 < imps.length; ++j2) {
                    if (imps[j2].length() <= 0 || !Character.isUpperCase(imps[j2].charAt(0))) continue;
                    l2.add(imps[j2]);
                }
            }
        }
        Iterator<MIBObject> it = this.objectsIterator();
        while (it.hasNext()) {
            MIBObject o2 = it.next();
            if (o2.getName().length() <= 0 || !Character.isUpperCase(o2.getName().charAt(0))) continue;
            l2.add(o2.getName());
        }
        return l2;
    }

    private static int getTimezoneOffsetGMT() {
        GregorianCalendar calendar = new GregorianCalendar();
        int off = TimeZone.getDefault().getOffset(1, calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(7), calendar.get(14));
        return off;
    }

    public static String getUTCTime(long time) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmm");
        String utc = formatter.format(new Date(time - (long)MIBModule.getTimezoneOffsetGMT()));
        utc = utc + "Z";
        return utc;
    }
}

