/*_############################################################################
  _## 
  _##  subagent_win32.h  
  _## 
  _##
  _##  AGENT++Win32 API Version 1.4a
  _##  ---------------------------------------------------------
  _##  Copyright (C) 2003-2004, Frank Fock, All rights reserved.
  _##  
  _##  LICENSE AGREEMENT
  _##
  _##
  _##  Use of this software is subject to the license agreement you received
  _##  with this software and which can be downloaded from 
  _##  http://www.agentpp.com/agentX++/license.txt
  _##
  _##  This is licensed software and may not be used in a commercial
  _##  environment, except for evaluation purposes, unless a valid
  _##  license has been purchased.
  _##
  _##
  _##  Stuttgart, Germany, Thu Sep  2 00:08:13 CEST 2010 
  _##  
  _##########################################################################*/

#include <snmp.h>
#include <snmp_pp/log.h>
#include <agent_pp/mib.h>
#include <agent_pp/vacm.h>

// The following ifdef block is the standard way of creating macros which make exporting 
// from a DLL simpler. All files within this DLL are compiled with the SUBAGENT_WIN32_EXPORTS
// symbol defined on the command line. this symbol should not be defined on any project
// that uses this DLL. This way any other project whose source files include this file see 
// SUBAGENT_WIN32_API functions as being imported from a DLL, whereas this DLL sees symbols
// defined with this macro as being exported.
#ifdef SUBAGENT_WIN32_EXPORTS
#define SUBAGENT_WIN32_API __declspec(dllexport)
#define SUBAGENT_WIN32_TEMPL
#else
#define SUBAGENT_WIN32_API __declspec(dllimport)
#define SUBAGENT_WIN32_TEMPL extern
#endif

#if !defined (SUBAGENT_WIN32_TEMPL_LIST_PDUX)
#define SUBAGENT_WIN32_TEMPL_LIST_PDUX
    SUBAGENT_WIN32_TEMPL template class SUBAGENT_WIN32_API List<Pdux>;
#endif

/**
 * The Win32Log class extends AgentLog from AGENT++ and
 * redirects logging to the WinSNMP logging.
 *
 * @author Frank Fock
 * @version 1.0
 */
class SUBAGENT_WIN32_API Win32Log: public AgentLog {
public:
	Win32Log() {}
	~Win32Log() {}

    LogEntry*	create_log_entry(unsigned char t) const
		{ return new LogEntryImpl(t); }

	AgentLog&	operator+=(const LogEntry* log);
};

#ifdef _SNMPv3
/**
 * The Win32NoVacm class extends Vacm from AGENT++ in order
 * to disable access control in Win32 extension agents.
 * 
 * @author Frank Fock
 * @version 1.0
 */
class Win32NoVacm: public Vacm {
 public:
	 Win32NoVacm() { }
	virtual ~Win32NoVacm() { }
	
	virtual int    	isAccessAllowed(int model, OctetStr name, int level, 
					int viewType,
					OctetStr context, Oidx o) 
				{ return VACM_accessAllowed; }
	
	virtual int  	isAccessAllowed(OctetStr viewName, Oidx o)
				{ return VACM_accessAllowed; }
};
#endif

/**
 * The Win32Request class extends Request from AGENT++ to
 * support multi-threading in future versions.
 *
 * @author Frank Fock
 * @version 1.0
 */
class SUBAGENT_WIN32_API Win32Request: public Request
#ifdef _THREADS
	, public Synchronized
#endif
{
public:
	Win32Request(const Pdux&);
	virtual ~Win32Request();	
};

/**
 * The Win32RequestList class implements all the SnmpExtension*Ex
 * interfaces defined in the MicrosoftTM SNMP agent extension API.
 * An extension agent DLL will have to export the following 
 * functions as follows:
 * <pre>
 *  // globals:
 *  Mib* mib;
 *  Win32RequestList* requestList;
 *
 *  BOOL WINAPI SnmpExtensionInit(DWORD dwUptimeReference,
 *                                HANDLE *phSubagentTrapEvent,
 *								  AsnObjectIdentifier *pFirstSupportedRegion)
 *  {
 *		DefaultLog::init(new Win32Log());
 *		mib = new Mib();
 *
 *		mib->add(new xyz_mib());
 *		requestList = new Win32RequestList();
 *		mib->set_request_list(requestList);
 *		// register notification sender
 *		mib->set_notification_sender(requestList);
 *
 *		return requestList->init(mib,
 *			                     phSubagentTrapEvent,
 *			                     pFirstSupportedRegion);
 *	}
 *
 *	BOOL WINAPI SnmpExtensionInitEx(AsnObjectIdentifier *pNextSupportedRegion)
 *	{
 *		return requestList->init_next(pNextSupportedRegion);
 *	}
 *
 *  BOOL WINAPI SnmpExtensionQuery(BYTE bPduType,
 *								   SnmpVarBindList *pVarBindList,
 *								   AsnInteger32 *pErrorStatus,
 *									AsnInteger32 *pErrorIndex)
 *	{
 *		return FALSE;
 *	}
 *
 *
 *	BOOL WINAPI SnmpExtensionQueryEx(DWORD dwRequestType,
 *		                             DWORD dwTransactionId,
 *									 SnmpVarBindList *pVarBindList,
 *									 AsnOctetString *pContextInfo,
 *									 AsnInteger32 *pErrorStatus,
 *									 AsnInteger32 *pErrorIndex)
 *	{
 *		return requestList->query(dwRequestType, dwTransactionId, 
 *		                          pVarBindList, pContextInfo,
 *			                      pErrorStatus, pErrorIndex);
 *	}
 *
 *	BOOL WINAPI SnmpExtensionTrap(AsnObjectIdentifier *pEnterpriseOid,
 *								  AsnInteger32 *pGenericTrapId,
 *								  AsnInteger32 *pSpecificTrapId,
 *								  AsnTimeticks *pTimeStamp,
 *								  SnmpVarBindList *pVarBindList)
 *	{
 *		return requestList->trap(pEnterpriseOid, pGenericTrapId,
 *			                     pSpecificTrapId, pTimeStamp, pVarBindList);
 *	}
 *
 *	VOID WINAPI SnmpExtensionClose() 
 *	{
 *		delete mib;
 *	}
 * </PRE>
 * 
 * @author Frank Fock
 * @version 1.0
 */
class SUBAGENT_WIN32_API Win32RequestList: public RequestList, 
	                                       public NotificationSender
{
public:
	Win32RequestList();
	virtual ~Win32RequestList();

	/**
	 * Initialize the sub-agent.
	 *
	 * @param mib
	 *    [in/out] an initialized Mib instance.
	 * @param phSubagentTrapEvent
	 *    [out] Pointer to an event handle the extension agent 
	 *    passes back to the SNMP service. This handle is used to
	 *    notify the service that the extension agent has one or 
	 *    more traps to send. 
	 * @param pFirstSupportedRegion
	 *    [out] Pointer to an AsnObjectIdentifier structure to
	 *    receive the first MIB subtree that the extension agent
	 *    supports. 
	 * @return
	 *    TRUE if connection to master could be established,
	 *    FALSE otherwise.
	 */
	virtual BOOL		init(Mib* mib, HANDLE *phSubagentTrapEvent, 
							 AsnObjectIdentifier *pFirstSupportedRegion);

	/**
	 * Provide the next MIB subtree this subagent manages.
	 *
	 * @param 
	 *    [out] Pointer to an AsnObjectIdentifier structure to
	 *    receive the next MIB subtree that the extension agent supports.
	 * @return
	 *    TRUE if the pNextSupportedRegion parameter has been initialized
	 *    with an additional MIB subtree, or FALSE otherwise.
	 */
	virtual BOOL		init_next(AsnObjectIdentifier *pNextSupportedRegion);


	/**
	 *
	 * @param dwRequestType 
	 *    Specifies the type of operation that the SNMP service is 
	 *    requesting the extension agent to perform. This parameter
	 *    can be one of the following values: 
	 *    <UL>
     *    <LI>SNMP_EXTENSION_GET  Retrieve the value or values of 
	 *    the specified variables.  
	 *    <LI>SNMP_EXTENSION_GET_NEXT  Retrieve the value or values
	 *    of the lexicographic successor of the specified variables.  
     *    <LI>SNMP_EXTENSION_SET_TEST  Validate the values of the
	 *    specified variables. This operation maximizes the probability
	 *    of a successful write during the COMMIT request.  
     *    <LI>SNMP_EXTENSION_SET_COMMIT  Write the new values to
	 *    the specified variables.  
     *    <LI>SNMP_EXTENSION_SET_UNDO  Reset the values of the specified
	 *    variables to their values before the COMMIT request.  
     *    <LI>SNMP_EXTENSION_SET_CLEANUP  Release the resources allocated
	 *    in previous requests and operations.  
	 *    </UL>
     *
     * @param dwTransactionId 
     *    Specifies a DWORD variable that is the unique identifier of the
	 *    incoming SNMP request PDU. The extension agent can use this
	 *    value to correlate multiple calls by the SNMP service that
	 *    involve the same PDU. 
     * @param pVarBindList 
     *    Pointer to the variable binding list containing the variables
	 *    of interest. 
     * @param pContextInfo 
     *    Pointer to an octet string that contains user-defined context
	 *    information. 
     *    The extension agent can use this parameter to store context
	 *    information used during multiphase SNMP SET operations. The 
	 *    extension agent must release resources associated with this
	 *    parameter during the CLEANUP request. The SNMP service does
	 *    not release any resources associated with this parameter.  
     *
     * @param pErrorStatus 
     *    Pointer to a variable to receive the error status result. 
	 *    This parameter can be one of the following values defined by
	 *    SNMPv2C: 
	 *    <UL>
	 *    <LI>SNMP_ERRORSTATUS_NOERROR  The agent reports that no errors
	 *    occurred during transmission.  
     *    <LI>SNMP_ERRORSTATUS_TOOBIG  The agent could not place the
	 *    results of the requested SNMP operation into a single SNMP
	 *    message.  
     *    <LI>SNMP_ERRORSTATUS_NOSUCHNAME  The requested SNMP operation
	 *    identified an unknown variable.  
     *    <LI>SNMP_ERRORSTATUS_BADVALUE  The requested SNMP operation
	 *    tried to change a variable but it specified either a syntax 
	 *    or value error.  
	 *    <LI>SNMP_ERRORSTATUS_READONLY  The requested SNMP operation
	 *    tried to change a variable that was not allowed to change, 
	 *    according to the community profile of the variable.  
     *    SNMP_ERRORSTATUS_GENERR  An error other than one of those
	 *    listed here occurred during the requested SNMP operation.  
     *    <LI>SNMP_ERRORSTATUS_NOACCESS  The specified SNMP variable
	 *    is not accessible.  
     *    <LI>SNMP_ERRORSTATUS_WRONGTYPE  The value specifies a type
	 *    that is inconsistent with the type required for the variable.  
     *    <LI>SNMP_ERRORSTATUS_WRONGLENGTH  The value specifies a length
	 *    that is inconsistent with the length required for the variable.  
     *    <LI>SNMP_ERRORSTATUS_WRONGENCODING  The value contains an
	 *    Abstract Syntax Notation One (ASN.1) encoding that is 
	 *    inconsistent with the ASN.1 tag of the field.  
     *    <LI>SNMP_ERRORSTATUS_WRONGVALUE  The value cannot be assigned
	 *    to the variable.  
     *    <LI>SNMP_ERRORSTATUS_NOCREATION  The variable does not exist,
	 *    and the agent cannot create it.  
     *    <LI>SNMP_ERRORSTATUS_INCONSISTENTVALUE  The value is inconsistent
	 *    with values of other managed objects.  
     *    <LI>SNMP_ERRORSTATUS_RESOURCEUNAVAILABLE  Assigning the value to
	 *    the variable requires allocation of resources that are currently
	 *    unavailable.  
     *    <LI>SNMP_ERRORSTATUS_COMMITFAILED  No validation errors occurred,
	 *    but no variables were updated.  
     *    <LI>SNMP_ERRORSTATUS_UNDOFAILED  No validation errors occurred.
	 *    Some variables were updated because it was not possible to undo
	 *    their assignment.  
     *    <LI>SNMP_ERRORSTATUS_AUTHORIZATIONERROR  An authorization error 
	 *    occurred.  
     *    <LI>SNMP_ERRORSTATUS_NOTWRITABLE  The variable exists but the 
	 *    agent cannot modify it.  
     *    <LI>SNMP_ERRORSTATUS_INCONSISTENTNAME  The variable does not 
	 *    exist; the agent cannot create it because the named object 
	 *    instance is inconsistent with the values of other managed objects.   
     *
     * @param pErrorIndex 
     *    Pointer to a variable to receive the error index result. 
	 */
	virtual BOOL		query(DWORD dwRequestType,   // extension agent request type
							  DWORD dwTransactionId, // identifier of the incoming PDU
							  SnmpVarBindList *pVarBindList, // pointer to variable binding list
							  AsnOctetString *pContextInfo,  // pointer to context information
							  AsnInteger32 *pErrorStatus,    // pointer to SNMPv2 error status
							  AsnInteger32 *pErrorIndex      // pointer to the error index
							  );


	virtual BOOL		trap(AsnObjectIdentifier *pEnterpriseOid,  // generating enterprise
							 AsnInteger32 *pGenericTrapId,         // generating trap type
							 AsnInteger32 *pSpecificTrapId,        // enterprise-specific type
							 AsnTimeticks *pTimeStamp,             // time stamp
							 SnmpVarBindList *pVarBindList);       // variable bindings


	/**
	 * Send a notification.
	 *
	 * @param context
	 *    the context originating the notification, this should be "" 
	 *    for the default context.
	 * @param trapoid
	 *    the oid of the notification.
	 * @param vbs
	 *    an array of variable bindings.
	 * @param size
	 *    the size of the above variable binding array.
	 * @param timestamp
	 *    an optional timestamp.
	 * @return 
	 *    SNMP_ERROR_SUCCESS.
	 */
	virtual int			notify(const OctetStr&, const Oidx&, Vbx*, int, 
						       unsigned int=0); 


	/**
	 * Copies an Oidx into an AsnObjectIdentifier.
	 * 
	 * @param oid
	 *    [in] an Oidx instance.
	 * @param 
	 *    [out] an AsnObjectIdentifier with no subidentifiers
	 *    allocated.
	 */
	static void			copy_oid(const Oidx&, AsnObjectIdentifier&);

	
	// Parent OID of all generic trap OIDs.
	static Oidx			genericTrapOid;


	/**
	 * Overwrites RequestList::answer to remove the given
	 * request from the list.
	 * 
	 * @param request
	 *    a pointer to a Win32Request instance.
	 */
	virtual void			answer(Request*);

	/**
	 * Overwrites the super-class method to suppress request deletion within
	 * the Mib::finalize method. This method is called at the end of the finalize
	 * method.
	 * @param req
	 *    a pointer to the Request instance to delete.
	 * @since 1.5.2
	 */ 
	virtual void    delete_request(Request* req) { /* request is deleted later */ }


protected:

	virtual Request*		add_request(Request*);



	int						copy_vbs(Vbx*, unsigned int, SnmpVarBindList*) const;
	AsnInteger32			get_generic_id(const Oidx&) const;
	AsnInteger32			get_specific_id(const Oidx&) const;

	unsigned int			num_regions_registered;
	unsigned int			num_regions;
	AsnObjectIdentifier*	regions; 	
	HANDLE					trapEvent;
#ifdef _THREADS
	Synchronized			trapEventLock;
#endif
	List<Pdux>				trapEventQueue;

	AsnObjectIdentifier*	enterpriseOid;

	Mib*					mib;
};

