/*_############################################################################
  _## 
  _##  agentx_master.cpp  
  _## 
  _##
  _##  AGENT++Win32 API Version 1.4a
  _##  ---------------------------------------------------------
  _##  Copyright (C) 2003-2004, Frank Fock, All rights reserved.
  _##  
  _##  LICENSE AGREEMENT
  _##
  _##
  _##  Use of this software is subject to the license agreement you received
  _##  with this software and which can be downloaded from 
  _##  http://www.agentpp.com/agentX++/license.txt
  _##
  _##  This is licensed software and may not be used in a commercial
  _##  environment, except for evaluation purposes, unless a valid
  _##  license has been purchased.
  _##
  _##
  _##  Stuttgart, Germany, Thu Sep  2 00:08:13 CEST 2010 
  _##  
  _##########################################################################*/
// agentx_master.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"


#include <stdlib.h>
#include <signal.h>

#include <agent_pp/agent++.h>
#include <agentx_pp_master.h>


#ifdef AGENTPP_NAMESPACE
using namespace Agentpp;
#endif

static void sig(int signo)
{
	if ((signo == SIGTERM) || (signo == SIGINT) ||
		(signo == SIGSEGV)) {

			printf ("\n");

			switch (signo) {
				case SIGSEGV: {
					printf ("Segmentation fault, aborting.\n");
					exit(1);
				}
				case SIGTERM: 
				case SIGINT: {
					if (MasterAgentXMibWin32::runStatus) {
						MasterAgentXMibWin32::runStatus = 0;
						printf ("User abort\n");
					}	
				}	
			}
		}
}


void init_signals()
{
	signal (SIGTERM, sig);
	signal (SIGINT, sig);
	signal (SIGSEGV, sig); 
}	


int _tmain(int argc, _TCHAR* argv[])
{
	printf("\r\nAgentX++Win32 Master Agent v1.5\nCopyright  2000-2005, Frank Fock, All rights reserved\r\n\r\n");
	printf("Use is subject to the AgentX++ license agreement:\r\n");
	printf("http://www.agentpp.com/agentX++/license.txt\r\n\r\n");

	if ((argc > 1) && (_stricmp("-?", argv[1]) == 0)) {
		printf("Usage: agentX++Win32Master [<command>] [<options>]\n");
		printf("where <command> is one of the following:\n\n");
		printf("       -?                Print usage information.\n");
		printf("       -i [serviceName]  Installs the AgentX++Win32Master agent as a\n");
		printf("                         service with the supplied name. If the service\n");
		printf("                     	 name is omitted, the default name 'SNMP' will be used.\n");
		printf("       -u [serviceName]  Uninstalls the AgentX++Win32Master service with.\n");
		printf("                         If the service name is omitted, 'SNMP' will be used.\n");
		printf("       -n serviceName    Starts the service under the supplied name.\n\n");
		printf("where <options> is any of the following:\n");
		printf("       -p port           Uses the specified SNMP port instead 161 (the default).\n\n");
		return 0;
	}
	else if ((argc >= 2) && (_stricmp("-u", argv[1]) == 0)) {
		if (argc >= 3) {
			MasterAgentXMibWin32::set_service_name(argv[2]);
		}
		return !MasterAgentXMibWin32::uninstall_service();
	}
	else if ((argc >= 2) && (_stricmp("-i", argv[1]) == 0))	{			
		if (argc >= 3) {
			MasterAgentXMibWin32::set_service_name(argv[2]);
		}
		return !MasterAgentXMibWin32::install_service(argv[0]);
	}
	else if ((argc >= 3) && (_stricmp("-n", argv[1]) == 0)) {
		MasterAgentXMibWin32::set_service_name(argv[2]);
	}
	if (!MasterAgentXMibWin32::start_service()) {
		init_signals();
		MasterAgentXMibWin32::Service(argc, argv);
	}
	return 0;
}





