/*_############################################################################
  _## 
  _##  agentpp_test_mib.h  
  _## 
  _##
  _##  AGENT++Win32 API Version 1.4a
  _##  ---------------------------------------------------------
  _##  Copyright (C) 2003-2004, Frank Fock, All rights reserved.
  _##  
  _##  LICENSE AGREEMENT
  _##
  _##
  _##  Use of this software is subject to the license agreement you received
  _##  with this software and which can be downloaded from 
  _##  http://www.agentpp.com/agentX++/license.txt
  _##
  _##  This is licensed software and may not be used in a commercial
  _##  environment, except for evaluation purposes, unless a valid
  _##  license has been purchased.
  _##
  _##
  _##  Stuttgart, Germany, Thu Sep  2 00:08:13 CEST 2010 
  _##  
  _##########################################################################*/



//--AgentGen BEGIN=_BEGIN
//--AgentGen END


#ifndef _agentpp_test_mib_h
#define _agentpp_test_mib_h


#include <agent_pp/mib.h>
#include <agent_pp/snmp_textual_conventions.h>
#include <agent_pp/notification_originator.h>
#include <snmp_pp/log.h>


#define oidAgentppTestTimeout            "1.3.6.1.4.1.4976.6.3.1.1.0"
#define oidAgentppTestVariableTable      "1.3.6.1.4.1.4976.6.3.1.2"
#define oidAgentppTestVariableEntry      "1.3.6.1.4.1.4976.6.3.1.2.1"
#define oidAgentppTestVariableIndex      "1.3.6.1.4.1.4976.6.3.1.2.1.1"
#define colAgentppTestVariableIndex      "1"
#define oidAgentppTestVariableCounter32Val "1.3.6.1.4.1.4976.6.3.1.2.1.2"
#define colAgentppTestVariableCounter32Val "2"
#define oidAgentppTestUnsigned32Val      "1.3.6.1.4.1.4976.6.3.1.2.1.3"
#define colAgentppTestUnsigned32Val      "3"
#define oidAgentppTestVariableTimeTicksVal "1.3.6.1.4.1.4976.6.3.1.2.1.4"
#define colAgentppTestVariableTimeTicksVal "4"
#define oidAgentppTestVariableInteger32Val "1.3.6.1.4.1.4976.6.3.1.2.1.5"
#define colAgentppTestVariableInteger32Val "5"
#define oidAgentppTestVariableOctetStringVal "1.3.6.1.4.1.4976.6.3.1.2.1.6"
#define colAgentppTestVariableOctetStringVal "6"
#define oidAgentppTestVariableIpAddressVal "1.3.6.1.4.1.4976.6.3.1.2.1.7"
#define colAgentppTestVariableIpAddressVal "7"
#define oidAgentppTestVariableOidVal     "1.3.6.1.4.1.4976.6.3.1.2.1.8"
#define colAgentppTestVariableOidVal     "8"
#define oidAgentppTestVariableCounter64Val "1.3.6.1.4.1.4976.6.3.1.2.1.9"
#define colAgentppTestVariableCounter64Val "9"
#define oidAgentppTestVariableOpaqueVal  "1.3.6.1.4.1.4976.6.3.1.2.1.10"
#define colAgentppTestVariableOpaqueVal  "10"
#define oidAgentppTestVariableRowStatus  "1.3.6.1.4.1.4976.6.3.1.2.1.11"
#define colAgentppTestVariableRowStatus  "11"

#define nAgentppTestVariableCounter32Val 0
#define cAgentppTestVariableCounter32Val 2
#define nAgentppTestUnsigned32Val        1
#define cAgentppTestUnsigned32Val        3
#define nAgentppTestVariableTimeTicksVal 2
#define cAgentppTestVariableTimeTicksVal 4
#define nAgentppTestVariableInteger32Val 3
#define cAgentppTestVariableInteger32Val 5
#define nAgentppTestVariableOctetStringVal 4
#define cAgentppTestVariableOctetStringVal 6
#define nAgentppTestVariableIpAddressVal 5
#define cAgentppTestVariableIpAddressVal 7
#define nAgentppTestVariableOidVal       6
#define cAgentppTestVariableOidVal       8
#define nAgentppTestVariableCounter64Val 7
#define cAgentppTestVariableCounter64Val 9
#define nAgentppTestVariableOpaqueVal    8
#define cAgentppTestVariableOpaqueVal    10
#define nAgentppTestVariableRowStatus    9
#define cAgentppTestVariableRowStatus    11


//--AgentGen BEGIN=_INCLUDE
#ifdef AGENTPP_NAMESPACE
namespace Agentpp {
#endif
//--AgentGen END


/**
 *  agentppTestTimeout
 *
 * "Setting this object will be delayed by the given
 * amount of milliseconds. That is, by setting this
 * object to 1000 the corresponding response to
 * that SET request will be delayed by one second."
 */


class agentppTestTimeout: public MibLeaf {

public:
	agentppTestTimeout();
	virtual ~agentppTestTimeout();

	static agentppTestTimeout* instance;

	virtual void       	get_request(Request*, int);
	virtual unsigned long       	get_state();
	virtual void       	set_state(unsigned long);
	virtual int        	set(const Vbx&);
	virtual int        	prepare_set_request(Request*, int&);
	virtual boolean    	value_ok(const Vbx&);

//--AgentGen BEGIN=agentppTestTimeout
//--AgentGen END
};


/**
 *  agentppTestVariableCounter32Val
 *
 * "A Counter32 test variable."
 */


class agentppTestVariableCounter32Val: public MibLeaf {

public:
	agentppTestVariableCounter32Val(const Oidx&);
	virtual ~agentppTestVariableCounter32Val();

	virtual MibEntryPtr	clone();
	virtual void       	get_request(Request*, int);
	virtual unsigned long       	get_state();
	virtual void       	set_state(unsigned long);
	virtual unsigned long 	inc();
	virtual int        	set(const Vbx&);
	virtual int        	prepare_set_request(Request*, int&);
	virtual boolean    	value_ok(const Vbx&);

//--AgentGen BEGIN=agentppTestVariableCounter32Val
//--AgentGen END
};


/**
 *  agentppTestUnsigned32Val
 *
 * "An Unsigned32 test variable."
 */


class agentppTestUnsigned32Val: public MibLeaf {

public:
	agentppTestUnsigned32Val(const Oidx&);
	virtual ~agentppTestUnsigned32Val();

	virtual MibEntryPtr	clone();
	virtual void       	get_request(Request*, int);
	virtual unsigned long       	get_state();
	virtual void       	set_state(unsigned long);
	virtual int        	set(const Vbx&);
	virtual int        	prepare_set_request(Request*, int&);
	virtual boolean    	value_ok(const Vbx&);

//--AgentGen BEGIN=agentppTestUnsigned32Val
//--AgentGen END
};


/**
 *  agentppTestVariableTimeTicksVal
 *
 * "A TimeTicks test variable."
 */


class agentppTestVariableTimeTicksVal: public MibLeaf {

public:
	agentppTestVariableTimeTicksVal(const Oidx&);
	virtual ~agentppTestVariableTimeTicksVal();

	virtual MibEntryPtr	clone();
	virtual void       	get_request(Request*, int);
	virtual unsigned long       	get_state();
	virtual void       	set_state(unsigned long);
	virtual int        	set(const Vbx&);
	virtual int        	prepare_set_request(Request*, int&);
	virtual boolean    	value_ok(const Vbx&);

//--AgentGen BEGIN=agentppTestVariableTimeTicksVal
//--AgentGen END
};


/**
 *  agentppTestVariableInteger32Val
 *
 * "A Integer32 test variable."
 */


class agentppTestVariableInteger32Val: public MibLeaf {

public:
	agentppTestVariableInteger32Val(const Oidx&);
	virtual ~agentppTestVariableInteger32Val();

	virtual MibEntryPtr	clone();
	virtual void       	get_request(Request*, int);
	virtual long       	get_state();
	virtual void       	set_state(long);
	virtual int        	set(const Vbx&);
	virtual int        	prepare_set_request(Request*, int&);
	virtual boolean    	value_ok(const Vbx&);

//--AgentGen BEGIN=agentppTestVariableInteger32Val
//--AgentGen END
};


/**
 *  agentppTestVariableOctetStringVal
 *
 * "An OCTET STRING test variable."
 */


class agentppTestVariableOctetStringVal: public MibLeaf {

public:
	agentppTestVariableOctetStringVal(const Oidx&);
	virtual ~agentppTestVariableOctetStringVal();

	virtual MibEntryPtr	clone();
	virtual void       	get_request(Request*, int);
	virtual OctetStr       	get_state();
	virtual void       	set_state(const OctetStr&);
	virtual int        	set(const Vbx&);
	virtual int        	prepare_set_request(Request*, int&);
	virtual boolean    	value_ok(const Vbx&);

//--AgentGen BEGIN=agentppTestVariableOctetStringVal
//--AgentGen END
};


/**
 *  agentppTestVariableIpAddressVal
 *
 * "An IpAddress test variable."
 */


class agentppTestVariableIpAddressVal: public MibLeaf {

public:
	agentppTestVariableIpAddressVal(const Oidx&);
	virtual ~agentppTestVariableIpAddressVal();

	virtual MibEntryPtr	clone();
	virtual void       	get_request(Request*, int);
	virtual IpAddress       	get_state();
	virtual void       	set_state(const IpAddress&);
	virtual int        	set(const Vbx&);
	virtual int        	prepare_set_request(Request*, int&);
	virtual boolean    	value_ok(const Vbx&);

//--AgentGen BEGIN=agentppTestVariableIpAddressVal
//--AgentGen END
};


/**
 *  agentppTestVariableOidVal
 *
 * "An OBJECT IDENTIFIER test variable."
 */


class agentppTestVariableOidVal: public MibLeaf {

public:
	agentppTestVariableOidVal(const Oidx&);
	virtual ~agentppTestVariableOidVal();

	virtual MibEntryPtr	clone();
	virtual void       	get_request(Request*, int);
	virtual int        	set(const Vbx&);
	virtual int        	prepare_set_request(Request*, int&);
	virtual boolean    	value_ok(const Vbx&);

//--AgentGen BEGIN=agentppTestVariableOidVal
//--AgentGen END
};


/**
 *  agentppTestVariableCounter64Val
 *
 * "A Counter64 test variable."
 */


class agentppTestVariableCounter64Val: public MibLeaf {

public:
	agentppTestVariableCounter64Val(const Oidx&);
	virtual ~agentppTestVariableCounter64Val();

	virtual MibEntryPtr	clone();
	virtual void       	get_request(Request*, int);
	virtual Counter64       	get_state();
	virtual void       	set_state(const Counter64&);
	virtual int        	set(const Vbx&);
	virtual int        	prepare_set_request(Request*, int&);
	virtual boolean    	value_ok(const Vbx&);

//--AgentGen BEGIN=agentppTestVariableCounter64Val
//--AgentGen END
};


/**
 *  agentppTestVariableOpaqueVal
 *
 * "An Opaque test variable."
 */


class agentppTestVariableOpaqueVal: public MibLeaf {

public:
	agentppTestVariableOpaqueVal(const Oidx&);
	virtual ~agentppTestVariableOpaqueVal();

	virtual MibEntryPtr	clone();
	virtual void       	get_request(Request*, int);
	virtual int        	set(const Vbx&);
	virtual int        	prepare_set_request(Request*, int&);
	virtual boolean    	value_ok(const Vbx&);

//--AgentGen BEGIN=agentppTestVariableOpaqueVal
//--AgentGen END
};


/**
 *  agentppTestVariableRowStatus
 *
 * "This object should be set to createAndWait or
 * createAndGo in order to create a row in this table. "
 */


class agentppTestVariableRowStatus: public snmpRowStatus {

public:
	agentppTestVariableRowStatus(const Oidx&);
	virtual ~agentppTestVariableRowStatus();

	virtual MibEntryPtr	clone();
	virtual long       	get_state();
	virtual void       	set_state(long);
	virtual int        	set(const Vbx&);
	virtual int        	prepare_set_request(Request*, int&);
	enum labels {
		e_active = 1,
		e_notInService = 2,
		e_notReady = 3,
		e_createAndGo = 4,
		e_createAndWait = 5,
		e_destroy = 6 };

//--AgentGen BEGIN=agentppTestVariableRowStatus
//--AgentGen END
};


/**
 *  agentppTestVariableEntry
 *
 * "Entries in this table can be created using its RowStatus object."
 */


class agentppTestVariableEntry: public MibTable {

public:
	agentppTestVariableEntry();
	virtual ~agentppTestVariableEntry();

	static agentppTestVariableEntry* instance;


//--AgentGen BEGIN=agentppTestVariableEntry
//--AgentGen END
};


class agentpp_test_mib: public MibGroup
{
  public:
	agentpp_test_mib();
	virtual ~agentpp_test_mib() { }

//--AgentGen BEGIN=agentpp_test_mib
//--AgentGen END

};

//--AgentGen BEGIN=_END
#ifdef AGENTPP_NAMESPACE
}
#endif

//--AgentGen END


/**
 * agentpp_test_mib.h generated by AgentGen 1.7 for AGENT++v3.5 
 * Thu Oct 11 21:58:12 CEST 2001.
 */


#endif


