/*_############################################################################
  _## 
  _##  agentpp_test_mib.cpp  
  _## 
  _##
  _##  AGENT++Win32 API Version 1.4a
  _##  ---------------------------------------------------------
  _##  Copyright (C) 2003-2004, Frank Fock, All rights reserved.
  _##  
  _##  LICENSE AGREEMENT
  _##
  _##
  _##  Use of this software is subject to the license agreement you received
  _##  with this software and which can be downloaded from 
  _##  http://www.agentpp.com/agentX++/license.txt
  _##
  _##  This is licensed software and may not be used in a commercial
  _##  environment, except for evaluation purposes, unless a valid
  _##  license has been purchased.
  _##
  _##
  _##  Stuttgart, Germany, Thu Sep  2 00:08:13 CEST 2010 
  _##  
  _##########################################################################*/



//--AgentGen BEGIN=_BEGIN
//--AgentGen END


#include "agentpp_test_mib.h"



/**
 *  generated by AgentGen 1.7 for AGENT++v3.5 
 * Thu Oct 11 21:58:12 CEST 2001.
 */


//--AgentGen BEGIN=_INCLUDE
#ifdef AGENTPP_NAMESPACE
namespace Agentpp {
#endif
//--AgentGen END


/**
 *  agentppTestTimeout
 *
 */

agentppTestTimeout* agentppTestTimeout::instance = 0;

agentppTestTimeout::agentppTestTimeout():
   MibLeaf(oidAgentppTestTimeout, READWRITE, new Gauge32())
{
	// This leaf object is a singleton. In order to access it use
	// the static pointer agentppTestTimeout::instance.
	instance = this;

	//--AgentGen BEGIN=agentppTestTimeout::agentppTestTimeout
	//--AgentGen END

}

agentppTestTimeout::~agentppTestTimeout()
{

	//--AgentGen BEGIN=agentppTestTimeout::~agentppTestTimeout
	//--AgentGen END
}

void agentppTestTimeout::get_request(Request* req, int ind)
{

	//--AgentGen BEGIN=agentppTestTimeout::get_request
	//--AgentGen END
	MibLeaf::get_request(req, ind);
}

unsigned long agentppTestTimeout::get_state()
{
	return (unsigned long)*((Gauge32*)value);
}

void agentppTestTimeout::set_state(unsigned long l)
{

	//--AgentGen BEGIN=agentppTestTimeout::set_state
	//--AgentGen END
	*((Gauge32*)value) = l;
}

int agentppTestTimeout::set(const Vbx& vb)
{

	//--AgentGen BEGIN=agentppTestTimeout::set
	unsigned long timeout;
	vb.get_value(timeout);
	Sleep(timeout);
	//--AgentGen END
	return MibLeaf::set(vb);
}

boolean agentppTestTimeout::value_ok(const Vbx& vb)
{
	unsigned long v;
	vb.get_value(v);
	if (!(((v >= 0) && (v <= 1000000))))
		 return FALSE;

	//--AgentGen BEGIN=agentppTestTimeout::value_ok
	//--AgentGen END
	return TRUE;
}

int agentppTestTimeout::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = MibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;

	//--AgentGen BEGIN=agentppTestTimeout::prepare_set_request
	//--AgentGen END
	return SNMP_ERROR_SUCCESS;
}


//--AgentGen BEGIN=agentppTestTimeout
//--AgentGen END




/**
 *  agentppTestVariableCounter32Val
 *
 */

agentppTestVariableCounter32Val::agentppTestVariableCounter32Val(const Oidx& id):
   MibLeaf(id, READCREATE, new Counter32(0), VMODE_DEFAULT)
{

	//--AgentGen BEGIN=agentppTestVariableCounter32Val::agentppTestVariableCounter32Val
	//--AgentGen END

}

agentppTestVariableCounter32Val::~agentppTestVariableCounter32Val()
{

	//--AgentGen BEGIN=agentppTestVariableCounter32Val::~agentppTestVariableCounter32Val
	//--AgentGen END
}

MibEntryPtr agentppTestVariableCounter32Val::clone()
{
	MibEntryPtr other = new agentppTestVariableCounter32Val(oid);
	((agentppTestVariableCounter32Val*)other)->replace_value(value->clone());
	((agentppTestVariableCounter32Val*)other)->set_reference_to_table(my_table);

	//--AgentGen BEGIN=agentppTestVariableCounter32Val::clone
	//--AgentGen END
	return other;
}

void agentppTestVariableCounter32Val::get_request(Request* req, int ind)
{

	//--AgentGen BEGIN=agentppTestVariableCounter32Val::get_request
	//--AgentGen END
	MibLeaf::get_request(req, ind);
}

unsigned long agentppTestVariableCounter32Val::get_state()
{
	return (unsigned long)*((Counter32*)value);
}

void agentppTestVariableCounter32Val::set_state(unsigned long l)
{

	//--AgentGen BEGIN=agentppTestVariableCounter32Val::set_state
	//--AgentGen END
	*((Counter32*)value) = l;
}

unsigned long agentppTestVariableCounter32Val::inc()
{

	//--AgentGen BEGIN=agentppTestVariableCounter32Val::inc
	//--AgentGen END
	unsigned long l = get_state();
	set_state(++l);
	return l;
}

int agentppTestVariableCounter32Val::set(const Vbx& vb)
{

	//--AgentGen BEGIN=agentppTestVariableCounter32Val::set
	//--AgentGen END
	return MibLeaf::set(vb);
}

boolean agentppTestVariableCounter32Val::value_ok(const Vbx& vb)
{

	//--AgentGen BEGIN=agentppTestVariableCounter32Val::value_ok
	//--AgentGen END
	return TRUE;
}

int agentppTestVariableCounter32Val::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = MibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;

	//--AgentGen BEGIN=agentppTestVariableCounter32Val::prepare_set_request
	//--AgentGen END
	return SNMP_ERROR_SUCCESS;
}


//--AgentGen BEGIN=agentppTestVariableCounter32Val
//--AgentGen END




/**
 *  agentppTestUnsigned32Val
 *
 */

agentppTestUnsigned32Val::agentppTestUnsigned32Val(const Oidx& id):
   MibLeaf(id, READCREATE, new Gauge32(1), VMODE_DEFAULT)
{

	//--AgentGen BEGIN=agentppTestUnsigned32Val::agentppTestUnsigned32Val
	//--AgentGen END

}

agentppTestUnsigned32Val::~agentppTestUnsigned32Val()
{

	//--AgentGen BEGIN=agentppTestUnsigned32Val::~agentppTestUnsigned32Val
	//--AgentGen END
}

MibEntryPtr agentppTestUnsigned32Val::clone()
{
	MibEntryPtr other = new agentppTestUnsigned32Val(oid);
	((agentppTestUnsigned32Val*)other)->replace_value(value->clone());
	((agentppTestUnsigned32Val*)other)->set_reference_to_table(my_table);

	//--AgentGen BEGIN=agentppTestUnsigned32Val::clone
	//--AgentGen END
	return other;
}

void agentppTestUnsigned32Val::get_request(Request* req, int ind)
{

	//--AgentGen BEGIN=agentppTestUnsigned32Val::get_request
	//--AgentGen END
	MibLeaf::get_request(req, ind);
}

unsigned long agentppTestUnsigned32Val::get_state()
{
	return (unsigned long)*((Gauge32*)value);
}

void agentppTestUnsigned32Val::set_state(unsigned long l)
{

	//--AgentGen BEGIN=agentppTestUnsigned32Val::set_state
	//--AgentGen END
	*((Gauge32*)value) = l;
}

int agentppTestUnsigned32Val::set(const Vbx& vb)
{

	//--AgentGen BEGIN=agentppTestUnsigned32Val::set
	//--AgentGen END
	return MibLeaf::set(vb);
}

boolean agentppTestUnsigned32Val::value_ok(const Vbx& vb)
{

	//--AgentGen BEGIN=agentppTestUnsigned32Val::value_ok
	//--AgentGen END
	return TRUE;
}

int agentppTestUnsigned32Val::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = MibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;

	//--AgentGen BEGIN=agentppTestUnsigned32Val::prepare_set_request
	//--AgentGen END
	return SNMP_ERROR_SUCCESS;
}


//--AgentGen BEGIN=agentppTestUnsigned32Val
//--AgentGen END




/**
 *  agentppTestVariableTimeTicksVal
 *
 */

agentppTestVariableTimeTicksVal::agentppTestVariableTimeTicksVal(const Oidx& id):
   MibLeaf(id, READCREATE, new TimeTicks(0), VMODE_DEFAULT)
{

	//--AgentGen BEGIN=agentppTestVariableTimeTicksVal::agentppTestVariableTimeTicksVal
	//--AgentGen END

}

agentppTestVariableTimeTicksVal::~agentppTestVariableTimeTicksVal()
{

	//--AgentGen BEGIN=agentppTestVariableTimeTicksVal::~agentppTestVariableTimeTicksVal
	//--AgentGen END
}

MibEntryPtr agentppTestVariableTimeTicksVal::clone()
{
	MibEntryPtr other = new agentppTestVariableTimeTicksVal(oid);
	((agentppTestVariableTimeTicksVal*)other)->replace_value(value->clone());
	((agentppTestVariableTimeTicksVal*)other)->set_reference_to_table(my_table);

	//--AgentGen BEGIN=agentppTestVariableTimeTicksVal::clone
	//--AgentGen END
	return other;
}

void agentppTestVariableTimeTicksVal::get_request(Request* req, int ind)
{

	//--AgentGen BEGIN=agentppTestVariableTimeTicksVal::get_request
	//--AgentGen END
	MibLeaf::get_request(req, ind);
}

unsigned long agentppTestVariableTimeTicksVal::get_state()
{
	return (unsigned long)*((TimeTicks*)value);
}

void agentppTestVariableTimeTicksVal::set_state(unsigned long l)
{

	//--AgentGen BEGIN=agentppTestVariableTimeTicksVal::set_state
	//--AgentGen END
	*((TimeTicks*)value) = l;
}

int agentppTestVariableTimeTicksVal::set(const Vbx& vb)
{

	//--AgentGen BEGIN=agentppTestVariableTimeTicksVal::set
	//--AgentGen END
	return MibLeaf::set(vb);
}

boolean agentppTestVariableTimeTicksVal::value_ok(const Vbx& vb)
{

	//--AgentGen BEGIN=agentppTestVariableTimeTicksVal::value_ok
	//--AgentGen END
	return TRUE;
}

int agentppTestVariableTimeTicksVal::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = MibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;

	//--AgentGen BEGIN=agentppTestVariableTimeTicksVal::prepare_set_request
	//--AgentGen END
	return SNMP_ERROR_SUCCESS;
}


//--AgentGen BEGIN=agentppTestVariableTimeTicksVal
//--AgentGen END




/**
 *  agentppTestVariableInteger32Val
 *
 */

agentppTestVariableInteger32Val::agentppTestVariableInteger32Val(const Oidx& id):
   MibLeaf(id, READCREATE, new SnmpInt32(-1), VMODE_DEFAULT)
{

	//--AgentGen BEGIN=agentppTestVariableInteger32Val::agentppTestVariableInteger32Val
	//--AgentGen END

}

agentppTestVariableInteger32Val::~agentppTestVariableInteger32Val()
{

	//--AgentGen BEGIN=agentppTestVariableInteger32Val::~agentppTestVariableInteger32Val
	//--AgentGen END
}

MibEntryPtr agentppTestVariableInteger32Val::clone()
{
	MibEntryPtr other = new agentppTestVariableInteger32Val(oid);
	((agentppTestVariableInteger32Val*)other)->replace_value(value->clone());
	((agentppTestVariableInteger32Val*)other)->set_reference_to_table(my_table);

	//--AgentGen BEGIN=agentppTestVariableInteger32Val::clone
	//--AgentGen END
	return other;
}

void agentppTestVariableInteger32Val::get_request(Request* req, int ind)
{

	//--AgentGen BEGIN=agentppTestVariableInteger32Val::get_request
	//--AgentGen END
	MibLeaf::get_request(req, ind);
}

long agentppTestVariableInteger32Val::get_state()
{
	return (long)*((SnmpInt32*)value);
}

void agentppTestVariableInteger32Val::set_state(long l)
{

	//--AgentGen BEGIN=agentppTestVariableInteger32Val::set_state
	//--AgentGen END
	*((SnmpInt32*)value) = l;
}

int agentppTestVariableInteger32Val::set(const Vbx& vb)
{

	//--AgentGen BEGIN=agentppTestVariableInteger32Val::set
	//--AgentGen END
	return MibLeaf::set(vb);
}

boolean agentppTestVariableInteger32Val::value_ok(const Vbx& vb)
{

	//--AgentGen BEGIN=agentppTestVariableInteger32Val::value_ok
	//--AgentGen END
	return TRUE;
}

int agentppTestVariableInteger32Val::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = MibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;

	//--AgentGen BEGIN=agentppTestVariableInteger32Val::prepare_set_request
	//--AgentGen END
	return SNMP_ERROR_SUCCESS;
}


//--AgentGen BEGIN=agentppTestVariableInteger32Val
//--AgentGen END




/**
 *  agentppTestVariableOctetStringVal
 *
 */

agentppTestVariableOctetStringVal::agentppTestVariableOctetStringVal(const Oidx& id):
   MibLeaf(id, READCREATE, new OctetStr("default"), VMODE_DEFAULT)
{

	//--AgentGen BEGIN=agentppTestVariableOctetStringVal::agentppTestVariableOctetStringVal
	//--AgentGen END

}

agentppTestVariableOctetStringVal::~agentppTestVariableOctetStringVal()
{

	//--AgentGen BEGIN=agentppTestVariableOctetStringVal::~agentppTestVariableOctetStringVal
	//--AgentGen END
}

MibEntryPtr agentppTestVariableOctetStringVal::clone()
{
	MibEntryPtr other = new agentppTestVariableOctetStringVal(oid);
	((agentppTestVariableOctetStringVal*)other)->replace_value(value->clone());
	((agentppTestVariableOctetStringVal*)other)->set_reference_to_table(my_table);

	//--AgentGen BEGIN=agentppTestVariableOctetStringVal::clone
	//--AgentGen END
	return other;
}

void agentppTestVariableOctetStringVal::get_request(Request* req, int ind)
{

	//--AgentGen BEGIN=agentppTestVariableOctetStringVal::get_request
	//--AgentGen END
	MibLeaf::get_request(req, ind);
}

OctetStr agentppTestVariableOctetStringVal::get_state()
{
	return *((OctetStr*)value);
}

void agentppTestVariableOctetStringVal::set_state(const OctetStr& s)
{

	//--AgentGen BEGIN=agentppTestVariableOctetStringVal::set_state
	//--AgentGen END
	*((OctetStr*)value) = s;
}

int agentppTestVariableOctetStringVal::set(const Vbx& vb)
{

	//--AgentGen BEGIN=agentppTestVariableOctetStringVal::set
	//--AgentGen END
	return MibLeaf::set(vb);
}

boolean agentppTestVariableOctetStringVal::value_ok(const Vbx& vb)
{

	//--AgentGen BEGIN=agentppTestVariableOctetStringVal::value_ok
	//--AgentGen END
	return TRUE;
}

int agentppTestVariableOctetStringVal::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = MibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;

	//--AgentGen BEGIN=agentppTestVariableOctetStringVal::prepare_set_request
	//--AgentGen END
	return SNMP_ERROR_SUCCESS;
}


//--AgentGen BEGIN=agentppTestVariableOctetStringVal
//--AgentGen END




/**
 *  agentppTestVariableIpAddressVal
 *
 */

agentppTestVariableIpAddressVal::agentppTestVariableIpAddressVal(const Oidx& id):
   MibLeaf(id, READCREATE, new IpAddress("127.0.0.1"), VMODE_DEFAULT)
{

	//--AgentGen BEGIN=agentppTestVariableIpAddressVal::agentppTestVariableIpAddressVal
	//--AgentGen END

}

agentppTestVariableIpAddressVal::~agentppTestVariableIpAddressVal()
{

	//--AgentGen BEGIN=agentppTestVariableIpAddressVal::~agentppTestVariableIpAddressVal
	//--AgentGen END
}

MibEntryPtr agentppTestVariableIpAddressVal::clone()
{
	MibEntryPtr other = new agentppTestVariableIpAddressVal(oid);
	((agentppTestVariableIpAddressVal*)other)->replace_value(value->clone());
	((agentppTestVariableIpAddressVal*)other)->set_reference_to_table(my_table);

	//--AgentGen BEGIN=agentppTestVariableIpAddressVal::clone
	//--AgentGen END
	return other;
}

void agentppTestVariableIpAddressVal::get_request(Request* req, int ind)
{

	//--AgentGen BEGIN=agentppTestVariableIpAddressVal::get_request
	//--AgentGen END
	MibLeaf::get_request(req, ind);
}

IpAddress agentppTestVariableIpAddressVal::get_state()
{
	return *((IpAddress*)value);
}

void agentppTestVariableIpAddressVal::set_state(const IpAddress& s)
{

	//--AgentGen BEGIN=agentppTestVariableIpAddressVal::set_state
	//--AgentGen END
	*((IpAddress*)value) = s;
}

int agentppTestVariableIpAddressVal::set(const Vbx& vb)
{

	//--AgentGen BEGIN=agentppTestVariableIpAddressVal::set
	//--AgentGen END
	return MibLeaf::set(vb);
}

boolean agentppTestVariableIpAddressVal::value_ok(const Vbx& vb)
{

	//--AgentGen BEGIN=agentppTestVariableIpAddressVal::value_ok
	//--AgentGen END
	return TRUE;
}

int agentppTestVariableIpAddressVal::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = MibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;

	//--AgentGen BEGIN=agentppTestVariableIpAddressVal::prepare_set_request
	//--AgentGen END
	return SNMP_ERROR_SUCCESS;
}


//--AgentGen BEGIN=agentppTestVariableIpAddressVal
//--AgentGen END




/**
 *  agentppTestVariableOidVal
 *
 */

agentppTestVariableOidVal::agentppTestVariableOidVal(const Oidx& id):
   MibLeaf(id, READCREATE, new Oid("mgmt"), VMODE_DEFAULT)
{

	//--AgentGen BEGIN=agentppTestVariableOidVal::agentppTestVariableOidVal
	//--AgentGen END

}

agentppTestVariableOidVal::~agentppTestVariableOidVal()
{

	//--AgentGen BEGIN=agentppTestVariableOidVal::~agentppTestVariableOidVal
	//--AgentGen END
}

MibEntryPtr agentppTestVariableOidVal::clone()
{
	MibEntryPtr other = new agentppTestVariableOidVal(oid);
	((agentppTestVariableOidVal*)other)->replace_value(value->clone());
	((agentppTestVariableOidVal*)other)->set_reference_to_table(my_table);

	//--AgentGen BEGIN=agentppTestVariableOidVal::clone
	//--AgentGen END
	return other;
}

void agentppTestVariableOidVal::get_request(Request* req, int ind)
{

	//--AgentGen BEGIN=agentppTestVariableOidVal::get_request
	//--AgentGen END
	MibLeaf::get_request(req, ind);
}

int agentppTestVariableOidVal::set(const Vbx& vb)
{

	//--AgentGen BEGIN=agentppTestVariableOidVal::set
	//--AgentGen END
	return MibLeaf::set(vb);
}

boolean agentppTestVariableOidVal::value_ok(const Vbx& vb)
{

	//--AgentGen BEGIN=agentppTestVariableOidVal::value_ok
	//--AgentGen END
	return TRUE;
}

int agentppTestVariableOidVal::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = MibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;

	//--AgentGen BEGIN=agentppTestVariableOidVal::prepare_set_request
	//--AgentGen END
	return SNMP_ERROR_SUCCESS;
}


//--AgentGen BEGIN=agentppTestVariableOidVal
//--AgentGen END




/**
 *  agentppTestVariableCounter64Val
 *
 */

agentppTestVariableCounter64Val::agentppTestVariableCounter64Val(const Oidx& id):
   MibLeaf(id, READCREATE, new Counter64())
{

	//--AgentGen BEGIN=agentppTestVariableCounter64Val::agentppTestVariableCounter64Val
	//--AgentGen END

}

agentppTestVariableCounter64Val::~agentppTestVariableCounter64Val()
{

	//--AgentGen BEGIN=agentppTestVariableCounter64Val::~agentppTestVariableCounter64Val
	//--AgentGen END
}

MibEntryPtr agentppTestVariableCounter64Val::clone()
{
	MibEntryPtr other = new agentppTestVariableCounter64Val(oid);
	((agentppTestVariableCounter64Val*)other)->replace_value(value->clone());
	((agentppTestVariableCounter64Val*)other)->set_reference_to_table(my_table);

	//--AgentGen BEGIN=agentppTestVariableCounter64Val::clone
	//--AgentGen END
	return other;
}

void agentppTestVariableCounter64Val::get_request(Request* req, int ind)
{

	//--AgentGen BEGIN=agentppTestVariableCounter64Val::get_request
	//--AgentGen END
	MibLeaf::get_request(req, ind);
}

Counter64 agentppTestVariableCounter64Val::get_state()
{
	return *((Counter64*)value);
}

void agentppTestVariableCounter64Val::set_state(const Counter64& s)
{

	//--AgentGen BEGIN=agentppTestVariableCounter64Val::set_state
	//--AgentGen END
	*((Counter64*)value) = s;
}

int agentppTestVariableCounter64Val::set(const Vbx& vb)
{

	//--AgentGen BEGIN=agentppTestVariableCounter64Val::set
	//--AgentGen END
	return MibLeaf::set(vb);
}

boolean agentppTestVariableCounter64Val::value_ok(const Vbx& vb)
{

	//--AgentGen BEGIN=agentppTestVariableCounter64Val::value_ok
	//--AgentGen END
	return TRUE;
}

int agentppTestVariableCounter64Val::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = MibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;

	//--AgentGen BEGIN=agentppTestVariableCounter64Val::prepare_set_request
	//--AgentGen END
	return SNMP_ERROR_SUCCESS;
}


//--AgentGen BEGIN=agentppTestVariableCounter64Val
//--AgentGen END




/**
 *  agentppTestVariableOpaqueVal
 *
 */

agentppTestVariableOpaqueVal::agentppTestVariableOpaqueVal(const Oidx& id):
   MibLeaf(id, READCREATE, new OpaqueStr("\x44\x03\x46\x01\x01"), VMODE_DEFAULT)
{

	//--AgentGen BEGIN=agentppTestVariableOpaqueVal::agentppTestVariableOpaqueVal
	//--AgentGen END

}

agentppTestVariableOpaqueVal::~agentppTestVariableOpaqueVal()
{

	//--AgentGen BEGIN=agentppTestVariableOpaqueVal::~agentppTestVariableOpaqueVal
	//--AgentGen END
}

MibEntryPtr agentppTestVariableOpaqueVal::clone()
{
	MibEntryPtr other = new agentppTestVariableOpaqueVal(oid);
	((agentppTestVariableOpaqueVal*)other)->replace_value(value->clone());
	((agentppTestVariableOpaqueVal*)other)->set_reference_to_table(my_table);

	//--AgentGen BEGIN=agentppTestVariableOpaqueVal::clone
	//--AgentGen END
	return other;
}

void agentppTestVariableOpaqueVal::get_request(Request* req, int ind)
{

	//--AgentGen BEGIN=agentppTestVariableOpaqueVal::get_request
	//--AgentGen END
	MibLeaf::get_request(req, ind);
}

int agentppTestVariableOpaqueVal::set(const Vbx& vb)
{

	//--AgentGen BEGIN=agentppTestVariableOpaqueVal::set
	//--AgentGen END
	return MibLeaf::set(vb);
}

boolean agentppTestVariableOpaqueVal::value_ok(const Vbx& vb)
{

	//--AgentGen BEGIN=agentppTestVariableOpaqueVal::value_ok
	//--AgentGen END
	return TRUE;
}

int agentppTestVariableOpaqueVal::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = MibLeaf::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;

	//--AgentGen BEGIN=agentppTestVariableOpaqueVal::prepare_set_request
	//--AgentGen END
	return SNMP_ERROR_SUCCESS;
}


//--AgentGen BEGIN=agentppTestVariableOpaqueVal
//--AgentGen END




/**
 *  agentppTestVariableRowStatus
 *
 */

agentppTestVariableRowStatus::agentppTestVariableRowStatus(const Oidx& id):
   snmpRowStatus(id, READCREATE)

{

	//--AgentGen BEGIN=agentppTestVariableRowStatus::agentppTestVariableRowStatus
	//--AgentGen END

}

agentppTestVariableRowStatus::~agentppTestVariableRowStatus()
{

	//--AgentGen BEGIN=agentppTestVariableRowStatus::~agentppTestVariableRowStatus
	//--AgentGen END
}

MibEntryPtr agentppTestVariableRowStatus::clone()
{
	MibEntryPtr other = new agentppTestVariableRowStatus(oid);
	((agentppTestVariableRowStatus*)other)->replace_value(value->clone());
	((agentppTestVariableRowStatus*)other)->set_reference_to_table(my_table);

	//--AgentGen BEGIN=agentppTestVariableRowStatus::clone
	//--AgentGen END
	return other;
}

long agentppTestVariableRowStatus::get_state()
{
	return (long)*((SnmpInt32*)value);
}

void agentppTestVariableRowStatus::set_state(long l)
{

	//--AgentGen BEGIN=agentppTestVariableRowStatus::set_state
	//--AgentGen END
	*((SnmpInt32*)value) = l;
}

int agentppTestVariableRowStatus::set(const Vbx& vb)
{

	//--AgentGen BEGIN=agentppTestVariableRowStatus::set
	//--AgentGen END
	return snmpRowStatus::set(vb);
}

int agentppTestVariableRowStatus::prepare_set_request(Request* req, int& ind)
{
	int status;
	if ((status = snmpRowStatus::prepare_set_request(req, ind)) !=
	    SNMP_ERROR_SUCCESS) return status;

	//--AgentGen BEGIN=agentppTestVariableRowStatus::prepare_set_request
	//--AgentGen END
	return SNMP_ERROR_SUCCESS;
}


//--AgentGen BEGIN=agentppTestVariableRowStatus
//--AgentGen END




/**
 *  agentppTestVariableEntry
 *
 */

agentppTestVariableEntry* agentppTestVariableEntry::instance = 0;

const index_info indAgentppTestVariableEntry[1] = {
	{ sNMP_SYNTAX_INT, FALSE, 1, 1 } };

agentppTestVariableEntry::agentppTestVariableEntry():
   MibTable(oidAgentppTestVariableEntry, indAgentppTestVariableEntry, 1)
{
	// This table object is a singleton. In order to access it use
	// the static pointer agentppTestVariableEntry::instance.
	instance = this;

	add_col(new agentppTestVariableCounter32Val(colAgentppTestVariableCounter32Val));
	add_col(new agentppTestUnsigned32Val(colAgentppTestUnsigned32Val));
	add_col(new agentppTestVariableTimeTicksVal(colAgentppTestVariableTimeTicksVal));
	add_col(new agentppTestVariableInteger32Val(colAgentppTestVariableInteger32Val));
	add_col(new agentppTestVariableOctetStringVal(colAgentppTestVariableOctetStringVal));
	add_col(new agentppTestVariableIpAddressVal(colAgentppTestVariableIpAddressVal));
	add_col(new agentppTestVariableOidVal(colAgentppTestVariableOidVal));
	add_col(new agentppTestVariableCounter64Val(colAgentppTestVariableCounter64Val));
	add_col(new agentppTestVariableOpaqueVal(colAgentppTestVariableOpaqueVal));
	add_col(new agentppTestVariableRowStatus(colAgentppTestVariableRowStatus));

	//--AgentGen BEGIN=agentppTestVariableEntry::agentppTestVariableEntry
	//--AgentGen END
}

agentppTestVariableEntry::~agentppTestVariableEntry()
{

	//--AgentGen BEGIN=agentppTestVariableEntry::~agentppTestVariableEntry
	//--AgentGen END
}


//--AgentGen BEGIN=agentppTestVariableEntry
//--AgentGen END




agentpp_test_mib::agentpp_test_mib():
   MibGroup("1.3.6.1.4.1.4976.6.3", "agentppTestMIB")
{

	//--AgentGen BEGIN=agentpp_test_mib::agentpp_test_mib
	//--AgentGen END
	add(new agentppTestTimeout());
	add(new agentppTestVariableEntry());

	//--AgentGen BEGIN=agentpp_test_mib::agentpp_test_mib:post
	//--AgentGen END
}


//--AgentGen BEGIN=agentpp_test_mib
//--AgentGen END



//--AgentGen BEGIN=_END
#ifdef AGENTPP_NAMESPACE
}
#endif

//--AgentGen END
