/*_############################################################################
  _## 
  _##  agentpp_notifytest_mib.h  
  _## 
  _##
  _##  AGENT++Win32 API Version 1.4a
  _##  ---------------------------------------------------------
  _##  Copyright (C) 2003-2004, Frank Fock, All rights reserved.
  _##  
  _##  LICENSE AGREEMENT
  _##
  _##
  _##  Use of this software is subject to the license agreement you received
  _##  with this software and which can be downloaded from 
  _##  http://www.agentpp.com/agentX++/license.txt
  _##
  _##  This is licensed software and may not be used in a commercial
  _##  environment, except for evaluation purposes, unless a valid
  _##  license has been purchased.
  _##
  _##
  _##  Stuttgart, Germany, Thu Sep  2 00:08:13 CEST 2010 
  _##  
  _##########################################################################*/



//--AgentGen BEGIN=_BEGIN
//--AgentGen END


#ifndef _agentpp_notifytest_mib_h
#define _agentpp_notifytest_mib_h


#include <agent_pp/mib.h>
#include <agent_pp/snmp_textual_conventions.h>
#include <agent_pp/notification_originator.h>
#include <snmp_pp/log.h>


#define oidAgentppNotifyTest             "1.3.6.1.4.1.4976.6.2.1.1.0"
#define oidAgentppNotifyTestAllTypes     "1.3.6.1.4.1.4976.6.2.2.0.1"



//--AgentGen BEGIN=_INCLUDE
#ifdef AGENTPP_NAMESPACE
namespace Agentpp {
#endif
//--AgentGen END


/**
 *  agentppNotifyTest
 *
 * "By setting this object to one of its enumerated
 * values generates a corresponding notification.
 * When reading this object it will return the value
 * corresponding to the last notification type sent."
 */


class agentppNotifyTest: public MibLeaf {

public:
	agentppNotifyTest();
	virtual ~agentppNotifyTest();

	static agentppNotifyTest* instance;

	virtual long       	get_state();
	virtual void       	set_state(long);
	virtual int        	set(const Vbx&);
	virtual int        	prepare_set_request(Request*, int&);
	virtual boolean    	value_ok(const Vbx&);
	enum labels {
		e_agentppNotifyTestAllTypes = 1 };

//--AgentGen BEGIN=agentppNotifyTest
	void send_agentppNotifyTestAllTypes();
//--AgentGen END
};


/**
 *  agentppNotifyTestAllTypes
 *
 * "A notification with objects of all possible SNMPv2/v3 types."
 */


class agentppNotifyTestAllTypes: public NotificationOriginator {

public:
	agentppNotifyTestAllTypes();
	virtual ~agentppNotifyTestAllTypes();

	virtual void        	generate(Vbx*, int, const OctetStr&);

//--AgentGen BEGIN=agentppNotifyTestAllTypes
//--AgentGen END
};


class agentpp_notifytest_mib: public MibGroup
{
  public:
	agentpp_notifytest_mib();
	virtual ~agentpp_notifytest_mib() { }

//--AgentGen BEGIN=agentpp_notifytest_mib
//--AgentGen END

};

//--AgentGen BEGIN=_END
#ifdef AGENTPP_NAMESPACE
}
#endif

//--AgentGen END

#endif


