/*_############################################################################
  _## 
  _##  ATMExample.cpp  
  _## 
  _##
  _##  AGENT++Win32 API Version 1.4a
  _##  ---------------------------------------------------------
  _##  Copyright (C) 2003-2004, Frank Fock, All rights reserved.
  _##  
  _##  LICENSE AGREEMENT
  _##
  _##
  _##  Use of this software is subject to the license agreement you received
  _##  with this software and which can be downloaded from 
  _##  http://www.agentpp.com/agentX++/license.txt
  _##
  _##  This is licensed software and may not be used in a commercial
  _##  environment, except for evaluation purposes, unless a valid
  _##  license has been purchased.
  _##
  _##
  _##  Stuttgart, Germany, Thu Sep  2 00:08:13 CEST 2010 
  _##  
  _##########################################################################*/


#include <snmp.h>
#include "stdafx.h"
#include <snmp_pp/log.h>
#include "agentpp_notifytest_mib.h"
#include "agentpp_test_mib.h"
#include "atm_mib.h"
#include "ATMExample.h"
#include "subagent_win32.h"

// globals
Mib* mib;
Win32RequestList* requestList;

BOOL WINAPI DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
	switch (ul_reason_for_call)
	{
	case DLL_PROCESS_ATTACH:
	case DLL_THREAD_ATTACH:
	case DLL_THREAD_DETACH:
	case DLL_PROCESS_DETACH:
		break;
	}
	SnmpSvcSetLogLevel(SNMP_LOG_VERBOSE);
	SnmpSvcSetLogType(SNMP_OUTPUT_TO_CONSOLE);

	return TRUE;
}

BOOL WINAPI SnmpExtensionInit(DWORD dwUptimeReference,
			         		  HANDLE *phSubagentTrapEvent,
					          AsnObjectIdentifier *pFirstSupportedRegion)
{
	DefaultLog::init(new Win32Log());

#ifndef _NO_LOGGING
	DefaultLog::log()->set_filter(ERROR_LOG, 8);
	DefaultLog::log()->set_filter(WARNING_LOG, 8);
	DefaultLog::log()->set_filter(EVENT_LOG, 8);
	DefaultLog::log()->set_filter(INFO_LOG, 8);
	DefaultLog::log()->set_filter(DEBUG_LOG, 8);
#endif	

	mib = new Mib();


	mib->add(new atm_mib());
	mib->add(new agentpp_notifytest_mib());
	mib->add(new agentpp_test_mib());

	requestList = new Win32RequestList();
	mib->set_request_list(requestList);
	// register notification sender
	mib->set_notification_sender(requestList);

	return requestList->init(mib,
		                     phSubagentTrapEvent,
		                     pFirstSupportedRegion);
}

BOOL WINAPI SnmpExtensionInitEx(AsnObjectIdentifier *pNextSupportedRegion)
{
//	return FALSE;
	return requestList->init_next(pNextSupportedRegion);
}

BOOL WINAPI SnmpExtensionQuery(
  BYTE bPduType,                  // SNMPv1 PDU request type
  SnmpVarBindList *pVarBindList,  // pointer to variable bindings
  AsnInteger32 *pErrorStatus,     // pointer to SNMPv1 error status
  AsnInteger32 *pErrorIndex       // pointer to the error index
)
{
	return FALSE;
}


BOOL WINAPI SnmpExtensionQueryEx(DWORD dwRequestType,
	                             DWORD dwTransactionId,
								 SnmpVarBindList *pVarBindList,
								 AsnOctetString *pContextInfo,
								 AsnInteger32 *pErrorStatus,
								 AsnInteger32 *pErrorIndex)
{
	return requestList->query(dwRequestType, dwTransactionId, 
		                      pVarBindList, pContextInfo,
		                      pErrorStatus, pErrorIndex);
}

BOOL WINAPI SnmpExtensionTrap(AsnObjectIdentifier *pEnterpriseOid,
							  AsnInteger32 *pGenericTrapId,
							  AsnInteger32 *pSpecificTrapId,
							  AsnTimeticks *pTimeStamp,
							  SnmpVarBindList *pVarBindList)
{
	return requestList->trap(pEnterpriseOid, pGenericTrapId,
		                     pSpecificTrapId, pTimeStamp, pVarBindList);
}

VOID WINAPI SnmpExtensionClose() 
{
	// requestList is deleted by Mib destructor
	// because we set the requestList as NotificationSender:
	// delete requestList;
	delete mib;
}
