/*_############################################################################
  _## 
  _##  agentx_pp_master.h  
  _## 
  _##
  _##  AGENT++Win32 API Version 1.4a
  _##  ---------------------------------------------------------
  _##  Copyright (C) 2003-2004, Frank Fock, All rights reserved.
  _##  
  _##  LICENSE AGREEMENT
  _##
  _##
  _##  Use of this software is subject to the license agreement you received
  _##  with this software and which can be downloaded from 
  _##  http://www.agentpp.com/agentX++/license.txt
  _##
  _##  This is licensed software and may not be used in a commercial
  _##  environment, except for evaluation purposes, unless a valid
  _##  license has been purchased.
  _##
  _##
  _##  Stuttgart, Germany, Thu Sep  2 00:08:13 CEST 2010 
  _##  
  _##########################################################################*/

#include <snmp.h>
#include <agentx_pp/agentx_master.h>

// The following ifdef block is the standard way of creating macros which make exporting 
// from a DLL simpler. All files within this DLL are compiled with the AGENTX_PP_MASTER_EXPORTS
// symbol defined on the command line. this symbol should not be defined on any project
// that uses this DLL. This way any other project whose source files include this file see 
// AGENTX_PP_MASTER_API functions as being imported from a DLL, whereas this DLL sees symbols
// defined with this macro as being exported.
#ifndef AGENTX_PP_MASTER_DECL
	#if defined (WIN32) && defined (AGENTX_PP_MASTER_DLL)
		#ifdef AGENTX_PP_MASTER_EXPORTS
			#define AGENTX_PP_MASTER_DECL __declspec(dllexport)
			#pragma warning (disable : 4018)	// signed/unsigned mismatch when exporting templates
		#else
			#define AGENTX_PP_MASTER_DECL __declspec(dllimport)
			#pragma warning (disable : 4231)	// disable warnings on extern before template instantiation
		#endif
	#else
		#define AGENTX_PP_MASTER_DECL
	#endif
#endif
//#ifdef AGENTX_PP_MASTER_DLL
//#define AGENTX_PP_MASTER_API __declspec(dllexport)
//#else
//#define AGENTX_PP_MASTER_API __declspec(dllimport)
//#endif

// This class is exported from the agentx_pp_master.dll

#ifdef AGENTPP_NAMESPACE
namespace Agentpp {
#endif


/**
 * The ExtensionDLL class represents a registered subtree of an 
 * extension DLL. The static init() factory method is used to
 * the first instance for a extension DLL. Subsequent subtrees
 * managed by the same extension DLL are then created by calling
 * the init_ex() method on the initial instance until init_ex()
 * returns 0.
 *
 * @author Frank Fock
 * @version 1.0
 */
class AGENTX_PP_MASTER_DECL ExtensionDLL: public MibComplexEntry 
{
public:
	virtual ~ExtensionDLL();

	static ExtensionDLL* init(Mib*, const char* dllName);

	/**
	 * Create an ExtensionDLL instance for the next subtree 
	 * managed by this extension DLL.
	 * @returns
     *    a pointer to an ExtensionDLL instance or <code>null</code>
	 *    if no such subtree is available.
	 */
	ExtensionDLL* init_ex();

	/**
	 * Return a clone of the receiver.
	 *
	 * @return
	 *    a pointer to a clone of the MibComplexEntry object.  
	 */
	virtual MibEntry*	clone();

	/**
	 * Return the successor of a given object identifier within the 
	 * receiver's scope and the context of a given Request.
	 *
	 * @param oid
	 *    an object identifier
	 * @param request
	 *    a pointer to a Request instance.
	 * @return 
	 *    an object identifier if a successor could be found,
	 *    otherwise (if no successor exists or is out of scope) 
	 *    a zero length oid is returned
	 */
	virtual Oidx		find_succ(const Oidx&, Request* req = 0);
	
	/**
	 * Let the receiver process a SNMP GET subrequest
	 * 
	 * @param req - A pointer to the whole SNMP GET request.
	 * @param ind - The index of the subrequest to be processed.
	 */
	virtual void		get_request(Request*, int);

	/**
	 * Let the receiver process a SNMP GETNEXT subrequest
	 * 
	 * @param req - A pointer to the whole SNMP GETNEXT request.
	 * @param ind - The index of the subrequest to be processed.
	 */
	virtual void		get_next_request(Request*, int);
	
	/**
	 * Let the receiver commit a SNMP SET subrequest
	 * 
	 * @param req - A pointer to the whole SNMP SET request.
	 * @param ind - The index of the subrequest to be processed.
	 * @return SNMP_ERROR_SUCCESS on success and 
	 *         SNMP_ERROR_COMITFAIL on failure.
	 */
	virtual int			commit_set_request(Request*, int);

	/**
	 * Let the receiver prepare a SNMP SET subrequest
	 * 
	 * @param req - A pointer to the whole SNMP SET request.
	 * @param ind - The index of the subrequest to be processed.
	 * @return SNMP_ERROR_SUCCESS on success and SNMP_ERROR_WRONG_VALUE,
	 *         SNMP_ERROR_WRONG_TYPE, or 
	 *         SNMP_ERROR_NOT_WRITEABLE on failure.
	 */
	virtual int			prepare_set_request(Request*, int&); 

	/**
	 * Let the receiver undo a SNMP SET subrequest
	 * 
	 * @param req - A pointer to the whole SNMP SET request.
	 * @param ind - The index of the subrequest to be processed.
	 * @return SNMP_ERROR_SUCCESS on success and 
	 *         SNMP_ERROR_UNDO_FAIL on failure.
	 */
	virtual int	        undo_set_request(Request*, int&);

	/**
	 * Clean up resources used for performing (or undoing) set requests. 
	 *
	 * @param req - A pointer to the whole SNMP SET request.
	 * @param ind - The index of the subrequest to be processed.
	 */
	virtual void		cleanup_set_request(Request*, int&);


	static void			copy_oid(const Oidx&, AsnObjectIdentifier&);
	static int			copy_vbs(Vbx*, unsigned int, SnmpVarBindList*);
	static void         free_vbs(SnmpVarBindList*);
	static boolean		get_vb(const SnmpVarBindList&, unsigned int, Vbx&);

	HANDLE				get_event_handle() { return eventHandle; }

	PFNSNMPEXTENSIONTRAP		trap;

protected:

	ExtensionDLL(Mib*,
		         HINSTANCE, 
		         HANDLE, 
		         PFNSNMPEXTENSIONQUERY,
				 PFNSNMPEXTENSIONQUERYEX,
				 PFNSNMPEXTENSIONTRAP,
			     const Oidx&, 
				 mib_access);
	virtual int					process_set_request(Request*, int&, int);

	HINSTANCE					hDll;
	HANDLE						eventHandle;

	PFNSNMPEXTENSIONQUERY		query;
	PFNSNMPEXTENSIONQUERYEX		queryEx;
	AsnOctetString				contextInfo;

	Mib*						mib;
};


class MasterAgentXMibWin32;

/**
 * The TrapPoller class receives traps and notifications from various 
 * extension DLLs and forwards them to the master agent.
 * @author Frank Fock
 * @version 1.1
 */
class AGENTX_PP_MASTER_DECL TrapPoller: public Thread 
{
public:
    TrapPoller::TrapPoller(MasterAgentXMibWin32* m)
				{ mib = m; stopit = FALSE; pauseit = FALSE;
					hStopEvent = CreateEvent(NULL, TRUE, FALSE, NULL); }

    virtual TrapPoller::~TrapPoller() { stop(); join(); extensions.clear();
		CloseHandle(hStopEvent); }

	/**
	 * Stops the trap/notification poller thread. After it has been
	 * stopped it cannot be started (run) again.
	 */
	void	stop() { stopit = TRUE; SetEvent(hStopEvent); }

	/**
	 * Pauses polling for traps if called for the first time. 
	 * Subsequent calls toggle the pause state.
	 */
	void	pause() { pauseit = !pauseit; }

	/**
	 * Adds an extension DLL to the list of polled subagents.
	 * @param extension
	 *    a pointer to an ExtensionDLL main (initial) instance.
	 */
	void	add_extension(ExtensionDLL* extension) 
				{ extensions.addLast(extension); }

	/**
	 * Process a trap or notification that is available from the
	 * supplied extension DLL.
	 * @param extension
	 *    a pointer to an ExtensionDLL main (initial) instance
	 *    that has signalled that is has one or more traps/notifications
	 *    waiting.
	 */
	void process_trap(ExtensionDLL*);

	/**
	 * Runs the poller thread. 
	 */
    void run();

private:
	boolean					stopit;
	boolean					pauseit;
    MasterAgentXMibWin32*	mib;
	Array<MibEntry>			extensions;
	HANDLE					hStopEvent;
};


/**
 * The MasterAgentXMibWin32 is a subclass of the AgentX++ MasterAgentXMib
 * and implements an SNMPv1/v2c/v3 AgentX master agent that also implements 
 * the extensible agent API for Win32 platforms.
 * 
 * @author Frank Fock
 * @version 1.2
 */
class AGENTX_PP_MASTER_DECL MasterAgentXMibWin32: public MasterAgentXMib {
	friend DWORD WINAPI ServiceWorker(LPVOID threadParam);
	friend DWORD WINAPI HandlerEx(DWORD dwControl, DWORD dwEventType,
			LPVOID lpEventData, LPVOID lpContext);

public:

	MasterAgentXMibWin32();
	virtual ~MasterAgentXMibWin32();

	static void			Service(int argc, LPTSTR* argv);
	
	/**
	 * Sets the name of the SNMP service (default is "SNMP")
	 * @param name
	 *    a pointer to the name of the service. 
	 *    The name must not be freed while this process is
	 *    running. If name is 0, the default name will be used.
	 */
	static void			set_service_name(char* name);

	/**
	 * Starts the SNMP service.
	 * @return
	 *    TRUE on success and FALSE on failure.
	 */
	static boolean		start_service();

	/**
	 * Installs the SNMP service.
	 * @param exePath
	 *    path to the exe file of the service process.
	 * @return
	 *    TRUE on success and FALSE on failure.
	 */
	static boolean		install_service(char* exePath);

	/**
	 * Unsinstalls the SNMP service.
	 * @return
	 *    TRUE on success and FALSE on failure.
	 */
	static boolean      uninstall_service();

	/**
	 * Initializes the SNMP service.
	 * @return
	 *    TRUE on success and FALSE on failure.
	 */
	boolean				init_service(); 
	
	/**
	 * Sets the service status.
	 * @param status
	 *    a service status, e.g. SERVICE_STOPPED.
	 * @param checkPoint
	 *    an incrementing value for start/stop progress bar
	 * @param waitHint
	 *    a suggested time (in msec) before timeout
	 * @return
	 *    TRUE on success and FALSE on failure.
	 */
	boolean				set_service_status( DWORD status,
			DWORD checkPoint = 0, DWORD waitHint = 0); 


	/**
	 * Start the master agent thread and initialize extension DLLs.
	 *
	 * @return 
	 *    TRUE if initialization was successful, FALSE otherwise.
	 */
	virtual boolean		init();


	virtual int         get_boot_counter(const OctetStr&, unsigned int&);
	virtual int         set_boot_counter(const OctetStr&, unsigned int);

	/**
	 * Gets the intial passphrase from the registry.
	 * @param 
	 *    security protocol type ("auth" or "priv").
	 * @returns
	 *    a pointer to an OctetStr instance if an intial passphrase could
	 *    be found in the registry for the given security protocol type.
	 *    Otherwise <code>null</code> is returned.
	 */
	virtual OctetStr*	get_initial_passphrase(const OctetStr& type) const;

	/**
	 * Gets the configuration path for persistent objects.
	 * @return
	 *    a pointer to an OctetStr instance denoting the directory where 
	 *    persistent objects should be stored. It returns 0 if a persistent
	 *    objects path is not set in the registry.
	 */
	virtual OctetStr*	get_config_path() const;

	static int			runStatus;

protected:
	virtual void        init_v3_security();
	virtual void		init_notification_targets();
	virtual void		init_communities();
	virtual void		init_source_addresses();
	virtual void		init_trap_poller();

	OctetStr			make_target_address(const UdpAddress& addr) const;

	int					create_engine_key(const OctetStr&);
	int					get_engine_key(const OctetStr&);

	void				add_target_params(const OctetStr&);
	void				add_target(const UdpAddress&, const OctetStr&);

	TrapPoller*			trapPoller;

	SERVICE_STATUS          serviceStatus; 
	SERVICE_STATUS_HANDLE   hServiceStatusHandle; 
	boolean				service;
	static HANDLE		hServiceMainThread;
	HANDLE				hIOCPort;
	v3MP*				v3mp;
	Snmpx*				snmp;
};

#ifdef AGENTPP_NAMESPACE
}
#endif
