/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport.tls;

import java.io.Serializable;
import java.security.Principal;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;
import org.snmp4j.transport.TLSTM;
import org.snmp4j.transport.tls.SecurityNameMapping;
import org.snmp4j.transport.tls.TlsTmSecurityCallback;

public class DefaultTlsTmSecurityCallback
implements TlsTmSecurityCallback<X509Certificate> {
    private LogAdapter LOGGER = LogFactory.getLogger(DefaultTlsTmSecurityCallback.class);
    private Map<SecurityNameMapping, OctetString> securityNameMapping = new HashMap<SecurityNameMapping, OctetString>();
    private Map<Address, String> localCertMapping = new HashMap<Address, String>();
    private Set<String> acceptedSubjectDN = new HashSet<String>();
    private Set<String> acceptedIssuerDN = new HashSet<String>();

    public OctetString getSecurityName(X509Certificate[] peerCertificateChain) {
        for (Map.Entry<SecurityNameMapping, OctetString> entry : this.securityNameMapping.entrySet()) {
            OctetString fingerprint = entry.getKey().getFingerprint();
            for (X509Certificate cert : peerCertificateChain) {
                OctetString certFingerprint = null;
                certFingerprint = TLSTM.getFingerprint(cert);
                if (certFingerprint == null || !certFingerprint.equals(fingerprint)) continue;
                SecurityNameMapping.CertMappingType mappingType = entry.getKey().getType();
                OctetString data = entry.getKey().getData();
                OctetString tmSecurityName = null;
                try {
                    tmSecurityName = this.mapCertToTSN(cert, mappingType, data);
                }
                catch (CertificateParsingException e2) {
                    this.LOGGER.warn((Serializable)((Object)("Failed to parse client certificate: " + e2.getMessage())));
                }
                if (tmSecurityName == null || tmSecurityName.length() > 32) continue;
                return tmSecurityName;
            }
        }
        return null;
    }

    private OctetString mapCertToTSN(X509Certificate cert, SecurityNameMapping.CertMappingType mappingType, OctetString data) throws CertificateParsingException {
        switch (mappingType) {
            case Specified: {
                return data;
            }
            case SANAny: 
            case SANRFC822Name: {
                Object entry = TLSTM.getSubjAltName(cert.getSubjectAlternativeNames(), 1);
                if (entry != null) {
                    String[] rfc822Name = ((String)entry).split("@");
                    return new OctetString(rfc822Name[0] + "@" + rfc822Name[1].toLowerCase());
                }
            }
            case SANDNSName: {
                Object entry = TLSTM.getSubjAltName(cert.getSubjectAlternativeNames(), 2);
                if (entry != null) {
                    String dNSName = ((String)entry).toLowerCase();
                    return new OctetString(dNSName);
                }
            }
            case SANIpAddress: {
                Object entry = TLSTM.getSubjAltName(cert.getSubjectAlternativeNames(), 7);
                if (entry != null) {
                    String ipAddress = ((String)entry).toLowerCase();
                    if (ipAddress.indexOf(58) >= 0) {
                        String[] bytes;
                        StringBuilder buf = new StringBuilder(16);
                        for (String b2 : bytes = ipAddress.split(":")) {
                            for (int diff = 2 - b2.length(); diff > 0; --diff) {
                                buf.append('0');
                            }
                            buf.append(b2);
                        }
                        return new OctetString(buf.toString());
                    }
                    return new OctetString(ipAddress);
                }
            }
            case CommonName: {
                X500Principal x500Principal = cert.getSubjectX500Principal();
                return new OctetString(x500Principal.getName());
            }
        }
        return null;
    }

    @Override
    public boolean isClientCertificateAccepted(X509Certificate peerEndCertificate) {
        return this.acceptedSubjectDN.contains(peerEndCertificate.getSubjectDN().getName());
    }

    public boolean isServerCertificateAccepted(X509Certificate[] peerCertificateChain) {
        String subject = peerCertificateChain[0].getSubjectDN().getName();
        if (this.acceptedSubjectDN.contains(subject)) {
            return true;
        }
        for (X509Certificate cert : peerCertificateChain) {
            Principal issuerDN = cert.getIssuerDN();
            if (issuerDN == null || !this.acceptedIssuerDN.contains(issuerDN.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAcceptedIssuer(X509Certificate issuerCertificate) {
        Principal issuerDN = issuerCertificate.getIssuerDN();
        return issuerDN != null && this.acceptedIssuerDN.contains(issuerDN.getName());
    }

    @Override
    public String getLocalCertificateAlias(Address targetAddress) {
        String localCert = this.localCertMapping.get(targetAddress);
        if (localCert == null) {
            return this.localCertMapping.get(null);
        }
        return localCert;
    }

    public void addSecurityNameMapping(OctetString fingerprint, SecurityNameMapping.CertMappingType type, OctetString data, OctetString securityName) {
        this.securityNameMapping.put(new SecurityNameMapping(fingerprint, data, type, securityName), securityName);
    }

    public OctetString removeSecurityNameMapping(OctetString fingerprint, SecurityNameMapping.CertMappingType type, OctetString data) {
        return this.securityNameMapping.remove(new SecurityNameMapping(fingerprint, data, type, null));
    }

    public void addAcceptedIssuerDN(String issuerDN) {
        this.acceptedIssuerDN.add(issuerDN);
    }

    public boolean removeAcceptedIssuerDN(String issuerDN) {
        return this.acceptedIssuerDN.remove(issuerDN);
    }

    public void addAcceptedSubjectDN(String subjectDN) {
        this.acceptedSubjectDN.add(subjectDN);
    }

    public boolean removeAcceptedSubjectDN(String subjectDN) {
        return this.acceptedSubjectDN.remove(subjectDN);
    }

    public void addLocalCertMapping(Address address, String certAlias) {
        this.localCertMapping.put(address, certAlias);
    }

    public String removeLocalCertMapping(Address address) {
        return this.localCertMapping.remove(address);
    }
}

