/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.smi;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.AbstractVariable;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.AssignableFromByteArray;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.SMIAddress;
import org.snmp4j.smi.Variable;

public class IpAddress
extends SMIAddress
implements AssignableFromByteArray {
    private static final long serialVersionUID = -146846354059565449L;
    private static final LogAdapter logger = LogFactory.getLogger(AbstractVariable.class);
    private static final byte[] IPANYADDRESS = new byte[]{0, 0, 0, 0};
    public static final InetAddress ANY_IPADDRESS = IpAddress.createAnyAddress();
    private InetAddress inetAddress;

    public IpAddress() {
        this.inetAddress = ANY_IPADDRESS;
    }

    public IpAddress(InetAddress address) {
        if (address == null) {
            throw new NullPointerException();
        }
        this.inetAddress = address;
    }

    public IpAddress(String address) {
        if (!this.parseAddress(address)) {
            throw new IllegalArgumentException(address);
        }
    }

    public IpAddress(byte[] addressBytes) {
        try {
            this.inetAddress = InetAddress.getByAddress(addressBytes);
        }
        catch (UnknownHostException ex) {
            throw new IllegalArgumentException("Unknown host: " + ex.getMessage());
        }
    }

    @Override
    public int getSyntax() {
        return 64;
    }

    @Override
    public boolean isValid() {
        return this.inetAddress != null;
    }

    @Override
    public String toString() {
        if (this.inetAddress != null) {
            String addressString = this.inetAddress.toString();
            return addressString.substring(addressString.indexOf(47) + 1);
        }
        return "0.0.0.0";
    }

    @Override
    public int hashCode() {
        if (this.inetAddress != null) {
            return this.inetAddress.hashCode();
        }
        return 0;
    }

    public static Address parse(String address) {
        try {
            InetAddress addr = InetAddress.getByName(address);
            return new IpAddress(addr);
        }
        catch (Exception ex) {
            logger.error("Unable to parse IpAddress from: " + address, ex);
            return null;
        }
    }

    @Override
    public boolean parseAddress(String address) {
        try {
            this.inetAddress = InetAddress.getByName(address);
            return true;
        }
        catch (UnknownHostException uhex) {
            return false;
        }
    }

    @Override
    public int compareTo(Variable o2) {
        OctetString a2 = new OctetString(this.inetAddress.getAddress());
        return a2.compareTo(new OctetString(((IpAddress)o2).getInetAddress().getAddress()));
    }

    @Override
    public boolean equals(Object o2) {
        return o2 instanceof IpAddress && this.compareTo((IpAddress)o2) == 0;
    }

    @Override
    public void decodeBER(BERInputStream inputStream) throws IOException {
        BER.MutableByte type = new BER.MutableByte();
        byte[] value = BER.decodeString(inputStream, type);
        if (type.getValue() != 64) {
            throw new IOException("Wrong type encountered when decoding Counter: " + type.getValue());
        }
        if (value.length != 4) {
            throw new IOException("IpAddress encoding error, wrong length: " + value.length);
        }
        this.inetAddress = InetAddress.getByAddress(value);
    }

    @Override
    public void encodeBER(OutputStream outputStream) throws IOException {
        byte[] address = new byte[4];
        if (this.inetAddress instanceof Inet6Address) {
            Inet6Address v6Addr = (Inet6Address)this.inetAddress;
            if (v6Addr.isIPv4CompatibleAddress()) {
                byte[] v6Bytes = this.inetAddress.getAddress();
                System.arraycopy(v6Bytes, v6Bytes.length - 5, address, 0, 4);
            }
        } else {
            System.arraycopy(this.inetAddress.getAddress(), 0, address, 0, 4);
        }
        BER.encodeString(outputStream, (byte)64, address);
    }

    @Override
    public int getBERLength() {
        return 6;
    }

    public void setAddress(byte[] rawValue) throws UnknownHostException {
        this.inetAddress = InetAddress.getByAddress(rawValue);
    }

    public void setInetAddress(InetAddress inetAddress) {
        this.inetAddress = inetAddress;
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    private static InetAddress createAnyAddress() {
        try {
            return InetAddress.getByAddress(IPANYADDRESS);
        }
        catch (Exception ex) {
            logger.error("Unable to create any IpAddress: " + ex.getMessage(), ex);
            return null;
        }
    }

    @Override
    public Object clone() {
        return new IpAddress(this.inetAddress);
    }

    @Override
    public int toInt() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long toLong() {
        throw new UnsupportedOperationException();
    }

    @Override
    public OID toSubIndex(boolean impliedLength) {
        byte[] address = new byte[4];
        System.arraycopy(this.inetAddress.getAddress(), 0, address, 0, 4);
        OID subIndex = new OID(new int[4]);
        for (int i2 = 0; i2 < address.length; ++i2) {
            subIndex.set(i2, address[i2] & 0xFF);
        }
        return subIndex;
    }

    @Override
    public void fromSubIndex(OID subIndex, boolean impliedLength) {
        byte[] rawValue = new byte[4];
        for (int i2 = 0; i2 < rawValue.length; ++i2) {
            rawValue[i2] = (byte)(subIndex.get(i2) & 0xFF);
        }
        try {
            this.setAddress(rawValue);
        }
        catch (UnknownHostException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void setValue(String value) {
        if (!this.parseAddress(value)) {
            throw new IllegalArgumentException(value + " cannot be parsed by " + this.getClass().getName());
        }
    }

    @Override
    public void setValue(byte[] value) {
        try {
            this.setAddress(value);
        }
        catch (UnknownHostException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public byte[] toByteArray() {
        if (this.getInetAddress() != null) {
            return this.getInetAddress().getAddress();
        }
        return null;
    }
}

