/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import org.snmp4j.SNMP4JSettings;
import org.snmp4j.User;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

public class UsmUser
implements User,
Comparable,
Cloneable {
    private static final long serialVersionUID = -2258973598142206767L;
    private OctetString securityName;
    private OctetString authenticationPassphrase;
    private OctetString privacyPassphrase;
    private OID authenticationProtocol;
    private OID privacyProtocol;
    private OctetString localizationEngineID;

    public UsmUser(OctetString securityName, OID authenticationProtocol, OctetString authenticationPassphrase, OID privacyProtocol, OctetString privacyPassphrase) {
        if (securityName == null) {
            throw new NullPointerException();
        }
        if (SNMP4JSettings.isCheckUsmUserPassphraseLength()) {
            if (authenticationProtocol != null && authenticationPassphrase != null && authenticationPassphrase.length() < 8) {
                throw new IllegalArgumentException("USM passphrases must be at least 8 bytes long (RFC3414 \u00a711.2)");
            }
            if (privacyProtocol != null && privacyPassphrase != null && privacyPassphrase.length() < 8) {
                throw new IllegalArgumentException("USM passphrases must be at least 8 bytes long (RFC3414 \u00a711.2)");
            }
        }
        this.securityName = securityName;
        this.authenticationProtocol = authenticationProtocol;
        this.authenticationPassphrase = authenticationPassphrase;
        this.privacyProtocol = privacyProtocol;
        this.privacyPassphrase = privacyPassphrase;
    }

    public UsmUser(OctetString securityName, OID authenticationProtocol, OctetString authenticationPassphrase, OID privacyProtocol, OctetString privacyPassphrase, OctetString localizationEngineID) {
        this(securityName, authenticationProtocol, authenticationPassphrase, privacyProtocol, privacyPassphrase);
        this.localizationEngineID = localizationEngineID;
    }

    public OctetString getSecurityName() {
        return (OctetString)this.securityName.clone();
    }

    public OID getAuthenticationProtocol() {
        if (this.authenticationProtocol == null) {
            return null;
        }
        return (OID)this.authenticationProtocol.clone();
    }

    public OID getPrivacyProtocol() {
        if (this.privacyProtocol == null) {
            return null;
        }
        return (OID)this.privacyProtocol.clone();
    }

    public OctetString getAuthenticationPassphrase() {
        if (this.authenticationPassphrase == null) {
            return null;
        }
        return (OctetString)this.authenticationPassphrase.clone();
    }

    public OctetString getPrivacyPassphrase() {
        if (this.privacyPassphrase == null) {
            return null;
        }
        return (OctetString)this.privacyPassphrase.clone();
    }

    public OctetString getLocalizationEngineID() {
        return this.localizationEngineID;
    }

    public boolean isLocalized() {
        return this.localizationEngineID != null;
    }

    public int getSecurityModel() {
        return 3;
    }

    public int compareTo(Object o2) {
        UsmUser other = (UsmUser)o2;
        return this.securityName.compareTo(other.securityName);
    }

    public Object clone() {
        UsmUser copy = new UsmUser(this.securityName, this.authenticationProtocol, this.authenticationPassphrase, this.privacyProtocol, this.privacyPassphrase, this.localizationEngineID);
        return copy;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        UsmUser usmUser = (UsmUser)o2;
        if (!this.securityName.equals(usmUser.securityName)) {
            return false;
        }
        if (this.authenticationPassphrase != null ? !this.authenticationPassphrase.equals(usmUser.authenticationPassphrase) : usmUser.authenticationPassphrase != null) {
            return false;
        }
        if (this.privacyPassphrase != null ? !this.privacyPassphrase.equals(usmUser.privacyPassphrase) : usmUser.privacyPassphrase != null) {
            return false;
        }
        if (this.authenticationProtocol != null ? !this.authenticationProtocol.equals(usmUser.authenticationProtocol) : usmUser.authenticationProtocol != null) {
            return false;
        }
        if (this.privacyProtocol != null ? !this.privacyProtocol.equals(usmUser.privacyProtocol) : usmUser.privacyProtocol != null) {
            return false;
        }
        return !(this.localizationEngineID != null ? !this.localizationEngineID.equals(usmUser.localizationEngineID) : usmUser.localizationEngineID != null);
    }

    public int hashCode() {
        return this.securityName.hashCode();
    }

    public String toString() {
        return "UsmUser[secName=" + this.securityName + ",authProtocol=" + this.authenticationProtocol + ",authPassphrase=" + this.authenticationPassphrase + ",privProtocol=" + this.privacyProtocol + ",privPassphrase=" + this.privacyPassphrase + ",localizationEngineID=" + this.getLocalizationEngineID() + "]";
    }
}

