/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.model.snmp.proxy.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.snmp4j.Target;
import org.snmp4j.model.mapper.VariableBindingMapper;
import org.snmp4j.model.snmp.proxy.SnmpProxyColumn;
import org.snmp4j.model.snmp.proxy.SnmpProxyIndexColumn;
import org.snmp4j.model.snmp.proxy.SnmpProxyRow;
import org.snmp4j.model.snmp.proxy.SnmpProxyRowFactory;
import org.snmp4j.model.snmp.proxy.SnmpProxyRowFilter;
import org.snmp4j.model.snmp.proxy.SnmpTableRO;
import org.snmp4j.model.snmp.proxy.TaskId;
import org.snmp4j.model.snmp.proxy.impl.SnmpColumn;
import org.snmp4j.model.snmp.proxy.impl.SnmpProxyObjectHelper;
import org.snmp4j.model.snmp.proxy.impl.SnmpValuesChangeSet;
import org.snmp4j.model.snmp.spi.SnmpCell;
import org.snmp4j.model.snmp.spi.SnmpErrorStatus;
import org.snmp4j.model.snmp.spi.SnmpException;
import org.snmp4j.model.snmp.spi.SnmpProxyReloadListener;
import org.snmp4j.model.snmp.spi.SnmpRow;
import org.snmp4j.model.snmp.spi.SnmpRowListener;
import org.snmp4j.model.snmp.spi.SnmpService;
import org.snmp4j.smi.AbstractVariable;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.UnsignedInteger32;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class SnmpTableImplRO<C extends SnmpProxyColumn, IC extends SnmpProxyIndexColumn, IT, T, R extends SnmpProxyRow<IT, T>>
extends AbstractTableModel
implements SnmpTableRO<IC, C, IT, T, R>,
Collection<R> {
    private static final long serialVersionUID = -8026396218277991810L;
    protected List<C> columns = new ArrayList<C>();
    protected List<IC> indexColumns = new ArrayList<IC>();
    protected List<R> rows = Collections.synchronizedList(new ArrayList());
    protected List<R> updatingRows;
    protected OID tableEntryOID;
    protected int pageSize;
    protected int currentIndex;
    protected Object[] minIndex;
    protected SnmpProxyRowFilter rowFilter;
    protected SnmpProxyRowFactory<R, IT, T> rowFactory;
    protected ConcurrentHashMap<OID, RowUpdateError> rowErrors = new ConcurrentHashMap();
    protected OctetString context;

    public SnmpTableImplRO(OID tableEntryOID, OctetString context, SnmpProxyRowFactory<R, IT, T> rowFactory, List<C> columns, List<IC> indexColumns, int pageSize) {
        this.tableEntryOID = tableEntryOID;
        this.context = context;
        this.rowFactory = rowFactory;
        this.columns = columns;
        this.indexColumns = indexColumns;
        this.pageSize = pageSize;
    }

    @Override
    public OctetString getContext() {
        return this.context;
    }

    @Override
    public String getColumnName(int column) {
        if (column < this.indexColumns.size()) {
            return ((SnmpProxyIndexColumn)this.indexColumns.get(column)).toString();
        }
        if (column - this.indexColumns.size() < this.columns.size()) {
            return ((SnmpProxyColumn)this.columns.get(column - this.indexColumns.size())).toString();
        }
        return null;
    }

    @Override
    public int findColumn(String columnName) {
        return super.findColumn(columnName);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return super.getColumnClass(columnIndex);
    }

    @Override
    public OID getOID() {
        return this.tableEntryOID;
    }

    @Override
    public SnmpCell getCell(OID instanceOID) {
        OID rowIndex;
        OID columnOID;
        if (instanceOID.size() == this.tableEntryOID.size() + 1) {
            columnOID = this.tableEntryOID;
            rowIndex = new OID(new int[]{0});
        } else {
            columnOID = new OID(instanceOID.getValue(), 0, this.tableEntryOID.size() + 1);
            rowIndex = new OID(instanceOID.getValue(), this.tableEntryOID.size() + 1, instanceOID.size() - columnOID.size());
        }
        int row = this.getRowNumber(rowIndex);
        int column = this.getColumnNumber(columnOID);
        return new SnmpCell(row, column, instanceOID, rowIndex);
    }

    @Override
    public TaskId reload(SnmpService snmpService, Target target, final VariableBindingMapper variableBindingMapper, final SnmpProxyReloadListener reloadListener) {
        final List<C> columns = this.getColumns();
        ArrayList<OID> colOIDs = new ArrayList<OID>(columns.size());
        for (SnmpProxyColumn column : columns) {
            colOIDs.add(column.getOID());
        }
        final List<IC> indexColumns = this.getIndexColumns();
        OID minIndexOID = null;
        OID maxIndexOID = null;
        try {
            SnmpRowListener rowListener = new SnmpRowListener(){
                private volatile boolean finished;

                @Override
                public void beginUpdate(Object userObject) {
                    SnmpTableImplRO.this.beginUpdate(userObject);
                }

                @Override
                public boolean nextRow(SnmpRow nextRow, Object userObject) {
                    List<VariableBinding> indexVBs = SnmpTableImplRO.this.getIndexVariableBindings(nextRow.getIndex());
                    SnmpTableImplRO.this.updateRow(userObject, SnmpTableImplRO.this.getRowFactory().createProxyRow(nextRow.getIndex(), SnmpProxyObjectHelper.mapVBsToObjects(variableBindingMapper, indexVBs, indexColumns), SnmpProxyObjectHelper.mapVBsToObjects(variableBindingMapper, nextRow.getVariableBindings(), columns)));
                    return true;
                }

                @Override
                public synchronized void endUpdate(SnmpErrorStatus errorStatus, Object userObject) {
                    SnmpTableImplRO.this.finishUpdate(userObject);
                    if (reloadListener != null) {
                        reloadListener.reloadFinished(SnmpTableImplRO.this);
                    }
                    this.finished = true;
                    this.notify();
                }

                @Override
                public boolean isFinished() {
                    return this.finished;
                }
            };
            snmpService.getTable(target, colOIDs, minIndexOID, maxIndexOID, rowListener, rowListener);
            return rowListener;
        }
        catch (SnmpException e2) {
            if (reloadListener != null) {
                reloadListener.reloadFailed(this, e2.getErrorStatus());
            }
            e2.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitForTask(TaskId taskId, long timeout) {
        try {
            TaskId taskId2 = taskId;
            synchronized (taskId2) {
                taskId.wait(timeout);
            }
        }
        catch (InterruptedException e2) {
            // empty catch block
        }
        return taskId.isFinished();
    }

    @Override
    public List<C> getColumns() {
        return this.columns;
    }

    @Override
    public List<IC> getIndexColumns() {
        return this.indexColumns;
    }

    @Override
    public void setPageSize(int numRows) {
        this.pageSize = numRows;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public void setCurrentIndex(int startPos) {
        this.currentIndex = startPos;
    }

    @Override
    public int getCurrentIndex() {
        return this.currentIndex;
    }

    @Override
    public void setRowFilter(SnmpProxyRowFilter rowFilter) {
        this.rowFilter = rowFilter;
    }

    @Override
    public SnmpProxyRowFilter getRowFilter() {
        return this.rowFilter;
    }

    @Override
    public Object[] getMinIndex() {
        return this.minIndex;
    }

    @Override
    public List<VariableBinding> getIndexVariableBindings(OID index) {
        List<OID> indexOIDs = this.getIndexOIDs(index, this.getIndexColumns());
        return SnmpTableImplRO.getIndexVariables(this.getIndexColumns(), indexOIDs);
    }

    @Override
    public void setMinIndex(Object[] minIndex) {
        this.minIndex = minIndex;
    }

    @Override
    public SnmpProxyRowFactory<R, IT, T> getRowFactory() {
        return this.rowFactory;
    }

    public void setRowFactory(SnmpProxyRowFactory<R, IT, T> rowFactory) {
        this.rowFactory = rowFactory;
    }

    @Override
    public void beginUpdate(Object userObject) {
        this.updatingRows = new ArrayList<R>();
    }

    @Override
    public void updateRow(Object userObject, R updateRow) {
        if (this.rowFilter == null || this.rowFilter.passesFilter((SnmpProxyRow)updateRow)) {
            this.updatingRows.add(updateRow);
        }
    }

    @Override
    public synchronized void finishUpdate(Object userObject) {
        if (this.updatingRows != null) {
            this.rows = this.updatingRows;
            this.fireTableStructureChanged();
        }
    }

    @Override
    public synchronized int getRowCount() {
        return Math.min(this.rows.size(), this.pageSize);
    }

    @Override
    public int getColumnCount() {
        return this.indexColumns.size() + this.columns.size();
    }

    @Override
    public synchronized Object getValueAt(int rowIndex, int columnIndex) {
        SnmpProxyRow row = (SnmpProxyRow)this.rows.get(this.getNonPagedRowIndex(rowIndex));
        if (columnIndex < this.indexColumns.size()) {
            return row.getIndexObjects().get(columnIndex);
        }
        return row.getValue(columnIndex - this.indexColumns.size());
    }

    protected int getNonPagedRowIndex(int pageRowIndex) {
        return pageRowIndex % this.pageSize + this.currentIndex * this.pageSize;
    }

    public static VariableBinding getIndexVariable(SnmpProxyIndexColumn indexColumn, OID subIndex) {
        try {
            AbstractVariable variable;
            switch (indexColumn.getSnmpSyntax()) {
                case 4: {
                    if (indexColumn.hasImpliedLength() || indexColumn.getMinLength() == indexColumn.getMaxLength()) {
                        variable = new OctetString(subIndex.toByteArray());
                        break;
                    }
                    variable = new OctetString(subIndex.toByteArray(), 1, subIndex.size() - 1);
                    break;
                }
                case 66: {
                    variable = new UnsignedInteger32(subIndex.get(subIndex.size() - 1));
                    break;
                }
                case 2: {
                    variable = new Integer32(subIndex.get(subIndex.size() - 1));
                    break;
                }
                case 67: {
                    variable = new TimeTicks((long)subIndex.get(subIndex.size() - 1));
                    break;
                }
                case 64: {
                    variable = new IpAddress(subIndex.toString());
                    break;
                }
                default: {
                    variable = indexColumn.hasImpliedLength() || indexColumn.getMinLength() == indexColumn.getMaxLength() ? subIndex : new OID(subIndex.getValue(), 1, subIndex.size() - 1);
                }
            }
            return new VariableBinding(indexColumn.getOID(), variable);
        }
        catch (Exception e2) {
            return new VariableBinding(indexColumn.getOID(), subIndex);
        }
    }

    public static List<VariableBinding> getIndexVariables(List<? extends SnmpProxyIndexColumn> indexes, List<? extends OID> indexValues) {
        int sz = Math.min(indexes.size(), indexValues.size());
        ArrayList<VariableBinding> vbs = new ArrayList<VariableBinding>(sz);
        for (int i2 = 0; i2 < sz; ++i2) {
            vbs.add(SnmpTableImplRO.getIndexVariable(indexes.get(i2), indexValues.get(i2)));
        }
        return vbs;
    }

    public static List<VariableBinding> getIndexVariableTemplates(List<? extends SnmpProxyIndexColumn> indexes) {
        int sz = indexes.size();
        ArrayList<VariableBinding> vbs = new ArrayList<VariableBinding>(sz);
        for (SnmpProxyIndexColumn snmpProxyIndexColumn : indexes) {
            Variable v = AbstractVariable.createFromSyntax(snmpProxyIndexColumn.getSmiSyntax());
            OID oid = snmpProxyIndexColumn.getOID();
            vbs.add(new VariableBinding(oid, v));
        }
        return vbs;
    }

    public List<OID> getIndexOIDs(OID index, List<? extends SnmpProxyIndexColumn> indexColumns) {
        OID indexSuffix = index;
        ArrayList<OID> subIndexes = new ArrayList<OID>(indexColumns.size());
        for (SnmpProxyIndexColumn snmpProxyIndexColumn : indexColumns) {
            OID next = snmpProxyIndexColumn.hasImpliedLength() ? indexSuffix : (!snmpProxyIndexColumn.hasImpliedLength() && snmpProxyIndexColumn.getMinLength() != snmpProxyIndexColumn.getMaxLength() ? new OID(indexSuffix.getValue(), 0, indexSuffix.get(0) + 1) : new OID(indexSuffix.getValue(), 0, snmpProxyIndexColumn.getMaxLength()));
            subIndexes.add(next);
            indexSuffix = new OID(indexSuffix.getValue(), next.size(), indexSuffix.size() - next.size());
        }
        return subIndexes;
    }

    @Override
    public TableColumnModel getTableColumnModel(int maxCharacterPixelWidth, int maxColumnCharacters) {
        TableColumn tableColumn;
        int i2;
        DefaultTableColumnModel tableColumnModel = new DefaultTableColumnModel();
        for (i2 = 0; i2 < this.indexColumns.size(); ++i2) {
            SnmpProxyIndexColumn indexColumn = (SnmpProxyIndexColumn)this.indexColumns.get(i2);
            tableColumn = new TableColumn(i2, maxCharacterPixelWidth * Math.min(maxColumnCharacters, indexColumn.getMaxWidth()));
            tableColumn.setHeaderValue(indexColumn.getHeader());
            tableColumnModel.addColumn(tableColumn);
        }
        for (i2 = 0; i2 < this.columns.size(); ++i2) {
            SnmpProxyColumn column = (SnmpProxyColumn)this.columns.get(i2);
            tableColumn = new TableColumn(i2 + this.indexColumns.size(), maxCharacterPixelWidth * Math.min(maxColumnCharacters, column.getMaxWidth()));
            tableColumn.setHeaderValue(column.getHeader());
            tableColumnModel.addColumn(tableColumn);
        }
        return tableColumnModel;
    }

    @Override
    public void addError(List<SnmpValuesChangeSet> valuesChangeSets, SnmpErrorStatus errorStatus, int errorIndex) {
        OID cellOID;
        int columnIndex = 0;
        SnmpValuesChangeSet errorChangeSet = null;
        for (SnmpValuesChangeSet changeSet : valuesChangeSets) {
            int offset = changeSet.getChanges().size();
            if (columnIndex + offset < errorIndex) {
                columnIndex += offset;
                continue;
            }
            columnIndex = errorIndex - columnIndex - 1;
            errorChangeSet = changeSet;
            break;
        }
        OID oID = cellOID = errorChangeSet != null ? errorChangeSet.getVariableBindings().get(columnIndex).getOid() : null;
        if (cellOID != null) {
            int columnOidLength = this.tableEntryOID.getValue().length + 1;
            OID columnOID = new OID(cellOID.getValue(), 0, columnOidLength);
            OID rowIndex = new OID(cellOID.getValue(), columnOidLength, cellOID.size() - columnOidLength);
            RowUpdateError rowUpdateError = new RowUpdateError(errorStatus, Math.max(this.getColumnNumber(columnOID), 0), errorChangeSet);
            this.rowErrors.put(rowIndex, rowUpdateError);
        }
    }

    @Override
    public SnmpErrorStatus getError(OID rowIndex, int column) {
        System.out.println(this.rowErrors);
        System.out.println(rowIndex + " : " + column);
        RowUpdateError rowUpdateError = this.rowErrors.get(rowIndex);
        if (rowUpdateError != null && (rowUpdateError.columnIndex == column || rowUpdateError.columnIndex < 0)) {
            System.out.println(rowUpdateError);
            return rowUpdateError.errorStatus;
        }
        return null;
    }

    @Override
    public void clearAllErrors() {
        this.rowErrors.clear();
    }

    @Override
    public SnmpErrorStatus clearError(OID rowIndex) {
        RowUpdateError rowUpdateError = this.rowErrors.remove(rowIndex);
        if (rowUpdateError != null) {
            return rowUpdateError.errorStatus;
        }
        return null;
    }

    @Override
    public int size() {
        return this.getRowCount();
    }

    @Override
    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    @Override
    public boolean contains(Object o2) {
        return this.rows.contains(o2);
    }

    @Override
    public Iterator<R> iterator() {
        return this.rows.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.rows.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a2) {
        return this.rows.toArray(a2);
    }

    @Override
    public boolean add(R r2) {
        return false;
    }

    @Override
    public boolean remove(Object o2) {
        return this.rows.remove(o2);
    }

    @Override
    public boolean containsAll(Collection<?> c2) {
        return this.rows.containsAll(c2);
    }

    @Override
    public boolean addAll(Collection<? extends R> c2) {
        return this.rows.addAll(c2);
    }

    @Override
    public boolean removeAll(Collection<?> c2) {
        return this.rows.removeAll(c2);
    }

    @Override
    public boolean retainAll(Collection<?> c2) {
        return this.rows.retainAll(c2);
    }

    @Override
    public void clear() {
        this.rows.clear();
    }

    @Override
    public int getRowNumber(OID index) {
        for (int i2 = 0; i2 < this.rows.size(); ++i2) {
            if (!((SnmpProxyRow)this.rows.get(i2)).getIndex().equals(index)) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public int getColumnNumber(OID columnOID) {
        for (int i2 = 0; i2 < this.columns.size(); ++i2) {
            OID colOID = ((SnmpProxyColumn)this.columns.get(i2)).getOID();
            if (colOID.last() != columnOID.last() || !colOID.equals(columnOID)) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public List<OID> getRowIndexes() {
        ArrayList<OID> rowIndexes = new ArrayList<OID>(this.rows.size());
        for (SnmpProxyRow row : this.rows) {
            rowIndexes.add(row.getIndex());
        }
        return rowIndexes;
    }

    @Override
    public OID getRowIndex(int rowNumber) {
        return ((SnmpProxyRow)this.rows.get(rowNumber)).getIndex();
    }

    public String toString() {
        return "SnmpTableImplRO{" + super.toString() + ", columns=" + this.columns + ", indexColumns=" + this.indexColumns + ", rows=" + this.rows + ", updatingRows=" + this.updatingRows + ", tableEntryOID=" + this.tableEntryOID + ", pageSize=" + this.pageSize + ", currentIndex=" + this.currentIndex + ", minIndex=" + Arrays.toString(this.minIndex) + ", rowFilter=" + this.rowFilter + ", rowFactory=" + this.rowFactory + '}';
    }

    protected class RowUpdateError {
        private SnmpErrorStatus errorStatus;
        private int columnIndex;
        private SnmpValuesChangeSet errorChangeSet;

        public RowUpdateError(SnmpErrorStatus errorStatus, int columnIndex, SnmpValuesChangeSet errorChangeSet) {
            this.errorStatus = errorStatus;
            this.columnIndex = columnIndex;
            this.errorChangeSet = errorChangeSet;
        }

        public String toString() {
            return "RowUpdateError{errorStatus=" + (Object)((Object)this.errorStatus) + ", columnIndex=" + this.columnIndex + ", errorChangeSet=" + this.errorChangeSet + '}';
        }
    }

    protected class SnmpColumnOidComparator
    implements Comparator {
        protected SnmpColumnOidComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof OID) && !(o1 instanceof SnmpColumn) || !(o2 instanceof OID) && !(o2 instanceof SnmpColumn)) {
                throw new ClassCastException();
            }
            OID oid1 = o1 instanceof SnmpColumn ? ((SnmpColumn)o1).getOID() : (OID)o1;
            OID oid2 = o2 instanceof SnmpColumn ? ((SnmpColumn)o2).getOID() : (OID)o2;
            return oid1.compareTo(oid2);
        }
    }

    protected class SnmpProxyRowOidComparator
    implements Comparator {
        protected SnmpProxyRowOidComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof OID) && !(o1 instanceof SnmpProxyRow) || !(o2 instanceof OID) && !(o2 instanceof SnmpProxyRow)) {
                throw new ClassCastException();
            }
            OID oid1 = o1 instanceof SnmpProxyRow ? ((SnmpProxyRow)o1).getIndex() : (OID)o1;
            OID oid2 = o2 instanceof SnmpProxyRow ? ((SnmpProxyRow)o2).getIndex() : (OID)o2;
            return oid1.compareTo(oid2);
        }
    }
}

