/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.model.snmp.proxy.impl;

import java.util.Collections;
import java.util.List;
import org.snmp4j.Target;
import org.snmp4j.model.mapper.VariableBindingMapper;
import org.snmp4j.model.snmp.proxy.SnmpScalarRO;
import org.snmp4j.model.snmp.proxy.TaskId;
import org.snmp4j.model.snmp.proxy.impl.SnmpProxyObjectImpl;
import org.snmp4j.model.snmp.spi.SnmpException;
import org.snmp4j.model.snmp.spi.SnmpProxyReloadListener;
import org.snmp4j.model.snmp.spi.SnmpService;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.VariableBinding;

public class SnmpScalarImplRO<T>
extends SnmpProxyObjectImpl
implements SnmpScalarRO<T> {
    private T value;
    private Class<T> valueClass;
    private int snmpSyntax;

    public SnmpScalarImplRO(OID oid, OctetString context, T value, Class<T> valueClass, int snmpSyntax) {
        super(context, oid);
        this.value = value;
        this.valueClass = valueClass;
        this.snmpSyntax = snmpSyntax;
    }

    @Override
    public TaskId reload(SnmpService snmpService, Target target, VariableBindingMapper variableBindingMapper, SnmpProxyReloadListener reloadListener) {
        block3: {
            try {
                OID instanceOID = new OID(this.oid.getValue(), 0);
                List<? extends VariableBinding> vbs = snmpService.get(target, Collections.singletonList(instanceOID));
                this.setValue(variableBindingMapper.toObject(vbs.get(0), this.getValueClass()));
                if (reloadListener != null) {
                    reloadListener.reloadFinished(this);
                }
            }
            catch (SnmpException e2) {
                if (reloadListener == null) break block3;
                reloadListener.reloadFailed(this, e2.getErrorStatus());
            }
        }
        return null;
    }

    @Override
    public boolean waitForTask(TaskId taskId, long timeout) {
        return false;
    }

    @Override
    public String getName() {
        return this.getOID().toString();
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(T value) {
        this.value = value;
    }

    @Override
    public Class<T> getValueClass() {
        return this.valueClass;
    }

    @Override
    public int getSnmpSyntax() {
        return this.snmpSyntax;
    }

    @Override
    public String toString() {
        return "SnmpScalarImplRO{" + super.toString() + ", snmpSyntax=" + this.snmpSyntax + ", value=" + this.value + ", valueClass=" + this.valueClass + "} ";
    }
}

