/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.model.snmp.proxy.impl;

import java.util.ArrayList;
import java.util.Collection;
import org.snmp4j.model.snmp.proxy.ChangeSet;
import org.snmp4j.model.snmp.proxy.SnmpProxyRow;
import org.snmp4j.model.snmp.proxy.SnmpTable;
import org.snmp4j.model.snmp.proxy.impl.SnmpColumn;
import org.snmp4j.model.snmp.proxy.impl.SnmpIndexColumn;
import org.snmp4j.model.snmp.proxy.impl.SnmpValueChange;
import org.snmp4j.model.snmp.proxy.impl.SnmpValuesChangeSet;
import org.snmp4j.smi.OID;

public class ColumnList<C extends SnmpColumn, IC extends SnmpIndexColumn, IT, T, R extends SnmpProxyRow<IT, T>>
extends ArrayList<T> {
    private OID rowIndex;
    private SnmpTable<C, IC, IT, T, R> table;

    public ColumnList(Collection<? extends T> c2, OID rowIndex, SnmpTable<C, IC, IT, T, R> table) {
        super(c2);
        this.rowIndex = rowIndex;
        this.table = table;
    }

    @Override
    public T set(int columnIndex, T value) {
        if (value != null && value != super.get(columnIndex) && !value.equals(super.get(columnIndex)) && columnIndex < this.table.getColumnCount() && columnIndex >= this.table.getIndexColumns().size() && columnIndex < this.size()) {
            SnmpColumn column = (SnmpColumn)this.table.getColumns().get(columnIndex);
            if (column.getSmiMaxAccess().isWritable()) {
                OID instanceOID = new OID(column.getOID().getValue(), this.rowIndex.getValue());
                SnmpValuesChangeSet changeSet = new SnmpValuesChangeSet();
                changeSet.addChange(new SnmpValueChange(instanceOID, column.getValueClass(), value, this.get(columnIndex)));
                SnmpValuesChangeSet validatedChangeSet = this.table.getCommitter().validateChange(changeSet);
                if (validatedChangeSet.getStatus() == ChangeSet.ChangeStatus.PREPARED) {
                    this.table.getCommitter().addChange(this.table, changeSet);
                    value = validatedChangeSet.getChanges().get(0).getNewValue();
                }
                this.table.fireTableCellUpdated(this.table.getRowNumber(this.rowIndex), columnIndex);
            }
            return super.set(columnIndex, value);
        }
        return (T)this.get(columnIndex);
    }
}

