/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.model.snmp.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.WeakHashMap;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.MessageDispatcherImpl;
import org.snmp4j.PDU;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.model.snmp.api.CommitStatus;
import org.snmp4j.model.snmp.api.GlobalTransaction;
import org.snmp4j.model.snmp.api.LocalTransaction;
import org.snmp4j.model.snmp.proxy.SnmpCommitListener;
import org.snmp4j.model.snmp.proxy.impl.SnmpValuesChangeSet;
import org.snmp4j.model.snmp.spi.SnmpCommitResult;
import org.snmp4j.model.snmp.spi.SnmpErrorStatus;
import org.snmp4j.model.snmp.spi.SnmpException;
import org.snmp4j.model.snmp.spi.SnmpRow;
import org.snmp4j.model.snmp.spi.SnmpRowListener;
import org.snmp4j.model.snmp.spi.SnmpService;
import org.snmp4j.model.transaction.SnmpIsolationLevel;
import org.snmp4j.model.transaction.SnmpTransaction;
import org.snmp4j.model.transaction.SnmpTransactionStrategy;
import org.snmp4j.model.transaction.TransactionManager;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.MessageProcessingModel;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.TSM;
import org.snmp4j.security.USM;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.util.DefaultPDUFactory;
import org.snmp4j.util.PDUFactory;
import org.snmp4j.util.TableEvent;
import org.snmp4j.util.TableListener;
import org.snmp4j.util.TableUtils;
import org.snmp4j.util.TreeEvent;
import org.snmp4j.util.TreeUtils;

public class LocalSnmpService
implements SnmpService,
TransactionManager {
    private static final LogAdapter LOGGER = LogFactory.getLogger(LocalSnmpService.class);
    private Snmp snmp;
    private PDUFactory pduFactory;
    private WeakHashMap<GlobalTransaction, Map<Target, LocalTransaction>> transactions = new WeakHashMap();

    public LocalSnmpService() {
        this(new MessageDispatcherImpl(), null, null, SecurityModels.getCollection(new SecurityModel[]{new USM(), new TSM()}), SecurityProtocols.getInstance().addDefaultProtocols());
    }

    public LocalSnmpService(MessageDispatcher messageDispatcher, List<TransportMapping> transportMappings, List<MessageProcessingModel> messageProcessingModels, SecurityModels securityModels, SecurityProtocols securityProtocols) {
        this.snmp = new Snmp(messageDispatcher);
        if (messageProcessingModels == null) {
            messageProcessingModels = Arrays.asList(new MPv3());
        }
        if (transportMappings == null) {
            try {
                transportMappings = Arrays.asList(new DefaultUdpTransportMapping());
            }
            catch (IOException e2) {
                LOGGER.error("Failed to create default UDP transport mapping: " + e2.getMessage(), e2);
            }
        }
        for (MessageProcessingModel mp : messageProcessingModels) {
            messageDispatcher.addMessageProcessingModel(mp);
            if (!(mp instanceof MPv3)) continue;
            MPv3 mpv3 = (MPv3)mp;
            mpv3.setSecurityModels(securityModels);
            mpv3.setSecurityProtocols(securityProtocols);
        }
        for (TransportMapping tm : transportMappings) {
            messageDispatcher.addTransportMapping(tm);
            tm.addTransportListener(messageDispatcher);
        }
        this.pduFactory = new DefaultPDUFactory(-96);
        LOGGER.info("LocalSnmpService initialized. TransportMappings=" + transportMappings + ", MPs=" + messageProcessingModels);
    }

    public Snmp getSnmp() {
        return this.snmp;
    }

    @Override
    public void initTransports() throws IOException {
        this.snmp.listen();
    }

    public PDUFactory getPduFactory() {
        return this.pduFactory;
    }

    public void setPduFactory(PDUFactory pduFactory) {
        this.pduFactory = pduFactory;
    }

    @Override
    public List<? extends VariableBinding> get(Target target, List<OID> oidList) throws SnmpException {
        PDU pdu = this.pduFactory.createPDU(target);
        ArrayList<VariableBinding> vbs = new ArrayList<VariableBinding>(oidList.size());
        for (OID oid : oidList) {
            vbs.add(new VariableBinding(oid));
        }
        pdu.setVariableBindings(vbs);
        pdu.setRequestID(null);
        try {
            ResponseEvent responseEvent = this.snmp.get(pdu, target);
            if (responseEvent.getResponse() != null) {
                if (responseEvent.getResponse().getErrorStatus() == 0) {
                    return responseEvent.getResponse().getVariableBindings();
                }
                throw new SnmpException(SnmpErrorStatus.fromSnmpErrorStatus(responseEvent.getResponse().getErrorStatus()));
            }
            throw new SnmpException("Request timed out", responseEvent.getError(), SnmpErrorStatus.timeout);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            throw new SnmpException("IO exception", e2, null);
        }
    }

    @Override
    public List<? extends VariableBinding> getNext(Target target, List<OID> oidList) throws SnmpException {
        PDU pdu = this.pduFactory.createPDU(target);
        ArrayList<VariableBinding> vbs = new ArrayList<VariableBinding>(oidList.size());
        for (OID oid : oidList) {
            vbs.add(new VariableBinding(oid));
        }
        pdu.setVariableBindings(vbs);
        try {
            ResponseEvent responseEvent = this.snmp.getNext(pdu, target);
            if (responseEvent.getResponse() != null) {
                if (responseEvent.getResponse().getErrorStatus() == 0) {
                    return responseEvent.getResponse().getVariableBindings();
                }
                throw new SnmpException(SnmpErrorStatus.fromSnmpErrorStatus(responseEvent.getResponse().getErrorStatus()));
            }
            throw new SnmpException("Request timed out", responseEvent.getError(), SnmpErrorStatus.timeout);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            throw new SnmpException("IO exception", e2, null);
        }
    }

    @Override
    public List<? extends VariableBinding> getSubTree(Target target, OID oid) throws SnmpException {
        TreeUtils treeUtils = new TreeUtils(this.snmp, this.pduFactory);
        List<TreeEvent> treeEvents = treeUtils.getSubtree(target, oid);
        ArrayList<VariableBinding> instances = new ArrayList<VariableBinding>(treeEvents.size());
        for (TreeEvent treeEvent : treeEvents) {
            if (treeEvent.getStatus() == 0) {
                instances.addAll(Arrays.asList(treeEvent.getVariableBindings()));
                continue;
            }
            throw new SnmpException(SnmpErrorStatus.fromSnmpErrorStatus(treeEvent.getStatus()));
        }
        return instances;
    }

    @Override
    public List<? extends SnmpRow> getTable(Target target, List<OID> columnOIDs, OID minIndexOID, OID maxIndexOID) throws SnmpException {
        TableUtils tableUtils = new TableUtils(this.snmp, this.pduFactory);
        List<TableEvent> tableEvents = tableUtils.getTable(target, columnOIDs.toArray(new OID[columnOIDs.size()]), minIndexOID, maxIndexOID);
        ArrayList<SnmpRow> rows = new ArrayList<SnmpRow>(tableEvents.size());
        for (TableEvent tableEvent : tableEvents) {
            if (tableEvent.getStatus() == 0) {
                SnmpRow row = new SnmpRow(tableEvent.getIndex(), Arrays.asList(tableEvent.getColumns()));
                rows.add(row);
                continue;
            }
            throw new SnmpException(SnmpErrorStatus.fromSnmpErrorStatus(tableEvent.getStatus()));
        }
        return rows;
    }

    @Override
    public void getTable(Target target, List<OID> columnOIDs, OID minIndex, OID maxIndex, SnmpRowListener callback, Object userObject) throws SnmpException {
        TableUtils tableUtils = new TableUtils(this.snmp, this.pduFactory);
        LocalTableListener tableListener = new LocalTableListener(callback);
        tableUtils.getTable(target, columnOIDs.toArray(new OID[columnOIDs.size()]), tableListener, userObject, minIndex, maxIndex);
    }

    @Override
    public void update(SnmpTransaction snmpTransaction, Target target, SnmpValuesChangeSet variableBindings, SnmpCommitListener commitListener) {
        Map<Target, LocalTransaction> localTransactions = this.transactions.get(snmpTransaction);
        if (localTransactions == null) {
            throw new IllegalStateException("Transaction not available: " + snmpTransaction);
        }
        LocalTransaction localTransaction = localTransactions.get(target);
        if (localTransaction == null) {
            localTransaction = new LocalTransaction(target);
            localTransactions.put(target, localTransaction);
        }
        localTransaction.addUpdate(variableBindings);
        if (snmpTransaction.isAutoCommit()) {
            this.commit(snmpTransaction, commitListener);
        }
    }

    @Override
    public List<? extends SnmpCommitResult> commit(SnmpTransaction transaction, SnmpCommitListener commitListener) {
        Map<Target, LocalTransaction> localTransactions = this.transactions.get(transaction);
        if (localTransactions == null) {
            throw new IllegalStateException("Transaction not available: " + transaction);
        }
        ArrayList<CommitStatus> commitResults = new ArrayList<CommitStatus>();
        for (Map.Entry<Target, LocalTransaction> localTransactionEntry : localTransactions.entrySet()) {
            LocalTransaction localTransaction = localTransactionEntry.getValue();
            Queue<SnmpValuesChangeSet> updates = localTransaction.getPending();
            ArrayList<SnmpValuesChangeSet> localTransactionPending = new ArrayList<SnmpValuesChangeSet>();
            int maxSizePDU = localTransaction.getTarget().getMaxSizeRequestPDU();
            PDU pdu = this.pduFactory.createPDU(localTransaction.getTarget());
            if (pdu instanceof ScopedPDU) {
                ((ScopedPDU)pdu).setContextName(commitListener.getContext());
            }
            SnmpErrorStatus snmpErrorStatus = SnmpErrorStatus.noError;
            while (snmpErrorStatus == SnmpErrorStatus.noError && !updates.isEmpty() && localTransaction.getFailedVariableBindings().isEmpty()) {
                SnmpValuesChangeSet successorUpdate;
                SnmpValuesChangeSet nextUpdate = updates.poll();
                pdu.addAll(nextUpdate.getVariableBindings());
                localTransactionPending.add(nextUpdate);
                if (!updates.isEmpty() && (successorUpdate = updates.peek()) != null && pdu.getBERLength() + PDU.getBERLength(successorUpdate.getVariableBindings()) < maxSizePDU) continue;
                try {
                    CommitStatus commitStatus;
                    ResponseEvent responseEvent = this.snmp.set(pdu, localTransaction.getTarget());
                    PDU responsePDU = responseEvent.getResponse();
                    if (responsePDU != null) {
                        if (responsePDU.getErrorStatus() == 0) {
                            commitStatus = new CommitStatus(SnmpErrorStatus.noError, 0, localTransactionPending, null);
                            localTransaction.getCommitted().addAll(localTransactionPending);
                            if (commitListener != null) {
                                commitListener.commitSuccess(localTransactionPending);
                            }
                        } else {
                            snmpErrorStatus = SnmpErrorStatus.fromSnmpErrorStatus(responsePDU.getErrorStatus());
                            localTransaction.setErrorIndex(responsePDU.getErrorIndex());
                            localTransaction.getFailedVariableBindings().addAll(pdu.getVariableBindings());
                            commitStatus = new CommitStatus(snmpErrorStatus, responsePDU.getErrorIndex(), null, localTransactionPending);
                            if (commitListener != null) {
                                commitListener.commitFailure(localTransactionPending, snmpErrorStatus, localTransaction.getErrorIndex());
                            }
                        }
                    } else {
                        localTransaction.getFailedVariableBindings().addAll(pdu.getVariableBindings());
                        snmpErrorStatus = SnmpErrorStatus.timeout;
                        commitStatus = new CommitStatus(snmpErrorStatus, 0, null, localTransactionPending);
                        if (commitListener != null) {
                            commitListener.commitFailure(localTransactionPending, snmpErrorStatus, 0);
                        }
                    }
                    commitResults.add(commitStatus);
                }
                catch (IOException e2) {
                    LOGGER.error("IOException occurred while committing transaction '" + localTransaction + "': " + e2.getMessage(), e2);
                    localTransaction.getFailedVariableBindings().addAll(pdu.getVariableBindings());
                    snmpErrorStatus = SnmpErrorStatus.ioError;
                }
                pdu = this.pduFactory.createPDU(localTransaction.getTarget());
            }
            localTransaction.setSnmpErrorStatus(snmpErrorStatus);
        }
        return commitResults;
    }

    @Override
    public void rollback(SnmpTransaction transaction) {
        Map<Target, LocalTransaction> localTransactions = this.transactions.get(transaction);
        if (localTransactions != null) {
            for (LocalTransaction localTransaction : localTransactions.values()) {
                localTransaction.getPending().clear();
            }
        }
    }

    @Override
    public boolean isAtomic(SnmpTransaction transaction) {
        Map<Target, LocalTransaction> localTransactions = this.transactions.get(transaction);
        if (localTransactions != null) {
            // empty if block
        }
        return true;
    }

    @Override
    public SnmpTransaction getSnmpTransaction(SnmpTransactionStrategy transactionStrategy) {
        GlobalTransaction globalTransaction = new GlobalTransaction(SnmpIsolationLevel.none == transactionStrategy.getIsolationLevel());
        this.transactions.put(globalTransaction, new LinkedHashMap());
        return globalTransaction;
    }

    protected class LocalTableListener
    implements TableListener {
        private SnmpRowListener rowListener;
        private boolean finished;
        private boolean initialized;

        public LocalTableListener(SnmpRowListener rowListener) {
            this.rowListener = rowListener;
        }

        @Override
        public boolean next(TableEvent tableEvent) {
            if (!this.initialized) {
                this.rowListener.beginUpdate(tableEvent.getUserObject());
                this.initialized = true;
            }
            if (tableEvent.getStatus() == 0) {
                SnmpRow row = new SnmpRow(tableEvent.getIndex(), Arrays.asList(tableEvent.getColumns()));
                return this.rowListener.nextRow(row, tableEvent.getUserObject());
            }
            this.rowListener.endUpdate(SnmpErrorStatus.fromSnmpErrorStatus(tableEvent.getStatus()), tableEvent.getUserObject());
            this.finished = true;
            return false;
        }

        @Override
        public void finished(TableEvent event) {
            this.rowListener.endUpdate(SnmpErrorStatus.fromSnmpErrorStatus(event.getStatus()), event.getUserObject());
            this.finished = true;
        }

        @Override
        public boolean isFinished() {
            return this.finished;
        }
    }
}

