/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.model.demo.mibbrowser;

import com.snmp4j.smi.SmiObjectType;
import com.snmp4j.smi.SmiValueType;
import org.snmp4j.model.demo.mibbrowser.SimpleAbstractTreeTableModel;
import org.snmp4j.model.demo.mibbrowser.SimpleMibDataNode;

public class SimpleMibTreeTableModel
extends SimpleAbstractTreeTableModel {
    protected static String[] columnNames = new String[]{"MIB Object", "Value", "Syntax", "OID", "Max-Access", "Description"};
    protected static Class<?>[] columnTypes = new Class[]{SimpleMibTreeTableModel.class, String.class, String.class, String.class, String.class, String.class};
    protected static boolean[] editableColumns = new boolean[]{true, false, false, false, false, false};

    public SimpleMibTreeTableModel(SimpleMibDataNode rootNode) {
        super(rootNode);
        this.root = rootNode;
    }

    @Override
    public Object getChild(Object parent, int index) {
        return ((SimpleMibDataNode)parent).getChildren().get(index);
    }

    @Override
    public int getChildCount(Object parent) {
        if (!(parent instanceof SimpleMibDataNode) || ((SimpleMibDataNode)parent).getChildren() == null) {
            return 0;
        }
        return ((SimpleMibDataNode)parent).getChildren().size();
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return columnNames[column];
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return columnTypes[column];
    }

    @Override
    public Object getValueAt(Object node, int column) {
        SimpleMibDataNode dataNode = (SimpleMibDataNode)node;
        try {
            switch (column) {
                case 0: {
                    return "" + dataNode.getObjectName();
                }
                case 1: {
                    return dataNode.getValue() == null ? "" : dataNode.getValue();
                }
                case 2: {
                    if (dataNode.getSmiObject() instanceof SmiValueType) {
                        return "" + ((SmiValueType)((Object)dataNode.getSmiObject())).getSyntax().getSyntaxClause();
                    }
                    return "";
                }
                case 3: {
                    return "" + dataNode.getOID().toDottedString();
                }
                case 4: {
                    return dataNode.getSmiObject() instanceof SmiObjectType ? "" + (Object)((Object)((SmiObjectType)dataNode.getSmiObject()).getMaxAccess()) : "";
                }
                case 5: {
                    return dataNode.getDescription();
                }
            }
        }
        catch (NullPointerException npe) {
            return null;
        }
        return null;
    }

    @Override
    public boolean isCellEditable(Object node, int column) {
        return editableColumns[column];
    }

    @Override
    public void setValueAt(Object aValue, Object node, int column) {
    }
}

