/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.model.demo.mibbrowser;

import com.snmp4j.smi.SmiManager;
import com.snmp4j.smi.SmiObject;
import com.snmp4j.smi.SmiObjectType;
import com.snmp4j.smi.util.MemRepositoryDriver;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreePath;
import org.snmp4j.MessageDispatcherImpl;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.Target;
import org.snmp4j.asn1.BER;
import org.snmp4j.log.ConsoleLogFactory;
import org.snmp4j.log.LogFactory;
import org.snmp4j.log.LogLevel;
import org.snmp4j.model.demo.mibbrowser.SimpleMibDataNode;
import org.snmp4j.model.demo.mibbrowser.SimpleMibTableBrowser;
import org.snmp4j.model.demo.mibbrowser.SimpleMibTreeTable;
import org.snmp4j.model.demo.mibbrowser.SimpleMibTreeTableModel;
import org.snmp4j.model.mapper.VariableBindingMapper;
import org.snmp4j.model.mapper.VariableBindingMapperJava;
import org.snmp4j.model.snmp.api.LocalSnmpService;
import org.snmp4j.model.snmp.api.TableHelper;
import org.snmp4j.model.snmp.proxy.SnmpProxyColumn;
import org.snmp4j.model.snmp.proxy.SnmpProxyIndexColumn;
import org.snmp4j.model.snmp.proxy.SnmpProxyObject;
import org.snmp4j.model.snmp.proxy.SnmpProxyRowFactory;
import org.snmp4j.model.snmp.proxy.impl.SnmpProxyAdapter;
import org.snmp4j.model.snmp.proxy.impl.SnmpProxyRowImpl;
import org.snmp4j.model.snmp.proxy.impl.SnmpScalarImplRO;
import org.snmp4j.model.snmp.proxy.impl.SnmpTableImpl;
import org.snmp4j.model.snmp.spi.SnmpService;
import org.snmp4j.mp.MPv1;
import org.snmp4j.mp.MPv2c;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.TSM;
import org.snmp4j.security.USM;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.TlsAddress;
import org.snmp4j.transport.AbstractTransportMapping;
import org.snmp4j.transport.DefaultTcpTransportMapping;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.transport.TLSTM;
import org.snmp4j.util.ArgumentParser;
import org.snmp4j.util.SnmpConfigurator;

public class SimpleMibBrowser
extends JFrame
implements SnmpProxyRowFactory<SnmpProxyRowImpl<String, String>, String, String> {
    private static final String SNMP4J_SMI_PRO_LICENSE_OPTIONS = "+L[s] ";
    private static final String MIB_OPTIONS = "+M[s] +m[s] ";
    private static final String V3_OPTIONS = "+a[s<MD5|SHA>] +A[s] +bc[i{=0}] +e[x] +E[x] +y[s<DES|3DES|AES128|AES192|AES256|AES192p|AES256p>] +Y[s] +u[s] +l[x] +n[s] ";
    private static final String SNMP_OPTIONS = "+c[s] +r[i{=1}] +t[i{=5000}] +v[s{=3}<1|2c|3>] +Ors[i{=65535}] ";
    private static final String BULK_OPTIONS = "-Cr[i{=10}] -Cn[i{=0}] ";
    private static final String ADDRESS_PARAMETER = "#address[s<((udp|tcp):)?.*[/[0-9]+]?>] ";
    private static final String ALL_OPTIONS = "+M[s] +m[s] +a[s<MD5|SHA>] +A[s] +bc[i{=0}] +e[x] +E[x] +y[s<DES|3DES|AES128|AES192|AES256|AES192p|AES256p>] +Y[s] +u[s] +l[x] +n[s] +c[s] +r[i{=1}] +t[i{=5000}] +v[s{=3}<1|2c|3>] +Ors[i{=65535}] -Cr[i{=10}] -Cn[i{=0}] +L[s] ";
    private SmiManager smiManager;
    private SnmpService snmpService;
    private VariableBindingMapper variableBindingMapper;
    private SnmpProxyAdapter snmpProxyAdapter;
    private SimpleMibTreeTable mibTreeTable;
    private TreePath popupPath = null;
    private JPopupMenu popupMenuNode = new JPopupMenu();
    private JMenuItem menuItemBrowse = new JMenuItem();
    private JMenuItem menuItemGet = new JMenuItem();
    private JMenuItem menuItemTable = new JMenuItem();
    private Target target;

    public SimpleMibBrowser(Map<String, List<?>> commandLineParameters) throws IOException {
        this.smiManager = SimpleMibBrowser.configureSnmp4jSMI(commandLineParameters);
        SnmpConfigurator snmpConfig = new SnmpConfigurator();
        this.target = snmpConfig.getTarget(commandLineParameters);
        AbstractTransportMapping transport = this.target.getAddress() instanceof TlsAddress ? new TLSTM() : (this.target.getAddress() instanceof TcpAddress ? new DefaultTcpTransportMapping() : new DefaultUdpTransportMapping());
        this.snmpService = new LocalSnmpService(new MessageDispatcherImpl(), Arrays.asList(transport), Arrays.asList(new MPv1(), new MPv2c(), new MPv3()), SecurityModels.getCollection(new SecurityModel[]{new USM(), new TSM()}), SecurityProtocols.getInstance().addDefaultProtocols());
        this.variableBindingMapper = new VariableBindingMapperJava();
        this.snmpProxyAdapter = new SnmpProxyAdapter(this.snmpService, this.target, this.variableBindingMapper);
        snmpConfig.configure(((LocalSnmpService)this.snmpService).getSnmp(), commandLineParameters);
        SNMP4JSettings.setNoGetBulk(true);
        this.initGUI();
    }

    private void initGUI() {
        this.setDefaultCloseOperation(3);
        this.setLayout(new BorderLayout(0, 0));
        SimpleMibTreeTableModel treeTableModel = new SimpleMibTreeTableModel(this.createDataMibStructure());
        this.mibTreeTable = new SimpleMibTreeTable(treeTableModel);
        Container cPane = this.getContentPane();
        cPane.add((Component)new JScrollPane(this.mibTreeTable), "Center");
        this.setSize(1000, 800);
        this.setLocationRelativeTo(null);
        this.initPopupMenu();
        this.mibTreeTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                super.mouseClicked(e2);
            }

            @Override
            public void mousePressed(MouseEvent e2) {
                super.mousePressed(e2);
                SimpleMibBrowser.this.showPopupMenu(e2);
            }

            @Override
            public void mouseReleased(MouseEvent e2) {
                super.mouseReleased(e2);
                SimpleMibBrowser.this.showPopupMenu(e2);
            }
        });
        try {
            this.snmpService.initTransports();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    private void showPopupMenu(MouseEvent e2) {
        TreePath path = this.mibTreeTable.getTree().getPathForLocation(e2.getX(), e2.getY());
        if (path != null && (e2.isPopupTrigger() || e2.getModifiers() == 4)) {
            this.popupPath = path;
            SimpleMibDataNode node = (SimpleMibDataNode)path.getLastPathComponent();
            this.enablePopupMenu(node);
            this.popupMenuNode.setVisible(true);
            this.popupMenuNode.show(this.mibTreeTable, e2.getX(), e2.getY());
        }
    }

    private void enablePopupMenu(SimpleMibDataNode node) {
    }

    private void initPopupMenu() {
        this.menuItemGet.setMnemonic('G');
        this.menuItemGet.setToolTipText("Refresh value of the current OBJECT-TYPE (not applicable for tables");
        this.menuItemGet.setText("Get");
        this.menuItemGet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                SimpleMibBrowser.this.doGetAction(e2);
            }
        });
        this.menuItemTable.setMnemonic('T');
        this.menuItemTable.setToolTipText("Browse the current node as SNMP table");
        this.menuItemTable.setText("Table...");
        this.menuItemTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                SimpleMibBrowser.this.doTableAction(e2);
            }
        });
        this.popupMenuNode.add(this.menuItemGet);
        this.popupMenuNode.add(this.menuItemTable);
    }

    private void doGetAction(ActionEvent e2) {
        final SimpleMibDataNode node = (SimpleMibDataNode)this.popupPath.getLastPathComponent();
        if (node.getProxyObject() != null) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    node.getProxyObject().reload(SimpleMibBrowser.this.snmpService, SimpleMibBrowser.this.target, SimpleMibBrowser.this.variableBindingMapper, null);
                    ((AbstractTableModel)SimpleMibBrowser.this.mibTreeTable.getModel()).fireTableDataChanged();
                }
            });
            thread.start();
        }
    }

    private void doTableAction(ActionEvent e2) {
        final SimpleMibDataNode node = (SimpleMibDataNode)this.popupPath.getLastPathComponent();
        if (node.getProxyObject() != null) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    node.getProxyObject().reload(SimpleMibBrowser.this.snmpService, SimpleMibBrowser.this.target, SimpleMibBrowser.this.variableBindingMapper, null);
                }
            });
            thread.start();
            final JDialog dialog = new JDialog(this);
            SnmpTableImpl snmpTable = (SnmpTableImpl)node.getProxyObject();
            Graphics g2 = this.getGraphics();
            int maxAdvance = g2.getFontMetrics().getMaxAdvance();
            SimpleMibTableBrowser tableBrowser = new SimpleMibTableBrowser(snmpTable, snmpTable.getTableColumnModel(maxAdvance, 20), this.snmpService, this.smiManager, this.target, this.variableBindingMapper){

                @Override
                public void close() {
                    dialog.setVisible(false);
                }
            };
            dialog.setTitle(node.getObjectName());
            dialog.setLocationRelativeTo(this);
            dialog.setLayout(new BorderLayout(10, 10));
            dialog.add("Center", tableBrowser.$$$getRootComponent$$$());
            dialog.pack();
            dialog.setVisible(true);
        }
    }

    private SimpleMibDataNode createDataMibStructure() {
        SmiObject rootNode = this.smiManager.findSmiObject(new OID("1.3.6.1"));
        if (rootNode == null) {
            rootNode = this.smiManager.findRootSmiObject();
        }
        if (rootNode == null) {
            return null;
        }
        SimpleMibDataNode node = new SimpleMibDataNode(rootNode, null);
        this.buildSubtree(node);
        return node;
    }

    private void buildSubtree(SimpleMibDataNode node) {
        List<? extends SmiObject> children = node.getSmiObject().getChildren();
        ArrayList<SimpleMibDataNode> childNodes = new ArrayList<SimpleMibDataNode>(children.size());
        for (SmiObject smiObject : children) {
            SnmpProxyObject proxyObject = null;
            boolean buildSubtree = true;
            if (smiObject instanceof SmiObjectType) {
                SmiObjectType smiObjectType = (SmiObjectType)smiObject;
                switch (smiObject.getType()) {
                    case OBJECT_TYPE_SCALAR: {
                        proxyObject = new SnmpScalarImplRO<String>(smiObject.getOID(), null, null, String.class, smiObject.getSmiSyntax());
                        buildSubtree = false;
                        break;
                    }
                    case OBJECT_TYPE_TABLE: {
                        try {
                            SmiObjectType tableEntry = (SmiObjectType)smiObjectType.getChildren().get(0);
                            proxyObject = new SnmpTableImpl<SnmpProxyIndexColumn<String>, SnmpProxyColumn<String>, String, String, SnmpProxyRowImpl<String, String>>(tableEntry.getOID(), null, this.snmpProxyAdapter, this, TableHelper.buildIndexColumns(tableEntry), TableHelper.buildColumns(tableEntry), 10);
                        }
                        catch (NullPointerException npe) {
                        }
                        catch (ClassCastException cce) {}
                        break;
                    }
                    case OBJECT_TYPE_TABLE_ENTRY: {
                        proxyObject = new SnmpTableImpl<SnmpProxyIndexColumn<String>, SnmpProxyColumn<String>, String, String, SnmpProxyRowImpl<String, String>>(smiObjectType.getOID(), null, this.snmpProxyAdapter, this, TableHelper.buildIndexColumns(smiObjectType), TableHelper.buildColumns(smiObjectType), 10);
                    }
                }
            }
            SimpleMibDataNode childNode = new SimpleMibDataNode(smiObject, proxyObject);
            childNodes.add(childNode);
            if (!buildSubtree) continue;
            this.buildSubtree(childNode);
        }
        node.setChildren(childNodes);
    }

    private static SmiManager configureSnmp4jSMI(Map<String, List<?>> commandLineParameters) throws IOException {
        SmiManager smiManager;
        String licenseKey = "";
        if (commandLineParameters.containsKey("L")) {
            licenseKey = (String)ArgumentParser.getFirstValue(commandLineParameters.get("L"));
        }
        if (commandLineParameters.containsKey("M")) {
            String f2 = (String)ArgumentParser.getFirstValue(commandLineParameters.get("M"));
            smiManager = new SmiManager(licenseKey, new File(f2));
        } else {
            smiManager = new SmiManager(licenseKey, new MemRepositoryDriver());
        }
        if (commandLineParameters.containsKey("m")) {
            ArrayList<String> modulePatterns = new ArrayList<String>();
            for (Object p2 : commandLineParameters.get("m")) {
                modulePatterns.add(p2.toString());
            }
            SimpleMibBrowser.loadModules(smiManager, modulePatterns);
        }
        SNMP4JSettings.setOIDTextFormat(smiManager);
        SNMP4JSettings.setVariableTextFormat(smiManager);
        smiManager.setOidFormat(SmiManager.OIDFormat.ObjectNameAndDecodedIndex4RoundTrip);
        smiManager.setOctetStringDisplayHint(SmiManager.OctetStringDefaultFormat.MIB);
        return smiManager;
    }

    private static void loadModules(SmiManager smiManager, List<String> modulePatterns) throws IOException {
        String[] availableModules = smiManager.listModules();
        for (String modulePattern : modulePatterns) {
            Pattern p2 = Pattern.compile(modulePattern);
            boolean matched = false;
            for (String availableModule : availableModules) {
                Matcher m2 = p2.matcher(availableModule);
                if (!m2.matches()) continue;
                matched = smiManager.loadModule(availableModule);
                System.out.println("Loaded MIB module '" + availableModule + "'");
            }
            if (matched) continue;
            System.err.println("No module loaded for pattern '" + modulePattern + "'");
        }
    }

    public static void main(final String[] args) {
        Runnable gui = new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                try {
                    try {
                        ArgumentParser parser = new ArgumentParser(SimpleMibBrowser.ALL_OPTIONS, SimpleMibBrowser.ADDRESS_PARAMETER);
                        Map<String, List<?>> commandLineParameters = parser.parse(args);
                        new SimpleMibBrowser(commandLineParameters).setVisible(true);
                    }
                    catch (ParseException e3) {
                        e3.printStackTrace();
                    }
                }
                catch (IOException e4) {
                    e4.printStackTrace();
                }
            }
        };
        SwingUtilities.invokeLater(gui);
    }

    @Override
    public SnmpProxyRowImpl<String, String> createProxyRow(OID index, List<String> indexObjects, List<String> values) {
        return new SnmpProxyRowImpl<String, String>(index, indexObjects, values);
    }

    static {
        LogFactory.setLogFactory(new ConsoleLogFactory());
        BER.setCheckSequenceLength(false);
        LogFactory.getLogFactory().getRootLogger().setLogLevel(LogLevel.ALL);
    }
}

