/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.model.demo.mibbrowser;

import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import org.snmp4j.model.demo.mibbrowser.SimpleTreeTableModel;

public abstract class SimpleAbstractTreeTableModel
implements SimpleTreeTableModel {
    protected Object root;
    protected EventListenerList listenerList = new EventListenerList();
    private static final int CHANGED = 0;
    private static final int INSERTED = 1;
    private static final int REMOVED = 2;
    private static final int STRUCTURE_CHANGED = 3;

    public SimpleAbstractTreeTableModel(Object root) {
        this.root = root;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return 0;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l2) {
        this.listenerList.add(TreeModelListener.class, l2);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l2) {
        this.listenerList.remove(TreeModelListener.class, l2);
    }

    private void fireTreeNode(int changeType, Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e2 = new TreeModelEvent(source, path, childIndices, children);
        block6: for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != TreeModelListener.class) continue;
            switch (changeType) {
                case 0: {
                    ((TreeModelListener)listeners[i2 + 1]).treeNodesChanged(e2);
                    continue block6;
                }
                case 1: {
                    ((TreeModelListener)listeners[i2 + 1]).treeNodesInserted(e2);
                    continue block6;
                }
                case 2: {
                    ((TreeModelListener)listeners[i2 + 1]).treeNodesRemoved(e2);
                    continue block6;
                }
                case 3: {
                    ((TreeModelListener)listeners[i2 + 1]).treeStructureChanged(e2);
                    continue block6;
                }
            }
        }
    }

    protected void fireTreeNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        this.fireTreeNode(0, source, path, childIndices, children);
    }

    protected void fireTreeNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
        this.fireTreeNode(1, source, path, childIndices, children);
    }

    protected void fireTreeNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
        this.fireTreeNode(2, source, path, childIndices, children);
    }

    protected void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        this.fireTreeNode(3, source, path, childIndices, children);
    }
}

