/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.log;

import java.util.Collections;
import java.util.Iterator;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.NoLogger;

public class LogFactory {
    public static final String SNMP4J_LOG_FACTORY_SYSTEM_PROPERTY = "snmp4j.LogFactory";
    private static LogFactory snmp4jLogFactory = null;
    private static boolean configChecked = false;

    public static LogAdapter getLogger(Class c2) {
        LogFactory.checkConfig();
        if (snmp4jLogFactory == null) {
            return NoLogger.instance;
        }
        return snmp4jLogFactory.createLogger(c2.getName());
    }

    private static void checkConfig() {
        if (!configChecked) {
            configChecked = true;
            LogFactory.getFactoryFromSystemProperty();
        }
    }

    private static synchronized void getFactoryFromSystemProperty() {
        block6: {
            try {
                String factory = System.getProperty(SNMP4J_LOG_FACTORY_SYSTEM_PROPERTY, null);
                if (factory == null) break block6;
                try {
                    Class<?> c2 = Class.forName(factory);
                    snmp4jLogFactory = (LogFactory)c2.newInstance();
                }
                catch (ClassNotFoundException ex) {
                    throw new RuntimeException(ex);
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException(ex);
                }
                catch (InstantiationException ex) {
                    throw new RuntimeException(ex);
                }
            }
            catch (SecurityException sec) {
                throw new RuntimeException(sec);
            }
        }
    }

    public LogAdapter getRootLogger() {
        return NoLogger.instance;
    }

    public static LogAdapter getLogger(String className) {
        LogFactory.checkConfig();
        if (snmp4jLogFactory == null) {
            return NoLogger.instance;
        }
        return snmp4jLogFactory.createLogger(className);
    }

    protected LogAdapter createLogger(Class c2) {
        return NoLogger.instance;
    }

    protected LogAdapter createLogger(String className) {
        return NoLogger.instance;
    }

    public static void setLogFactory(LogFactory factory) {
        configChecked = true;
        snmp4jLogFactory = factory;
    }

    public static LogFactory getLogFactory() {
        if (snmp4jLogFactory == null) {
            return new LogFactory();
        }
        return snmp4jLogFactory;
    }

    public Iterator loggers() {
        return Collections.singletonList(NoLogger.instance).iterator();
    }
}

