/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.log;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogLevel;
import org.snmp4j.util.EnumerationIterator;

public class Log4jLogAdapter
implements LogAdapter,
Comparable {
    private final Logger logger;
    private static final String FQCN = Log4jLogAdapter.class.getName();

    public Log4jLogAdapter(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void debug(Serializable message) {
        this.logger.log(FQCN, Level.DEBUG, message, null);
    }

    @Override
    public void error(Serializable message) {
        this.logger.log(FQCN, Level.ERROR, message, null);
    }

    @Override
    public void error(CharSequence message, Throwable throwable) {
        this.logger.log(FQCN, Level.ERROR, message, throwable);
    }

    @Override
    public void info(CharSequence message) {
        this.logger.log(FQCN, Level.INFO, message, null);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor(Level.WARN);
    }

    @Override
    public void warn(Serializable message) {
        this.logger.log(FQCN, Level.WARN, message, null);
    }

    @Override
    public void fatal(Object message) {
        this.logger.log(FQCN, Level.FATAL, message, null);
    }

    @Override
    public void fatal(CharSequence message, Throwable throwable) {
        this.logger.log(FQCN, Level.FATAL, message, throwable);
    }

    @Override
    public void setLogLevel(LogLevel level) {
        Level l2;
        switch (level.getLevel()) {
            case 1: {
                l2 = Level.OFF;
                break;
            }
            case 2: {
                l2 = Level.ALL;
                break;
            }
            case 3: {
                l2 = Level.DEBUG;
                break;
            }
            case 4: {
                l2 = Level.DEBUG;
                break;
            }
            case 5: {
                l2 = Level.INFO;
                break;
            }
            case 6: {
                l2 = Level.WARN;
                break;
            }
            case 7: {
                l2 = Level.ERROR;
                break;
            }
            case 8: {
                l2 = Level.FATAL;
                break;
            }
            default: {
                l2 = null;
            }
        }
        this.logger.setLevel(l2);
    }

    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public LogLevel getLogLevel() {
        Level l2 = this.logger.getLevel();
        return this.toLogLevel(l2);
    }

    private LogLevel toLogLevel(Level l2) {
        if (l2 == null) {
            return LogLevel.NONE;
        }
        switch (l2.toInt()) {
            case 0x7FFFFFFF: {
                return LogLevel.OFF;
            }
            case -2147483648: {
                return LogLevel.ALL;
            }
            case 10000: {
                return LogLevel.DEBUG;
            }
            case 20000: {
                return LogLevel.INFO;
            }
            case 30000: {
                return LogLevel.WARN;
            }
            case 40000: {
                return LogLevel.ERROR;
            }
            case 50000: {
                return LogLevel.FATAL;
            }
        }
        return LogLevel.DEBUG;
    }

    public int compareTo(Object o2) {
        return this.getName().compareTo(((Log4jLogAdapter)o2).getName());
    }

    @Override
    public LogLevel getEffectiveLogLevel() {
        Level l2 = this.logger.getEffectiveLevel();
        return this.toLogLevel(l2);
    }

    @Override
    public Iterator<Appender> getLogHandler() {
        return new EnumerationIterator<Appender>(this.logger.getAllAppenders());
    }
}

