/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.util;

import java.util.Iterator;
import java.util.LinkedList;

public class TemporaryList<T> {
    public static final int DEFAULT_ITEM_TIMEOUT = 300000;
    private int timeout = 300000;
    private LinkedList<TemporaryListItem<T>> list = new LinkedList();

    public TemporaryList() {
    }

    public TemporaryList(int timeout) {
        this.timeout = timeout;
    }

    public synchronized void add(T o2) {
        long now = System.nanoTime();
        if (this.list.size() > 0 && this.list.getFirst().atMaturity(now)) {
            this.list.removeFirst();
        }
        if (this.list.size() > 0 && this.list.getLast().atMaturity(now)) {
            this.list.removeLast();
        }
        this.list.addFirst(new TemporaryListItem<T>(o2));
    }

    public synchronized boolean contains(T o2) {
        for (TemporaryListItem temporaryListItem : this.list) {
            if (!temporaryListItem.getItem().equals(o2)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean remove(T o2) {
        long now = System.nanoTime();
        Iterator it = this.list.iterator();
        while (it.hasNext()) {
            TemporaryListItem item = (TemporaryListItem)it.next();
            if (item.getItem().equals(o2)) {
                it.remove();
                return true;
            }
            if (!item.atMaturity(now)) continue;
            it.remove();
        }
        return false;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public Iterator<T> iterator() {
        return new TemporaryListIterator<T>(this.list);
    }

    public int size() {
        return this.list.size();
    }

    public synchronized void clear() {
        this.list.clear();
    }

    class TemporaryListIterator<T>
    implements Iterator<T> {
        private Iterator<TemporaryListItem<T>> iterator;

        public TemporaryListIterator(LinkedList<TemporaryListItem<T>> list) {
            this.iterator = list.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            return this.iterator.next().getItem();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    class TemporaryListItem<T> {
        private T item;
        private long timeOfMaturity;

        public TemporaryListItem(T item) {
            this.item = item;
            this.timeOfMaturity = System.nanoTime() + (long)(TemporaryList.this.timeout * 1000000);
        }

        public long getTimeOfMaturity() {
            return this.timeOfMaturity;
        }

        public T getItem() {
            return this.item;
        }

        public boolean equals(Object obj) {
            return obj instanceof TemporaryList && this.item.equals(obj);
        }

        public int hashCode() {
            return this.item.hashCode();
        }

        public boolean atMaturity(long referenceTime) {
            return referenceTime > this.timeOfMaturity;
        }
    }
}

