/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.util;

import org.snmp4j.smi.Counter64;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.UnsignedInteger32;
import org.snmp4j.smi.Variable;

public class IndexGenerator {
    private Variable seedSubIndex;
    private boolean impliedLength;

    public IndexGenerator(Variable seedSubIndex) {
        if (!(seedSubIndex instanceof Integer32 || seedSubIndex instanceof UnsignedInteger32 || seedSubIndex instanceof Counter64)) {
            throw new IllegalArgumentException("A seed subindex of type " + seedSubIndex.getSyntaxString() + "is not supported");
        }
        this.seedSubIndex = seedSubIndex;
    }

    public IndexGenerator(Variable seedSubIndex, boolean impliedLength) {
        this(seedSubIndex);
        this.impliedLength = impliedLength;
    }

    public synchronized OID getNextSubIndex() {
        if (this.seedSubIndex instanceof Integer32) {
            Integer32 i2 = (Integer32)this.seedSubIndex;
            i2.setValue(i2.getValue() + 1);
        } else if (this.seedSubIndex instanceof UnsignedInteger32) {
            UnsignedInteger32 ui = (UnsignedInteger32)this.seedSubIndex;
            ui.setValue(ui.getValue() + 1L);
        } else if (this.seedSubIndex instanceof Counter64) {
            Counter64 c2 = (Counter64)this.seedSubIndex;
            c2.setValue(c2.getValue() + 1L);
        }
        return this.seedSubIndex.toSubIndex(this.impliedLength);
    }
}

