/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp;

import java.io.Serializable;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import javax.security.auth.x500.X500Principal;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.NotificationOriginator;
import org.snmp4j.agent.mo.DefaultMOFactory;
import org.snmp4j.agent.mo.DefaultMOMutableRow2PC;
import org.snmp4j.agent.mo.DefaultMOMutableTableModel;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOFactory;
import org.snmp4j.agent.mo.MOMutableColumn;
import org.snmp4j.agent.mo.MOMutableRow2PC;
import org.snmp4j.agent.mo.MOMutableTableModel;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.agent.mo.MOTable;
import org.snmp4j.agent.mo.MOTableIndex;
import org.snmp4j.agent.mo.MOTableIndexValidator;
import org.snmp4j.agent.mo.MOTableModel;
import org.snmp4j.agent.mo.MOTableRowFactory;
import org.snmp4j.agent.mo.MOTableSubIndex;
import org.snmp4j.agent.mo.MOValueValidationEvent;
import org.snmp4j.agent.mo.MOValueValidationListener;
import org.snmp4j.agent.mo.snmp.RowStatus;
import org.snmp4j.agent.mo.snmp.StorageType;
import org.snmp4j.agent.mo.snmp.smi.Constraint;
import org.snmp4j.agent.mo.snmp.smi.ConstraintsImpl;
import org.snmp4j.agent.mo.snmp.smi.EnumerationConstraint;
import org.snmp4j.agent.mo.snmp.smi.ValueConstraintValidator;
import org.snmp4j.agent.mo.snmp.tc.TextualConvention;
import org.snmp4j.event.CounterListener;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.DefaultCounterListener;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.AssignableFromLong;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.Gauge32;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.TLSTM;
import org.snmp4j.transport.tls.TlsTmSecurityCallback;

public class SnmpTlsTmMib
implements MOGroup,
TlsTmSecurityCallback<X509Certificate> {
    private static final LogAdapter LOGGER = LogFactory.getLogger(SnmpTlsTmMib.class);
    private static MOFactory moFactory = DefaultMOFactory.getInstance();
    public static final OID oidSnmpTlsTmMib = new OID(new int[]{1, 3, 6, 1, 2, 1, 198});
    public static final OID oidSnmpTlstmCertSpecified = new OID(new int[]{1, 3, 6, 1, 2, 1, 198, 1, 1, 1});
    public static final OID oidSnmpTlstmCertSANRFC822Name = new OID(new int[]{1, 3, 6, 1, 2, 1, 198, 1, 1, 2});
    public static final OID oidSnmpTlstmCertSANDNSName = new OID(new int[]{1, 3, 6, 1, 2, 1, 198, 1, 1, 3});
    public static final OID oidSnmpTlstmCertSANIpAddress = new OID(new int[]{1, 3, 6, 1, 2, 1, 198, 1, 1, 4});
    public static final OID oidSnmpTlstmCertSANAny = new OID(new int[]{1, 3, 6, 1, 2, 1, 198, 1, 1, 5});
    public static final OID oidSnmpTlstmCertCommonName = new OID(new int[]{1, 3, 6, 1, 2, 1, 198, 1, 1, 6});
    public static final OID oidSnmpTLSTCPDomain = new OID(new int[]{1, 3, 6, 1, 6, 1, 8});
    public static final OID oidSnmpDTLSUDPDomain = new OID(new int[]{1, 3, 6, 1, 6, 1, 9});
    public static final OID oidSnmpTlstmSessionOpens = new OID(new int[]{1, 3, 6, 1, 2, 1, 198, 2, 1, 1, 0});
    public static final OID oidSnmpTlstmSessionClientCloses = new OID(new int[]{1, 3, 6, 1, 2, 1, 198, 2, 1, 2, 0});
    public static final OID oidSnmpTlstmSessionOpenErrors = new OID(new int[]{1, 3, 6, 1, 2, 1, 198, 2, 1, 3, 0});
    public static final OID oidSnmpTlstmSessionAccepts = new OID(new int[]{1, 3, 6, 1, 2, 1, 198, 2, 1, 4, 0});
    public static final OID oidSnmpTlstmSessionServerCloses = new OID(new int[]{1, 3, 6, 1, 2, 1, 198, 2, 1, 5, 0});
    public static final OID oidSnmpTlstmSessionNoSessions = new OID(new int[]{1, 3, 6, 1, 2, 1, 198, 2, 1, 6, 0});
    public static final OID oidSnmpTlstmSessionInvalidClientCertificates = new OID(new int[]{1, 3, 6, 1, 2, 1, 198, 2, 1, 7, 0});
    public static final OID oidSnmpTlstmSessionUnknownServerCertificate = new OID(new int[]{1, 3, 6, 1, 2, 1, 198, 2, 1, 8, 0});
    public static final OID oidSnmpTlstmSessionInvalidServerCertificates = new OID(new int[]{1, 3, 6, 1, 2, 1, 198, 2, 1, 9, 0});
    public static final OID oidSnmpTlstmSessionInvalidCaches = new OID(new int[]{1, 3, 6, 1, 2, 1, 198, 2, 1, 10, 0});
    public static final OID oidSnmpTlstmCertToTSNCount = new OID(new int[]{1, 3, 6, 1, 2, 1, 198, 2, 2, 1, 1, 0});
    public static final OID oidSnmpTlstmCertToTSNTableLastChanged = new OID(new int[]{1, 3, 6, 1, 2, 1, 198, 2, 2, 1, 2, 0});
    public static final OID oidSnmpTlstmParamsCount = new OID(new int[]{1, 3, 6, 1, 2, 1, 198, 2, 2, 1, 4, 0});
    public static final OID oidSnmpTlstmParamsTableLastChanged = new OID(new int[]{1, 3, 6, 1, 2, 1, 198, 2, 2, 1, 5, 0});
    public static final OID oidSnmpTlstmAddrCount = new OID(new int[]{1, 3, 6, 1, 2, 1, 198, 2, 2, 1, 7, 0});
    public static final OID oidSnmpTlstmAddrTableLastChanged = new OID(new int[]{1, 3, 6, 1, 2, 1, 198, 2, 2, 1, 8, 0});
    public static final OID oidSnmpTlstmServerCertificateUnknown = new OID(new int[]{1, 3, 6, 1, 2, 1, 198, 0, 1});
    public static final OID oidTrapVarSnmpTlstmSessionUnknownServerCertificate = new OID(new int[]{1, 3, 6, 1, 2, 1, 198, 2, 1, 8});
    public static final OID oidSnmpTlstmServerInvalidCertificate = new OID(new int[]{1, 3, 6, 1, 2, 1, 198, 0, 2});
    public static final OID oidTrapVarSnmpTlstmAddrServerFingerprint = new OID(new int[]{1, 3, 6, 1, 2, 1, 198, 2, 2, 1, 9, 1, 1});
    public static final OID oidTrapVarSnmpTlstmSessionInvalidServerCertificates = new OID(new int[]{1, 3, 6, 1, 2, 1, 198, 2, 1, 9});
    private static final String TC_MODULE_SNMP_TLS_TM_MIB = "SNMP-TLS-TM-MIB";
    private static final String TC_MODULE_SNMP_FRAMEWORK_MIB = "SNMP-FRAMEWORK-MIB";
    private static final String TC_MODULE_SNMPV2_TC = "SNMPv2-TC";
    private static final String TC_SNMPADMINSTRING = "SnmpAdminString";
    private static final String TC_TIMESTAMP = "TimeStamp";
    private static final String TC_AUTONOMOUSTYPE = "AutonomousType";
    private static final String TC_STORAGETYPE = "StorageType";
    private static final String TC_ROWSTATUS = "RowStatus";
    private static final String TC_SNMPTLSFINGERPRINT = "SnmpTLSFingerprint";
    private MOScalar<Counter32> snmpTlstmSessionOpens;
    private MOScalar<Counter32> snmpTlstmSessionClientCloses;
    private MOScalar<Counter32> snmpTlstmSessionOpenErrors;
    private MOScalar<Counter32> snmpTlstmSessionAccepts;
    private MOScalar<Counter32> snmpTlstmSessionServerCloses;
    private MOScalar<Counter32> snmpTlstmSessionNoSessions;
    private MOScalar<Counter32> snmpTlstmSessionInvalidClientCertificates;
    private MOScalar<Counter32> snmpTlstmSessionUnknownServerCertificate;
    private MOScalar<Counter32> snmpTlstmSessionInvalidServerCertificates;
    private MOScalar<Counter32> snmpTlstmSessionInvalidCaches;
    private MOScalar<Gauge32> snmpTlstmCertToTSNCount;
    private MOScalar<TimeTicks> snmpTlstmCertToTSNTableLastChanged;
    private MOScalar<Gauge32> snmpTlstmParamsCount;
    private MOScalar<TimeTicks> snmpTlstmParamsTableLastChanged;
    private MOScalar<Gauge32> snmpTlstmAddrCount;
    private MOScalar<TimeTicks> snmpTlstmAddrTableLastChanged;
    public static final OID oidSnmpTlstmCertToTSNEntry = new OID(new int[]{1, 3, 6, 1, 2, 1, 198, 2, 2, 1, 3, 1});
    public static final OID oidSnmpTlstmCertToTSNID = new OID(new int[]{1, 3, 6, 1, 2, 1, 198, 2, 2, 1, 3, 1, 1});
    public static final String tcModuleSnmpTlsTmMib = "SNMP-TLS-TM-MIB";
    public static final String tcDefSnmpTLSFingerprint = "SnmpTLSFingerprint";
    public static final String tcModuleSNMPv2Tc = "SNMPv2-TC";
    public static final String tcDefAutonomousType = "AutonomousType";
    public static final String tcDefStorageType = "StorageType";
    public static final String tcDefRowStatus = "RowStatus";
    public static final int colSnmpTlstmCertToTSNFingerprint = 2;
    public static final int colSnmpTlstmCertToTSNMapType = 3;
    public static final int colSnmpTlstmCertToTSNData = 4;
    public static final int colSnmpTlstmCertToTSNStorageType = 5;
    public static final int colSnmpTlstmCertToTSNRowStatus = 6;
    public static final int idxSnmpTlstmCertToTSNFingerprint = 0;
    public static final int idxSnmpTlstmCertToTSNMapType = 1;
    public static final int idxSnmpTlstmCertToTSNData = 2;
    public static final int idxSnmpTlstmCertToTSNStorageType = 3;
    public static final int idxSnmpTlstmCertToTSNRowStatus = 4;
    private MOTableSubIndex[] snmpTlstmCertToTSNEntryIndexes;
    private MOTableIndex snmpTlstmCertToTSNEntryIndex;
    private MOTable<SnmpTlstmCertToTSNEntryRow, MOColumn, DefaultMOMutableTableModel<SnmpTlstmCertToTSNEntryRow>> snmpTlstmCertToTSNEntry;
    private DefaultMOMutableTableModel<SnmpTlstmCertToTSNEntryRow> snmpTlstmCertToTSNEntryModel;
    public static final OID oidSnmpTlstmParamsEntry = new OID(new int[]{1, 3, 6, 1, 2, 1, 198, 2, 2, 1, 6, 1});
    public static final OID oidSnmpTargetParamsName = new OID(new int[]{1, 3, 6, 1, 6, 3, 12, 1, 3, 1, 1});
    public static final int colSnmpTlstmParamsClientFingerprint = 1;
    public static final int colSnmpTlstmParamsStorageType = 2;
    public static final int colSnmpTlstmParamsRowStatus = 3;
    public static final int idxSnmpTlstmParamsClientFingerprint = 0;
    public static final int idxSnmpTlstmParamsStorageType = 1;
    public static final int idxSnmpTlstmParamsRowStatus = 2;
    private MOTableSubIndex[] snmpTlstmParamsEntryIndexes;
    private MOTableIndex snmpTlstmParamsEntryIndex;
    private MOTable<SnmpTlstmParamsEntryRow, MOColumn, MOTableModel<SnmpTlstmParamsEntryRow>> snmpTlstmParamsEntry;
    private MOTableModel<SnmpTlstmParamsEntryRow> snmpTlstmParamsEntryModel;
    public static final OID oidSnmpTlstmAddrEntry = new OID(new int[]{1, 3, 6, 1, 2, 1, 198, 2, 2, 1, 9, 1});
    public static final OID oidSnmpTargetAddrName = new OID(new int[]{1, 3, 6, 1, 6, 3, 12, 1, 2, 1, 1});
    public static final String tcModuleSnmpFrameworkMib = "SNMP-FRAMEWORK-MIB";
    public static final String tcDefSnmpAdminString = "SnmpAdminString";
    public static final int colSnmpTlstmAddrServerFingerprint = 1;
    public static final int colSnmpTlstmAddrServerIdentity = 2;
    public static final int colSnmpTlstmAddrStorageType = 3;
    public static final int colSnmpTlstmAddrRowStatus = 4;
    public static final int idxSnmpTlstmAddrServerFingerprint = 0;
    public static final int idxSnmpTlstmAddrServerIdentity = 1;
    public static final int idxSnmpTlstmAddrStorageType = 2;
    public static final int idxSnmpTlstmAddrRowStatus = 3;
    private MOTableSubIndex[] snmpTlstmAddrEntryIndexes;
    private MOTableIndex snmpTlstmAddrEntryIndex;
    private MOTable<MOMutableRow2PC, MOColumn, MOTableModel<MOMutableRow2PC>> snmpTlstmAddrEntry;
    private MOTableModel<MOMutableRow2PC> snmpTlstmAddrEntryModel;
    private DefaultCounterListener counterListener = new DefaultCounterListener();

    protected SnmpTlsTmMib() {
        this.counterListener.setCountRegisteredOnly(true);
    }

    public SnmpTlsTmMib(MOFactory moFactory) {
        this();
        this.createMO(moFactory);
        this.counterListener.add(this.snmpTlstmSessionOpens.getOid(), this.snmpTlstmSessionOpens.getValue());
        this.counterListener.add(this.snmpTlstmSessionClientCloses.getOid(), this.snmpTlstmSessionClientCloses.getValue());
        this.counterListener.add(this.snmpTlstmSessionOpenErrors.getOid(), this.snmpTlstmSessionOpenErrors.getValue());
        this.counterListener.add(this.snmpTlstmSessionAccepts.getOid(), this.snmpTlstmSessionAccepts.getValue());
        this.counterListener.add(this.snmpTlstmSessionServerCloses.getOid(), this.snmpTlstmSessionServerCloses.getValue());
        this.counterListener.add(this.snmpTlstmSessionNoSessions.getOid(), this.snmpTlstmSessionNoSessions.getValue());
        this.counterListener.add(this.snmpTlstmSessionInvalidClientCertificates.getOid(), this.snmpTlstmSessionInvalidClientCertificates.getValue());
        this.counterListener.add(this.snmpTlstmSessionUnknownServerCertificate.getOid(), this.snmpTlstmSessionUnknownServerCertificate.getValue());
        this.counterListener.add(this.snmpTlstmSessionInvalidServerCertificates.getOid(), this.snmpTlstmSessionInvalidServerCertificates.getValue());
        this.counterListener.add(this.snmpTlstmSessionInvalidCaches.getOid(), this.snmpTlstmSessionInvalidCaches.getValue());
    }

    protected void createMO(MOFactory moFactory) {
        this.addTCsToFactory(moFactory);
        this.snmpTlstmSessionOpens = moFactory.createScalar(oidSnmpTlstmSessionOpens, moFactory.createAccess(9), new Counter32());
        this.snmpTlstmSessionClientCloses = moFactory.createScalar(oidSnmpTlstmSessionClientCloses, moFactory.createAccess(9), new Counter32());
        this.snmpTlstmSessionOpenErrors = moFactory.createScalar(oidSnmpTlstmSessionOpenErrors, moFactory.createAccess(9), new Counter32());
        this.snmpTlstmSessionAccepts = moFactory.createScalar(oidSnmpTlstmSessionAccepts, moFactory.createAccess(9), new Counter32());
        this.snmpTlstmSessionServerCloses = moFactory.createScalar(oidSnmpTlstmSessionServerCloses, moFactory.createAccess(9), new Counter32());
        this.snmpTlstmSessionNoSessions = moFactory.createScalar(oidSnmpTlstmSessionNoSessions, moFactory.createAccess(9), new Counter32());
        this.snmpTlstmSessionInvalidClientCertificates = moFactory.createScalar(oidSnmpTlstmSessionInvalidClientCertificates, moFactory.createAccess(9), new Counter32());
        this.snmpTlstmSessionUnknownServerCertificate = moFactory.createScalar(oidSnmpTlstmSessionUnknownServerCertificate, moFactory.createAccess(9), new Counter32());
        this.snmpTlstmSessionInvalidServerCertificates = moFactory.createScalar(oidSnmpTlstmSessionInvalidServerCertificates, moFactory.createAccess(9), new Counter32());
        this.snmpTlstmSessionInvalidCaches = moFactory.createScalar(oidSnmpTlstmSessionInvalidCaches, moFactory.createAccess(9), new Counter32());
        this.snmpTlstmCertToTSNCount = moFactory.createScalar(oidSnmpTlstmCertToTSNCount, moFactory.createAccess(9), new Gauge32());
        this.snmpTlstmCertToTSNTableLastChanged = moFactory.createScalar(oidSnmpTlstmCertToTSNTableLastChanged, moFactory.createAccess(9), null, "SNMPv2-TC", TC_TIMESTAMP);
        this.snmpTlstmParamsCount = moFactory.createScalar(oidSnmpTlstmParamsCount, moFactory.createAccess(9), new Gauge32());
        this.snmpTlstmParamsTableLastChanged = moFactory.createScalar(oidSnmpTlstmParamsTableLastChanged, moFactory.createAccess(9), null, "SNMPv2-TC", TC_TIMESTAMP);
        this.snmpTlstmAddrCount = moFactory.createScalar(oidSnmpTlstmAddrCount, moFactory.createAccess(9), new Gauge32());
        this.snmpTlstmAddrTableLastChanged = moFactory.createScalar(oidSnmpTlstmAddrTableLastChanged, moFactory.createAccess(9), null, "SNMPv2-TC", TC_TIMESTAMP);
        this.createSnmpTlstmCertToTSNEntry(moFactory);
        this.createSnmpTlstmParamsEntry(moFactory);
        this.createSnmpTlstmAddrEntry(moFactory);
    }

    public MOScalar getSnmpTlstmSessionOpens() {
        return this.snmpTlstmSessionOpens;
    }

    public MOScalar getSnmpTlstmSessionClientCloses() {
        return this.snmpTlstmSessionClientCloses;
    }

    public MOScalar getSnmpTlstmSessionOpenErrors() {
        return this.snmpTlstmSessionOpenErrors;
    }

    public MOScalar getSnmpTlstmSessionAccepts() {
        return this.snmpTlstmSessionAccepts;
    }

    public MOScalar getSnmpTlstmSessionServerCloses() {
        return this.snmpTlstmSessionServerCloses;
    }

    public MOScalar getSnmpTlstmSessionNoSessions() {
        return this.snmpTlstmSessionNoSessions;
    }

    public MOScalar getSnmpTlstmSessionInvalidClientCertificates() {
        return this.snmpTlstmSessionInvalidClientCertificates;
    }

    public MOScalar getSnmpTlstmSessionUnknownServerCertificate() {
        return this.snmpTlstmSessionUnknownServerCertificate;
    }

    public MOScalar getSnmpTlstmSessionInvalidServerCertificates() {
        return this.snmpTlstmSessionInvalidServerCertificates;
    }

    public MOScalar getSnmpTlstmSessionInvalidCaches() {
        return this.snmpTlstmSessionInvalidCaches;
    }

    public MOScalar getSnmpTlstmCertToTSNCount() {
        return this.snmpTlstmCertToTSNCount;
    }

    public MOScalar getSnmpTlstmCertToTSNTableLastChanged() {
        return this.snmpTlstmCertToTSNTableLastChanged;
    }

    public MOScalar getSnmpTlstmParamsCount() {
        return this.snmpTlstmParamsCount;
    }

    public MOScalar getSnmpTlstmParamsTableLastChanged() {
        return this.snmpTlstmParamsTableLastChanged;
    }

    public MOScalar getSnmpTlstmAddrCount() {
        return this.snmpTlstmAddrCount;
    }

    public MOScalar getSnmpTlstmAddrTableLastChanged() {
        return this.snmpTlstmAddrTableLastChanged;
    }

    public MOTable getSnmpTlstmCertToTSNEntry() {
        return this.snmpTlstmCertToTSNEntry;
    }

    private void createSnmpTlstmCertToTSNEntry(MOFactory moFactory) {
        this.snmpTlstmCertToTSNEntryIndexes = new MOTableSubIndex[]{moFactory.createSubIndex(oidSnmpTlstmCertToTSNID, 2, 1, 1)};
        this.snmpTlstmCertToTSNEntryIndex = moFactory.createIndex(this.snmpTlstmCertToTSNEntryIndexes, false, new MOTableIndexValidator(){

            @Override
            public boolean isValidIndex(OID index) {
                boolean isValidIndex = true;
                return isValidIndex;
            }
        });
        MOColumn[] snmpTlstmCertToTSNEntryColumns = new MOColumn[5];
        snmpTlstmCertToTSNEntryColumns[0] = new MOMutableColumn(2, 4, moFactory.createAccess(15), null);
        ConstraintsImpl snmpTlstmCertToTSNFingerprintVC = new ConstraintsImpl();
        snmpTlstmCertToTSNFingerprintVC.add(new Constraint(1L, 255L));
        ((MOMutableColumn)snmpTlstmCertToTSNEntryColumns[0]).addMOValueValidationListener(new ValueConstraintValidator(snmpTlstmCertToTSNFingerprintVC));
        ((MOMutableColumn)snmpTlstmCertToTSNEntryColumns[0]).addMOValueValidationListener(new SnmpTlstmCertToTSNFingerprintValidator());
        snmpTlstmCertToTSNEntryColumns[1] = new MOMutableColumn(3, 6, moFactory.createAccess(15), new OID("1.3.6.1.2.1.198.1.1.1"));
        ((MOMutableColumn)snmpTlstmCertToTSNEntryColumns[1]).addMOValueValidationListener(new SnmpTlstmCertToTSNMapTypeValidator());
        snmpTlstmCertToTSNEntryColumns[2] = new MOMutableColumn(4, 4, moFactory.createAccess(15), new OctetString(new byte[0]));
        ConstraintsImpl snmpTlstmCertToTSNDataVC = new ConstraintsImpl();
        snmpTlstmCertToTSNDataVC.add(new Constraint(0L, 1024L));
        ((MOMutableColumn)snmpTlstmCertToTSNEntryColumns[2]).addMOValueValidationListener(new ValueConstraintValidator(snmpTlstmCertToTSNDataVC));
        ((MOMutableColumn)snmpTlstmCertToTSNEntryColumns[2]).addMOValueValidationListener(new SnmpTlstmCertToTSNDataValidator());
        snmpTlstmCertToTSNEntryColumns[3] = new StorageType(5, moFactory.createAccess(15), new Integer32(3));
        EnumerationConstraint snmpTlstmCertToTSNStorageTypeVC = new EnumerationConstraint(new int[]{1, 2, 3, 4, 5});
        ((MOMutableColumn)snmpTlstmCertToTSNEntryColumns[3]).addMOValueValidationListener(new ValueConstraintValidator(snmpTlstmCertToTSNStorageTypeVC));
        ((MOMutableColumn)snmpTlstmCertToTSNEntryColumns[3]).addMOValueValidationListener(new SnmpTlstmCertToTSNStorageTypeValidator());
        snmpTlstmCertToTSNEntryColumns[4] = new RowStatus(6);
        EnumerationConstraint snmpTlstmCertToTSNRowStatusVC = new EnumerationConstraint(new int[]{1, 2, 3, 4, 5, 6});
        ((MOMutableColumn)snmpTlstmCertToTSNEntryColumns[4]).addMOValueValidationListener(new ValueConstraintValidator(snmpTlstmCertToTSNRowStatusVC));
        ((MOMutableColumn)snmpTlstmCertToTSNEntryColumns[4]).addMOValueValidationListener(new SnmpTlstmCertToTSNRowStatusValidator());
        this.snmpTlstmCertToTSNEntryModel = (DefaultMOMutableTableModel)moFactory.createTableModel(oidSnmpTlstmCertToTSNEntry, this.snmpTlstmCertToTSNEntryIndex, snmpTlstmCertToTSNEntryColumns);
        this.snmpTlstmCertToTSNEntryModel.setRowFactory(new SnmpTlstmCertToTSNEntryRowFactory());
        this.snmpTlstmCertToTSNEntry = moFactory.createTable(oidSnmpTlstmCertToTSNEntry, this.snmpTlstmCertToTSNEntryIndex, snmpTlstmCertToTSNEntryColumns, this.snmpTlstmCertToTSNEntryModel);
    }

    public MOTable getSnmpTlstmParamsEntry() {
        return this.snmpTlstmParamsEntry;
    }

    private void createSnmpTlstmParamsEntry(MOFactory moFactory) {
        this.snmpTlstmParamsEntryIndexes = new MOTableSubIndex[]{moFactory.createSubIndex(oidSnmpTargetParamsName, 4, 1, 32)};
        this.snmpTlstmParamsEntryIndex = moFactory.createIndex(this.snmpTlstmParamsEntryIndexes, true, new MOTableIndexValidator(){

            @Override
            public boolean isValidIndex(OID index) {
                boolean isValidIndex = true;
                return isValidIndex;
            }
        });
        MOColumn[] snmpTlstmParamsEntryColumns = new MOColumn[3];
        snmpTlstmParamsEntryColumns[0] = new MOMutableColumn(1, 4, moFactory.createAccess(15), null);
        ConstraintsImpl snmpTlstmParamsClientFingerprintVC = new ConstraintsImpl();
        snmpTlstmParamsClientFingerprintVC.add(new Constraint(0L, 255L));
        ((MOMutableColumn)snmpTlstmParamsEntryColumns[0]).addMOValueValidationListener(new ValueConstraintValidator(snmpTlstmParamsClientFingerprintVC));
        ((MOMutableColumn)snmpTlstmParamsEntryColumns[0]).addMOValueValidationListener(new SnmpTlstmParamsClientFingerprintValidator());
        snmpTlstmParamsEntryColumns[1] = new StorageType(2, moFactory.createAccess(15), new Integer32(3));
        EnumerationConstraint snmpTlstmParamsStorageTypeVC = new EnumerationConstraint(new int[]{1, 2, 3, 4, 5});
        ((MOMutableColumn)snmpTlstmParamsEntryColumns[1]).addMOValueValidationListener(new ValueConstraintValidator(snmpTlstmParamsStorageTypeVC));
        ((MOMutableColumn)snmpTlstmParamsEntryColumns[1]).addMOValueValidationListener(new SnmpTlstmParamsStorageTypeValidator());
        snmpTlstmParamsEntryColumns[2] = new RowStatus(3);
        EnumerationConstraint snmpTlstmParamsRowStatusVC = new EnumerationConstraint(new int[]{1, 2, 3, 4, 5, 6});
        ((MOMutableColumn)snmpTlstmParamsEntryColumns[2]).addMOValueValidationListener(new ValueConstraintValidator(snmpTlstmParamsRowStatusVC));
        ((MOMutableColumn)snmpTlstmParamsEntryColumns[2]).addMOValueValidationListener(new SnmpTlstmParamsRowStatusValidator());
        this.snmpTlstmParamsEntryModel = moFactory.createTableModel(oidSnmpTlstmParamsEntry, this.snmpTlstmParamsEntryIndex, snmpTlstmParamsEntryColumns);
        ((MOMutableTableModel)this.snmpTlstmParamsEntryModel).setRowFactory(new SnmpTlstmParamsEntryRowFactory());
        this.snmpTlstmParamsEntry = moFactory.createTable(oidSnmpTlstmParamsEntry, this.snmpTlstmParamsEntryIndex, snmpTlstmParamsEntryColumns, this.snmpTlstmParamsEntryModel);
    }

    public MOTable getSnmpTlstmAddrEntry() {
        return this.snmpTlstmAddrEntry;
    }

    private void createSnmpTlstmAddrEntry(MOFactory moFactory) {
        this.snmpTlstmAddrEntryIndexes = new MOTableSubIndex[]{moFactory.createSubIndex(oidSnmpTargetAddrName, 4, 1, 32)};
        this.snmpTlstmAddrEntryIndex = moFactory.createIndex(this.snmpTlstmAddrEntryIndexes, true, new MOTableIndexValidator(){

            @Override
            public boolean isValidIndex(OID index) {
                boolean isValidIndex = true;
                return isValidIndex;
            }
        });
        MOColumn[] snmpTlstmAddrEntryColumns = new MOColumn[4];
        snmpTlstmAddrEntryColumns[0] = new MOMutableColumn(1, 4, moFactory.createAccess(15), new OctetString(new byte[0]));
        ConstraintsImpl snmpTlstmAddrServerFingerprintVC = new ConstraintsImpl();
        snmpTlstmAddrServerFingerprintVC.add(new Constraint(0L, 255L));
        ((MOMutableColumn)snmpTlstmAddrEntryColumns[0]).addMOValueValidationListener(new ValueConstraintValidator(snmpTlstmAddrServerFingerprintVC));
        ((MOMutableColumn)snmpTlstmAddrEntryColumns[0]).addMOValueValidationListener(new SnmpTlstmAddrServerFingerprintValidator());
        snmpTlstmAddrEntryColumns[1] = new MOMutableColumn(2, 4, moFactory.createAccess(15), new OctetString(new byte[0]));
        ConstraintsImpl snmpTlstmAddrServerIdentityVC = new ConstraintsImpl();
        snmpTlstmAddrServerIdentityVC.add(new Constraint(0L, 255L));
        ((MOMutableColumn)snmpTlstmAddrEntryColumns[1]).addMOValueValidationListener(new ValueConstraintValidator(snmpTlstmAddrServerIdentityVC));
        ((MOMutableColumn)snmpTlstmAddrEntryColumns[1]).addMOValueValidationListener(new SnmpTlstmAddrServerIdentityValidator());
        snmpTlstmAddrEntryColumns[2] = new StorageType(3, moFactory.createAccess(15), new Integer32(3));
        EnumerationConstraint snmpTlstmAddrStorageTypeVC = new EnumerationConstraint(new int[]{1, 2, 3, 4, 5});
        ((MOMutableColumn)snmpTlstmAddrEntryColumns[2]).addMOValueValidationListener(new ValueConstraintValidator(snmpTlstmAddrStorageTypeVC));
        ((MOMutableColumn)snmpTlstmAddrEntryColumns[2]).addMOValueValidationListener(new SnmpTlstmAddrStorageTypeValidator());
        snmpTlstmAddrEntryColumns[3] = new RowStatus(4);
        EnumerationConstraint snmpTlstmAddrRowStatusVC = new EnumerationConstraint(new int[]{1, 2, 3, 4, 5, 6});
        ((MOMutableColumn)snmpTlstmAddrEntryColumns[3]).addMOValueValidationListener(new ValueConstraintValidator(snmpTlstmAddrRowStatusVC));
        ((MOMutableColumn)snmpTlstmAddrEntryColumns[3]).addMOValueValidationListener(new SnmpTlstmAddrRowStatusValidator());
        this.snmpTlstmAddrEntryModel = moFactory.createTableModel(oidSnmpTlstmAddrEntry, this.snmpTlstmAddrEntryIndex, snmpTlstmAddrEntryColumns);
        ((MOMutableTableModel)this.snmpTlstmAddrEntryModel).setRowFactory(new SnmpTlstmAddrEntryRowFactory());
        this.snmpTlstmAddrEntry = moFactory.createTable(oidSnmpTlstmAddrEntry, this.snmpTlstmAddrEntryIndex, snmpTlstmAddrEntryColumns, this.snmpTlstmAddrEntryModel);
    }

    @Override
    public void registerMOs(MOServer server, OctetString context) throws DuplicateRegistrationException {
        server.register(this.snmpTlstmSessionOpens, context);
        server.register(this.snmpTlstmSessionClientCloses, context);
        server.register(this.snmpTlstmSessionOpenErrors, context);
        server.register(this.snmpTlstmSessionAccepts, context);
        server.register(this.snmpTlstmSessionServerCloses, context);
        server.register(this.snmpTlstmSessionNoSessions, context);
        server.register(this.snmpTlstmSessionInvalidClientCertificates, context);
        server.register(this.snmpTlstmSessionUnknownServerCertificate, context);
        server.register(this.snmpTlstmSessionInvalidServerCertificates, context);
        server.register(this.snmpTlstmSessionInvalidCaches, context);
        server.register(this.snmpTlstmCertToTSNCount, context);
        server.register(this.snmpTlstmCertToTSNTableLastChanged, context);
        server.register(this.snmpTlstmParamsCount, context);
        server.register(this.snmpTlstmParamsTableLastChanged, context);
        server.register(this.snmpTlstmAddrCount, context);
        server.register(this.snmpTlstmAddrTableLastChanged, context);
        server.register(this.snmpTlstmCertToTSNEntry, context);
        server.register(this.snmpTlstmParamsEntry, context);
        server.register(this.snmpTlstmAddrEntry, context);
    }

    @Override
    public void unregisterMOs(MOServer server, OctetString context) {
        server.unregister(this.snmpTlstmSessionOpens, context);
        server.unregister(this.snmpTlstmSessionClientCloses, context);
        server.unregister(this.snmpTlstmSessionOpenErrors, context);
        server.unregister(this.snmpTlstmSessionAccepts, context);
        server.unregister(this.snmpTlstmSessionServerCloses, context);
        server.unregister(this.snmpTlstmSessionNoSessions, context);
        server.unregister(this.snmpTlstmSessionInvalidClientCertificates, context);
        server.unregister(this.snmpTlstmSessionUnknownServerCertificate, context);
        server.unregister(this.snmpTlstmSessionInvalidServerCertificates, context);
        server.unregister(this.snmpTlstmSessionInvalidCaches, context);
        server.unregister(this.snmpTlstmCertToTSNCount, context);
        server.unregister(this.snmpTlstmCertToTSNTableLastChanged, context);
        server.unregister(this.snmpTlstmParamsCount, context);
        server.unregister(this.snmpTlstmParamsTableLastChanged, context);
        server.unregister(this.snmpTlstmAddrCount, context);
        server.unregister(this.snmpTlstmAddrTableLastChanged, context);
        server.unregister(this.snmpTlstmCertToTSNEntry, context);
        server.unregister(this.snmpTlstmParamsEntry, context);
        server.unregister(this.snmpTlstmAddrEntry, context);
    }

    public void snmpTlstmServerCertificateUnknown(NotificationOriginator notificationOriginator, OctetString context, VariableBinding[] vbs) {
        if (vbs.length < 1) {
            throw new IllegalArgumentException("Too few notification objects: " + vbs.length + "<1");
        }
        if (!vbs[0].getOid().startsWith(oidTrapVarSnmpTlstmSessionUnknownServerCertificate)) {
            throw new IllegalArgumentException("Variable 0 has wrong OID: " + vbs[0].getOid() + " does not start with " + oidTrapVarSnmpTlstmSessionUnknownServerCertificate);
        }
        notificationOriginator.notify(context, oidSnmpTlstmServerCertificateUnknown, vbs);
    }

    public void snmpTlstmServerInvalidCertificate(NotificationOriginator notificationOriginator, OctetString context, VariableBinding[] vbs) {
        if (vbs.length < 2) {
            throw new IllegalArgumentException("Too few notification objects: " + vbs.length + "<2");
        }
        if (!vbs[0].getOid().startsWith(oidTrapVarSnmpTlstmAddrServerFingerprint)) {
            throw new IllegalArgumentException("Variable 0 has wrong OID: " + vbs[0].getOid() + " does not start with " + oidTrapVarSnmpTlstmAddrServerFingerprint);
        }
        if (!this.snmpTlstmAddrEntryIndex.isValidIndex(this.snmpTlstmAddrEntry.getIndexPart(vbs[0].getOid()))) {
            throw new IllegalArgumentException("Illegal index for variable 0 specified: " + this.snmpTlstmAddrEntry.getIndexPart(vbs[0].getOid()));
        }
        if (!vbs[1].getOid().startsWith(oidTrapVarSnmpTlstmSessionInvalidServerCertificates)) {
            throw new IllegalArgumentException("Variable 1 has wrong OID: " + vbs[1].getOid() + " does not start with " + oidTrapVarSnmpTlstmSessionInvalidServerCertificates);
        }
        notificationOriginator.notify(context, oidSnmpTlstmServerInvalidCertificate, vbs);
    }

    public CounterListener getCounterListener() {
        return this.counterListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClientCertificateAccepted(X509Certificate peerEndCertificate) {
        X509Certificate x509Certificate = peerEndCertificate;
        OctetString peerFingerprint = new OctetString(x509Certificate.getSignature());
        DefaultMOMutableTableModel<SnmpTlstmCertToTSNEntryRow> defaultMOMutableTableModel = this.snmpTlstmCertToTSNEntryModel;
        synchronized (defaultMOMutableTableModel) {
            RowStatus.ActiveRowsFilter activeRowsFilter = new RowStatus.ActiveRowsFilter(4);
            Iterator<SnmpTlstmCertToTSNEntryRow> rows = this.snmpTlstmCertToTSNEntryModel.iterator(activeRowsFilter);
            while (rows.hasNext()) {
                SnmpTlstmCertToTSNEntryRow row = rows.next();
                if (!peerFingerprint.equals(row.getSnmpTlstmCertToTSNFingerprint())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OctetString getSecurityName(X509Certificate[] peerCertificateChain) {
        if (peerCertificateChain != null) {
            DefaultMOMutableTableModel<SnmpTlstmCertToTSNEntryRow> defaultMOMutableTableModel = this.snmpTlstmCertToTSNEntryModel;
            synchronized (defaultMOMutableTableModel) {
                RowStatus.ActiveRowsFilter activeRowsFilter = new RowStatus.ActiveRowsFilter(4);
                Iterator<SnmpTlstmCertToTSNEntryRow> rows = this.snmpTlstmCertToTSNEntryModel.iterator(activeRowsFilter);
                while (rows.hasNext()) {
                    SnmpTlstmCertToTSNEntryRow row = rows.next();
                    OctetString fingerprint = row.getSnmpTlstmCertToTSNFingerprint();
                    for (X509Certificate cert : peerCertificateChain) {
                        OctetString certFingerprint = null;
                        certFingerprint = TLSTM.getFingerprint(cert);
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Serializable)((Object)("Comparing certificate fingerprint " + certFingerprint + " with " + fingerprint)));
                        }
                        if (certFingerprint == null) {
                            LOGGER.error((Serializable)((Object)("Failed to determine fingerprint for certificate " + cert + " and algorithm " + cert.getSigAlgName())));
                            continue;
                        }
                        if (!certFingerprint.equals(fingerprint)) continue;
                        OID mappingType = row.getSnmpTlstmCertToTSNMapType();
                        OctetString data = row.getSnmpTlstmCertToTSNData();
                        OctetString tmSecurityName = null;
                        try {
                            tmSecurityName = this.mapCertToTSN(cert, mappingType, data);
                        }
                        catch (CertificateParsingException e2) {
                            LOGGER.warn((Serializable)((Object)("Failed to parse client certificate: " + e2.getMessage())));
                        }
                        if (tmSecurityName == null || tmSecurityName.length() > 32) continue;
                        return tmSecurityName;
                    }
                }
            }
        }
        return null;
    }

    public boolean isServerCertificateAccepted(X509Certificate[] peerCertificateChain) {
        return true;
    }

    @Override
    public boolean isAcceptedIssuer(X509Certificate issuerCertificate) {
        return true;
    }

    @Override
    public String getLocalCertificateAlias(Address targetAddress) {
        return null;
    }

    private OctetString mapCertToTSN(X509Certificate cert, OID mappingType, OctetString data) throws CertificateParsingException {
        Object entry;
        if (oidSnmpTlstmCertSpecified.equals(mappingType)) {
            return data;
        }
        if ((oidSnmpTlstmCertSANRFC822Name.equals(mappingType) || oidSnmpTlstmCertSANAny.equals(mappingType)) && (entry = TLSTM.getSubjAltName(cert.getSubjectAlternativeNames(), 1)) != null) {
            String[] rfc822Name = ((String)entry).split("@");
            return new OctetString(rfc822Name[0] + "@" + rfc822Name[1].toLowerCase());
        }
        if ((oidSnmpTlstmCertSANDNSName.equals(mappingType) || oidSnmpTlstmCertSANAny.equals(mappingType)) && (entry = TLSTM.getSubjAltName(cert.getSubjectAlternativeNames(), 2)) != null) {
            String dNSName = ((String)entry).toLowerCase();
            return new OctetString(dNSName);
        }
        if ((oidSnmpTlstmCertSANIpAddress.equals(mappingType) || oidSnmpTlstmCertSANAny.equals(mappingType)) && (entry = TLSTM.getSubjAltName(cert.getSubjectAlternativeNames(), 7)) != null) {
            String ipAddress = ((String)entry).toLowerCase();
            if (ipAddress.indexOf(58) >= 0) {
                String[] bytes;
                StringBuffer buf = new StringBuffer(16);
                for (String b2 : bytes = ipAddress.split(":")) {
                    for (int diff = 2 - b2.length(); diff > 0; --diff) {
                        buf.append('0');
                    }
                    buf.append(b2);
                }
                return new OctetString(buf.toString());
            }
            return new OctetString(ipAddress);
        }
        if (oidSnmpTlstmCertCommonName.equals(mappingType)) {
            X500Principal x500Principal = cert.getSubjectX500Principal();
            return new OctetString(x500Principal.getName());
        }
        return null;
    }

    protected void addTCsToFactory(MOFactory moFactory) {
        moFactory.addTextualConvention(new SnmpTLSFingerprint());
    }

    public void addImportedTCsToFactory(MOFactory moFactory) {
        moFactory.addTextualConvention(new SnmpAdminString());
    }

    public class SnmpAdminString
    implements TextualConvention {
        @Override
        public String getModuleName() {
            return "SNMP-FRAMEWORK-MIB";
        }

        @Override
        public String getName() {
            return "SnmpAdminString";
        }

        public Variable createInitialValue() {
            OctetString v = new OctetString();
            if (v instanceof AssignableFromLong) {
                ((AssignableFromLong)((Object)v)).setValue(0L);
            }
            return v;
        }

        public MOScalar createScalar(OID oid, MOAccess access, Variable value) {
            MOScalar<Variable> scalar = moFactory.createScalar(oid, access, value);
            ConstraintsImpl vc = new ConstraintsImpl();
            vc.add(new Constraint(0L, 255L));
            scalar.addMOValueValidationListener(new ValueConstraintValidator(vc));
            return scalar;
        }

        public MOColumn createColumn(int columnID, int syntax, MOAccess access, Variable defaultValue, boolean mutableInService) {
            MOColumn<Variable> col = moFactory.createColumn(columnID, syntax, access, defaultValue, mutableInService);
            if (col instanceof MOMutableColumn) {
                MOMutableColumn mcol = (MOMutableColumn)col;
                ConstraintsImpl vc = new ConstraintsImpl();
                vc.add(new Constraint(0L, 255L));
                mcol.addMOValueValidationListener(new ValueConstraintValidator(vc));
            }
            return col;
        }
    }

    public class SnmpTLSFingerprint
    implements TextualConvention {
        @Override
        public String getModuleName() {
            return "SNMP-TLS-TM-MIB";
        }

        @Override
        public String getName() {
            return "SnmpTLSFingerprint";
        }

        public Variable createInitialValue() {
            OctetString v = new OctetString();
            if (v instanceof AssignableFromLong) {
                ((AssignableFromLong)((Object)v)).setValue(0L);
            }
            return v;
        }

        public MOScalar createScalar(OID oid, MOAccess access, Variable value) {
            MOScalar<Variable> scalar = moFactory.createScalar(oid, access, value);
            ConstraintsImpl vc = new ConstraintsImpl();
            vc.add(new Constraint(0L, 255L));
            scalar.addMOValueValidationListener(new ValueConstraintValidator(vc));
            return scalar;
        }

        public MOColumn createColumn(int columnID, int syntax, MOAccess access, Variable defaultValue, boolean mutableInService) {
            MOColumn<Variable> col = moFactory.createColumn(columnID, syntax, access, defaultValue, mutableInService);
            if (col instanceof MOMutableColumn) {
                MOMutableColumn mcol = (MOMutableColumn)col;
                ConstraintsImpl vc = new ConstraintsImpl();
                vc.add(new Constraint(0L, 255L));
                mcol.addMOValueValidationListener(new ValueConstraintValidator(vc));
            }
            return col;
        }
    }

    class SnmpTlstmAddrEntryRowFactory
    implements MOTableRowFactory<SnmpTlstmAddrEntryRow> {
        SnmpTlstmAddrEntryRowFactory() {
        }

        @Override
        public synchronized SnmpTlstmAddrEntryRow createRow(OID index, Variable[] values) throws UnsupportedOperationException {
            SnmpTlstmAddrEntryRow row = new SnmpTlstmAddrEntryRow(index, values);
            return row;
        }

        @Override
        public synchronized void freeRow(SnmpTlstmAddrEntryRow row) {
        }
    }

    public class SnmpTlstmAddrEntryRow
    extends DefaultMOMutableRow2PC {
        public SnmpTlstmAddrEntryRow(OID index, Variable[] values) {
            super(index, values);
        }

        public OctetString getSnmpTlstmAddrServerFingerprint() {
            return (OctetString)super.getValue(0);
        }

        public void setSnmpTlstmAddrServerFingerprint(OctetString newValue) {
            super.setValue(0, newValue);
        }

        public OctetString getSnmpTlstmAddrServerIdentity() {
            return (OctetString)super.getValue(1);
        }

        public void setSnmpTlstmAddrServerIdentity(OctetString newValue) {
            super.setValue(1, newValue);
        }

        public Integer32 getSnmpTlstmAddrStorageType() {
            return (Integer32)super.getValue(2);
        }

        public void setSnmpTlstmAddrStorageType(Integer32 newValue) {
            super.setValue(2, newValue);
        }

        public Integer32 getSnmpTlstmAddrRowStatus() {
            return (Integer32)super.getValue(3);
        }

        public void setSnmpTlstmAddrRowStatus(Integer32 newValue) {
            super.setValue(3, newValue);
        }

        @Override
        public Variable getValue(int column) {
            switch (column) {
                case 0: {
                    return this.getSnmpTlstmAddrServerFingerprint();
                }
                case 1: {
                    return this.getSnmpTlstmAddrServerIdentity();
                }
                case 2: {
                    return this.getSnmpTlstmAddrStorageType();
                }
                case 3: {
                    return this.getSnmpTlstmAddrRowStatus();
                }
            }
            return super.getValue(column);
        }

        @Override
        public void setValue(int column, Variable value) {
            switch (column) {
                case 0: {
                    this.setSnmpTlstmAddrServerFingerprint((OctetString)value);
                    break;
                }
                case 1: {
                    this.setSnmpTlstmAddrServerIdentity((OctetString)value);
                    break;
                }
                case 2: {
                    this.setSnmpTlstmAddrStorageType((Integer32)value);
                    break;
                }
                case 3: {
                    this.setSnmpTlstmAddrRowStatus((Integer32)value);
                    break;
                }
                default: {
                    super.setValue(column, value);
                }
            }
        }
    }

    class SnmpTlstmParamsEntryRowFactory
    implements MOTableRowFactory<SnmpTlstmParamsEntryRow> {
        SnmpTlstmParamsEntryRowFactory() {
        }

        @Override
        public synchronized SnmpTlstmParamsEntryRow createRow(OID index, Variable[] values) throws UnsupportedOperationException {
            SnmpTlstmParamsEntryRow row = new SnmpTlstmParamsEntryRow(index, values);
            return row;
        }

        @Override
        public synchronized void freeRow(SnmpTlstmParamsEntryRow row) {
        }
    }

    public class SnmpTlstmParamsEntryRow
    extends DefaultMOMutableRow2PC {
        public SnmpTlstmParamsEntryRow(OID index, Variable[] values) {
            super(index, values);
        }

        public OctetString getSnmpTlstmParamsClientFingerprint() {
            return (OctetString)super.getValue(0);
        }

        public void setSnmpTlstmParamsClientFingerprint(OctetString newValue) {
            super.setValue(0, newValue);
        }

        public Integer32 getSnmpTlstmParamsStorageType() {
            return (Integer32)super.getValue(1);
        }

        public void setSnmpTlstmParamsStorageType(Integer32 newValue) {
            super.setValue(1, newValue);
        }

        public Integer32 getSnmpTlstmParamsRowStatus() {
            return (Integer32)super.getValue(2);
        }

        public void setSnmpTlstmParamsRowStatus(Integer32 newValue) {
            super.setValue(2, newValue);
        }

        @Override
        public Variable getValue(int column) {
            switch (column) {
                case 0: {
                    return this.getSnmpTlstmParamsClientFingerprint();
                }
                case 1: {
                    return this.getSnmpTlstmParamsStorageType();
                }
                case 2: {
                    return this.getSnmpTlstmParamsRowStatus();
                }
            }
            return super.getValue(column);
        }

        @Override
        public void setValue(int column, Variable value) {
            switch (column) {
                case 0: {
                    this.setSnmpTlstmParamsClientFingerprint((OctetString)value);
                    break;
                }
                case 1: {
                    this.setSnmpTlstmParamsStorageType((Integer32)value);
                    break;
                }
                case 2: {
                    this.setSnmpTlstmParamsRowStatus((Integer32)value);
                    break;
                }
                default: {
                    super.setValue(column, value);
                }
            }
        }
    }

    class SnmpTlstmCertToTSNEntryRowFactory
    implements MOTableRowFactory<SnmpTlstmCertToTSNEntryRow> {
        SnmpTlstmCertToTSNEntryRowFactory() {
        }

        @Override
        public synchronized SnmpTlstmCertToTSNEntryRow createRow(OID index, Variable[] values) throws UnsupportedOperationException {
            SnmpTlstmCertToTSNEntryRow row = new SnmpTlstmCertToTSNEntryRow(index, values);
            return row;
        }

        @Override
        public synchronized void freeRow(SnmpTlstmCertToTSNEntryRow row) {
        }
    }

    public class SnmpTlstmCertToTSNEntryRow
    extends DefaultMOMutableRow2PC {
        public SnmpTlstmCertToTSNEntryRow(OID index, Variable[] values) {
            super(index, values);
        }

        public OctetString getSnmpTlstmCertToTSNFingerprint() {
            return (OctetString)super.getValue(0);
        }

        public void setSnmpTlstmCertToTSNFingerprint(OctetString newValue) {
            super.setValue(0, newValue);
        }

        public OID getSnmpTlstmCertToTSNMapType() {
            return (OID)super.getValue(1);
        }

        public void setSnmpTlstmCertToTSNMapType(OID newValue) {
            super.setValue(1, newValue);
        }

        public OctetString getSnmpTlstmCertToTSNData() {
            return (OctetString)super.getValue(2);
        }

        public void setSnmpTlstmCertToTSNData(OctetString newValue) {
            super.setValue(2, newValue);
        }

        public Integer32 getSnmpTlstmCertToTSNStorageType() {
            return (Integer32)super.getValue(3);
        }

        public void setSnmpTlstmCertToTSNStorageType(Integer32 newValue) {
            super.setValue(3, newValue);
        }

        public Integer32 getSnmpTlstmCertToTSNRowStatus() {
            return (Integer32)super.getValue(4);
        }

        public void setSnmpTlstmCertToTSNRowStatus(Integer32 newValue) {
            super.setValue(4, newValue);
        }

        @Override
        public Variable getValue(int column) {
            switch (column) {
                case 0: {
                    return this.getSnmpTlstmCertToTSNFingerprint();
                }
                case 1: {
                    return this.getSnmpTlstmCertToTSNMapType();
                }
                case 2: {
                    return this.getSnmpTlstmCertToTSNData();
                }
                case 3: {
                    return this.getSnmpTlstmCertToTSNStorageType();
                }
                case 4: {
                    return this.getSnmpTlstmCertToTSNRowStatus();
                }
            }
            return super.getValue(column);
        }

        @Override
        public void setValue(int column, Variable value) {
            switch (column) {
                case 0: {
                    this.setSnmpTlstmCertToTSNFingerprint((OctetString)value);
                    break;
                }
                case 1: {
                    this.setSnmpTlstmCertToTSNMapType((OID)value);
                    break;
                }
                case 2: {
                    this.setSnmpTlstmCertToTSNData((OctetString)value);
                    break;
                }
                case 3: {
                    this.setSnmpTlstmCertToTSNStorageType((Integer32)value);
                    break;
                }
                case 4: {
                    this.setSnmpTlstmCertToTSNRowStatus((Integer32)value);
                    break;
                }
                default: {
                    super.setValue(column, value);
                }
            }
        }
    }

    static class SnmpTlstmAddrRowStatusValidator
    implements MOValueValidationListener {
        SnmpTlstmAddrRowStatusValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
        }
    }

    static class SnmpTlstmAddrStorageTypeValidator
    implements MOValueValidationListener {
        SnmpTlstmAddrStorageTypeValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
        }
    }

    static class SnmpTlstmAddrServerIdentityValidator
    implements MOValueValidationListener {
        SnmpTlstmAddrServerIdentityValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
            OctetString os = (OctetString)newValue;
            if (os.length() < 0 || os.length() > 255) {
                validationEvent.setValidationStatus(8);
                return;
            }
        }
    }

    static class SnmpTlstmAddrServerFingerprintValidator
    implements MOValueValidationListener {
        SnmpTlstmAddrServerFingerprintValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
            OctetString os = (OctetString)newValue;
            if (os.length() < 0 || os.length() > 255) {
                validationEvent.setValidationStatus(8);
                return;
            }
        }
    }

    static class SnmpTlstmParamsRowStatusValidator
    implements MOValueValidationListener {
        SnmpTlstmParamsRowStatusValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
        }
    }

    static class SnmpTlstmParamsStorageTypeValidator
    implements MOValueValidationListener {
        SnmpTlstmParamsStorageTypeValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
        }
    }

    static class SnmpTlstmParamsClientFingerprintValidator
    implements MOValueValidationListener {
        SnmpTlstmParamsClientFingerprintValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
            OctetString os = (OctetString)newValue;
            if (os.length() < 0 || os.length() > 255) {
                validationEvent.setValidationStatus(8);
                return;
            }
        }
    }

    static class SnmpTlstmCertToTSNRowStatusValidator
    implements MOValueValidationListener {
        SnmpTlstmCertToTSNRowStatusValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
        }
    }

    static class SnmpTlstmCertToTSNStorageTypeValidator
    implements MOValueValidationListener {
        SnmpTlstmCertToTSNStorageTypeValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
        }
    }

    static class SnmpTlstmCertToTSNDataValidator
    implements MOValueValidationListener {
        SnmpTlstmCertToTSNDataValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
            OctetString os = (OctetString)newValue;
            if (os.length() < 0 || os.length() > 1024) {
                validationEvent.setValidationStatus(8);
                return;
            }
        }
    }

    static class SnmpTlstmCertToTSNMapTypeValidator
    implements MOValueValidationListener {
        SnmpTlstmCertToTSNMapTypeValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
        }
    }

    static class SnmpTlstmCertToTSNFingerprintValidator
    implements MOValueValidationListener {
        SnmpTlstmCertToTSNFingerprintValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
            OctetString os = (OctetString)newValue;
            if (os.length() < 1 || os.length() > 255) {
                validationEvent.setValidationStatus(8);
                return;
            }
        }
    }
}

