/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo;

import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import org.snmp4j.agent.mo.DefaultMOTable;
import org.snmp4j.agent.mo.MOMutableRow2PC;
import org.snmp4j.agent.mo.MOMutableTableModel;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableRowFactory;
import org.snmp4j.agent.mo.MOTableRowFilter;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.agent.util.SimpleValueConverter;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;

public class SimpleMOTableModel<V>
implements MOMutableTableModel<SimpleMOTableRow> {
    private SortedMap<OID, List<V>> data;
    private SimpleValueConverter<V> converter;
    private List<Integer> columnSmiSyntaxes;
    private SimpleRowListFactory<V> rowListFactory;

    public SimpleMOTableModel(List<Integer> columnSmiSyntaxes, SimpleValueConverter<V> converter, SortedMap<OID, List<V>> data, SimpleRowListFactory<V> rowListFactory) {
        this.columnSmiSyntaxes = columnSmiSyntaxes;
        this.converter = converter;
        this.data = data;
        this.rowListFactory = rowListFactory;
    }

    @Override
    public SimpleMOTableRow addRow(SimpleMOTableRow row) {
        return null;
    }

    @Override
    public SimpleMOTableRow removeRow(OID index) {
        this.data.remove(index);
        return null;
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public <F extends MOTableRowFactory<SimpleMOTableRow>> F getRowFactory() {
        return null;
    }

    @Override
    public <F extends MOTableRowFactory<SimpleMOTableRow>> void setRowFactory(F rowFactory) {
    }

    @Override
    public void clear(MOTableRowFilter<SimpleMOTableRow> filter) {
    }

    @Override
    public int getColumnCount() {
        return this.columnSmiSyntaxes.size();
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public boolean containsRow(OID index) {
        return this.data.containsKey(index);
    }

    @Override
    public SimpleMOTableRow getRow(OID index) {
        if (this.data.containsKey(index)) {
            return new SimpleMOTableRow(index);
        }
        return null;
    }

    @Override
    public Iterator<SimpleMOTableRow> iterator() {
        Iterator<SimpleMOTableRow> it = new Iterator<SimpleMOTableRow>(){
            Iterator<OID> rowIterator;
            {
                this.rowIterator = SimpleMOTableModel.this.data.keySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.rowIterator.hasNext();
            }

            @Override
            public SimpleMOTableRow next() {
                OID next = this.rowIterator.next();
                return new SimpleMOTableRow(next);
            }

            @Override
            public void remove() {
                this.rowIterator.remove();
            }
        };
        return it;
    }

    @Override
    public Iterator<SimpleMOTableRow> tailIterator(final OID lowerBound) {
        Iterator<SimpleMOTableRow> it = new Iterator<SimpleMOTableRow>(){
            Iterator<OID> rowIterator;
            {
                this.rowIterator = SimpleMOTableModel.this.data.tailMap(lowerBound).keySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.rowIterator.hasNext();
            }

            @Override
            public SimpleMOTableRow next() {
                OID next = this.rowIterator.next();
                return new SimpleMOTableRow(next);
            }

            @Override
            public void remove() {
                this.rowIterator.remove();
            }
        };
        return it;
    }

    @Override
    public OID lastIndex() {
        return this.data.lastKey();
    }

    @Override
    public OID firstIndex() {
        return this.data.firstKey();
    }

    @Override
    public SimpleMOTableRow firstRow() {
        if (this.isEmpty()) {
            return null;
        }
        return new SimpleMOTableRow(this.firstIndex());
    }

    @Override
    public SimpleMOTableRow lastRow() {
        if (this.isEmpty()) {
            return null;
        }
        return new SimpleMOTableRow(this.lastIndex());
    }

    @Override
    public SimpleMOTableRow createRow(OID index, Variable[] values) throws UnsupportedOperationException {
        List<V> newRowList = this.rowListFactory.createRow(values);
        List<V> oldRow = this.data.put(index, newRowList);
        return new SimpleMOTableRowCopy(index, oldRow);
    }

    @Override
    public void freeRow(SimpleMOTableRow row) {
        this.data.remove(row.getIndex());
    }

    public class SimpleMOTableRowCopy
    extends SimpleMOTableRow {
        private List<V> rowList;

        public SimpleMOTableRowCopy(OID index, List<V> rowList) {
            super(index);
            this.rowList = rowList;
        }

        @Override
        protected List<V> getRow(OID index) {
            return this.rowList;
        }
    }

    public class SimpleMOTableRow
    implements MOMutableRow2PC {
        private OID index;

        public SimpleMOTableRow(OID index) {
            this.index = index;
        }

        @Override
        public void prepareRow(SubRequest subRequest, MOTableRow changeSet) {
        }

        @Override
        public void prepare(SubRequest subRequest, MOTableRow changeSet, int column) {
        }

        @Override
        public void commit(SubRequest subRequest, MOTableRow changeSet, int column) {
            subRequest.setUndoValue(((List)SimpleMOTableModel.this.data.get(this.index)).get(column));
            this.setValue(column, (Variable)subRequest.getVariableBinding().getVariable().clone());
            subRequest.completed();
        }

        @Override
        public void commitRow(SubRequest subRequest, MOTableRow changeSet) {
        }

        @Override
        public void cleanup(SubRequest subRequest, int column) {
        }

        @Override
        public void cleanupRow(SubRequest request, DefaultMOTable.ChangeSet changeSet) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void undo(SubRequest subRequest, int column) {
            List row;
            List list = row = this.getRow(this.index);
            synchronized (list) {
                row.set(column, subRequest.getUndoValue());
            }
            subRequest.completed();
        }

        @Override
        public void undoRow(SubRequest request, DefaultMOTable.ChangeSet changeSet) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setValue(int column, Variable value) {
            List row;
            List list = row = this.getRow(this.index);
            synchronized (list) {
                row.set(column, SimpleMOTableModel.this.converter.convertToValue(value, row.get(column)));
            }
        }

        @Override
        public OID getIndex() {
            return this.index;
        }

        public Variable getValue(int column) {
            List row = this.getRow(this.index);
            return SimpleMOTableModel.this.converter.convertFromValue(row.get(column), (Integer)SimpleMOTableModel.this.columnSmiSyntaxes.get(column));
        }

        @Override
        public MOTableRow getBaseRow() {
            return null;
        }

        @Override
        public void setBaseRow(MOTableRow baseRow) {
        }

        @Override
        public int size() {
            List row = (List)SimpleMOTableModel.this.data.get(this.index);
            return row.size();
        }

        protected List<V> getRow(OID index) {
            return (List)SimpleMOTableModel.this.data.get(index);
        }
    }

    public static interface SimpleRowListFactory<V> {
        public List<V> createRow(Variable[] var1);
    }
}

