/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.io.DefaultMOInput;
import org.snmp4j.agent.io.DefaultMOOutput;
import org.snmp4j.agent.io.MOPersistenceProvider;
import org.snmp4j.agent.io.MOServerPersistence;

public class DefaultMOPersistenceProvider
implements MOPersistenceProvider {
    private MOServer[] server;
    private String defaultURI;

    public DefaultMOPersistenceProvider(MOServer[] server, String defaultURI) {
        this.server = server;
        this.defaultURI = defaultURI;
    }

    @Override
    public String getPersistenceProviderID() {
        return "default";
    }

    @Override
    public boolean isValidPersistenceURI(String uri) {
        try {
            File f2 = this.getFile(uri);
            return f2.isFile() && (f2.canRead() || f2.canWrite()) || !f2.exists();
        }
        catch (Exception ex) {
            return false;
        }
    }

    private File getFile(String uri) {
        File f2;
        if (uri.toUpperCase().startsWith("FILE:")) {
            URI u = URI.create(uri);
            f2 = new File(u);
        } else {
            f2 = new File(uri);
        }
        return f2;
    }

    @Override
    public void restore(String uri, int importMode) throws IOException {
        if (uri == null) {
            uri = this.getDefaultURI();
        }
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(this.getFile(uri)));
            DefaultMOInput is = new DefaultMOInput(ois);
            is.setOverwriteMode(importMode);
            MOServerPersistence p2 = new MOServerPersistence(this.server);
            p2.loadData(is);
            ois.close();
        }
        catch (IOException iox) {
            throw iox;
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException iox) {}
            }
        }
    }

    @Override
    public void store(String uri) throws IOException {
        if (uri == null) {
            uri = this.getDefaultURI();
        }
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new FileOutputStream(this.getFile(uri)));
            DefaultMOOutput os = new DefaultMOOutput(oos);
            MOServerPersistence p2 = new MOServerPersistence(this.server);
            p2.saveData(os);
            oos.flush();
            oos.close();
        }
        catch (IOException iox) {
            throw iox;
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iox) {}
            }
        }
    }

    @Override
    public String getDefaultURI() {
        return this.defaultURI;
    }
}

