/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j;

import java.io.IOException;
import java.io.OutputStream;
import org.snmp4j.PDU;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.smi.AbstractVariable;
import org.snmp4j.smi.OctetString;

public class ScopedPDU
extends PDU {
    private static final long serialVersionUID = 4343157159110407279L;
    private OctetString contextEngineID = new OctetString();
    private OctetString contextName = new OctetString();

    public ScopedPDU() {
    }

    public ScopedPDU(ScopedPDU other) {
        super(other);
        this.contextEngineID = (OctetString)other.contextEngineID.clone();
        this.contextName = (OctetString)other.contextName.clone();
    }

    public void setContextEngineID(OctetString contextEngineID) {
        if (contextEngineID == null) {
            throw new NullPointerException("Context engine ID must not be null");
        }
        this.contextEngineID = contextEngineID;
    }

    public OctetString getContextEngineID() {
        return this.contextEngineID;
    }

    public void setContextName(OctetString contextName) {
        if (contextName == null) {
            throw new NullPointerException("Context name must not be null");
        }
        this.contextName = contextName;
    }

    public OctetString getContextName() {
        return this.contextName;
    }

    @Override
    public int getBERLength() {
        int length = this.getBERPayloadLength();
        length += 1 + BER.getBERLengthOfLength(length);
        return length;
    }

    @Override
    public int getBERPayloadLength() {
        int length = super.getBERLength();
        int cid = this.contextEngineID == null ? 0 : this.contextEngineID.length();
        int cn = this.contextName == null ? 0 : this.contextName.length();
        return length += BER.getBERLengthOfLength(cid) + 1 + cid + BER.getBERLengthOfLength(cn) + 1 + cn;
    }

    @Override
    public void encodeBER(OutputStream outputStream) throws IOException {
        BER.encodeHeader(outputStream, 48, this.getBERPayloadLength());
        this.contextEngineID.encodeBER(outputStream);
        this.contextName.encodeBER(outputStream);
        super.encodeBER(outputStream);
    }

    @Override
    public Object clone() {
        return new ScopedPDU(this);
    }

    @Override
    public void decodeBER(BERInputStream inputStream) throws IOException {
        BER.MutableByte mutableByte = new BER.MutableByte();
        int length = BER.decodeHeader(inputStream, mutableByte);
        long startPos = inputStream.getPosition();
        this.contextEngineID.decodeBER(inputStream);
        this.contextName.decodeBER(inputStream);
        super.decodeBER(inputStream);
        if (BER.isCheckSequenceLength()) {
            BER.checkSequenceLength(length, (int)(inputStream.getPosition() - startPos), this);
        }
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(ScopedPDU.getTypeString(this.type));
        buf.append("[{contextEngineID=" + this.contextEngineID + ", contextName=" + this.contextName + "}, requestID=");
        buf.append(this.requestID);
        buf.append(", errorStatus=");
        buf.append(this.errorStatus);
        buf.append(", errorIndex=");
        buf.append(this.errorIndex);
        buf.append(", VBS[");
        for (int i2 = 0; i2 < this.variableBindings.size(); ++i2) {
            buf.append(this.variableBindings.get(i2));
            if (i2 + 1 >= this.variableBindings.size()) continue;
            buf.append("; ");
        }
        buf.append("]]");
        return buf.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ScopedPDU) {
            ScopedPDU o2 = (ScopedPDU)obj;
            return super.equals(obj) && AbstractVariable.equal(this.contextEngineID, o2.contextEngineID) && AbstractVariable.equal(this.contextName, o2.contextName);
        }
        return super.equals(obj);
    }
}

