/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import java.lang.reflect.Method;
import org.apache.velocity.runtime.RuntimeLogger;
import org.apache.velocity.runtime.log.Log;
import org.apache.velocity.runtime.log.RuntimeLoggerLog;
import org.apache.velocity.util.introspection.IntrospectorBase;
import org.apache.velocity.util.introspection.MethodMap;

public class Introspector
extends IntrospectorBase {
    public Introspector(Log log) {
        super(log);
    }

    public Introspector(RuntimeLogger logger) {
        this(new RuntimeLoggerLog(logger));
    }

    public Method getMethod(Class c2, String name, Object[] params) throws IllegalArgumentException {
        try {
            return super.getMethod(c2, name, params);
        }
        catch (MethodMap.AmbiguousException ae) {
            StringBuffer msg = new StringBuffer("Introspection Error : Ambiguous method invocation ").append(name).append("(");
            for (int i2 = 0; i2 < params.length; ++i2) {
                if (i2 > 0) {
                    msg.append(", ");
                }
                if (params[i2] == null) {
                    msg.append("null");
                    continue;
                }
                msg.append(params[i2].getClass().getName());
            }
            msg.append(") for class ").append(c2);
            this.log.debug(msg.toString());
            return null;
        }
    }
}

