/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.parser.node;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.log.Log;
import org.apache.velocity.runtime.parser.node.SetExecutor;
import org.apache.velocity.util.introspection.Introspector;

public class SetPropertyExecutor
extends SetExecutor {
    private final Introspector introspector;

    public SetPropertyExecutor(Log log, Introspector introspector, Class clazz, String property, Object arg) {
        this.log = log;
        this.introspector = introspector;
        if (StringUtils.isNotEmpty(property)) {
            this.discover(clazz, property, arg);
        }
    }

    protected Introspector getIntrospector() {
        return this.introspector;
    }

    protected void discover(Class clazz, String property, Object arg) {
        Object[] params = new Object[]{arg};
        try {
            StrBuilder sb = new StrBuilder("set");
            sb.append(property);
            this.setMethod(this.introspector.getMethod(clazz, sb.toString(), params));
            if (!this.isAlive()) {
                char c2 = sb.charAt(3);
                if (Character.isLowerCase(c2)) {
                    sb.setCharAt(3, Character.toUpperCase(c2));
                } else {
                    sb.setCharAt(3, Character.toLowerCase(c2));
                }
                this.setMethod(this.introspector.getMethod(clazz, sb.toString(), params));
            }
        }
        catch (RuntimeException e2) {
            throw e2;
        }
        catch (Exception e3) {
            String msg = "Exception while looking for property setter for '" + property;
            this.log.error(msg, e3);
            throw new VelocityException(msg, e3);
        }
    }

    public Object execute(Object o2, Object value) throws IllegalAccessException, InvocationTargetException {
        Object[] params = new Object[]{value};
        return this.isAlive() ? this.getMethod().invoke(o2, params) : null;
    }
}

