/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.io;

import java.io.IOException;
import java.io.Writer;

public final class VelocityWriter
extends Writer {
    public static final int NO_BUFFER = 0;
    public static final int DEFAULT_BUFFER = -1;
    public static final int UNBOUNDED_BUFFER = -2;
    private int bufferSize;
    private boolean autoFlush;
    private Writer writer;
    private char[] cb;
    private int nextChar;
    private static int defaultCharBufferSize = 8192;

    public VelocityWriter(Writer writer) {
        this(writer, defaultCharBufferSize, true);
    }

    private VelocityWriter(int bufferSize, boolean autoFlush) {
        this.bufferSize = bufferSize;
        this.autoFlush = autoFlush;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public boolean isAutoFlush() {
        return this.autoFlush;
    }

    public VelocityWriter(Writer writer, int sz, boolean autoFlush) {
        this(sz, autoFlush);
        if (sz < 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.writer = writer;
        this.cb = sz == 0 ? null : new char[sz];
        this.nextChar = 0;
    }

    private final void flushBuffer() throws IOException {
        if (this.bufferSize == 0) {
            return;
        }
        if (this.nextChar == 0) {
            return;
        }
        this.writer.write(this.cb, 0, this.nextChar);
        this.nextChar = 0;
    }

    public final void clear() {
        this.nextChar = 0;
    }

    private final void bufferOverflow() throws IOException {
        throw new IOException("overflow");
    }

    public final void flush() throws IOException {
        this.flushBuffer();
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    public final void close() throws IOException {
        if (this.writer == null) {
            return;
        }
        this.flush();
    }

    public final int getRemaining() {
        return this.bufferSize - this.nextChar;
    }

    public final void write(int c2) throws IOException {
        if (this.bufferSize == 0) {
            this.writer.write(c2);
        } else {
            if (this.nextChar >= this.bufferSize) {
                if (this.autoFlush) {
                    this.flushBuffer();
                } else {
                    this.bufferOverflow();
                }
            }
            this.cb[this.nextChar++] = (char)c2;
        }
    }

    private final int min(int a2, int b2) {
        return a2 < b2 ? a2 : b2;
    }

    public final void write(char[] cbuf, int off, int len) throws IOException {
        if (this.bufferSize == 0) {
            this.writer.write(cbuf, off, len);
            return;
        }
        if (len == 0) {
            return;
        }
        if (len >= this.bufferSize) {
            if (this.autoFlush) {
                this.flushBuffer();
            } else {
                this.bufferOverflow();
            }
            this.writer.write(cbuf, off, len);
            return;
        }
        int b2 = off;
        int t = off + len;
        while (b2 < t) {
            int d2 = this.min(this.bufferSize - this.nextChar, t - b2);
            System.arraycopy(cbuf, b2, this.cb, this.nextChar, d2);
            b2 += d2;
            this.nextChar += d2;
            if (this.nextChar < this.bufferSize) continue;
            if (this.autoFlush) {
                this.flushBuffer();
                continue;
            }
            this.bufferOverflow();
        }
    }

    public final void write(char[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public final void write(String s, int off, int len) throws IOException {
        if (this.bufferSize == 0) {
            this.writer.write(s, off, len);
            return;
        }
        int b2 = off;
        int t = off + len;
        while (b2 < t) {
            int d2 = this.min(this.bufferSize - this.nextChar, t - b2);
            s.getChars(b2, b2 + d2, this.cb, this.nextChar);
            b2 += d2;
            this.nextChar += d2;
            if (this.nextChar < this.bufferSize) continue;
            if (this.autoFlush) {
                this.flushBuffer();
                continue;
            }
            this.bufferOverflow();
        }
    }

    public final void write(String s) throws IOException {
        if (s != null) {
            this.write(s, 0, s.length());
        }
    }

    public final void recycle(Writer writer) {
        this.writer = writer;
        this.clear();
    }
}

