/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.lifecycle.io.xpp3;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.maven.plugin.lifecycle.Execution;
import org.apache.maven.plugin.lifecycle.Lifecycle;
import org.apache.maven.plugin.lifecycle.LifecycleConfiguration;
import org.apache.maven.plugin.lifecycle.Phase;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class LifecycleMappingsXpp3Writer {
    private static final String NAMESPACE = null;

    public void write(Writer writer, LifecycleConfiguration lifecycleConfiguration) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "\n");
        serializer.setOutput(writer);
        serializer.startDocument(lifecycleConfiguration.getModelEncoding(), null);
        this.writeLifecycleConfiguration(lifecycleConfiguration, "lifecycles", serializer);
        serializer.endDocument();
    }

    public void write(OutputStream stream, LifecycleConfiguration lifecycleConfiguration) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "\n");
        serializer.setOutput(stream, lifecycleConfiguration.getModelEncoding());
        serializer.startDocument(lifecycleConfiguration.getModelEncoding(), null);
        this.writeLifecycleConfiguration(lifecycleConfiguration, "lifecycles", serializer);
        serializer.endDocument();
    }

    private void writeExecution(Execution execution, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (execution.getConfiguration() != null) {
            ((Xpp3Dom)execution.getConfiguration()).writeToSerializer(NAMESPACE, serializer);
        }
        if (execution.getGoals() != null && execution.getGoals().size() > 0) {
            serializer.startTag(NAMESPACE, "goals");
            for (String goal : execution.getGoals()) {
                serializer.startTag(NAMESPACE, "goal").text(goal).endTag(NAMESPACE, "goal");
            }
            serializer.endTag(NAMESPACE, "goals");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeLifecycle(Lifecycle lifecycle, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (lifecycle.getId() != null) {
            serializer.startTag(NAMESPACE, "id").text(lifecycle.getId()).endTag(NAMESPACE, "id");
        }
        if (lifecycle.getPhases() != null && lifecycle.getPhases().size() > 0) {
            serializer.startTag(NAMESPACE, "phases");
            for (Phase o2 : lifecycle.getPhases()) {
                this.writePhase(o2, "phase", serializer);
            }
            serializer.endTag(NAMESPACE, "phases");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeLifecycleConfiguration(LifecycleConfiguration lifecycleConfiguration, String tagName, XmlSerializer serializer) throws IOException {
        serializer.setPrefix("", "http://maven.apache.org/LIFECYCLE/1.0.0");
        serializer.setPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        serializer.startTag(NAMESPACE, tagName);
        serializer.attribute("", "xsi:schemaLocation", "http://maven.apache.org/LIFECYCLE/1.0.0 http://maven.apache.org/xsd/lifecycle-1.0.0.xsd");
        if (lifecycleConfiguration.getLifecycles() != null && lifecycleConfiguration.getLifecycles().size() > 0) {
            for (Lifecycle o2 : lifecycleConfiguration.getLifecycles()) {
                this.writeLifecycle(o2, "lifecycle", serializer);
            }
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writePhase(Phase phase, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (phase.getId() != null) {
            serializer.startTag(NAMESPACE, "id").text(phase.getId()).endTag(NAMESPACE, "id");
        }
        if (phase.getExecutions() != null && phase.getExecutions().size() > 0) {
            serializer.startTag(NAMESPACE, "executions");
            for (Execution o2 : phase.getExecutions()) {
                this.writeExecution(o2, "execution", serializer);
            }
            serializer.endTag(NAMESPACE, "executions");
        }
        if (phase.getConfiguration() != null) {
            ((Xpp3Dom)phase.getConfiguration()).writeToSerializer(NAMESPACE, serializer);
        }
        serializer.endTag(NAMESPACE, tagName);
    }
}

