/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputLocationTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Extension
implements Serializable,
Cloneable,
InputLocationTracker {
    private String groupId;
    private String artifactId;
    private String version;
    private Map<Object, InputLocation> locations;

    public Extension clone() {
        try {
            Extension copy = (Extension)super.clone();
            if (copy.locations != null) {
                copy.locations = new LinkedHashMap<Object, InputLocation>(copy.locations);
            }
            return copy;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    public String getVersion() {
        return this.version;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Override
    public void setLocation(Object key, InputLocation location) {
        if (location != null) {
            if (this.locations == null) {
                this.locations = new LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put(key, location);
        }
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof Extension)) {
            return false;
        }
        Extension e2 = (Extension)o2;
        if (!Extension.equal(e2.getArtifactId(), this.getArtifactId())) {
            return false;
        }
        if (!Extension.equal(e2.getGroupId(), this.getGroupId())) {
            return false;
        }
        return Extension.equal(e2.getVersion(), this.getVersion());
    }

    private static <T> boolean equal(T obj1, T obj2) {
        return obj1 != null ? obj1.equals(obj2) : obj2 == null;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.getArtifactId() != null ? this.getArtifactId().hashCode() : 0);
        result = 37 * result + (this.getGroupId() != null ? this.getGroupId().hashCode() : 0);
        result = 37 * result + (this.getVersion() != null ? this.getVersion().hashCode() : 0);
        return result;
    }
}

