/*
 * Decompiled with CFR 0.152.
 */
package javax.vecmath;

import java.io.Serializable;
import javax.vecmath.Tuple4f;
import javax.vecmath.VecMathUtil;

public abstract class Tuple4d
implements Serializable,
Cloneable {
    static final long serialVersionUID = -4748953690425311052L;
    public double x;
    public double y;
    public double z;
    public double w;

    public Tuple4d(double d2, double d3, double d4, double d5) {
        this.x = d2;
        this.y = d3;
        this.z = d4;
        this.w = d5;
    }

    public Tuple4d(double[] dArray) {
        this.x = dArray[0];
        this.y = dArray[1];
        this.z = dArray[2];
        this.w = dArray[3];
    }

    public Tuple4d(Tuple4d tuple4d) {
        this.x = tuple4d.x;
        this.y = tuple4d.y;
        this.z = tuple4d.z;
        this.w = tuple4d.w;
    }

    public Tuple4d(Tuple4f tuple4f) {
        this.x = tuple4f.x;
        this.y = tuple4f.y;
        this.z = tuple4f.z;
        this.w = tuple4f.w;
    }

    public Tuple4d() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        this.w = 0.0;
    }

    public final void set(double d2, double d3, double d4, double d5) {
        this.x = d2;
        this.y = d3;
        this.z = d4;
        this.w = d5;
    }

    public final void set(double[] dArray) {
        this.x = dArray[0];
        this.y = dArray[1];
        this.z = dArray[2];
        this.w = dArray[3];
    }

    public final void set(Tuple4d tuple4d) {
        this.x = tuple4d.x;
        this.y = tuple4d.y;
        this.z = tuple4d.z;
        this.w = tuple4d.w;
    }

    public final void set(Tuple4f tuple4f) {
        this.x = tuple4f.x;
        this.y = tuple4f.y;
        this.z = tuple4f.z;
        this.w = tuple4f.w;
    }

    public final void get(double[] dArray) {
        dArray[0] = this.x;
        dArray[1] = this.y;
        dArray[2] = this.z;
        dArray[3] = this.w;
    }

    public final void get(Tuple4d tuple4d) {
        tuple4d.x = this.x;
        tuple4d.y = this.y;
        tuple4d.z = this.z;
        tuple4d.w = this.w;
    }

    public final void add(Tuple4d tuple4d, Tuple4d tuple4d2) {
        this.x = tuple4d.x + tuple4d2.x;
        this.y = tuple4d.y + tuple4d2.y;
        this.z = tuple4d.z + tuple4d2.z;
        this.w = tuple4d.w + tuple4d2.w;
    }

    public final void add(Tuple4d tuple4d) {
        this.x += tuple4d.x;
        this.y += tuple4d.y;
        this.z += tuple4d.z;
        this.w += tuple4d.w;
    }

    public final void sub(Tuple4d tuple4d, Tuple4d tuple4d2) {
        this.x = tuple4d.x - tuple4d2.x;
        this.y = tuple4d.y - tuple4d2.y;
        this.z = tuple4d.z - tuple4d2.z;
        this.w = tuple4d.w - tuple4d2.w;
    }

    public final void sub(Tuple4d tuple4d) {
        this.x -= tuple4d.x;
        this.y -= tuple4d.y;
        this.z -= tuple4d.z;
        this.w -= tuple4d.w;
    }

    public final void negate(Tuple4d tuple4d) {
        this.x = -tuple4d.x;
        this.y = -tuple4d.y;
        this.z = -tuple4d.z;
        this.w = -tuple4d.w;
    }

    public final void negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        this.w = -this.w;
    }

    public final void scale(double d2, Tuple4d tuple4d) {
        this.x = d2 * tuple4d.x;
        this.y = d2 * tuple4d.y;
        this.z = d2 * tuple4d.z;
        this.w = d2 * tuple4d.w;
    }

    public final void scale(double d2) {
        this.x *= d2;
        this.y *= d2;
        this.z *= d2;
        this.w *= d2;
    }

    public final void scaleAdd(double d2, Tuple4d tuple4d, Tuple4d tuple4d2) {
        this.x = d2 * tuple4d.x + tuple4d2.x;
        this.y = d2 * tuple4d.y + tuple4d2.y;
        this.z = d2 * tuple4d.z + tuple4d2.z;
        this.w = d2 * tuple4d.w + tuple4d2.w;
    }

    public final void scaleAdd(float f2, Tuple4d tuple4d) {
        this.scaleAdd((double)f2, tuple4d);
    }

    public final void scaleAdd(double d2, Tuple4d tuple4d) {
        this.x = d2 * this.x + tuple4d.x;
        this.y = d2 * this.y + tuple4d.y;
        this.z = d2 * this.z + tuple4d.z;
        this.w = d2 * this.w + tuple4d.w;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ", " + this.w + ")";
    }

    public boolean equals(Tuple4d tuple4d) {
        try {
            return this.x == tuple4d.x && this.y == tuple4d.y && this.z == tuple4d.z && this.w == tuple4d.w;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public boolean equals(Object object) {
        try {
            Tuple4d tuple4d = (Tuple4d)object;
            return this.x == tuple4d.x && this.y == tuple4d.y && this.z == tuple4d.z && this.w == tuple4d.w;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public boolean epsilonEquals(Tuple4d tuple4d, double d2) {
        double d3 = this.x - tuple4d.x;
        double d4 = d3 < 0.0 ? -d3 : d3;
        if (d4 > d2) {
            return false;
        }
        d3 = this.y - tuple4d.y;
        double d5 = d3 < 0.0 ? -d3 : d3;
        if (d5 > d2) {
            return false;
        }
        d3 = this.z - tuple4d.z;
        double d6 = d3 < 0.0 ? -d3 : d3;
        if (d6 > d2) {
            return false;
        }
        d3 = this.w - tuple4d.w;
        double d7 = d3 < 0.0 ? -d3 : d3;
        return !(d7 > d2);
    }

    public int hashCode() {
        long l2 = 1L;
        l2 = 31L * l2 + VecMathUtil.doubleToLongBits(this.x);
        l2 = 31L * l2 + VecMathUtil.doubleToLongBits(this.y);
        l2 = 31L * l2 + VecMathUtil.doubleToLongBits(this.z);
        l2 = 31L * l2 + VecMathUtil.doubleToLongBits(this.w);
        return (int)(l2 ^ l2 >> 32);
    }

    public final void clamp(float f2, float f3, Tuple4d tuple4d) {
        this.clamp((double)f2, (double)f3, tuple4d);
    }

    public final void clamp(double d2, double d3, Tuple4d tuple4d) {
        this.x = tuple4d.x > d3 ? d3 : (tuple4d.x < d2 ? d2 : tuple4d.x);
        this.y = tuple4d.y > d3 ? d3 : (tuple4d.y < d2 ? d2 : tuple4d.y);
        this.z = tuple4d.z > d3 ? d3 : (tuple4d.z < d2 ? d2 : tuple4d.z);
        this.w = tuple4d.w > d3 ? d3 : (tuple4d.w < d2 ? d2 : tuple4d.w);
    }

    public final void clampMin(float f2, Tuple4d tuple4d) {
        this.clampMin((double)f2, tuple4d);
    }

    public final void clampMin(double d2, Tuple4d tuple4d) {
        this.x = tuple4d.x < d2 ? d2 : tuple4d.x;
        this.y = tuple4d.y < d2 ? d2 : tuple4d.y;
        this.z = tuple4d.z < d2 ? d2 : tuple4d.z;
        this.w = tuple4d.w < d2 ? d2 : tuple4d.w;
    }

    public final void clampMax(float f2, Tuple4d tuple4d) {
        this.clampMax((double)f2, tuple4d);
    }

    public final void clampMax(double d2, Tuple4d tuple4d) {
        this.x = tuple4d.x > d2 ? d2 : tuple4d.x;
        this.y = tuple4d.y > d2 ? d2 : tuple4d.y;
        this.z = tuple4d.z > d2 ? d2 : tuple4d.z;
        this.w = tuple4d.w > d2 ? d2 : tuple4d.z;
    }

    public final void absolute(Tuple4d tuple4d) {
        this.x = Math.abs(tuple4d.x);
        this.y = Math.abs(tuple4d.y);
        this.z = Math.abs(tuple4d.z);
        this.w = Math.abs(tuple4d.w);
    }

    public final void clamp(float f2, float f3) {
        this.clamp((double)f2, (double)f3);
    }

    public final void clamp(double d2, double d3) {
        if (this.x > d3) {
            this.x = d3;
        } else if (this.x < d2) {
            this.x = d2;
        }
        if (this.y > d3) {
            this.y = d3;
        } else if (this.y < d2) {
            this.y = d2;
        }
        if (this.z > d3) {
            this.z = d3;
        } else if (this.z < d2) {
            this.z = d2;
        }
        if (this.w > d3) {
            this.w = d3;
        } else if (this.w < d2) {
            this.w = d2;
        }
    }

    public final void clampMin(float f2) {
        this.clampMin((double)f2);
    }

    public final void clampMin(double d2) {
        if (this.x < d2) {
            this.x = d2;
        }
        if (this.y < d2) {
            this.y = d2;
        }
        if (this.z < d2) {
            this.z = d2;
        }
        if (this.w < d2) {
            this.w = d2;
        }
    }

    public final void clampMax(float f2) {
        this.clampMax((double)f2);
    }

    public final void clampMax(double d2) {
        if (this.x > d2) {
            this.x = d2;
        }
        if (this.y > d2) {
            this.y = d2;
        }
        if (this.z > d2) {
            this.z = d2;
        }
        if (this.w > d2) {
            this.w = d2;
        }
    }

    public final void absolute() {
        this.x = Math.abs(this.x);
        this.y = Math.abs(this.y);
        this.z = Math.abs(this.z);
        this.w = Math.abs(this.w);
    }

    public void interpolate(Tuple4d tuple4d, Tuple4d tuple4d2, float f2) {
        this.interpolate(tuple4d, tuple4d2, (double)f2);
    }

    public void interpolate(Tuple4d tuple4d, Tuple4d tuple4d2, double d2) {
        this.x = (1.0 - d2) * tuple4d.x + d2 * tuple4d2.x;
        this.y = (1.0 - d2) * tuple4d.y + d2 * tuple4d2.y;
        this.z = (1.0 - d2) * tuple4d.z + d2 * tuple4d2.z;
        this.w = (1.0 - d2) * tuple4d.w + d2 * tuple4d2.w;
    }

    public void interpolate(Tuple4d tuple4d, float f2) {
        this.interpolate(tuple4d, (double)f2);
    }

    public void interpolate(Tuple4d tuple4d, double d2) {
        this.x = (1.0 - d2) * this.x + d2 * tuple4d.x;
        this.y = (1.0 - d2) * this.y + d2 * tuple4d.y;
        this.z = (1.0 - d2) * this.z + d2 * tuple4d.z;
        this.w = (1.0 - d2) * this.w + d2 * tuple4d.w;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }
}

