/*
 * Decompiled with CFR 0.152.
 */
package com.sitraka.licensing.util.os;

import com.sitraka.licensing.util.Logger;
import com.sitraka.licensing.util.arch.Arch;
import com.sitraka.licensing.util.os.OS;
import java.io.File;
import java.io.InputStream;

abstract class Unix
extends OS {
    private static final String[] ENV_LOCATIONS = new String[]{"/bin/env", "/usr/bin/env"};
    private static final String[] UNAME_LOCATIONS = new String[]{"/bin/uname", "/usr/bin/uname"};
    private static final String[] CMD_ENV_UNIX = new String[]{Unix.getEnvPath()};
    private static final String[] CMD_HOST_UNIX = new String[]{Unix.getUnamePath(), "-n"};
    private static final Logger logger = Logger.getLogger();

    protected Unix() {
        this.setBrowserLaunchStrategy(this.getDefaultBrowserLaunchStrategy());
    }

    public String getHostName() {
        if (hostname == null) {
            hostname = Unix.executeCommand(CMD_HOST_UNIX).trim();
            if (hostname != null && hostname.length() == 0) {
                hostname = null;
            }
            logger.debug(this, "(uname) Determined that the native hostname is '" + hostname + "'");
        }
        return hostname;
    }

    protected String[] getEnvCommand() {
        return CMD_ENV_UNIX;
    }

    private OS.BrowserLaunchStrategy getDefaultBrowserLaunchStrategy() {
        return new OS.BrowserLaunchStrategy(){

            public boolean displayURL(String string) {
                return Unix.execBrowser("netscape", string, true) || Unix.execBrowser("mozilla", string, true) || Unix.execBrowser("konqueror", string, false);
            }
        };
    }

    protected File extractHostInfo(String string, String string2) throws Exception {
        File file = super.extractHostInfo(string, string2);
        String[] stringArray = new String[]{"/bin/chmod", "a+rx", file.getAbsolutePath()};
        Process process = Runtime.getRuntime().exec(stringArray);
        process.waitFor();
        return file;
    }

    protected void getProcessorsImpl() {
        try {
            String string = this.getHostInfoData();
            int[] nArray = Arch.getCurrent().parseCPUInfo(string);
            physicalCPUCount = nArray[0];
            if (physicalCPUCount <= 0) {
                logger.warning(this, "warn.physicalProcessors.notValid");
                physicalCPUCount = -2;
            }
            if ((onlineCPUCount = nArray[1]) <= 0) {
                logger.warning(this, "warn.onlineProcessors.notValid");
                onlineCPUCount = -2;
            }
            if ((totalCPUCount = nArray[2]) <= 0) {
                logger.warning(this, "warn.totalProcessors.notValid");
                totalCPUCount = -2;
            }
        }
        catch (Exception exception) {
            logger.error(this, "error.cpuinfo.exception", exception);
        }
    }

    protected static String getEnvPath() {
        return Unix.getUtilPath(ENV_LOCATIONS, "env");
    }

    protected static String getUnamePath() {
        return Unix.getUtilPath(UNAME_LOCATIONS, "uname");
    }

    protected static final String getUtilPath(String[] stringArray, String string) {
        String string2 = string;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!new File(stringArray[i2]).exists()) continue;
            string2 = stringArray[i2];
            break;
        }
        return string2;
    }

    private static boolean execBrowser(String string, String string2, boolean bl) {
        Process process;
        String[] stringArray;
        int n2 = -1;
        if (bl) {
            try {
                stringArray = new String[]{string, "-remote", "openURL(" + string2 + ")"};
                process = Runtime.getRuntime().exec(stringArray);
                InputStream inputStream = process.getErrorStream();
                if (inputStream.read() == -1) {
                    n2 = process.waitFor();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (n2 != 0) {
            try {
                stringArray = new String[]{string, string2};
                process = Runtime.getRuntime().exec(stringArray);
                Thread.sleep(1000L);
                n2 = process.exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                n2 = 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n2 == 0;
    }
}

