/*
 * Decompiled with CFR 0.152.
 */
package com.sitraka.licensing.util.os;

import com.sitraka.licensing.util.Logger;
import com.sitraka.licensing.util.arch.Arch;
import com.sitraka.licensing.util.os.AIX;
import com.sitraka.licensing.util.os.Environment;
import com.sitraka.licensing.util.os.HPUX;
import com.sitraka.licensing.util.os.Linux;
import com.sitraka.licensing.util.os.MacOsX;
import com.sitraka.licensing.util.os.OS390;
import com.sitraka.licensing.util.os.Solaris;
import com.sitraka.licensing.util.os.Unsupported;
import com.sitraka.licensing.util.os.Windows;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

public abstract class OS {
    private static final Logger logger = Logger.getLogger();
    private static OS current;
    protected BrowserLaunchStrategy browserLauncher;
    protected static int physicalCPUCount;
    protected static int onlineCPUCount;
    protected static int totalCPUCount;
    protected static String hostname;
    private static final OS[] list;
    private static final OS unsupported;
    private static final String DEFAULT_EXE_EXTENSION = ".bin";
    protected final String exeExtension;
    private String hostinfoData;
    static /* synthetic */ Class class$com$sitraka$licensing$util$os$OS;

    public static OS getCurrent() {
        if (current == null) {
            String string = System.getProperty("os.name");
            String string2 = System.getProperty("os.version");
            current = OS.getOS(string, string2);
        }
        return current;
    }

    public static OS getOS(String string, String string2) {
        String string3 = string.toLowerCase();
        String string4 = string2.toLowerCase();
        for (int i2 = 0; i2 < list.length; ++i2) {
            OS oS = list[i2];
            if (!oS.matches(string3, string4)) continue;
            return oS;
        }
        logger.warning((Object)(class$com$sitraka$licensing$util$os$OS == null ? (class$com$sitraka$licensing$util$os$OS = OS.class$("com.sitraka.licensing.util.os.OS")) : class$com$sitraka$licensing$util$os$OS), "error.os.unsupportedOS", null, string + "/" + string2);
        return unsupported;
    }

    protected OS() {
        this(DEFAULT_EXE_EXTENSION);
    }

    protected OS(String string) {
        this.exeExtension = string;
    }

    public void setBrowserLaunchStrategy(BrowserLaunchStrategy browserLaunchStrategy) {
        this.browserLauncher = browserLaunchStrategy;
    }

    public abstract String getName();

    protected abstract boolean matches(String var1, String var2);

    public int getPhysicalProcessors() {
        if (physicalCPUCount == -1) {
            this.getProcessorsImpl();
        }
        return physicalCPUCount;
    }

    public int getOnlineProcessors() {
        if (onlineCPUCount == -1) {
            this.getProcessorsImpl();
        }
        return onlineCPUCount;
    }

    public int getTotalProcessors() {
        if (totalCPUCount == -1) {
            this.getProcessorsImpl();
        }
        return totalCPUCount;
    }

    protected abstract void getProcessorsImpl();

    public abstract String getHostName();

    public String getEnv(String string) {
        Environment environment = Environment.getInstance();
        if (environment.hasEnv(string)) {
            return environment.getEnv(string);
        }
        return null;
    }

    protected abstract String[] getEnvCommand();

    public boolean displayURL(String string) {
        return this.browserLauncher.displayURL(string);
    }

    public String toString() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            int n2;
            byte[] byArray = new byte[1024];
            while ((n2 = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n2);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                logger.debug(class$com$sitraka$licensing$util$os$OS == null ? (class$com$sitraka$licensing$util$os$OS = OS.class$("com.sitraka.licensing.util.os.OS")) : class$com$sitraka$licensing$util$os$OS, "Ignoring error on input stream close", iOException);
            }
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                logger.debug(class$com$sitraka$licensing$util$os$OS == null ? (class$com$sitraka$licensing$util$os$OS = OS.class$("com.sitraka.licensing.util.os.OS")) : class$com$sitraka$licensing$util$os$OS, "Ignoring error on output stream close", iOException);
            }
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            logger.debug(class$com$sitraka$licensing$util$os$OS == null ? (class$com$sitraka$licensing$util$os$OS = OS.class$("com.sitraka.licensing.util.os.OS")) : class$com$sitraka$licensing$util$os$OS, "Ignoring error on input stream close", iOException);
        }
        try {
            outputStream.close();
        }
        catch (IOException iOException) {
            logger.debug(class$com$sitraka$licensing$util$os$OS == null ? (class$com$sitraka$licensing$util$os$OS = OS.class$("com.sitraka.licensing.util.os.OS")) : class$com$sitraka$licensing$util$os$OS, "Ignoring error on output stream close", iOException);
        }
    }

    protected static String readFile(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        File file = new File(string);
        if (file.isFile() && file.canRead()) {
            try {
                int n2;
                FileReader fileReader = new FileReader(file);
                char[] cArray = new char[1024];
                while ((n2 = fileReader.read(cArray)) != -1) {
                    stringBuffer.append(cArray, 0, n2);
                }
                fileReader.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                logger.error((Object)(class$com$sitraka$licensing$util$os$OS == null ? (class$com$sitraka$licensing$util$os$OS = OS.class$("com.sitraka.licensing.util.os.OS")) : class$com$sitraka$licensing$util$os$OS), "error.os.fileDoesNotExists", (Throwable)fileNotFoundException, string);
            }
            catch (IOException iOException) {
                logger.error((Object)(class$com$sitraka$licensing$util$os$OS == null ? (class$com$sitraka$licensing$util$os$OS = OS.class$("com.sitraka.licensing.util.os.OS")) : class$com$sitraka$licensing$util$os$OS), "error.os.errorReadingFile", (Throwable)iOException, string);
            }
        } else {
            logger.error((Object)(class$com$sitraka$licensing$util$os$OS == null ? (class$com$sitraka$licensing$util$os$OS = OS.class$("com.sitraka.licensing.util.os.OS")) : class$com$sitraka$licensing$util$os$OS), "error.os.errorReadingFile", null, string);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String executeCommand(String[] stringArray) {
        Process process = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n2;
            process = Runtime.getRuntime().exec(stringArray);
            InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
            char[] cArray = new char[1024];
            while ((n2 = inputStreamReader.read(cArray)) != -1) {
                stringBuffer.append(cArray, 0, n2);
            }
        }
        catch (IOException iOException) {
            logger.warning((Object)(class$com$sitraka$licensing$util$os$OS == null ? (class$com$sitraka$licensing$util$os$OS = OS.class$("com.sitraka.licensing.util.os.OS")) : class$com$sitraka$licensing$util$os$OS), "error.os.cannotExecuteCommand", (Throwable)iOException, stringArray[0]);
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        return stringBuffer.toString();
    }

    protected File extractHostInfo(String string, String string2) throws Exception {
        if (string == null || string.trim().length() == 0) {
            throw new Exception("OS name is null or empty");
        }
        if (string2 == null || string2.trim().length() == 0) {
            throw new Exception("Architecture name is null or empty");
        }
        String string3 = "/bin/" + string + "/" + string2 + "/hostinfo" + this.exeExtension;
        InputStream inputStream = this.getClass().getResourceAsStream(string3);
        if (inputStream == null) {
            throw new Exception(string3 + " not found in the classpath");
        }
        File file = File.createTempFile("hostinfo", this.exeExtension);
        file.deleteOnExit();
        OS.copy(inputStream, new FileOutputStream(file));
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getHostInfoData() throws Exception {
        if (this.hostinfoData == null) {
            File file = null;
            try {
                file = this.extractHostInfo(this.getName(), Arch.getCurrent().getName());
                String[] stringArray = new String[]{file.getAbsolutePath()};
                this.hostinfoData = OS.executeCommand(stringArray);
            }
            finally {
                if (file != null) {
                    file.delete();
                }
            }
        }
        return this.hostinfoData;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        physicalCPUCount = -1;
        onlineCPUCount = -1;
        totalCPUCount = -1;
        hostname = null;
        list = new OS[]{new Windows(), new Solaris(), new Linux(), new AIX(), new HPUX(), new OS390(), new MacOsX()};
        unsupported = new Unsupported();
    }

    public static interface BrowserLaunchStrategy {
        public boolean displayURL(String var1);
    }
}

