/*
 * Decompiled with CFR 0.152.
 */
package com.sitraka.licensing.util;

import com.sitraka.licensing.logging.LicenseLogEvent;
import com.sitraka.licensing.logging.LicenseLogListener;
import com.sitraka.licensing.logging.LicenseLogManager;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;

public final class Debug {
    protected static boolean enabled = false;
    protected static PrintStream stream = System.out;

    private Debug() {
    }

    public static void setEnabled(boolean bl) {
        enabled = bl;
        LicenseLogManager.getLogManager().setLevel(bl ? 4 : 3);
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setPrintStream(PrintStream printStream) {
        stream = printStream;
    }

    public static PrintStream getPrintStream() {
        return stream;
    }

    static {
        LicenseLogManager.getLogManager().addListener(new DebugLogger());
    }

    private static class DebugLogger
    implements LicenseLogListener {
        private DateFormat mDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        private Date mDate = new Date();

        private DebugLogger() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getTimestamp() {
            Date date = this.mDate;
            synchronized (date) {
                this.mDate.setTime(System.currentTimeMillis());
                return this.mDateFormat.format(this.mDate);
            }
        }

        public void logEvent(LicenseLogEvent licenseLogEvent) {
            String string;
            if (!enabled) {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getTimestamp());
            stringBuffer.append(" ");
            switch (licenseLogEvent.getReason()) {
                case 4: {
                    stringBuffer.append("DEBUG ");
                    break;
                }
                case 3: {
                    stringBuffer.append("INFO  ");
                    break;
                }
                case 2: {
                    stringBuffer.append("WARN  ");
                    break;
                }
                case 1: {
                    stringBuffer.append("ERROR ");
                    break;
                }
            }
            stringBuffer.append("[");
            if (licenseLogEvent.getSource() instanceof Class) {
                stringBuffer.append(((Class)licenseLogEvent.getSource()).getName());
            } else {
                stringBuffer.append(licenseLogEvent.getSource().getClass().getName());
            }
            stringBuffer.append("] - ");
            try {
                string = licenseLogEvent.getTranslatedMessage();
                if (string.length() == 0) {
                    stringBuffer.append("(no message)");
                } else {
                    stringBuffer.append(string);
                }
            }
            catch (MissingResourceException missingResourceException) {
                stringBuffer.append("Missing resource for log message: " + licenseLogEvent.getMessage() + " in locale " + Locale.getDefault() + ". Error: " + missingResourceException.getMessage());
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
                stringBuffer.append("Untranslated message: " + licenseLogEvent.getMessage() + " or missing resource bundle in locale " + Locale.getDefault() + ". Error: " + exceptionInInitializerError.getMessage());
            }
            if (licenseLogEvent.getException() != null) {
                stringBuffer.append("\n");
                stringBuffer.append(licenseLogEvent.getExceptionAsText());
            }
            if ((string = stringBuffer.toString()).endsWith("\n")) {
                stream.print(string);
            } else {
                stream.println(string);
            }
            stream.flush();
        }
    }
}

