/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.Container;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InputIterator;
import com.objectspace.jgl.RandomAccessIterator;
import com.objectspace.jgl.adapters.DoubleArray;
import com.objectspace.jgl.adapters.DoubleBuffer;
import java.io.Serializable;
import java.util.NoSuchElementException;

public final class DoubleIterator
implements RandomAccessIterator,
Serializable {
    double[] buffer;
    Container original;
    int index;
    static final long serialVersionUID = 5481800139253707671L;

    public static DoubleIterator begin(double[] dArray) {
        return new DoubleIterator(dArray, 0);
    }

    public static DoubleIterator end(double[] dArray) {
        return new DoubleIterator(dArray, dArray.length);
    }

    public DoubleIterator() {
        this(new DoubleArray(), 0);
    }

    public DoubleIterator(DoubleIterator doubleIterator) {
        this.buffer = doubleIterator.buffer;
        this.original = doubleIterator.original;
        this.index = doubleIterator.index;
    }

    public DoubleIterator(double[] dArray, int n2) {
        this(new DoubleArray(dArray), n2);
    }

    public DoubleIterator(DoubleArray doubleArray, int n2) {
        this.buffer = doubleArray.array;
        this.original = doubleArray;
        this.index = n2;
    }

    public DoubleIterator(DoubleBuffer doubleBuffer, int n2) {
        this.buffer = doubleBuffer.storage;
        this.original = doubleBuffer;
        this.index = n2;
    }

    public Object clone() {
        return new DoubleIterator(this);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (!(object instanceof DoubleIterator)) break block2;
                DoubleIterator doubleIterator = (DoubleIterator)object;
                if (doubleIterator.index == this.index && (doubleIterator.buffer == this.buffer || false)) break block3;
            }
            return false;
        }
        return true;
    }

    public boolean equals(DoubleIterator doubleIterator) {
        return doubleIterator.index == this.index && doubleIterator.buffer == this.buffer;
    }

    public boolean less(RandomAccessIterator randomAccessIterator) {
        return this.index < ((DoubleIterator)randomAccessIterator).index;
    }

    public boolean atBegin() {
        return this.index == 0;
    }

    public boolean atEnd() {
        return this.index == this.original.size();
    }

    public boolean hasMoreElements() {
        return this.index < this.original.size();
    }

    public void advance() {
        ++this.index;
    }

    public void advance(int n2) {
        this.index += n2;
    }

    public void retreat() {
        --this.index;
    }

    public void retreat(int n2) {
        this.index -= n2;
    }

    public Object nextElement() {
        try {
            Double d2 = new Double(this.buffer[this.index]);
            ++this.index;
            return d2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoSuchElementException("DoubleIterator");
        }
    }

    public Object get() {
        return new Double(this.buffer[this.index]);
    }

    public double getDouble() {
        return this.buffer[this.index];
    }

    public Object get(int n2) {
        return new Double(this.buffer[this.index + n2]);
    }

    public double getDouble(int n2) {
        return this.buffer[this.index + n2];
    }

    public void put(Object object) {
        double d2;
        this.buffer[this.index] = d2 = ((Number)object).doubleValue();
    }

    public void put(double d2) {
        this.buffer[this.index] = d2;
    }

    public void put(int n2, Object object) {
        double d2;
        this.buffer[this.index + n2] = d2 = ((Number)object).doubleValue();
    }

    public void put(int n2, double d2) {
        this.buffer[this.index + n2] = d2;
    }

    public int distance(ForwardIterator forwardIterator) {
        ForwardIterator forwardIterator2 = forwardIterator;
        if (!(forwardIterator2 instanceof DoubleIterator) || this.buffer != ((DoubleIterator)forwardIterator2).buffer && !false) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        return ((DoubleIterator)forwardIterator).index - this.index;
    }

    public int index() {
        return this.index;
    }

    public Container getContainer() {
        return this.original;
    }

    public boolean isCompatibleWith(InputIterator inputIterator) {
        return inputIterator instanceof DoubleIterator && this.buffer == ((DoubleIterator)inputIterator).buffer;
    }
}

