/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InvalidOperationException;
import com.objectspace.jgl.Sequence;
import com.objectspace.jgl.adapters.Algorithms;
import com.objectspace.jgl.adapters.ArrayAdapter;
import com.objectspace.jgl.adapters.CharArray;
import com.objectspace.jgl.adapters.CharIterator;
import java.io.Serializable;
import java.util.Enumeration;

public class CharBuffer
implements Sequence {
    static final char defaultValue = '\u0000';
    char[] storage;
    int length;
    static final long serialVersionUID = -772607664012752530L;

    public CharBuffer() {
        this.clear();
    }

    public CharBuffer(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Attempt to create an CharBuffer with a negative size");
        }
        this.length = n2;
        this.storage = new char[this.length];
    }

    public CharBuffer(int n2, char c2) {
        this(n2);
        int n3 = 0;
        while (n3 < this.length) {
            this.storage[n3] = c2;
            ++n3;
        }
    }

    public CharBuffer(char[] cArray) {
        this(cArray, true);
    }

    CharBuffer(char[] cArray, boolean bl) {
        char[] cArray2 = cArray;
        synchronized (cArray2) {
            this.length = cArray.length;
            if (bl) {
                this.storage = new char[this.length];
                System.arraycopy(cArray, 0, this.storage, 0, this.length);
            } else {
                this.storage = cArray;
            }
            return;
        }
    }

    public CharBuffer(CharBuffer charBuffer) {
        this(charBuffer.storage);
    }

    public synchronized Object clone() {
        return new CharBuffer(this);
    }

    public boolean equals(Object object) {
        return object instanceof CharBuffer && this.equals((CharBuffer)object) || object instanceof CharArray && this.equals((CharArray)object);
    }

    public boolean equals(CharBuffer charBuffer) {
        return this.equals(new CharArray(charBuffer.storage));
    }

    public synchronized boolean equals(CharArray charArray) {
        return charArray.equals(this.storage);
    }

    public boolean equals(char[] cArray) {
        return this.equals(new CharArray(cArray));
    }

    public synchronized String toString() {
        return Algorithms.Printing.toString(this, "CharBuffer");
    }

    public synchronized void copy(CharBuffer charBuffer) {
        if (this == charBuffer) {
            return;
        }
        CharBuffer charBuffer2 = charBuffer;
        synchronized (charBuffer2) {
            if (charBuffer.length > this.storage.length) {
                this.storage = charBuffer.get();
            } else {
                System.arraycopy(charBuffer.storage, 0, this.storage, 0, charBuffer.length);
                int n2 = charBuffer.length;
                while (n2 < this.length) {
                    this.storage[n2] = '\u0000';
                    ++n2;
                }
            }
            this.length = charBuffer.length;
            return;
        }
    }

    public synchronized void copyTo(char[] cArray) {
        char[] cArray2 = cArray;
        synchronized (cArray2) {
            System.arraycopy(this.storage, 0, cArray, 0, Math.min(this.length, cArray.length));
            return;
        }
    }

    public synchronized char[] get() {
        char[] cArray = new char[this.length];
        this.copyTo(cArray);
        return cArray;
    }

    public synchronized int hashCode() {
        return Algorithms.Hashing.orderedHash(this.begin(), this.length);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Object back() {
        return this.at(this.size() - 1);
    }

    public Object front() {
        return this.at(0);
    }

    public int size() {
        return this.length;
    }

    public int capacity() {
        return this.storage.length;
    }

    public int maxSize() {
        return Integer.MAX_VALUE;
    }

    public Object at(int n2) {
        return new Character(this.charAt(n2));
    }

    public synchronized char charAt(int n2) {
        ArrayAdapter.checkIndex(n2, this.length);
        return this.storage[n2];
    }

    public synchronized void put(int n2, Object object) {
        this.put(n2, ((Character)object).charValue());
    }

    public synchronized void put(int n2, char c2) {
        ArrayAdapter.checkIndex(n2, this.length);
        this.storage[n2] = c2;
    }

    public synchronized void clear() {
        this.storage = new char[10];
        this.length = 0;
    }

    public Object remove(Enumeration enumeration) {
        if (!(enumeration instanceof CharIterator)) {
            throw new IllegalArgumentException("Enumeration not an CharIterator");
        }
        if (((CharIterator)enumeration).buffer != this.storage) {
            throw new IllegalArgumentException("Enumeration not for this CharBuffer ");
        }
        Serializable serializable = (CharIterator)enumeration;
        serializable = new Character(serializable.buffer[serializable.index]);
        this.remove(((CharIterator)enumeration).index);
        return serializable;
    }

    public synchronized Object remove(int n2) {
        ArrayAdapter.checkIndex(n2, this.length);
        Character c2 = new Character(this.storage[n2]);
        System.arraycopy(this.storage, n2 + 1, this.storage, n2, this.length - n2 - 1);
        this.storage[--this.length] = '\u0000';
        return c2;
    }

    public int remove(Enumeration enumeration, Enumeration enumeration2) {
        block5: {
            block4: {
                if (!(enumeration instanceof CharIterator) || !(enumeration2 instanceof CharIterator)) {
                    throw new IllegalArgumentException("Enumeration not an CharIterator");
                }
                if (((CharIterator)enumeration).buffer != this.storage) break block4;
                CharIterator charIterator = (CharIterator)enumeration;
                CharIterator charIterator2 = (CharIterator)enumeration2;
                if (!(charIterator2 instanceof CharIterator) || charIterator.buffer != charIterator2.buffer && !false) break block5;
            }
            throw new IllegalArgumentException("Enumeration not compatible");
        }
        return this.remove(((CharIterator)enumeration).index, ((CharIterator)enumeration2).index - 1);
    }

    public synchronized int remove(int n2, int n3) {
        if (n3 < n2) {
            return 0;
        }
        int n4 = this.length;
        ArrayAdapter.checkIndex(n2, n4);
        ArrayAdapter.checkIndex(n3, n4);
        n4 = n3 - n2 + 1;
        System.arraycopy(this.storage, n3 + 1, this.storage, n2, this.length - n3 - 1);
        int n5 = this.length - n4;
        while (n5 < this.length) {
            this.storage[n5] = '\u0000';
            ++n5;
        }
        this.length -= n4;
        return n4;
    }

    public synchronized Object popBack() {
        if (this.length == 0) {
            throw new InvalidOperationException("CharBuffer is empty");
        }
        Character c2 = new Character(this.storage[--this.length]);
        this.storage[this.length] = '\u0000';
        return c2;
    }

    public synchronized Object add(Object object) {
        this.add(((Character)object).charValue());
        return null;
    }

    public synchronized void add(char c2) {
        if (this.length == this.storage.length) {
            char[] cArray = this.getNextStorage(1);
            this.copyTo(cArray);
            this.storage = cArray;
        }
        this.storage[this.length++] = c2;
    }

    public void pushBack(Object object) {
        this.add(((Character)object).charValue());
    }

    public void pushBack(char c2) {
        this.add(c2);
    }

    public CharIterator insert(CharIterator charIterator, Object object) {
        return this.insert(charIterator, ((Character)object).charValue());
    }

    public CharIterator insert(CharIterator charIterator, char c2) {
        this.insert(charIterator.index, c2);
        return new CharIterator(this, charIterator.index);
    }

    public void insert(int n2, Object object) {
        this.insert(n2, ((Character)object).charValue());
    }

    public synchronized void insert(int n2, char c2) {
        ArrayAdapter.checkIndex(n2, this.length + 1);
        if (this.length != this.storage.length) {
            if (n2 != this.length) {
                System.arraycopy(this.storage, n2, this.storage, n2 + 1, this.length - n2);
            }
        } else {
            char[] cArray = this.getNextStorage(1);
            System.arraycopy(this.storage, 0, cArray, 0, n2);
            System.arraycopy(this.storage, n2, cArray, n2 + 1, this.length - n2);
            this.storage = cArray;
        }
        this.storage[n2] = c2;
        ++this.length;
    }

    public void insert(CharIterator charIterator, int n2, Object object) {
        this.insert(charIterator, n2, ((Character)object).charValue());
    }

    public void insert(CharIterator charIterator, int n2, char c2) {
        this.insert(charIterator.index, n2, c2);
    }

    public void insert(int n2, int n3, Object object) {
        this.insert(n2, n3, ((Character)object).charValue());
    }

    public synchronized void insert(int n2, int n3, char c2) {
        if (n3 < 0) {
            throw new IllegalArgumentException("Attempt to insert a negative number of objects.");
        }
        if (n3 == 0) {
            return;
        }
        ArrayAdapter.checkIndex(n2, this.length + 1);
        if (this.storage.length - this.length >= n3) {
            System.arraycopy(this.storage, n2, this.storage, n2 + n3, this.length - n2);
        } else {
            char[] cArray = this.getNextStorage(n3);
            System.arraycopy(this.storage, 0, cArray, 0, n2);
            System.arraycopy(this.storage, n2, cArray, n2 + n3, this.length - n2);
            this.storage = cArray;
        }
        int n4 = n2;
        while (n4 < n2 + n3) {
            this.storage[n4] = c2;
            ++n4;
        }
        this.length += n3;
    }

    public void insert(CharIterator charIterator, ForwardIterator forwardIterator, ForwardIterator forwardIterator2) {
        this.insert(charIterator.index, forwardIterator, forwardIterator2);
    }

    public synchronized void insert(int n2, ForwardIterator forwardIterator, ForwardIterator forwardIterator2) {
        int n3 = forwardIterator.distance(forwardIterator2);
        if (n3 == 0) {
            return;
        }
        ForwardIterator forwardIterator3 = (ForwardIterator)forwardIterator.clone();
        if (this.storage.length - this.length >= n3) {
            System.arraycopy(this.storage, n2, this.storage, n2 + n3, this.length - n2);
        } else {
            char[] cArray = this.getNextStorage(n3);
            System.arraycopy(this.storage, 0, cArray, 0, n2);
            System.arraycopy(this.storage, n2, cArray, n2 + n3, this.length - n2);
            this.storage = cArray;
        }
        this.length += n3;
        int n4 = n2;
        while (n4 < n2 + n3) {
            this.put(n4, forwardIterator3.nextElement());
            ++n4;
        }
    }

    public synchronized void swap(CharBuffer charBuffer) {
        CharBuffer charBuffer2 = charBuffer;
        synchronized (charBuffer2) {
            int n2 = this.length;
            char[] cArray = this.storage;
            this.length = charBuffer.length;
            this.storage = charBuffer.storage;
            charBuffer.length = n2;
            charBuffer.storage = cArray;
            return;
        }
    }

    public Enumeration elements() {
        return this.begin();
    }

    public ForwardIterator start() {
        return this.begin();
    }

    public ForwardIterator finish() {
        return this.end();
    }

    public synchronized CharIterator begin() {
        return new CharIterator(this, 0);
    }

    public synchronized CharIterator end() {
        return new CharIterator(this, this.length);
    }

    public synchronized void trimToSize() {
        if (this.length < this.storage.length) {
            this.storage = this.get();
        }
    }

    public synchronized void ensureCapacity(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Attempt to reserve a negative size.");
        }
        if (this.storage.length < n2) {
            char[] cArray = new char[n2];
            if (this.length > 0) {
                System.arraycopy(this.storage, 0, cArray, 0, this.length);
            }
            this.storage = cArray;
        }
    }

    public synchronized Object popFront() {
        if (this.length == 0) {
            throw new InvalidOperationException("CharBuffer is empty");
        }
        Character c2 = new Character(this.storage[0]);
        this.remove(0);
        return c2;
    }

    public void pushFront(Object object) {
        this.insert(0, object);
    }

    public void pushFront(char c2) {
        this.insert(0, c2);
    }

    public int remove(Object object) {
        return this.remove(object, this.length);
    }

    public synchronized int remove(Object object, int n2) {
        char c2 = ((Character)object).charValue();
        int n3 = 0;
        while (n2 > 0) {
            int n4 = this.indexOf(c2);
            if (n4 < 0) break;
            --n2;
            ++n3;
            this.remove(n4);
        }
        return n3;
    }

    public synchronized int remove(int n2, int n3, Object object) {
        ((Character)object).charValue();
        if (n3 < n2) {
            return 0;
        }
        int n4 = this.length;
        ArrayAdapter.checkIndex(n2, n4);
        ArrayAdapter.checkIndex(n3, n4);
        CharIterator charIterator = new CharIterator(this, n2);
        CharIterator charIterator2 = new CharIterator(this, n3 + 1);
        CharIterator charIterator3 = (CharIterator)Algorithms.Removing.remove(charIterator, charIterator2, object);
        return this.remove(charIterator3.index, n3);
    }

    public int replace(Object object, Object object2) {
        return this.replace(((Character)object).charValue(), ((Character)object2).charValue());
    }

    public int replace(char c2, char c3) {
        return this.replace(0, this.length - 1, c2, c3);
    }

    public int replace(int n2, int n3, Object object, Object object2) {
        return this.replace(n2, n3, ((Character)object).charValue(), ((Character)object2).charValue());
    }

    public synchronized int replace(int n2, int n3, char c2, char c3) {
        int n4 = this.length;
        ArrayAdapter.checkIndex(n2, n4);
        ArrayAdapter.checkIndex(n3, n4);
        n4 = 0;
        while (n2 < n3) {
            if (this.storage[n2] == c2) {
                this.storage[n2] = c3;
                ++n4;
            }
            ++n2;
        }
        return n4;
    }

    public int count(Object object) {
        return this.count(((Character)object).charValue());
    }

    public int count(char c2) {
        return this.count(0, this.length - 1, c2);
    }

    public int count(int n2, int n3, Object object) {
        return this.count(n2, n3, ((Character)object).charValue());
    }

    public synchronized int count(int n2, int n3, char c2) {
        int n4 = this.length;
        ArrayAdapter.checkIndex(n2, n4);
        ArrayAdapter.checkIndex(n3, n4);
        n4 = 0;
        while (n2 < n3) {
            if (this.storage[n2] == c2) {
                ++n4;
            }
            ++n2;
        }
        return n4;
    }

    public int indexOf(Object object) {
        return this.indexOf(((Character)object).charValue());
    }

    public int indexOf(char c2) {
        return this.indexOf(0, this.length - 1, c2);
    }

    public int indexOf(int n2, int n3, Object object) {
        return this.indexOf(n2, n3, ((Character)object).charValue());
    }

    public synchronized int indexOf(int n2, int n3, char c2) {
        if (n3 < n2) {
            return -1;
        }
        int n4 = this.length;
        ArrayAdapter.checkIndex(n2, n4);
        ArrayAdapter.checkIndex(n3, n4);
        while (n2 < n3) {
            if (this.storage[n2] == c2) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public synchronized void setSize(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Attempt to become a negative size.");
        }
        if (this.length > n2) {
            this.remove(n2, this.length - 1);
            return;
        }
        if (this.length < n2) {
            this.insert(this.length, n2 - this.length, '\u0000');
        }
    }

    public boolean contains(Object object) {
        return this.contains(((Character)object).charValue());
    }

    public boolean contains(char c2) {
        return this.indexOf(c2) != -1;
    }

    private char[] getNextStorage(int n2) {
        int n3 = Math.max(ArrayAdapter.getNextSize(this.length), this.length + n2);
        char[] cArray = new char[n3];
        return cArray;
    }

    static char asChar(Object object) {
        return ((Character)object).charValue();
    }
}

