/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InvalidOperationException;
import com.objectspace.jgl.adapters.Algorithms;
import com.objectspace.jgl.adapters.ArrayAdapter;
import com.objectspace.jgl.adapters.BooleanArray;
import com.objectspace.jgl.adapters.BooleanIterator;
import com.objectspace.jgl.adapters.ByteBuffer;
import com.objectspace.jgl.adapters.ByteIterator;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Enumeration;

public class BooleanBuffer
extends ArrayAdapter {
    ByteBuffer storage;
    int size;
    static final long serialVersionUID = -1087317977793221720L;

    public BooleanBuffer() {
        this(0);
    }

    public BooleanBuffer(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Attempt to create an BooleanBuffer with a negative size");
        }
        this.storage = new ByteBuffer(n2 / 8 + 1);
        this.size = n2;
    }

    public BooleanBuffer(int n2, boolean bl) {
        this(n2);
        int n3 = 0;
        while (n3 < this.storage.size()) {
            this.storage.put(n3, (byte)(bl ? 255 : 0));
            ++n3;
        }
    }

    public BooleanBuffer(boolean[] blArray) {
        this(new BooleanArray(blArray));
    }

    BooleanBuffer(ByteBuffer byteBuffer) {
        this.storage = byteBuffer;
        this.size = 0;
    }

    public BooleanBuffer(BooleanBuffer booleanBuffer) {
        this.storage = booleanBuffer.storage;
        this.size = booleanBuffer.size;
    }

    public BooleanBuffer(BooleanArray booleanArray) {
        this(booleanArray.size());
        Algorithms.Copying.copy(booleanArray.begin(), booleanArray.end(), this.begin());
    }

    public BooleanBuffer(BitSet bitSet) {
        this(bitSet.size());
        BooleanIterator booleanIterator = this.begin();
        BitSet bitSet2 = bitSet;
        synchronized (bitSet2) {
            int n2 = 0;
            while (n2 < this.size()) {
                booleanIterator.put(n2, bitSet.get(n2));
                ++n2;
            }
            return;
        }
    }

    public synchronized Object clone() {
        return new BooleanBuffer(this);
    }

    public synchronized int hashCode() {
        return this.storage.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof BooleanBuffer && this.equals((BooleanBuffer)object) || object instanceof BooleanArray && this.equals((BooleanArray)object);
    }

    public boolean equals(BooleanBuffer booleanBuffer) {
        BooleanBuffer booleanBuffer2 = booleanBuffer;
        synchronized (booleanBuffer2) {
            boolean bl = Algorithms.Comparing.equal(this, booleanBuffer);
            Object var4_4 = null;
            return bl;
        }
    }

    public boolean equals(BooleanArray booleanArray) {
        BooleanArray booleanArray2 = booleanArray;
        synchronized (booleanArray2) {
            boolean bl = Algorithms.Comparing.equal(this, booleanArray);
            Object var4_4 = null;
            return bl;
        }
    }

    public boolean equals(boolean[] blArray) {
        return this.equals(new BooleanArray(blArray));
    }

    public synchronized String toString() {
        return Algorithms.Printing.toString(this, "BooleanBuffer");
    }

    public synchronized void copy(BooleanBuffer booleanBuffer) {
        if (this == booleanBuffer) {
            return;
        }
        this.storage = new ByteBuffer(booleanBuffer.storage);
        this.size = booleanBuffer.size;
    }

    public synchronized void copyTo(boolean[] blArray) {
        boolean[] blArray2 = blArray;
        synchronized (blArray2) {
            int n2 = 0;
            BooleanIterator booleanIterator = this.begin();
            while (n2 < this.size()) {
                blArray[n2] = booleanIterator.getBoolean(n2);
                ++n2;
            }
            return;
        }
    }

    public synchronized void copyTo(BitSet bitSet) {
        BitSet bitSet2 = bitSet;
        synchronized (bitSet2) {
            int n2 = 0;
            BooleanIterator booleanIterator = this.begin();
            while (n2 < this.size()) {
                if (booleanIterator.getBoolean(n2)) {
                    bitSet.set(n2);
                } else {
                    bitSet.clear(n2);
                }
                ++n2;
            }
            return;
        }
    }

    public synchronized boolean[] get() {
        boolean[] blArray = new boolean[this.size()];
        this.copyTo(blArray);
        return blArray;
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.storage.size() * 8 - 1;
    }

    public synchronized Object at(int n2) {
        ArrayAdapter.checkIndex(n2, this.size);
        BooleanIterator booleanIterator = new BooleanIterator(this, n2);
        return new Boolean(booleanIterator.getBoolean(0));
    }

    public boolean booleanAt(int n2) {
        return (Boolean)this.at(n2);
    }

    public void put(int n2, Object object) {
        this.put(n2, (Boolean)object);
    }

    public synchronized void put(int n2, boolean bl) {
        ArrayAdapter.checkIndex(n2, this.size);
        this.begin().put(n2, bl);
    }

    public synchronized void clear() {
        this.storage.clear();
        this.size = 0;
    }

    public Object remove(Enumeration enumeration) {
        if (!(enumeration instanceof BooleanIterator)) {
            throw new IllegalArgumentException("Enumeration not an BooleanIterator");
        }
        if (((BooleanBuffer)((BooleanIterator)enumeration).original).storage != this.storage) {
            throw new IllegalArgumentException("Enumeration not for this BooleanBuffer ");
        }
        Serializable serializable = (BooleanIterator)enumeration;
        serializable = new Boolean(serializable.getBoolean(0));
        BooleanIterator booleanIterator = (BooleanIterator)enumeration;
        booleanIterator = new BooleanIterator(this, (booleanIterator.offset == -1 ? booleanIterator.index : booleanIterator.index * 8 + booleanIterator.offset) + 1);
        BooleanIterator booleanIterator2 = new BooleanIterator(this, this.size);
        if (booleanIterator.index != booleanIterator2.index || booleanIterator.offset != booleanIterator2.offset || !booleanIterator.isCompatibleWith(booleanIterator2)) {
            Algorithms.Copying.copy(booleanIterator, booleanIterator2, (BooleanIterator)enumeration);
        }
        --this.size;
        return serializable;
    }

    public synchronized Object remove(int n2) {
        ArrayAdapter.checkIndex(n2, this.size);
        return this.remove(new BooleanIterator(this, n2));
    }

    public int remove(Enumeration enumeration, Enumeration enumeration2) {
        if (!(enumeration instanceof BooleanIterator) || !(enumeration2 instanceof BooleanIterator)) {
            throw new IllegalArgumentException("Enumeration not an BooleanIterator");
        }
        if (((BooleanBuffer)((BooleanIterator)enumeration).original).storage != this.storage || ((BooleanIterator)enumeration).isCompatibleWith((BooleanIterator)enumeration2)) {
            throw new IllegalArgumentException("Enumeration not compatible");
        }
        int n2 = ((BooleanIterator)enumeration).distance((BooleanIterator)enumeration2);
        BooleanIterator cfr_ignored_0 = (BooleanIterator)Algorithms.Copying.copy((BooleanIterator)enumeration2, new BooleanIterator(this, this.size), (BooleanIterator)enumeration);
        this.size -= n2;
        return n2;
    }

    public synchronized int remove(int n2, int n3) {
        if (n3 < n2) {
            return 0;
        }
        int n4 = this.size;
        ArrayAdapter.checkIndex(n2, n4);
        ArrayAdapter.checkIndex(n3, n4);
        return this.remove(new BooleanIterator(this, n2), new BooleanIterator(this, n3));
    }

    public synchronized Object popBack() {
        if (this.size == 0) {
            throw new InvalidOperationException("BooleanBuffer is empty");
        }
        BooleanIterator booleanIterator = new BooleanIterator(this, --this.size);
        return new Boolean(booleanIterator.getBoolean(0));
    }

    public Object add(Object object) {
        this.add((Boolean)object);
        return null;
    }

    public synchronized void add(boolean bl) {
        BooleanIterator booleanIterator = new BooleanIterator(this, this.size);
        if (this.size / 8 == this.storage.size()) {
            this.insertAux(booleanIterator, bl);
            return;
        }
        ++this.size;
        booleanIterator.put(0, bl);
    }

    public void pushBack(Object object) {
        this.add((Boolean)object);
    }

    public void pushBack(boolean bl) {
        this.add(bl);
    }

    public BooleanIterator insert(BooleanIterator booleanIterator, Object object) {
        return this.insert(booleanIterator, (boolean)((Boolean)object));
    }

    public BooleanIterator insert(BooleanIterator booleanIterator, boolean bl) {
        int n2;
        int n3 = n2 = booleanIterator.offset == -1 ? booleanIterator.index : booleanIterator.index * 8 + booleanIterator.offset;
        if (n2 == this.size) {
            this.pushBack(bl);
        } else {
            this.insertAux(booleanIterator, bl);
        }
        return new BooleanIterator(this, n2);
    }

    public void insert(int n2, Object object) {
        this.insert(n2, (boolean)((Boolean)object));
    }

    public synchronized void insert(int n2, boolean bl) {
        ArrayAdapter.checkIndex(n2, this.size + 1);
        this.insert(new BooleanIterator(this, n2), bl);
    }

    public void insert(BooleanIterator booleanIterator, int n2, Object object) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Attempt to insert a negative number of objects.");
        }
        if (n2 == 0) {
            return;
        }
        if (this.capacity() - this.size >= n2) {
            BooleanIterator booleanIterator2 = new BooleanIterator(this, this.size + n2);
            Algorithms.Copying.copyBackward(booleanIterator, new BooleanIterator(this, this.size), booleanIterator2);
            BooleanIterator booleanIterator3 = booleanIterator;
            BooleanIterator booleanIterator4 = new BooleanIterator(this, (booleanIterator.offset == -1 ? booleanIterator.index : booleanIterator.index * 8 + booleanIterator.offset) + n2);
            while (!((Object)booleanIterator3).equals(booleanIterator4)) {
                booleanIterator3.put(object);
                booleanIterator3.advance();
            }
            this.size += n2;
            return;
        }
        BooleanBuffer booleanBuffer = new BooleanBuffer(new ByteBuffer(new byte[this.size + Math.max(this.size, n2)], false));
        Algorithms.Copying.copy(this.storage.begin(), new ByteIterator(this.storage, (booleanIterator.offset == -1 ? booleanIterator.index : booleanIterator.index * 8 + booleanIterator.offset) < this.size ? booleanIterator.index + 1 : booleanIterator.index), booleanBuffer.storage.begin());
        BooleanIterator booleanIterator5 = new BooleanIterator(booleanBuffer, booleanIterator.offset == -1 ? booleanIterator.index : booleanIterator.index * 8 + booleanIterator.offset);
        while (n2-- > 0) {
            booleanIterator5.put(0, (Boolean)object);
            booleanIterator5.advance();
        }
        Algorithms.Copying.copy(booleanIterator, new BooleanIterator(this, this.size), booleanIterator5);
        this.copy(booleanBuffer);
    }

    public void insert(BooleanIterator booleanIterator, int n2, boolean bl) {
        this.insert(booleanIterator, n2, (Object)new Boolean(bl));
    }

    public void insert(int n2, int n3, Object object) {
        ArrayAdapter.checkIndex(n2, this.size + 1);
        this.insert(new BooleanIterator(this, n2), n3, object);
    }

    public synchronized void insert(int n2, int n3, boolean bl) {
        this.insert(n2, n3, (Object)new Boolean(bl));
    }

    public void insert(BooleanIterator booleanIterator, ForwardIterator forwardIterator, ForwardIterator forwardIterator2) {
        int n2 = forwardIterator.distance(forwardIterator2);
        if (n2 == 0) {
            return;
        }
        if (this.capacity() - this.size >= n2) {
            BooleanIterator booleanIterator2 = new BooleanIterator(this, this.size + n2);
            Algorithms.Copying.copyBackward(booleanIterator, new BooleanIterator(this, this.size), booleanIterator2);
            Algorithms.Copying.copy(forwardIterator, forwardIterator2, booleanIterator);
            this.size += n2;
            return;
        }
        BooleanBuffer booleanBuffer = new BooleanBuffer(new ByteBuffer(new byte[this.size + Math.max(this.size, n2)], false));
        Algorithms.Copying.copy(this.storage.begin(), new ByteIterator(this.storage, (booleanIterator.offset == -1 ? booleanIterator.index : booleanIterator.index * 8 + booleanIterator.offset) < this.size ? booleanIterator.index + 1 : booleanIterator.index), booleanBuffer.storage.begin());
        BooleanIterator booleanIterator3 = new BooleanIterator(booleanBuffer, booleanIterator.offset == -1 ? booleanIterator.index : booleanIterator.index * 8 + booleanIterator.offset);
        Algorithms.Copying.copy(forwardIterator, forwardIterator2, booleanIterator3);
        booleanIterator3.advance(n2);
        Algorithms.Copying.copy(booleanIterator, new BooleanIterator(this, this.size), booleanIterator3);
        this.copy(booleanBuffer);
    }

    public synchronized void insert(int n2, ForwardIterator forwardIterator, ForwardIterator forwardIterator2) {
        ArrayAdapter.checkIndex(n2, this.size + 1);
        this.insert(new BooleanIterator(this, n2), forwardIterator, forwardIterator2);
    }

    public synchronized void swap(BooleanBuffer booleanBuffer) {
        BooleanBuffer booleanBuffer2 = booleanBuffer;
        synchronized (booleanBuffer2) {
            int n2 = this.size;
            ByteBuffer byteBuffer = this.storage;
            this.size = booleanBuffer.size;
            this.storage = booleanBuffer.storage;
            booleanBuffer.size = n2;
            booleanBuffer.storage = byteBuffer;
            return;
        }
    }

    public synchronized Enumeration elements() {
        return this.begin();
    }

    public ForwardIterator start() {
        return this.begin();
    }

    public ForwardIterator finish() {
        return this.end();
    }

    public synchronized BooleanIterator begin() {
        return new BooleanIterator(this, 0);
    }

    public synchronized BooleanIterator end() {
        return new BooleanIterator(this, this.size);
    }

    public synchronized void trimToSize() {
        if (this.size() < this.capacity()) {
            this.copy(new BooleanBuffer(this.get()));
        }
    }

    public synchronized void ensureCapacity(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Attempt to reserve a negative size.");
        }
        if (this.capacity() < n2) {
            this.storage.ensureCapacity(n2 / 8 + 1);
        }
    }

    public synchronized Object popFront() {
        if (this.size() == 0) {
            throw new InvalidOperationException("BooleanBuffer is empty");
        }
        Object object = this.at(0);
        this.remove(0);
        return object;
    }

    public void pushFront(Object object) {
        this.insert(0, object);
    }

    public void pushFront(boolean bl) {
        this.insert(0, bl);
    }

    public int remove(Object object) {
        return this.remove(object, this.size());
    }

    public synchronized int remove(Object object, int n2) {
        boolean bl = (Boolean)object;
        int n3 = 0;
        while (n2 > 0) {
            int n4 = this.indexOf(bl);
            if (n4 < 0) break;
            --n2;
            ++n3;
            this.remove(n4);
        }
        return n3;
    }

    public synchronized int remove(int n2, int n3, Object object) {
        ((Boolean)object).booleanValue();
        if (n3 < n2) {
            return 0;
        }
        int n4 = this.size;
        ArrayAdapter.checkIndex(n2, n4);
        ArrayAdapter.checkIndex(n3, n4);
        BooleanIterator booleanIterator = new BooleanIterator(this, n2);
        BooleanIterator booleanIterator2 = new BooleanIterator(this, n3 + 1);
        BooleanIterator booleanIterator3 = (BooleanIterator)Algorithms.Removing.remove(booleanIterator, booleanIterator2, object);
        return this.remove(booleanIterator3.offset == -1 ? booleanIterator3.index : booleanIterator3.index * 8 + booleanIterator3.offset, n3);
    }

    public int replace(Object object, Object object2) {
        return this.replace((Boolean)object, (Boolean)object2);
    }

    public int replace(boolean bl, boolean bl2) {
        return this.replace(0, this.size() - 1, bl, bl2);
    }

    public int replace(int n2, int n3, Object object, Object object2) {
        if (n3 < n2) {
            return -1;
        }
        int n4 = this.size;
        ArrayAdapter.checkIndex(n2, n4);
        ArrayAdapter.checkIndex(n3, n4);
        return Algorithms.Replacing.replace(new BooleanIterator(this, n2), new BooleanIterator(this, n3 + 1), object, object2);
    }

    public synchronized int replace(int n2, int n3, boolean bl, boolean bl2) {
        return this.replace(n2, n3, new Boolean(bl), new Boolean(bl2));
    }

    public int count(Object object) {
        return Algorithms.Counting.count(this.begin(), this.end(), object);
    }

    public int count(boolean bl) {
        return this.count(new Boolean(bl));
    }

    public synchronized int count(int n2, int n3, Object object) {
        int n4;
        if (n3 < n2) {
            return -1;
        }
        int n5 = this.size;
        ArrayAdapter.checkIndex(n2, n5);
        ArrayAdapter.checkIndex(n3, n5);
        BooleanIterator booleanIterator = (BooleanIterator)Algorithms.Finding.find(new BooleanIterator(this, n2), new BooleanIterator(this, n3 + 1), object);
        int n6 = n4 = booleanIterator.offset == -1 ? booleanIterator.index : booleanIterator.index * 8 + booleanIterator.offset;
        if (n4 == n3 + 1) {
            return -1;
        }
        return n4;
    }

    public int count(int n2, int n3, boolean bl) {
        return this.count(n2, n3, new Boolean(bl));
    }

    public int indexOf(boolean bl) {
        return this.indexOf(0, this.size() - 1, bl);
    }

    public int indexOf(int n2, int n3, Object object) {
        int n4;
        if (n3 < n2) {
            return -1;
        }
        int n5 = this.size;
        ArrayAdapter.checkIndex(n2, n5);
        ArrayAdapter.checkIndex(n3, n5);
        BooleanIterator booleanIterator = (BooleanIterator)Algorithms.Finding.find(new BooleanIterator(this, n2), new BooleanIterator(this, n3 + 1), object);
        int n6 = n4 = booleanIterator.offset == -1 ? booleanIterator.index : booleanIterator.index * 8 + booleanIterator.offset;
        if (n4 == n3 + 1) {
            return -1;
        }
        return n4;
    }

    public synchronized int indexOf(int n2, int n3, boolean bl) {
        return this.indexOf(n2, n3, new Boolean(bl));
    }

    public synchronized void setSize(int n2) {
        if (this.size() > n2) {
            this.remove(n2, this.size() - 1);
            return;
        }
        if (this.size() < n2) {
            this.insert(this.size(), n2 - this.size(), false);
        }
    }

    public boolean contains(boolean bl) {
        return this.indexOf(bl) != -1;
    }

    private void insertAux(BooleanIterator booleanIterator, boolean bl) {
        if (this.size / 8 == this.storage.size()) {
            BooleanBuffer booleanBuffer = new BooleanBuffer(new ByteBuffer(new byte[ArrayAdapter.getNextSize(this.size)], false));
            Algorithms.Copying.copy(this.storage.begin(), new ByteIterator(this.storage, (booleanIterator.offset == -1 ? booleanIterator.index : booleanIterator.index * 8 + booleanIterator.offset) < this.size ? booleanIterator.index + 1 : booleanIterator.index), booleanBuffer.storage.begin());
            BooleanIterator booleanIterator2 = new BooleanIterator(booleanBuffer, booleanIterator.offset == -1 ? booleanIterator.index : booleanIterator.index * 8 + booleanIterator.offset);
            booleanIterator2.put(0, bl);
            booleanIterator2.advance();
            Algorithms.Copying.copy(booleanIterator, new BooleanIterator(this, this.size), booleanIterator2);
            this.copy(booleanBuffer);
            return;
        }
        Algorithms.Copying.copyBackward(booleanIterator, new BooleanIterator(this, this.size + 1), new BooleanIterator(this, this.size));
        booleanIterator.put(0, bl);
    }

    static final boolean asBoolean(Object object) {
        return (Boolean)object;
    }

    private final boolean atEnd() {
        return this.size / 8 == this.storage.size();
    }
}

