/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.treetable;

import com.klg.jclass.util.JCListenerList;
import com.klg.jclass.util.treetable.JCTreeTableModel;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeChildrenTable
implements TableModel,
Serializable {
    protected JCListenerList listeners = null;
    protected TreePath path = null;
    protected JCTreeTableModel treetable;

    public NodeChildrenTable(JCTreeTableModel jCTreeTableModel) {
        this.treetable = jCTreeTableModel;
    }

    public NodeChildrenTable(JCTreeTableModel jCTreeTableModel, TreePath treePath) {
        this(jCTreeTableModel);
        this.setParentPath(treePath);
    }

    public TreePath getParentPath() {
        return this.path;
    }

    public void setParentPath(TreePath treePath) {
        if (this.path == treePath) {
            return;
        }
        if (this.path != null && this.path.equals(treePath)) {
            return;
        }
        this.path = treePath;
        TableModelEvent tableModelEvent = new TableModelEvent(this);
        Enumeration<Object> enumeration = JCListenerList.elements(this.listeners);
        while (enumeration.hasMoreElements()) {
            TableModelListener tableModelListener = (TableModelListener)enumeration.nextElement();
            tableModelListener.tableChanged(tableModelEvent);
        }
    }

    public boolean isLeaf(int n2) {
        Object object = this.path.getLastPathComponent();
        return this.treetable.isLeaf(this.treetable.getChild(object, n2));
    }

    @Override
    public void addTableModelListener(TableModelListener tableModelListener) {
        this.listeners = JCListenerList.add(this.listeners, tableModelListener);
    }

    @Override
    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.listeners = JCListenerList.remove(this.listeners, tableModelListener);
    }

    @Override
    public Class<?> getColumnClass(int n2) {
        return this.treetable.getColumnClass(n2);
    }

    @Override
    public int getColumnCount() {
        return this.treetable.getColumnCount();
    }

    @Override
    public String getColumnName(int n2) {
        return this.treetable.getColumnName(n2);
    }

    @Override
    public int getRowCount() {
        if (this.path == null) {
            return 0;
        }
        return this.treetable.getChildCount(this.path.getLastPathComponent());
    }

    @Override
    public Object getValueAt(int n2, int n3) {
        Object object = this.path.getLastPathComponent();
        return this.treetable.getValueAt(this.treetable.getChild(object, n2), n3);
    }

    @Override
    public boolean isCellEditable(int n2, int n3) {
        Object object = this.path.getLastPathComponent();
        return this.treetable.isCellEditable(this.treetable.getChild(object, n2), n3);
    }

    @Override
    public void setValueAt(Object object, int n2, int n3) {
        Object object2 = this.path.getLastPathComponent();
        this.treetable.setValueAt(object, this.treetable.getChild(object2, n2), n3);
    }
}

