/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing.encode.page;

import com.klg.jclass.page.JCDocument;
import com.klg.jclass.page.JCFlow;
import com.klg.jclass.page.JCFrame;
import com.klg.jclass.page.JCPage;
import com.klg.jclass.page.JCUnit;
import com.klg.jclass.util.swing.encode.Encoder;
import com.klg.jclass.util.swing.encode.EncoderException;
import com.klg.jclass.util.swing.encode.EncoderProperties;
import com.klg.jclass.util.swing.encode.resources.LocaleBundle;
import java.awt.Component;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.ImageIcon;

public abstract class AbstractVectorEncoder
implements Encoder,
EncoderProperties {
    protected boolean hiddenSurfaces = false;
    protected String componentName = null;
    protected Image img = null;
    protected Component comp = null;

    public void encode(Image image, OutputStream outputStream) throws IOException, EncoderException {
        this.img = image;
        JCDocument jCDocument = this.createOutput(outputStream);
        JCFlow jCFlow = new JCFlow(jCDocument);
        jCFlow.getCurrentFrame().pasteImage(this.img, new JCUnit.Point());
        jCDocument.print();
    }

    public void encode(Component component, OutputStream outputStream) throws IOException, EncoderException {
        this.comp = component;
        JCDocument jCDocument = this.createOutput(outputStream);
        JCFlow jCFlow = new JCFlow(jCDocument);
        jCFlow.getCurrentFrame().pasteComponent(component, new JCUnit.Point());
        jCDocument.print();
    }

    public void setHiddenSurfaces(boolean bl) {
        this.hiddenSurfaces = bl;
    }

    public boolean hasHiddenSurfaces() {
        return this.hiddenSurfaces;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String string) {
        this.componentName = string;
    }

    protected abstract JCDocument createOutput(OutputStream var1) throws IOException, EncoderException;

    protected JCUnit.Dimension getObjectSize() throws EncoderException {
        JCUnit.Dimension dimension = null;
        if (this.img != null) {
            ImageIcon imageIcon = new ImageIcon(this.img);
            dimension = new JCUnit.Dimension(JCUnit.POINTS, imageIcon.getIconWidth(), imageIcon.getIconHeight());
        } else if (this.comp != null) {
            Rectangle rectangle = this.comp.getBounds();
            dimension = new JCUnit.Dimension(JCUnit.POINTS, rectangle.width, rectangle.height);
        } else {
            this.error(LocaleBundle.string("No object to encode"));
        }
        return dimension;
    }

    protected JCPage createTemplatePage(JCUnit.Dimension dimension) {
        JCPage jCPage = new JCPage("template", new JCUnit.Point(), dimension);
        jCPage.setPageType(1);
        jCPage.setFlowPageTemplate(jCPage);
        jCPage.setFlowSectionTemplate(jCPage);
        JCFrame jCFrame = new JCFrame("body", new JCUnit.Point(), dimension);
        jCPage.getFrameList().add(jCFrame);
        jCPage.getFlowFrameList().add(jCFrame);
        return jCPage;
    }

    protected void error(String string) throws EncoderException {
        throw new EncoderException(string);
    }
}

