/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing.encode;

import com.klg.jclass.util.swing.encode.AbstractImageEncoder;
import com.klg.jclass.util.swing.encode.EncoderException;
import com.klg.jclass.util.swing.encode.resources.LocaleBundle;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;

public class PNGEncoder
extends AbstractImageEncoder {
    protected long[] crc_table = null;

    public void saveImage(Image image, OutputStream outputStream) throws IOException, EncoderException {
        int n2;
        int n3;
        if (image == null) {
            this.error(LocaleBundle.string("PNG encoding error: Image is NULL."));
            return;
        }
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, image.getWidth(null), image.getHeight(null), false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            this.error(LocaleBundle.string("PNG encoding error: Unable to retrieve pixels from image."));
        }
        ColorModel colorModel = pixelGrabber.getColorModel();
        int n4 = colorModel.getPixelSize();
        int n5 = (int)Math.pow(2.0, n4);
        if (n4 < 8 || n4 > 32) {
            this.error(LocaleBundle.string("PNG encoding error: PNG method needs color mode to be between 8 and 32 bits."));
        }
        int[] nArray = null;
        byte[] byArray = null;
        if (n4 > 8) {
            nArray = (int[])pixelGrabber.getPixels();
        } else {
            byArray = (byte[])pixelGrabber.getPixels();
        }
        outputStream.write(PNGEncoder.byteFromInt(137));
        outputStream.write(PNGEncoder.byteFromInt(80));
        outputStream.write(PNGEncoder.byteFromInt(78));
        outputStream.write(PNGEncoder.byteFromInt(71));
        outputStream.write(PNGEncoder.byteFromInt(13));
        outputStream.write(PNGEncoder.byteFromInt(10));
        outputStream.write(PNGEncoder.byteFromInt(26));
        outputStream.write(PNGEncoder.byteFromInt(10));
        long l2 = this.start_crc();
        outputStream.write(PNGEncoder.bytesFromLong(13L));
        outputStream.write(PNGEncoder.byteFromChar('I'));
        outputStream.write(PNGEncoder.byteFromChar('H'));
        outputStream.write(PNGEncoder.byteFromChar('D'));
        outputStream.write(PNGEncoder.byteFromChar('R'));
        l2 = this.update_crc(l2, PNGEncoder.byteFromChar('I'));
        l2 = this.update_crc(l2, PNGEncoder.byteFromChar('H'));
        l2 = this.update_crc(l2, PNGEncoder.byteFromChar('D'));
        l2 = this.update_crc(l2, PNGEncoder.byteFromChar('R'));
        int n6 = image.getWidth(null);
        int n7 = image.getHeight(null);
        l2 = this.update_crc(l2, PNGEncoder.bytesFromLong(n6));
        l2 = this.update_crc(l2, PNGEncoder.bytesFromLong(n7));
        l2 = this.update_crc(l2, PNGEncoder.byteFromInt(8));
        l2 = n4 > 8 ? this.update_crc(l2, PNGEncoder.byteFromInt(6)) : this.update_crc(l2, PNGEncoder.byteFromInt(3));
        l2 = this.update_crc(l2, PNGEncoder.byteFromInt(0));
        l2 = this.update_crc(l2, PNGEncoder.byteFromInt(0));
        l2 = this.update_crc(l2, PNGEncoder.byteFromInt(0));
        outputStream.write(PNGEncoder.bytesFromLong(n6));
        outputStream.write(PNGEncoder.bytesFromLong(n7));
        outputStream.write(PNGEncoder.byteFromInt(8));
        if (n4 > 8) {
            outputStream.write(PNGEncoder.byteFromInt(6));
        } else {
            outputStream.write(PNGEncoder.byteFromInt(3));
        }
        outputStream.write(PNGEncoder.byteFromInt(0));
        outputStream.write(PNGEncoder.byteFromInt(0));
        outputStream.write(PNGEncoder.byteFromInt(0));
        outputStream.write(PNGEncoder.bytesFromLong(this.end_crc(l2)));
        if (n4 == 8) {
            l2 = this.start_crc();
            outputStream.write(PNGEncoder.bytesFromLong(n5 * 3));
            outputStream.write(PNGEncoder.byteFromChar('P'));
            outputStream.write(PNGEncoder.byteFromChar('L'));
            outputStream.write(PNGEncoder.byteFromChar('T'));
            outputStream.write(PNGEncoder.byteFromChar('E'));
            l2 = this.update_crc(l2, PNGEncoder.byteFromChar('P'));
            l2 = this.update_crc(l2, PNGEncoder.byteFromChar('L'));
            l2 = this.update_crc(l2, PNGEncoder.byteFromChar('T'));
            l2 = this.update_crc(l2, PNGEncoder.byteFromChar('E'));
            for (int i2 = 0; i2 < n5; ++i2) {
                n3 = PNGEncoder.byteFromInt(colorModel.getRed(i2));
                n2 = PNGEncoder.byteFromInt(colorModel.getGreen(i2));
                byte by = PNGEncoder.byteFromInt(colorModel.getBlue(i2));
                l2 = this.update_crc(l2, (byte)n3);
                l2 = this.update_crc(l2, (byte)n2);
                l2 = this.update_crc(l2, by);
                outputStream.write(n3);
                outputStream.write(n2);
                outputStream.write(by);
            }
            outputStream.write(PNGEncoder.bytesFromLong(this.end_crc(l2)));
        }
        byte[] byArray2 = n4 == 8 ? new byte[byArray.length + n7] : new byte[nArray.length * 4 + n7];
        n3 = n4 > 8 ? this.compress(byArray2, nArray, colorModel, n6, n7) : this.compress(byArray2, byArray, n6, n7);
        l2 = this.start_crc();
        outputStream.write(PNGEncoder.bytesFromLong(n3));
        outputStream.write(PNGEncoder.byteFromChar('I'));
        outputStream.write(PNGEncoder.byteFromChar('D'));
        outputStream.write(PNGEncoder.byteFromChar('A'));
        outputStream.write(PNGEncoder.byteFromChar('T'));
        l2 = this.update_crc(l2, PNGEncoder.byteFromChar('I'));
        l2 = this.update_crc(l2, PNGEncoder.byteFromChar('D'));
        l2 = this.update_crc(l2, PNGEncoder.byteFromChar('A'));
        l2 = this.update_crc(l2, PNGEncoder.byteFromChar('T'));
        outputStream.write(byArray2, 0, n3);
        for (n2 = 0; n2 < n3; ++n2) {
            l2 = this.update_crc(l2, byArray2[n2]);
        }
        outputStream.write(PNGEncoder.bytesFromLong(this.end_crc(l2)));
        l2 = this.start_crc();
        outputStream.write(PNGEncoder.bytesFromLong(0L));
        outputStream.write(PNGEncoder.byteFromChar('I'));
        outputStream.write(PNGEncoder.byteFromChar('E'));
        outputStream.write(PNGEncoder.byteFromChar('N'));
        outputStream.write(PNGEncoder.byteFromChar('D'));
        l2 = this.update_crc(l2, PNGEncoder.byteFromChar('I'));
        l2 = this.update_crc(l2, PNGEncoder.byteFromChar('E'));
        l2 = this.update_crc(l2, PNGEncoder.byteFromChar('N'));
        l2 = this.update_crc(l2, PNGEncoder.byteFromChar('D'));
        outputStream.write(PNGEncoder.bytesFromLong(this.end_crc(l2)));
    }

    public int compress(byte[] byArray, int[] nArray, ColorModel colorModel, int n2, int n3) throws EncoderException {
        Deflater deflater = new Deflater(-1);
        byte[] byArray2 = new byte[nArray.length * 4 + n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = i2 * (n2 * 4 + 1);
            byArray2[n4++] = PNGEncoder.byteFromInt(0);
            for (int i3 = 0; i3 < n2 * 4; i3 += 4) {
                int n5 = nArray[i2 * n2 + (int)Math.floor(i3 / 4)];
                byArray2[n4++] = (byte)colorModel.getRed(n5);
                byArray2[n4++] = (byte)colorModel.getGreen(n5);
                byArray2[n4++] = (byte)colorModel.getBlue(n5);
                byArray2[n4++] = (byte)colorModel.getAlpha(n5);
            }
        }
        deflater.setInput(byArray2, 0, byArray2.length);
        deflater.finish();
        deflater.deflate(byArray);
        if (!deflater.finished()) {
            this.error(LocaleBundle.string("PNG encoding error: Deflater could not compress image data."));
        }
        PNGEncoder.bytesFromLong(deflater.getAdler());
        return deflater.getTotalOut();
    }

    public int compress(byte[] byArray, byte[] byArray2, int n2, int n3) throws EncoderException {
        Deflater deflater = new Deflater(-1);
        byte[] byArray3 = new byte[byArray2.length + n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            byArray3[i2 * (n2 + 1)] = PNGEncoder.byteFromInt(0);
            for (int i3 = 0; i3 < n2; ++i3) {
                byArray3[i2 * (n2 + 1) + i3 + 1] = byArray2[i2 * n2 + i3];
            }
        }
        deflater.setInput(byArray3, 0, byArray3.length);
        deflater.finish();
        deflater.deflate(byArray);
        if (!deflater.finished()) {
            this.error(LocaleBundle.string("PNG encoding error: Deflater could not compress image data."));
        }
        return deflater.getTotalOut();
    }

    protected void make_crc_table() {
        this.crc_table = new long[256];
        for (int i2 = 0; i2 < 256; ++i2) {
            long l2 = i2;
            for (int i3 = 0; i3 < 8; ++i3) {
                if ((l2 & 1L) != 0L) {
                    l2 = 0xEDB88320L ^ l2 >> 1;
                    continue;
                }
                l2 >>= 1;
            }
            this.crc_table[i2] = l2;
        }
    }

    protected long start_crc() {
        return 0xFFFFFFFFL;
    }

    protected long end_crc(long l2) {
        return l2 ^ 0xFFFFFFFFL;
    }

    protected long update_crc(long l2, byte[] byArray) {
        long l3 = l2;
        for (byte by : byArray) {
            l3 = this.update_crc(l3, by);
        }
        return l3;
    }

    protected long update_crc(long l2, byte by) {
        if (this.crc_table == null) {
            this.make_crc_table();
        }
        return this.crc_table[(int)((l2 ^ (long)by) & 0xFFL)] ^ l2 >> 8;
    }
}

