/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing.encode;

import com.klg.jclass.util.swing.encode.AbstractImageEncoder;
import com.klg.jclass.util.swing.encode.EncoderException;
import com.klg.jclass.util.swing.encode.resources.LocaleBundle;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;

public class JPEGEncoder
extends AbstractImageEncoder {
    public float quality = 1.0f;

    public void saveImage(Image image, OutputStream outputStream) throws IOException, EncoderException {
        if (image == null) {
            this.error(LocaleBundle.string("JPEG encoding error: Image is NULL."));
            return;
        }
        BufferedImage bufferedImage = image instanceof BufferedImage && ((BufferedImage)image).getType() != 2 ? (BufferedImage)image : JPEGEncoder.makeBufferedImage(image, 1);
        try {
            JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)outputStream);
            JPEGEncodeParam jPEGEncodeParam = jPEGImageEncoder.getDefaultJPEGEncodeParam(bufferedImage);
            jPEGEncodeParam.setQuality(this.quality, false);
            jPEGImageEncoder.setJPEGEncodeParam(jPEGEncodeParam);
            jPEGImageEncoder.encode(bufferedImage);
        }
        catch (Exception exception) {
            this.error(LocaleBundle.string("JPEG encoding error : ") + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public float getQuality() {
        return this.quality;
    }

    public void setQuality(float f2) {
        if (f2 < 0.0f) {
            f2 = 0.0f;
        } else if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        this.quality = f2;
    }
}

