/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing.beans;

import com.klg.jclass.beans.AbstractBeanEditor;
import com.klg.jclass.util.calendar.DateTimeEditor;
import com.klg.jclass.util.swing.JCExitFrame;
import com.klg.jclass.util.value.CalendarValueModel;
import com.klg.jclass.util.value.JCValueEvent;
import com.klg.jclass.util.value.JCValueListener;
import java.awt.Component;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class DateTimeBeanEditor
extends AbstractBeanEditor
implements JCValueListener {
    public static final String DATETIME_HELP = "DateTimeEditor";
    protected Date date;
    protected CalendarValueModel model;
    protected DateTimeEditor dateTimeEditor;
    protected boolean updatingModel = false;

    public DateTimeBeanEditor() {
        super("com.klg.jclass.util.swing.beans.resources.LocaleInfo", DATETIME_HELP, "Date Time Editor");
    }

    public Component getEditorComponent() {
        JPanel jPanel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(jPanel, 1);
        jPanel.setLayout(boxLayout);
        this.dateTimeEditor = new DateTimeEditor();
        Calendar calendar = Calendar.getInstance();
        if (this.date != null) {
            calendar.setTime(this.date);
        }
        this.model = new CalendarValueModel(calendar);
        this.model.addValueListener(this);
        this.dateTimeEditor.setCalendarModel(this.model);
        jPanel.add(this.dateTimeEditor);
        return jPanel;
    }

    public String getJavaInitializationString() {
        String string = "null";
        if (this.date != null) {
            string = "new java.util.Date(" + this.date.getTime() + "l)";
        }
        return string;
    }

    public Object getValue() {
        return this.date == null ? null : this.date.clone();
    }

    protected String getValueAsText() {
        String string = "none";
        if (this.date != null) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, Locale.getDefault());
            string = dateFormat.format(this.date);
        }
        return string;
    }

    public void setValue(Object object) {
        this.date = object == null ? null : (Date)((Date)object).clone();
        if (this.model != null) {
            this.updatingModel = true;
            Calendar calendar = Calendar.getInstance();
            if (this.date != null) {
                calendar.setTime(this.date);
            }
            this.model.setValue(calendar);
            this.updatingModel = false;
        }
    }

    public void valueChanging(JCValueEvent jCValueEvent) {
    }

    public void valueChanged(JCValueEvent jCValueEvent) {
        if (this.updatingModel) {
            return;
        }
        Calendar calendar = (Calendar)jCValueEvent.getNewValue();
        this.date = calendar == null ? null : calendar.getTime();
        this.support.firePropertyChange(null, null, null);
    }

    public static void main(String[] stringArray) {
        JCExitFrame jCExitFrame = new JCExitFrame();
        jCExitFrame.getContentPane().add(new DateTimeEditor());
        jCExitFrame.pack();
        jCExitFrame.setVisible(true);
    }
}

