/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing;

import com.klg.jclass.util.graphics.JCFontMetrics;
import com.klg.jclass.util.label.JCLabel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class JCSwingUtilities {
    public static void setEnabled(Component component, boolean bl) {
        if (component instanceof Container) {
            Component[] componentArray;
            for (Component component2 : componentArray = ((Container)component).getComponents()) {
                JCSwingUtilities.setEnabled(component2, bl);
            }
        }
        component.setEnabled(bl);
    }

    public static Dimension getPreferredSizeFromGraphics(JComponent jComponent, Graphics graphics, boolean bl) {
        if (jComponent == null) {
            return new Dimension(0, 0);
        }
        if (graphics == null) {
            return jComponent.getPreferredSize();
        }
        String string = jComponent.getUIClassID();
        UIDefaults uIDefaults = UIManager.getDefaults();
        String string2 = (String)uIDefaults.get(string);
        Class<? extends ComponentUI> clazz = null;
        if (string2 != null) {
            clazz = uIDefaults.getUIClass(string);
        }
        Class<?> clazz2 = null;
        if (!bl) {
            if (jComponent instanceof JLabel) {
                clazz2 = ((JLabel)jComponent).getUI().getClass();
            } else if (jComponent instanceof JButton) {
                clazz2 = ((JButton)jComponent).getUI().getClass();
            }
        }
        if (!(clazz2 != null && clazz == clazz2 || jComponent instanceof JCLabel)) {
            return jComponent.getPreferredSize();
        }
        if (jComponent instanceof JLabel) {
            return JCSwingUtilities.getLabelPSFromGraphics((JLabel)jComponent, graphics);
        }
        if (jComponent instanceof JButton) {
            return JCSwingUtilities.getButtonPSFromGraphics((JButton)jComponent, graphics);
        }
        return jComponent.getPreferredSize();
    }

    public static Dimension getLabelPSFromGraphics(JLabel jLabel, Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics(jLabel.getFont());
        if (fontMetrics instanceof JCFontMetrics) {
            fontMetrics = ((JCFontMetrics)((Object)fontMetrics)).getEncoderFontMetrics();
        }
        Insets insets = jLabel.getInsets();
        int n2 = insets.left + insets.right;
        int n3 = insets.top + insets.bottom;
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        Rectangle rectangle3 = new Rectangle(n2, n3, Short.MAX_VALUE, Short.MAX_VALUE);
        SwingUtilities.layoutCompoundLabel(jLabel, fontMetrics, jLabel.getText(), jLabel.getIcon(), jLabel.getVerticalAlignment(), jLabel.getHorizontalAlignment(), jLabel.getVerticalTextPosition(), jLabel.getHorizontalTextPosition(), rectangle3, rectangle2, rectangle, jLabel.getIconTextGap());
        int n4 = Math.min(rectangle2.x, rectangle.x);
        int n5 = Math.max(rectangle2.x + rectangle2.width, rectangle.x + rectangle.width);
        int n6 = Math.min(rectangle2.y, rectangle.y);
        int n7 = Math.max(rectangle2.y + rectangle2.height, rectangle.y + rectangle.height);
        return new Dimension(n5 - n4 + n2, n7 - n6 + n3);
    }

    public static Dimension getButtonPSFromGraphics(JButton jButton, Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics(jButton.getFont());
        if (fontMetrics instanceof JCFontMetrics) {
            fontMetrics = ((JCFontMetrics)((Object)fontMetrics)).getEncoderFontMetrics();
        }
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        Rectangle rectangle3 = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        String string = jButton.getText();
        int n2 = string == null ? 0 : jButton.getIconTextGap();
        SwingUtilities.layoutCompoundLabel(jButton, fontMetrics, string, jButton.getIcon(), jButton.getVerticalAlignment(), jButton.getHorizontalAlignment(), jButton.getVerticalTextPosition(), jButton.getHorizontalTextPosition(), rectangle3, rectangle2, rectangle, n2);
        Rectangle rectangle4 = rectangle2.union(rectangle);
        Insets insets = jButton.getInsets();
        int n3 = insets.left + insets.right;
        int n4 = insets.top + insets.bottom;
        rectangle4.width += n3;
        rectangle4.height += n4;
        return new Dimension(rectangle4.width, rectangle4.height);
    }

    public static String layoutCompoundLabel(JComponent jComponent, FontMetrics fontMetrics, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        int n2;
        Icon icon;
        String string;
        int n3;
        int n4;
        int n5;
        int n6;
        if (!(jComponent instanceof JLabel) && !(jComponent instanceof AbstractButton)) {
            return null;
        }
        if (rectangle == null || rectangle2 == null || rectangle3 == null) {
            throw new IllegalArgumentException("Cannot pass in null rectangles");
        }
        if (jComponent instanceof JLabel) {
            JLabel jLabel = (JLabel)jComponent;
            n6 = jLabel.getHorizontalAlignment();
            n5 = jLabel.getVerticalAlignment();
            n4 = jLabel.getHorizontalTextPosition();
            n3 = jLabel.getVerticalTextPosition();
            string = jLabel.getText();
            icon = jLabel.getIcon();
            n2 = jLabel.getIconTextGap();
        } else {
            AbstractButton abstractButton = (AbstractButton)jComponent;
            n6 = abstractButton.getHorizontalAlignment();
            n5 = abstractButton.getVerticalAlignment();
            n4 = abstractButton.getHorizontalTextPosition();
            n3 = abstractButton.getVerticalTextPosition();
            string = abstractButton.getText();
            icon = abstractButton.getIcon();
            n2 = string == null ? 0 : abstractButton.getIconTextGap();
        }
        return SwingUtilities.layoutCompoundLabel(jComponent, fontMetrics, string, icon, n5, n6, n3, n4, rectangle, rectangle2, rectangle3, n2);
    }
}

