/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing;

import java.awt.Color;
import java.awt.Graphics;

public class JCBorder {
    public static final int NONE = 0;
    public static final int ETCHED_IN = 1;
    public static final int ETCHED_OUT = 2;
    public static final int IN = 3;
    public static final int OUT = 4;
    public static final int PLAIN = 5;
    public static final int FRAME_IN = 6;
    public static final int FRAME_OUT = 7;
    public static final int CONTROL_IN = 8;
    public static final int CONTROL_OUT = 9;
    public static final int NUM_BORDER_STYLES = 10;
    public static final String[] border_strings = new String[]{"None", "Etched_In", "Etched_Out", "In", "Out", "Plain", "Frame_In", "Frame_Out", "Control_In", "Control_Out"};
    public static final int[] border_values = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    private static final Color WHITE_BRIGHTER = new Color(200, 200, 200);
    private static final Color WHITE_DARKER = new Color(140, 140, 140);
    private static final Color BLACK_BRIGHTER = new Color(125, 125, 125);
    private static final Color BLACK_DARKER = new Color(75, 75, 75);
    private static final double FACTOR = 0.5;

    public static void drawTopLines(Graphics graphics, int n2, int n3, int n4, int n5, int n6, Color color) {
        graphics.setColor(color);
        for (int i2 = 0; i2 < n2; ++i2) {
            graphics.drawLine(n3 + i2, n4 + i2, n3 + n5 - (i2 + 1), n4 + i2);
            graphics.drawLine(n3 + i2, n4 + i2 + 1, n3 + i2, n4 + n6 - (i2 + 1));
        }
    }

    public static void drawBottomLines(Graphics graphics, int n2, int n3, int n4, int n5, int n6, Color color) {
        graphics.setColor(color);
        for (int i2 = 1; i2 <= n2; ++i2) {
            graphics.drawLine(n3 + i2 - 1, n4 + n6 - i2, n3 + n5 - i2, n4 + n6 - i2);
            graphics.drawLine(n3 + n5 - i2, n4 + i2 - 1, n3 + n5 - i2, n4 + n6 - i2);
        }
    }

    public static void drawNormal(Graphics graphics, int n2, int n3, int n4, int n5, int n6, Color color, Color color2) {
        JCBorder.drawTopLines(graphics, n2, n3, n4, n5, n6, color);
        JCBorder.drawBottomLines(graphics, n2, n3, n4, n5, n6, color2);
    }

    public static Color brighter(Color color) {
        if (color.equals(Color.white)) {
            return WHITE_BRIGHTER;
        }
        if (color.equals(Color.black)) {
            return BLACK_BRIGHTER;
        }
        int n2 = color.getRed();
        n2 += (int)((double)(255 - n2) * 0.5);
        int n3 = color.getBlue();
        n3 += (int)((double)(255 - n3) * 0.5);
        int n4 = color.getGreen();
        n4 += (int)((double)(255 - n4) * 0.5);
        return new Color(Math.min(n2, 255), Math.min(n4, 255), Math.min(n3, 255));
    }

    public static Color darker(Color color) {
        if (color.equals(Color.white)) {
            return WHITE_DARKER;
        }
        if (color.equals(Color.black)) {
            return BLACK_DARKER;
        }
        return color.darker();
    }

    public static void draw(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, Color color, Color color2) {
        JCBorder.draw(graphics, n2, n3, n4, n5, n6, n7, JCBorder.brighter(color), JCBorder.darker(color), color2);
    }

    public static void draw(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, Color color, Color color2, Color color3) {
        int n8 = n3 % 2;
        int n9 = n8 == 0 ? n3 / 2 : n3 / 2 + 1;
        int n10 = n3 - n9;
        Color color4 = graphics.getColor();
        switch (n2) {
            case 5: {
                JCBorder.drawNormal(graphics, n3, n4, n5, n6, n7, color3, color3);
                break;
            }
            case 3: {
                JCBorder.drawNormal(graphics, n3, n4, n5, n6, n7, color2, color);
                break;
            }
            case 4: {
                JCBorder.drawNormal(graphics, n3, n4, n5, n6, n7, color, color2);
                break;
            }
            case 8: {
                if (n3 == 2) {
                    JCBorder.drawNormal(graphics, 1, n4 + 1, n5 + 1, n6 - 2, n7 - 2, Color.black, color);
                    JCBorder.drawNormal(graphics, 1, n4, n5, n6, n7, color2, JCBorder.brighter(color));
                    break;
                }
                JCBorder.drawNormal(graphics, n3, n4, n5, n6, n7, color2, color);
                break;
            }
            case 9: {
                if (n3 == 2) {
                    JCBorder.drawNormal(graphics, 1, n4, n5, n6, n7, JCBorder.brighter(color), color2);
                    JCBorder.drawNormal(graphics, 1, n4 + 1, n5 + 1, n6 - 2, n7 - 2, color, Color.black);
                    break;
                }
                JCBorder.drawNormal(graphics, n3, n4, n5, n6, n7, color, color2);
                break;
            }
            case 1: {
                JCBorder.drawNormal(graphics, n9, n4, n5, n6, n7, color2, color);
                JCBorder.drawNormal(graphics, n10, n4 + n9, n5 + n9, n6 - n3 - n8, n7 - n3 - n8, color, color2);
                break;
            }
            case 2: {
                JCBorder.drawNormal(graphics, n9, n4, n5, n6, n7, color, color2);
                JCBorder.drawNormal(graphics, n10, n4 + n9, n5 + n9, n6 - n3 - n8, n7 - n3 - n8, color2, color);
                break;
            }
            case 7: {
                JCBorder.drawNormal(graphics, n3, n4, n5, n6, n7, color, color2);
                JCBorder.drawNormal(graphics, n3 - 1, n4, n5, n6, n7, color3, color3);
                break;
            }
            case 6: {
                JCBorder.drawNormal(graphics, n3, n4, n5, n6, n7, color2, color);
                JCBorder.drawNormal(graphics, n3 - 1, n4, n5, n6, n7, color3, color3);
                break;
            }
        }
        graphics.setColor(color4);
    }
}

