/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.style;

import com.klg.jclass.util.style.JCStyle;
import com.klg.jclass.util.style.resources.LocaleBundle;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.text.MessageFormat;
import java.util.Arrays;

public class JCLineStyle
extends JCStyle
implements Cloneable {
    public static final int NONE = 0;
    public static final int SOLID = 1;
    public static final int LONG_DASH = 2;
    public static final int SHORT_DASH = 3;
    public static final int LSL_DASH = 4;
    public static final int DASH_DOT = 5;
    public static final int CUSTOM = 6;
    public static final int DOTTED = 7;
    public static final int LONG_DASH_FINE = 8;
    public static final int SHORT_DASH_FINE = 9;
    public static final int LSL_DASH_FINE = 10;
    public static final int DASH_DOT_FINE = 11;
    public static final float[] LONG_DASH_ARRAY = new float[]{10.0f, 10.0f};
    public static final float[] SHORT_DASH_ARRAY = new float[]{5.0f, 10.0f};
    public static final float[] LSL_DASH_ARRAY = new float[]{10.0f, 10.0f, 5.0f, 10.0f};
    public static final float[] DASH_DOT_ARRAY = new float[]{10.0f, 10.0f, 1.0f, 10.0f};
    public static final float[] DOTTED_ARRAY = new float[]{1.0f, 1.0f};
    public static final float[] LONG_DASH_FINE_ARRAY = new float[]{5.0f, 1.0f};
    public static final float[] SHORT_DASH_FINE_ARRAY = new float[]{2.0f, 1.0f};
    public static final float[] LSL_DASH_FINE_ARRAY = new float[]{5.0f, 1.0f, 2.0f, 1.0f};
    public static final float[] DASH_DOT_FINE_ARRAY = new float[]{2.0f, 1.0f, 1.0f, 1.0f};
    public static final float[] LEGEND_LONG_DASH_ARRAY = new float[]{5.0f, 5.0f};
    public static final float[] LEGEND_SHORT_DASH_ARRAY = new float[]{2.5f, 5.0f};
    public static final float[] LEGEND_LSL_DASH_ARRAY = new float[]{5.0f, 5.0f, 2.5f, 5.0f};
    public static final float[] LEGEND_DASH_DOT_ARRAY = new float[]{5.0f, 5.0f, 1.0f, 5.0f};
    protected int join = 0;
    protected int cap = 0;
    protected int pattern = 1;
    protected int width = 1;
    protected int colorIndex;
    protected Color color = null;
    protected float[] dashArray = null;
    protected float[] legendDashArray = null;
    protected int[] xp = null;
    protected int[] yp = null;

    public JCLineStyle(int n2, Color color, int n3) {
        this.width = this.checkWidth(n2);
        this.color = color;
        this.pattern = this.checkPattern(n3);
        this.join = 0;
        this.cap = 0;
        this.updateDashArray();
    }

    public JCLineStyle(int n2, Color color, int n3, int n4, int n5) {
        this(n2, color, n3, n4, n5, null, null);
    }

    public JCLineStyle(int n2, Color color, int n3, int n4, int n5, float[] fArray, float[] fArray2) {
        this.width = this.checkWidth(n2);
        this.color = color;
        this.pattern = this.checkPattern(n3);
        this.cap = this.checkCap(n4);
        this.join = this.checkJoin(n5);
        this.dashArray = fArray;
        this.legendDashArray = fArray2 != null ? fArray2 : fArray;
        this.updateDashArray();
    }

    public boolean updateGraphics(Graphics graphics) {
        return this.updateGraphics(graphics, -1);
    }

    public boolean updateGraphics(Graphics graphics, int n2) {
        if (this.pattern == 0 || this.width <= 0) {
            return false;
        }
        if (this.color != null && !graphics.getColor().equals(this.color)) {
            graphics.setColor(this.color);
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.pattern == 1 || this.dashArray == null) {
            graphics2D.setStroke(new BasicStroke(this.width, this.cap, this.join));
        } else if (n2 > 0) {
            float f22;
            float f3 = 0.0f;
            for (float f22 : this.dashArray) {
                f3 += f22;
            }
            f3 += this.dashArray[0];
            float[] fArray = new float[this.dashArray.length + 1];
            int n3 = 0;
            for (int i2 = 0; i2 < fArray.length; ++i2) {
                f22 = i2 == fArray.length - 1 ? this.dashArray[0] : this.dashArray[i2];
                float f4 = (float)Math.floor((float)n2 / f3 * f22);
                if (!((double)f4 < 1.0)) continue;
                ++n3;
            }
            float f5 = f3 - (float)n3;
            f22 = (float)n2 - (float)n3;
            for (int i3 = 0; i3 < fArray.length; ++i3) {
                float f6 = i3 == fArray.length - 1 ? this.dashArray[0] : this.dashArray[i3];
                float f7 = (float)Math.floor((float)n2 / f3 * f6);
                f7 = (double)f7 < 1.0 ? 1.0f : f22 / f5 * f6;
                fArray[i3] = f7;
            }
            graphics2D.setStroke(new BasicStroke(this.width, this.cap, this.join, 10.0f, fArray, 0.0f));
        } else {
            graphics2D.setStroke(new BasicStroke(this.width, this.cap, this.join, 10.0f, this.dashArray, 0.0f));
        }
        return true;
    }

    public void resetGraphics(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setStroke(new BasicStroke(1.0f));
    }

    public void draw(Graphics graphics, int n2, int n3, int n4, int n5) {
        this.draw(graphics, n2, n3, n4, n5, null);
    }

    public void draw(Graphics graphics, int n2, int n3, int n4, int n5, Color color) {
        if (!this.updateGraphics(graphics)) {
            return;
        }
        if (color != null && !graphics.getColor().equals(color)) {
            graphics.setColor(color);
        }
        this.drawLine(graphics, n2, n3, n4, n5);
        this.resetGraphics(graphics);
    }

    public void drawLine(Graphics graphics, int n2, int n3, int n4, int n5) {
        graphics.drawLine(n2, n3, n4, n5);
    }

    public void drawLine(Graphics graphics, double d2, double d3, double d4, double d5) {
        if (this.updateGraphics(graphics)) {
            ((Graphics2D)graphics).draw(new Line2D.Double(d2, d3, d4, d5));
        }
    }

    public void drawShape(Graphics graphics, Shape shape) {
        if (this.updateGraphics(graphics)) {
            ((Graphics2D)graphics).draw(shape);
            this.resetGraphics(graphics);
        }
    }

    public void drawSquaredLine(Graphics graphics, int n2, int n3, int n4, int n5, boolean bl, int n6, int n7, int n8) {
        if (this.width == 1) {
            graphics.drawLine(n2, n3, n4, n5);
        } else if (n2 == n4) {
            int n9 = Math.min(n3, n5);
            int n10 = Math.abs(n5 - n3);
            if (!bl) {
                graphics.fillRect(n2 - this.width / 2, n9, this.width, n10 + 1);
            } else {
                int n11 = this.width;
                int n12 = n2 - this.width / 2;
                if (n12 < n7) {
                    n11 -= n7 - n12;
                    n12 = n7;
                } else if (n12 + n11 > n8) {
                    n11 -= n12 + n11 - n8;
                }
                graphics.fillRect(n12, n9, n11, n10 + 1);
            }
        } else if (n3 == n5) {
            int n13 = Math.min(n2, n4);
            int n14 = Math.abs(n4 - n2);
            if (!bl) {
                int n15 = this.width;
                int n16 = n3 - this.width / 2;
                if (n16 < n7) {
                    n15 -= n7 - n16;
                    n16 = n7;
                } else if (n16 + n15 > n8) {
                    n15 -= n16 + n15 - n8;
                }
                graphics.fillRect(n13, n16, n14, n15);
            } else {
                graphics.fillRect(n13, n3 - this.width / 2, n14, this.width);
            }
        } else {
            if (this.xp == null || this.yp == null) {
                this.xp = new int[4];
                this.yp = new int[4];
            }
            if (!bl) {
                int n17 = this.width / 2;
                int n18 = (this.width + 1) / 2;
                this.xp[0] = n2;
                this.yp[0] = n3 + n17;
                this.xp[1] = n4;
                this.yp[1] = n5 + n17;
                this.xp[2] = n4;
                this.yp[2] = n5 - n18;
                this.xp[3] = n2;
                this.yp[3] = n3 - n18;
                for (int i2 = 0; i2 < 4; ++i2) {
                    int n19 = 0;
                    if (i2 == 1 || i2 == 2) {
                        n19 = n6;
                    }
                    if (this.yp[i2] < n7 + n19) {
                        this.yp[i2] = n7 + n19;
                        continue;
                    }
                    if (this.yp[i2] <= n8 + n19) continue;
                    this.yp[i2] = n8 + n19;
                }
            } else {
                int n20 = this.width / 2;
                int n21 = (this.width + 1) / 2;
                this.xp[0] = n2 + n20;
                this.yp[0] = n3;
                this.xp[1] = n4 + n20;
                this.yp[1] = n5 + 1;
                this.xp[2] = n4 - n21;
                this.yp[2] = n5 + 1;
                this.xp[3] = n2 - n21;
                this.yp[3] = n3;
                for (int i3 = 0; i3 < 4; ++i3) {
                    int n22 = 0;
                    if (i3 == 1 || i3 == 2) {
                        n22 = n6;
                    }
                    if (this.xp[i3] < n7 + n22) {
                        this.xp[i3] = n7 + n22;
                        continue;
                    }
                    if (this.xp[i3] < n8 + n22) continue;
                    this.xp[i3] = n8 + n22;
                }
            }
            graphics.fillPolygon(this.xp, this.yp, 4);
        }
    }

    public void drawRect(Graphics graphics, int n2, int n3, int n4, int n5) {
        if (this.updateGraphics(graphics)) {
            graphics.drawRect(n2, n3, n4, n5);
            this.resetGraphics(graphics);
        }
    }

    public void fillRect(Graphics graphics, int n2, int n3, int n4, int n5) {
        if (this.updateGraphics(graphics)) {
            graphics.fillRect(n2, n3, n4, n5);
            this.resetGraphics(graphics);
        }
    }

    public void drawCircle(Graphics graphics, int n2, int n3, int n4) {
        if (this.updateGraphics(graphics)) {
            int n5 = 2 * n4;
            graphics.drawArc(n2 - n4, n3 - n4, n5, n5, 0, 360);
            this.resetGraphics(graphics);
        }
    }

    public void drawArc(Graphics graphics, double d2, double d3, double d4, double d5, double d6, double d7) {
        if (this.updateGraphics(graphics)) {
            ((Graphics2D)graphics).draw(new Arc2D.Double(d2, d3, d4, d5, d6, d7, 0));
        }
    }

    public int getPattern() {
        return this.pattern;
    }

    public void setPattern(int n2) {
        if (n2 == this.pattern) {
            return;
        }
        this.pattern = this.checkPattern(n2);
        this.updateDashArray();
        this.setChanged(true, 17);
    }

    protected int checkPattern(int n2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            default: {
                String string = LocaleBundle.string("Not linestyle enum");
                throw new IllegalArgumentException(string);
            }
        }
        return n2;
    }

    public void setPattern(float[] fArray, float[] fArray2) {
        this.pattern = 6;
        this.dashArray = fArray;
        this.legendDashArray = fArray2 != null ? fArray2 : fArray;
        this.setChanged(true, 17);
    }

    public float[] getCustomPatternArray() {
        return this.dashArray;
    }

    public float[] getCustomLegendPatternArray() {
        return this.legendDashArray;
    }

    protected void updateDashArray() {
        switch (this.pattern) {
            case 0: {
                this.dashArray = null;
                this.legendDashArray = null;
                break;
            }
            case 1: {
                this.dashArray = null;
                this.legendDashArray = null;
                break;
            }
            case 2: {
                this.dashArray = LONG_DASH_ARRAY;
                this.legendDashArray = LONG_DASH_ARRAY;
                break;
            }
            case 3: {
                this.dashArray = SHORT_DASH_ARRAY;
                this.legendDashArray = SHORT_DASH_ARRAY;
                break;
            }
            case 4: {
                this.dashArray = LSL_DASH_ARRAY;
                this.legendDashArray = LSL_DASH_ARRAY;
                break;
            }
            case 5: {
                this.dashArray = DASH_DOT_ARRAY;
                this.legendDashArray = DASH_DOT_ARRAY;
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                this.dashArray = DOTTED_ARRAY;
                this.legendDashArray = DOTTED_ARRAY;
                break;
            }
            case 8: {
                this.dashArray = LONG_DASH_FINE_ARRAY;
                this.legendDashArray = LONG_DASH_FINE_ARRAY;
                break;
            }
            case 9: {
                this.dashArray = SHORT_DASH_FINE_ARRAY;
                this.legendDashArray = SHORT_DASH_FINE_ARRAY;
                break;
            }
            case 10: {
                this.dashArray = LSL_DASH_FINE_ARRAY;
                this.legendDashArray = LSL_DASH_FINE_ARRAY;
                break;
            }
            case 11: {
                this.dashArray = DASH_DOT_FINE_ARRAY;
                this.legendDashArray = DASH_DOT_FINE_ARRAY;
                break;
            }
            default: {
                this.dashArray = null;
                this.legendDashArray = null;
            }
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n2) {
        if (this.width == n2) {
            return;
        }
        this.width = this.checkWidth(n2);
        this.setChanged(true, 18);
    }

    protected int checkWidth(int n2) {
        if (n2 < 0) {
            String string = LocaleBundle.string("Invalid line width");
            Object[] objectArray = new Object[]{new Integer(n2)};
            throw new IllegalArgumentException(MessageFormat.format(string, objectArray));
        }
        return n2;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (this.color == color) {
            return;
        }
        this.color = color;
        this.setChanged(true, 17);
    }

    public int getColorIndex() {
        return this.colorIndex;
    }

    public int getJoin() {
        return this.join;
    }

    public void setJoin(int n2) {
        if (n2 == this.join) {
            return;
        }
        this.join = this.checkJoin(n2);
        this.setChanged(true, 17);
    }

    protected int checkJoin(int n2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                String string = LocaleBundle.string("Illegal join value");
                throw new IllegalArgumentException(string);
            }
        }
        return n2;
    }

    public int getCap() {
        return this.cap;
    }

    public void setCap(int n2) {
        if (n2 == this.cap) {
            return;
        }
        this.cap = this.checkCap(n2);
        this.setChanged(true, 17);
    }

    protected int checkCap(int n2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                String string = LocaleBundle.string("Illegal cap value");
                throw new IllegalArgumentException(string);
            }
        }
        return n2;
    }

    private boolean isSameColor(Color color) {
        return this.color == null ? color == null : this.color.equals(color);
    }

    public boolean equals(Object object) {
        JCLineStyle jCLineStyle;
        boolean bl = false;
        if (object != null && object.getClass().equals(this.getClass()) && (this == (jCLineStyle = (JCLineStyle)object) || jCLineStyle.getJoin() == this.join && jCLineStyle.getCap() == this.cap && jCLineStyle.getPattern() == this.pattern && jCLineStyle.getWidth() == this.width && this.isSameColor(jCLineStyle.getColor()) && Arrays.equals(jCLineStyle.getCustomPatternArray(), this.dashArray) && Arrays.equals(jCLineStyle.getCustomLegendPatternArray(), this.legendDashArray))) {
            bl = true;
        }
        return bl;
    }

    public int hashCode() {
        int n2 = 17;
        int n3 = this.color == null ? 0 : this.color.hashCode();
        n2 = 37 * n2 + this.join;
        n2 = 37 * n2 + this.cap;
        n2 = 37 * n2 + this.pattern;
        n2 = 37 * n2 + this.width;
        n2 = 37 * n2 + n3;
        n2 = 37 * n2 + Arrays.hashCode(this.dashArray);
        n2 = 37 * n2 + Arrays.hashCode(this.legendDashArray);
        return n2;
    }

    public Object clone() throws CloneNotSupportedException {
        JCLineStyle jCLineStyle = (JCLineStyle)super.clone();
        jCLineStyle.color = this.color;
        jCLineStyle.colorIndex = this.colorIndex;
        jCLineStyle.join = this.join;
        jCLineStyle.pattern = this.pattern;
        jCLineStyle.width = this.width;
        jCLineStyle.dashArray = this.dashArray;
        jCLineStyle.legendDashArray = this.legendDashArray;
        jCLineStyle.xp = null;
        jCLineStyle.yp = null;
        return jCLineStyle;
    }
}

