/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.style;

import com.klg.jclass.util.Changeable;
import com.klg.jclass.util.JCGraphicsUtil;
import com.klg.jclass.util.io.OutputProperties;
import com.klg.jclass.util.style.JCLineStyle;
import com.klg.jclass.util.style.JCStyle;
import com.klg.jclass.util.style.resources.LocaleBundle;
import com.klg.jclass.util.swing.JCIconCreator;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import javax.swing.ImageIcon;

public class JCFillStyle
extends JCStyle
implements Cloneable {
    public Object parent = null;
    public static final int NONE = 0;
    public static final int SOLID = 1;
    public static final int PER_25 = 2;
    public static final int PER_50 = 3;
    public static final int PER_75 = 4;
    public static final int HORIZ_STRIPE = 5;
    public static final int VERT_STRIPE = 6;
    public static final int STRIPE_45 = 7;
    public static final int STRIPE_135 = 8;
    public static final int DIAG_HATCHED = 9;
    public static final int CROSS_HATCHED = 10;
    public static final int IMAGE = 11;
    public static final int STACKED_IMAGE = 12;
    public static final int CUSTOM_PAINT = 13;
    public static final int GRADIENT_PAINT = 14;
    public static final int CUSTOM_FILL = 11;
    public static final int CUSTOM_STACKED = 12;
    public static final String[] PER_25_PIXELS = new String[]{"C C C C C C C C C C C C C C C C ", "                                ", "C C C C C C C C C C C C C C C C ", "                                ", "C C C C C C C C C C C C C C C C ", "                                ", "C C C C C C C C C C C C C C C C ", "                                ", "C C C C C C C C C C C C C C C C ", "                                ", "C C C C C C C C C C C C C C C C ", "                                ", "C C C C C C C C C C C C C C C C ", "                                ", "C C C C C C C C C C C C C C C C ", "                                "};
    public static final String[] PER_50_PIXELS = new String[]{"C C C C C C C C C C C C C C C C ", " C C C C C C C C C C C C C C C C", "C C C C C C C C C C C C C C C C ", " C C C C C C C C C C C C C C C C", "C C C C C C C C C C C C C C C C ", " C C C C C C C C C C C C C C C C", "C C C C C C C C C C C C C C C C ", " C C C C C C C C C C C C C C C C", "C C C C C C C C C C C C C C C C ", " C C C C C C C C C C C C C C C C", "C C C C C C C C C C C C C C C C ", " C C C C C C C C C C C C C C C C", "C C C C C C C C C C C C C C C C ", " C C C C C C C C C C C C C C C C", "C C C C C C C C C C C C C C C C ", " C C C C C C C C C C C C C C C C"};
    public static final String[] PER_75_PIXELS = new String[]{"CCC CCC CCC CCC CCC CCC CCC CCC ", "C CCC CCC CCC CCC CCC CCC CCC CC", "CCC CCC CCC CCC CCC CCC CCC CCC ", "C CCC CCC CCC CCC CCC CCC CCC CC", "CCC CCC CCC CCC CCC CCC CCC CCC ", "C CCC CCC CCC CCC CCC CCC CCC CC", "CCC CCC CCC CCC CCC CCC CCC CCC ", "C CCC CCC CCC CCC CCC CCC CCC CC", "CCC CCC CCC CCC CCC CCC CCC CCC ", "C CCC CCC CCC CCC CCC CCC CCC CC", "CCC CCC CCC CCC CCC CCC CCC CCC ", "C CCC CCC CCC CCC CCC CCC CCC CC", "CCC CCC CCC CCC CCC CCC CCC CCC ", "C CCC CCC CCC CCC CCC CCC CCC CC", "CCC CCC CCC CCC CCC CCC CCC CCC ", "C CCC CCC CCC CCC CCC CCC CCC CC"};
    public static final String[] HORIZ_STRIPE_PIXELS = new String[]{"                                ", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "                                ", "                                ", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "                                ", "                                ", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "                                ", "                                ", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "                                "};
    public static final String[] VERT_STRIPE_PIXELS = new String[]{"CC  CC  CC  CC  CC  CC  CC  CC  ", "CC  CC  CC  CC  CC  CC  CC  CC  ", "CC  CC  CC  CC  CC  CC  CC  CC  ", "CC  CC  CC  CC  CC  CC  CC  CC  ", "CC  CC  CC  CC  CC  CC  CC  CC  ", "CC  CC  CC  CC  CC  CC  CC  CC  ", "CC  CC  CC  CC  CC  CC  CC  CC  ", "CC  CC  CC  CC  CC  CC  CC  CC  ", "CC  CC  CC  CC  CC  CC  CC  CC  ", "CC  CC  CC  CC  CC  CC  CC  CC  ", "CC  CC  CC  CC  CC  CC  CC  CC  ", "CC  CC  CC  CC  CC  CC  CC  CC  ", "CC  CC  CC  CC  CC  CC  CC  CC  ", "CC  CC  CC  CC  CC  CC  CC  CC  ", "CC  CC  CC  CC  CC  CC  CC  CC  ", "CC  CC  CC  CC  CC  CC  CC  CC  "};
    public static final String[] STRIPE_45_PIXELS = new String[]{"   CC      CC      CC      CC   ", "  CC      CC      CC      CC    ", " CC      CC      CC      CC     ", "CC      CC      CC      CC      ", "C      CC      CC      CC      C", "      CC      CC      CC      CC", "     CC      CC      CC      CC ", "    CC      CC      CC      CC  ", "   CC      CC      CC      CC   ", "  CC      CC      CC      CC    ", " CC      CC      CC      CC     ", "CC      CC      CC      CC      ", "C      CC      CC      CC      C", "      CC      CC      CC      CC", "     CC      CC      CC      CC ", "    CC      CC      CC      CC  "};
    public static final String[] STRIPE_135_PIXELS = new String[]{"C      CC      CC      CC      C", "CC      CC      CC      CC      ", " CC      CC      CC      CC     ", "  CC      CC      CC      CC    ", "   CC      CC      CC      CC   ", "    CC      CC      CC      CC  ", "     CC      CC      CC      CC ", "      CC      CC      CC      CC", "C      CC      CC      CC      C", "CC      CC      CC      CC      ", " CC      CC      CC      CC     ", "  CC      CC      CC      CC    ", "   CC      CC      CC      CC   ", "    CC      CC      CC      CC  ", "     CC      CC      CC      CC ", "      CC      CC      CC      CC"};
    public static final String[] DIAG_HATCHED_PIXELS = new String[]{"CC      CC      CC      CC      ", "CCC    CCCC    CCCC    CCCC    C", "  CC  CC  CC  CC  CC  CC  CC  CC", "   CCCC    CCCC    CCCC    CCCC ", "    CC      CC      CC      CC  ", "   CCCC    CCCC    CCCC    CCCC ", "  CC  CC  CC  CC  CC  CC  CC  CC", "CCC    CCCC    CCCC    CCCC    C", "CC      CC      CC      CC      ", "CCC    CCCC    CCCC    CCCC    C", "  CC  CC  CC  CC  CC  CC  CC  CC", "   CCCC    CCCC    CCCC    CCCC ", "    CC      CC      CC      CC  ", "   CCCC    CCCC    CCCC    CCCC ", "  CC  CC  CC  CC  CC  CC  CC  CC", "CCC    CCCC    CCCC    CCCC    C"};
    public static final String[] CROSS_HATCHED_PIXELS = new String[]{"CC      CC      CC      CC      ", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "CC      CC      CC      CC      ", "CC      CC      CC      CC      ", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "CC      CC      CC      CC      ", "CC      CC      CC      CC      ", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "CC      CC      CC      CC      ", "CC      CC      CC      CC      ", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "CC      CC      CC      CC      "};
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    public static final int CENTER = 5;
    public static final int BOTTOM_LEFT = 6;
    public static final int TOP_LEFT = 7;
    public static final int BOTTOM_RIGHT = 8;
    public static final int TOP_RIGHT = 9;
    public static final int ABSOLUTE = 10;
    public static final int USE_ACTUAL_SIZE = 0;
    public static final int TILE = 1;
    public static final int FIT_TO_RECT = 2;
    public static final int GRADIENT_HORIZONTAL = 0;
    public static final int GRADIENT_VERTICAL = 1;
    public static final int GRADIENT_DIAGONAL_UP = 2;
    public static final int GRADIENT_DIAGONAL_DOWN = 3;
    public static final int GRADIENT_HORIZONTAL_CYLINDER = 4;
    public static final int GRADIENT_VERTICAL_CYLINDER = 5;
    public static final int GRADIENT_DIAGONAL_UP_CYLINDER = 6;
    public static final int GRADIENT_DIAGONAL_DOWN_CYLINDER = 7;
    public static final int GRADIENT_HORIZONTAL_RIBBON = 8;
    public static final int GRADIENT_VERTICAL_RIBBON = 9;
    public static final int GRADIENT_DIAGONAL_UP_RIBBON = 10;
    public static final int GRADIENT_DIAGONAL_DOWN_RIBBON = 11;
    public static final int DEFAULT_RIBBON_SIZE = 10;
    protected Color color = null;
    protected Color backgroundColor = null;
    protected int pattern = 1;
    protected int colorIndex;
    protected Rectangle2D anchorRect = null;
    protected int orientation = 0;
    protected OutputProperties outputProperties;
    protected int fillCorrection = 0;
    protected int gradientStyle = 0;
    protected int ribbonSize = 10;
    protected int imageLayoutHint = 1;
    protected Point imagePosition = new Point(0, 0);
    protected transient Image image = null;
    protected transient BufferedImage buffImage = null;
    protected transient Paint customPaint = null;
    protected transient GradientPaint gradientPaint = null;
    protected transient Paint fillPaint = null;
    protected transient Paint hiFillPaint = null;
    protected transient Paint shFillPaint = null;
    private static int alpha = 255;

    public JCFillStyle(Color color, int n2) {
        this.color = color;
        this.pattern = this.checkPattern(n2);
        this.buffImage = this.makeBufferedImage();
        this.fillPaint = null;
        this.hiFillPaint = null;
        this.shFillPaint = null;
    }

    public JCFillStyle(Color color, int n2, Color color2) {
        this.color = color;
        this.pattern = this.checkPattern(n2);
        this.backgroundColor = color2;
        this.buffImage = this.makeBufferedImage();
        this.fillPaint = null;
        this.hiFillPaint = null;
        this.shFillPaint = null;
    }

    public JCFillStyle(Color color, Color color2, int n2) {
        this.pattern = 14;
        this.setGradientPaint(color, color2, n2);
    }

    public boolean updateGraphics(Graphics graphics) {
        if (this.pattern == 0) {
            return false;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (!graphics.getColor().equals(this.color)) {
            graphics.setColor(this.color);
        }
        if (this.pattern != 12 || this.image == null) {
            if (this.pattern == 13) {
                if (this.customPaint != null) {
                    if (this.customPaint instanceof TexturePaint) {
                        BufferedImage bufferedImage = ((TexturePaint)this.customPaint).getImage();
                        this.fillPaint = this.makeFillPaint(bufferedImage, this.color, this.anchorRect, this.orientation);
                    } else {
                        this.fillPaint = this.customPaint;
                    }
                }
            } else if (this.pattern == 14) {
                if (this.color != null && this.backgroundColor != null) {
                    Rectangle2D rectangle2D = this.anchorRect != null ? this.anchorRect : new Rectangle(0, 0, 32, 16);
                    this.fillPaint = this.makeGradientPaint(this.color, this.backgroundColor, rectangle2D);
                } else {
                    this.fillPaint = this.color;
                }
            } else if (this.pattern != 1 || this.fillPaint == null) {
                this.fillPaint = this.makeFillPaint(this.buffImage, this.color, this.anchorRect, this.orientation);
            }
            graphics2D.setPaint(this.fillPaint);
        }
        return true;
    }

    public boolean updateGraphicsToShadow(Graphics graphics) {
        if (this.pattern == 0) {
            return false;
        }
        Color color = JCGraphicsUtil.darker(this.color);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.pattern != 12 || this.image == null) {
            if (this.pattern == 13) {
                if (this.customPaint != null) {
                    if (this.customPaint instanceof TexturePaint) {
                        BufferedImage bufferedImage = ((TexturePaint)this.customPaint).getImage();
                        this.shFillPaint = this.makeFillPaint(bufferedImage, color, this.anchorRect, this.orientation);
                    } else if (this.customPaint instanceof GradientPaint) {
                        Rectangle2D rectangle2D = this.anchorRect != null ? this.anchorRect : new Rectangle(0, 0, 32, 16);
                        GradientPaint gradientPaint = (GradientPaint)this.customPaint;
                        this.shFillPaint = this.makeGradientPaint(JCGraphicsUtil.darker(gradientPaint.getColor1()), JCGraphicsUtil.darker(gradientPaint.getColor2()), rectangle2D);
                    }
                } else {
                    this.shFillPaint = color;
                }
            } else if (this.pattern == 14) {
                if (this.color != null && this.backgroundColor != null) {
                    Rectangle2D rectangle2D = this.anchorRect != null ? this.anchorRect : new Rectangle(0, 0, 32, 16);
                    this.shFillPaint = this.makeGradientPaint(JCGraphicsUtil.darker(this.color), JCGraphicsUtil.darker(this.backgroundColor), rectangle2D);
                } else {
                    this.shFillPaint = color;
                }
            } else if (this.pattern != 1 || this.shFillPaint == null) {
                this.shFillPaint = this.pattern == 11 ? this.makeFillPaint(this.buffImage, color, this.anchorRect, this.orientation) : this.makeFillPaint(this.makeBufferedImage(color), color, this.anchorRect, this.orientation);
            }
            graphics2D.setPaint(this.shFillPaint);
        }
        return true;
    }

    public boolean updateGraphicsToHighlight(Graphics graphics) {
        if (this.pattern == 0) {
            return false;
        }
        Color color = JCGraphicsUtil.brighter(this.color);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.pattern != 12 || this.image == null) {
            if (this.pattern == 13) {
                if (this.customPaint != null) {
                    if (this.customPaint instanceof TexturePaint) {
                        BufferedImage bufferedImage = ((TexturePaint)this.customPaint).getImage();
                        this.hiFillPaint = this.makeFillPaint(bufferedImage, color, this.anchorRect, this.orientation);
                    } else if (this.customPaint instanceof GradientPaint) {
                        GradientPaint gradientPaint = (GradientPaint)this.customPaint;
                        Rectangle2D rectangle2D = this.anchorRect != null ? this.anchorRect : new Rectangle(0, 0, 32, 16);
                        Color color2 = gradientPaint.getColor1();
                        Color color3 = gradientPaint.getColor2();
                        this.hiFillPaint = this.makeGradientPaint(JCGraphicsUtil.brighter(color2), JCGraphicsUtil.brighter(color3), rectangle2D);
                    }
                } else {
                    this.hiFillPaint = color;
                }
            } else if (this.pattern == 14) {
                if (this.color != null && this.backgroundColor != null) {
                    Rectangle2D rectangle2D = this.anchorRect != null ? this.anchorRect : new Rectangle(0, 0, 32, 16);
                    this.hiFillPaint = this.makeGradientPaint(JCGraphicsUtil.brighter(this.color), JCGraphicsUtil.brighter(this.backgroundColor), rectangle2D);
                } else {
                    this.hiFillPaint = color;
                }
            } else if (this.pattern != 1 || this.hiFillPaint == null) {
                this.hiFillPaint = this.pattern == 11 ? this.makeFillPaint(this.buffImage, color, this.anchorRect, this.orientation) : this.makeFillPaint(this.makeBufferedImage(color), color, this.anchorRect, this.orientation);
            }
            graphics2D.setPaint(this.hiFillPaint);
        }
        return true;
    }

    public void resetGraphics(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setPaint(null);
        graphics2D.setColor(this.color);
    }

    public void updateAnchorRect(Rectangle2D rectangle2D) {
        this.anchorRect = rectangle2D;
    }

    public int getFillOrientation() {
        return this.orientation;
    }

    public void setFillOrientation(int n2) {
        this.orientation = this.checkFillOrientation(n2);
        this.setChanged(true, 33);
    }

    public void updateFillOrientation(Rectangle2D rectangle2D, int n2) {
        this.anchorRect = rectangle2D;
        this.orientation = this.checkFillOrientation(n2);
    }

    public void resetFillOrientation() {
        this.anchorRect = null;
        this.orientation = 0;
    }

    public void fillRect(Graphics graphics, int n2, int n3, int n4, int n5) {
        if (this.pattern == 11 && this.backgroundColor != null) {
            if (!graphics.getColor().equals(this.backgroundColor)) {
                graphics.setColor(this.backgroundColor);
            }
            graphics.fillRect(n2, n3, n4, n5);
        }
        if (this.updateGraphics(graphics)) {
            graphics.fillRect(n2, n3, n4, n5);
            this.resetGraphics(graphics);
        }
    }

    public void fillRect(Graphics graphics, double d2, double d3, double d4, double d5) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle2D.Double double_ = new Rectangle2D.Double(d2, d3, d4, d5);
        if (this.pattern == 11 && this.backgroundColor != null) {
            if (!graphics.getColor().equals(this.backgroundColor)) {
                graphics.setColor(this.backgroundColor);
            }
            graphics2D.fill(double_);
        }
        if (this.updateGraphics(graphics)) {
            graphics2D.fill(double_);
            this.resetGraphics(graphics);
        }
    }

    public void fillImageRect(Graphics graphics, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) {
        if (this.image == null) {
            return;
        }
        int n6 = this.image.getHeight(null);
        int n7 = this.image.getWidth(null);
        if (n6 <= 0 || n7 <= 0) {
            return;
        }
        Graphics graphics2 = graphics.create();
        graphics2.clipRect(n2, n3, n4, n5);
        if (!bl2) {
            int n8 = n2 + (n4 - n7) / 2;
            if (bl) {
                int n9;
                for (n9 = n3 + n5 - n6; n9 > n3; n9 -= n6) {
                    this.drawImage(graphics2, n8, n9);
                }
                this.drawImage(graphics2, n8, n9);
            } else {
                for (int i2 = n3 + 1; i2 < n3 + n5; i2 += n6) {
                    this.drawImage(graphics2, n8, i2);
                }
            }
        } else {
            int n10 = n3 + (n5 - n6) / 2;
            if (bl) {
                for (int i3 = n2 + 1; i3 < n2 + n4; i3 += n7) {
                    this.drawImage(graphics2, i3, n10);
                }
            } else {
                int n11;
                for (n11 = n2 + n4 - n7; n11 > n2; n11 -= n7) {
                    this.drawImage(graphics2, n11, n10);
                }
                this.drawImage(graphics2, n11, n10);
            }
        }
        graphics2.dispose();
    }

    private void drawImage(Graphics graphics, int n2, int n3) {
        if (this.image != null) {
            if (this.backgroundColor != null) {
                graphics.drawImage(this.image, n2, n3, this.backgroundColor, null);
            } else {
                graphics.drawImage(this.image, n2, n3, null);
            }
        }
    }

    public void fillOutlineRect(Graphics graphics, int n2, int n3, int n4, int n5) {
        this.fillOutlineRect(graphics, n2, n3, n4, n5, (Color)null);
    }

    public void fillOutlineRect(Graphics graphics, int n2, int n3, int n4, int n5, Color color) {
        if (color == null) {
            color = this.calcOutlineColor();
        }
        this.fillOutlineRect(graphics, n2, n3, n4, n5, new JCLineStyle(1, color, 1));
    }

    public void fillOutlineRect(Graphics graphics, int n2, int n3, int n4, int n5, JCLineStyle jCLineStyle) {
        this.fillRect(graphics, n2, n3, n4, n5);
        this.drawOutlineRect(graphics, n2, n3, n4, n5, jCLineStyle);
    }

    public void drawOutlineRect(Graphics graphics, int n2, int n3, int n4, int n5, Color color) {
        if (color == null) {
            color = this.calcOutlineColor();
        }
        this.drawOutlineRect(graphics, n2, n3, n4, n5, new JCLineStyle(1, color, 1));
    }

    public void drawOutlineRect(Graphics graphics, int n2, int n3, int n4, int n5, JCLineStyle jCLineStyle) {
        if (jCLineStyle != null) {
            jCLineStyle.drawRect(graphics, n2, n3, n4, n5);
        }
    }

    public void fillPolygon(Graphics graphics, Polygon polygon) {
        if (this.pattern == 11 && this.backgroundColor != null) {
            if (!graphics.getColor().equals(this.backgroundColor)) {
                graphics.setColor(this.backgroundColor);
            }
            graphics.fillPolygon(polygon);
        }
        if (this.updateGraphics(graphics)) {
            graphics.fillPolygon(polygon);
            this.resetGraphics(graphics);
        }
    }

    public void fillPolygon(Graphics graphics, Shape shape) {
        if (this.pattern == 11 && this.backgroundColor != null) {
            if (!graphics.getColor().equals(this.backgroundColor)) {
                graphics.setColor(this.backgroundColor);
            }
            ((Graphics2D)graphics).fill(shape);
        }
        if (this.updateGraphics(graphics)) {
            ((Graphics2D)graphics).fill(shape);
            this.resetGraphics(graphics);
        }
    }

    public void fillOutlinePolygon(Graphics graphics, Polygon polygon, Color color) {
        if (color == null) {
            color = this.calcOutlineColor();
        }
        this.fillOutlinePolygon(graphics, polygon, new JCLineStyle(1, color, 1));
    }

    public void fillOutlinePolygon(Graphics graphics, Polygon polygon, JCLineStyle jCLineStyle) {
        this.fillPolygon(graphics, polygon);
        this.drawOutlinePolygon(graphics, polygon, jCLineStyle);
    }

    public void drawOutlinePolygon(Graphics graphics, Polygon polygon, Color color) {
        if (color == null) {
            color = this.calcOutlineColor();
        }
        this.drawOutlinePolygon(graphics, polygon, new JCLineStyle(1, color, 1));
    }

    public void drawOutlinePolygon(Graphics graphics, Polygon polygon, JCLineStyle jCLineStyle) {
        this.drawOutlineLine(graphics, polygon, 0, 0, jCLineStyle);
    }

    public void drawOutlineLine(Graphics graphics, Polygon polygon, int n2, int n3, Color color) {
        if (color == null) {
            color = this.calcOutlineColor();
        }
        this.drawOutlineLine(graphics, polygon, n2, n3, new JCLineStyle(1, color, 1));
    }

    public void drawOutlineLine(Graphics graphics, Polygon polygon, int n2, int n3, JCLineStyle jCLineStyle) {
        if (jCLineStyle == null) {
            return;
        }
        if (n3 <= n2) {
            int n4;
            for (n4 = n2; n4 < polygon.npoints - 1; ++n4) {
                jCLineStyle.drawLine(graphics, (double)polygon.xpoints[n4], (double)polygon.ypoints[n4], (double)polygon.xpoints[n4 + 1], (double)polygon.ypoints[n4 + 1]);
            }
            jCLineStyle.drawLine(graphics, (double)polygon.xpoints[polygon.npoints - 1], (double)polygon.ypoints[polygon.npoints - 1], (double)polygon.xpoints[0], (double)polygon.ypoints[0]);
            for (n4 = 0; n4 < n3; ++n4) {
                jCLineStyle.drawLine(graphics, (double)polygon.xpoints[n4], (double)polygon.ypoints[n4], (double)polygon.xpoints[n4 + 1], (double)polygon.ypoints[n4 + 1]);
            }
        } else {
            for (int i2 = n2; i2 < n3 && i2 < polygon.npoints - 1; ++i2) {
                jCLineStyle.drawLine(graphics, (double)polygon.xpoints[i2], (double)polygon.ypoints[i2], (double)polygon.xpoints[i2 + 1], (double)polygon.ypoints[i2 + 1]);
            }
        }
    }

    public void fillOutlinePartialPolygon(Graphics graphics, Polygon polygon, Color color) {
        if (color == null) {
            color = this.calcOutlineColor();
        }
        this.fillOutlinePartialPolygon(graphics, polygon, new JCLineStyle(1, color, 1));
    }

    public void fillOutlinePartialPolygon(Graphics graphics, Polygon polygon, JCLineStyle jCLineStyle) {
        this.fillPolygon(graphics, polygon);
        if (jCLineStyle == null) {
            return;
        }
        Color color = jCLineStyle.getColor();
        int n2 = jCLineStyle.getPattern();
        Color color2 = graphics.getColor();
        if (!color.equals(color2)) {
            jCLineStyle.setColor(color2);
        }
        jCLineStyle.setPattern(1);
        jCLineStyle.drawLine(graphics, (double)polygon.xpoints[0], (double)polygon.ypoints[0], (double)polygon.xpoints[1], (double)polygon.ypoints[1]);
        jCLineStyle.setPattern(n2);
        if (!color.equals(color2)) {
            jCLineStyle.setColor(color);
        }
        int n3 = polygon.npoints;
        for (int i2 = 1; i2 < n3; ++i2) {
            jCLineStyle.drawLine(graphics, (double)polygon.xpoints[i2], (double)polygon.ypoints[i2], (double)polygon.xpoints[(i2 + 1) % n3], (double)polygon.ypoints[(i2 + 1) % n3]);
        }
    }

    public void fillPolygonShadow(Graphics graphics, Polygon polygon) {
        if (this.pattern == 11 && this.backgroundColor != null) {
            if (!graphics.getColor().equals(this.backgroundColor)) {
                graphics.setColor(this.backgroundColor);
            }
            graphics.fillPolygon(polygon);
        }
        if (this.updateGraphicsToShadow(graphics)) {
            graphics.fillPolygon(polygon);
            this.resetGraphics(graphics);
        }
    }

    public void fillPolygonShadow(Graphics graphics, Shape shape) {
        if (this.pattern == 11 && this.backgroundColor != null) {
            if (!graphics.getColor().equals(this.backgroundColor)) {
                graphics.setColor(this.backgroundColor);
            }
            ((Graphics2D)graphics).fill(shape);
        }
        if (this.updateGraphicsToShadow(graphics)) {
            ((Graphics2D)graphics).fill(shape);
            this.resetGraphics(graphics);
        }
    }

    public void fillPolygonHighlight(Graphics graphics, Polygon polygon) {
        if (this.pattern == 11 && this.backgroundColor != null) {
            if (!graphics.getColor().equals(this.backgroundColor)) {
                graphics.setColor(this.backgroundColor);
            }
            graphics.fillPolygon(polygon);
        }
        if (this.updateGraphicsToHighlight(graphics)) {
            graphics.fillPolygon(polygon);
            this.resetGraphics(graphics);
        }
    }

    public void fillOutlinePolygonShadow(Graphics graphics, Polygon polygon) {
        this.fillOutlinePolygonShadow(graphics, polygon, null);
    }

    public void fillOutlinePolygonShadow(Graphics graphics, Polygon polygon, Color color) {
        this.fillPolygonShadow(graphics, polygon);
        this.drawOutlinePolygon(graphics, polygon, color);
    }

    public void fillOutlinePolygonHighlight(Graphics graphics, Polygon polygon) {
        this.fillOutlinePolygonHighlight(graphics, polygon, null);
    }

    public void fillOutlinePolygonHighlight(Graphics graphics, Polygon polygon, Color color) {
        this.fillPolygonHighlight(graphics, polygon);
        this.drawOutlinePolygon(graphics, polygon, color);
    }

    protected Color calcOutlineColor() {
        Color color = JCGraphicsUtil.darker(this.color);
        if (color.equals(this.color)) {
            color = JCGraphicsUtil.brighter(this.color);
        }
        return color;
    }

    public void fillArc(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (this.pattern == 11 && this.backgroundColor != null) {
            if (!graphics.getColor().equals(this.backgroundColor)) {
                graphics.setColor(this.backgroundColor);
            }
            graphics.fillArc(n2, n3, n4 + this.fillCorrection, n5 + this.fillCorrection, n6, n7);
        }
        if (this.updateGraphics(graphics)) {
            graphics.fillArc(n2, n3, n4 + this.fillCorrection, n5 + this.fillCorrection, n6, n7);
            this.resetGraphics(graphics);
        }
    }

    public void fillArcShadow(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (this.pattern == 11 && this.backgroundColor != null) {
            if (!graphics.getColor().equals(this.backgroundColor)) {
                graphics.setColor(this.backgroundColor);
            }
            graphics.fillArc(n2, n3, n4 + this.fillCorrection, n5 + this.fillCorrection, n6, n7);
        }
        if (this.updateGraphicsToShadow(graphics)) {
            graphics.fillArc(n2, n3, n4 + this.fillCorrection, n5 + this.fillCorrection, n6, n7);
            this.resetGraphics(graphics);
        }
    }

    public void fillArc(Graphics graphics, double d2, double d3, double d4, double d5, double d6, double d7) {
        Arc2D.Double double_ = new Arc2D.Double(d2, d3, d4, d5, d6, d7, 2);
        if (this.pattern == 11 && this.backgroundColor != null && !graphics.getColor().equals(this.backgroundColor)) {
            graphics.setColor(this.backgroundColor);
            this.resetColorWithAlpha(graphics);
            ((Graphics2D)graphics).fill(double_);
        }
        if (this.updateGraphics(graphics)) {
            this.resetColorWithAlpha(graphics);
            ((Graphics2D)graphics).fill(double_);
            this.resetGraphics(graphics);
        }
    }

    public void fillArcShadow(Graphics graphics, double d2, double d3, double d4, double d5, double d6, double d7) {
        Arc2D.Double double_ = new Arc2D.Double(d2, d3, d4, d5, d6, d7, 2);
        if (this.pattern == 11 && this.backgroundColor != null && !graphics.getColor().equals(this.backgroundColor)) {
            graphics.setColor(this.backgroundColor);
            ((Graphics2D)graphics).fill(double_);
        }
        if (this.updateGraphicsToShadow(graphics)) {
            ((Graphics2D)graphics).fill(double_);
            this.resetGraphics(graphics);
        }
    }

    public void fillCircle(Graphics graphics, int n2, int n3, int n4) {
        int n5;
        if (this.pattern == 11 && this.backgroundColor != null) {
            if (!graphics.getColor().equals(this.backgroundColor)) {
                graphics.setColor(this.backgroundColor);
            }
            n5 = 2 * n4 + this.fillCorrection;
            graphics.fillArc(n2 - n4, n3 - n4, n5, n5, 0, 360);
        }
        if (this.updateGraphics(graphics)) {
            n5 = 2 * n4 + this.fillCorrection;
            graphics.fillArc(n2 - n4, n3 - n4, n5, n5, 0, 360);
            this.resetGraphics(graphics);
        }
    }

    public void setFillCorrection(int n2) {
        this.fillCorrection = n2;
    }

    public int getFillCorrection() {
        return this.fillCorrection;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        if (this.pattern != 11 && this.pattern != 12 && this.pattern != 13) {
            this.buffImage = this.makeBufferedImage();
            this.fillPaint = null;
            this.hiFillPaint = null;
            this.shFillPaint = null;
        }
        this.setChanged(true, 17);
    }

    public Color getBackground() {
        return this.backgroundColor;
    }

    public void setBackground(Color color) {
        this.backgroundColor = color;
        if (this.pattern != 11 && this.pattern != 12 && this.pattern != 13) {
            this.buffImage = this.makeBufferedImage();
            this.fillPaint = null;
            this.hiFillPaint = null;
            this.shFillPaint = null;
        }
        this.setChanged(true, 17);
    }

    public int getPattern() {
        return this.pattern;
    }

    public void setPattern(int n2) {
        if (n2 == this.pattern) {
            return;
        }
        this.pattern = this.checkPattern(n2);
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.buffImage = this.makeBufferedImage();
                this.fillPaint = null;
                this.hiFillPaint = null;
                this.shFillPaint = null;
                break;
            }
            case 11: {
                this.buffImage = this.makeBufferedImage(this.image);
                this.fillPaint = null;
                this.hiFillPaint = null;
                this.shFillPaint = null;
                break;
            }
            case 12: {
                this.fillPaint = null;
                this.hiFillPaint = null;
                this.shFillPaint = null;
                break;
            }
        }
        this.setChanged(true, 33);
    }

    public int checkPattern(int n2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            default: {
                String string = LocaleBundle.string("Not fillstyle enum");
                throw new IllegalArgumentException(string);
            }
        }
        return n2;
    }

    public int checkGradientStyle(int n2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            default: {
                String string = LocaleBundle.string("Illegal Gradient Style Value");
                throw new IllegalArgumentException(string);
            }
        }
        return n2;
    }

    public int checkFillOrientation(int n2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            default: {
                String string = LocaleBundle.string("Illegal Fill Orientation Value");
                throw new IllegalArgumentException(string);
            }
        }
        return n2;
    }

    public int checkImageLayoutHint(int n2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                String string = LocaleBundle.string("Illegal Image Layout Hint Value");
                throw new IllegalArgumentException(string);
            }
        }
        return n2;
    }

    public Paint getCustomPaint() {
        return this.customPaint;
    }

    public void setCustomPaint(Paint paint) {
        if (paint == this.customPaint) {
            return;
        }
        this.buffImage = null;
        this.customPaint = paint;
        this.setChanged(true, 33);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
        if (this.image != null) {
            int n2 = this.image.getHeight(null);
            int n3 = this.image.getWidth(null);
            if (n2 <= 0 || n3 <= 0) {
                this.image = null;
            }
        }
        if (this.pattern == 11 || this.pattern == 12) {
            this.buffImage = this.makeBufferedImage(this.image);
            this.fillPaint = null;
            this.hiFillPaint = null;
            this.shFillPaint = null;
        }
        this.setChanged(true, 33);
    }

    public void setImage(String string) {
        Image image = new ImageIcon(string).getImage();
        this.setImage(image);
    }

    public int getImageLayoutHint() {
        return this.imageLayoutHint;
    }

    public void setImageLayoutHint(int n2) {
        this.imageLayoutHint = this.checkImageLayoutHint(n2);
        this.setChanged(true, 17);
    }

    public Point getImagePosition() {
        return this.imagePosition;
    }

    public void setImagePosition(Point point) {
        if (point == null) {
            point = new Point(0, 0);
        }
        this.imagePosition = point;
        this.setChanged(true, 17);
    }

    public OutputProperties getOutputProperties() {
        return this.outputProperties;
    }

    public void setOutputProperties(OutputProperties outputProperties) {
        this.outputProperties = outputProperties;
    }

    public int getColorIndex() {
        return this.colorIndex;
    }

    public BufferedImage makeBufferedImage() {
        return this.makeBufferedImage(this.color);
    }

    public BufferedImage makeBufferedImage(Color color) {
        if (this.pattern == 0 || this.pattern == 1) {
            return null;
        }
        JCIconCreator jCIconCreator = new JCIconCreator(32, 16);
        jCIconCreator.setColor('C', color);
        Color color2 = this.backgroundColor;
        if (color2 == null) {
            color2 = new Color(0.0f, 0.0f, 0.0f, 0.0f);
        }
        jCIconCreator.setColor(' ', color2);
        String[] stringArray = null;
        switch (this.pattern) {
            case 2: {
                stringArray = PER_25_PIXELS;
                break;
            }
            case 3: {
                stringArray = PER_50_PIXELS;
                break;
            }
            case 4: {
                stringArray = PER_75_PIXELS;
                break;
            }
            case 5: {
                stringArray = HORIZ_STRIPE_PIXELS;
                break;
            }
            case 6: {
                stringArray = VERT_STRIPE_PIXELS;
                break;
            }
            case 7: {
                stringArray = STRIPE_45_PIXELS;
                break;
            }
            case 8: {
                stringArray = STRIPE_135_PIXELS;
                break;
            }
            case 9: {
                stringArray = DIAG_HATCHED_PIXELS;
                break;
            }
            case 10: {
                stringArray = CROSS_HATCHED_PIXELS;
            }
        }
        if (stringArray == null) {
            return null;
        }
        jCIconCreator.setPixels(stringArray);
        Image image = jCIconCreator.getIcon().getImage();
        return this.makeBufferedImage(image);
    }

    public BufferedImage makeBufferedImage(Image image) {
        if (image == null) {
            return null;
        }
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        if (n2 < 0 || n3 < 0) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        return bufferedImage;
    }

    public Paint makeFillPaint() {
        return this.makeFillPaint(this.buffImage, this.color, null, 0);
    }

    public Paint makeFillPaint(BufferedImage bufferedImage, Color color, Rectangle2D rectangle2D, int n2) {
        if (this.pattern == 0) {
            return null;
        }
        if (this.pattern == 1) {
            return color;
        }
        if (bufferedImage == null) {
            return color;
        }
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        Rectangle2D rectangle2D2 = new Rectangle2D.Double(0.0, 0.0, n3, n4);
        if (rectangle2D != null) {
            if (this.imageLayoutHint == 2) {
                rectangle2D2 = rectangle2D;
            } else {
                boolean bl = this.imageLayoutHint == 0;
                double d2 = (rectangle2D.getWidth() - (double)n3) / 2.0;
                double d3 = (rectangle2D.getHeight() - (double)n4) / 2.0;
                double d4 = bl ? 0.0 : rectangle2D.getX();
                double d5 = bl ? 0.0 : rectangle2D.getY();
                switch (n2) {
                    case 2: {
                        rectangle2D2 = new Rectangle2D.Double(d2 + d4, d5 + rectangle2D.getHeight() - (double)n4, n3, n4);
                        break;
                    }
                    case 1: {
                        rectangle2D2 = new Rectangle2D.Double(d2 + d4, d5, n3, n4);
                        break;
                    }
                    case 3: {
                        rectangle2D2 = new Rectangle2D.Double(d4, d3 + d5, n3, n4);
                        break;
                    }
                    case 4: {
                        rectangle2D2 = new Rectangle2D.Double(d4 + rectangle2D.getWidth() - (double)n3, d3 + d5, n3, n4);
                        break;
                    }
                    case 5: {
                        rectangle2D2 = new Rectangle2D.Double(d2 + d4, d3 + d5, n3, n4);
                        break;
                    }
                    case 6: {
                        rectangle2D2 = new Rectangle2D.Double(d4, d5 + rectangle2D.getHeight() - (double)n4, n3, n4);
                        break;
                    }
                    case 7: {
                        rectangle2D2 = new Rectangle2D.Double(d4, d5, n3, n4);
                        break;
                    }
                    case 8: {
                        rectangle2D2 = new Rectangle2D.Double(d4 + rectangle2D.getWidth() - (double)n3, d5 + rectangle2D.getHeight() - (double)n4, n3, n4);
                        break;
                    }
                    case 9: {
                        rectangle2D2 = new Rectangle2D.Double(d4 + rectangle2D.getWidth() - (double)n3, d5, n3, n4);
                        break;
                    }
                    case 10: {
                        Point point = this.getImagePosition();
                        rectangle2D2 = new Rectangle2D.Double(point.x, point.y, n3, n4);
                        break;
                    }
                }
                if (bl) {
                    int n5 = (int)rectangle2D.getWidth();
                    int n6 = (int)rectangle2D.getHeight();
                    if (n3 != n5 || n4 != n6) {
                        BufferedImage bufferedImage2 = new BufferedImage(n5, n6, 2);
                        Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
                        graphics2D.drawImage(bufferedImage, (int)rectangle2D2.getX(), (int)rectangle2D2.getY(), n3, n4, null);
                        bufferedImage = bufferedImage2;
                    }
                    rectangle2D2 = rectangle2D;
                }
            }
        }
        return new TexturePaint(bufferedImage, rectangle2D2);
    }

    protected GradientPaint makeGradientPaint(Color color, Color color2, Rectangle2D rectangle2D) {
        Point2D.Double double_;
        Point2D.Double double_2;
        double d2 = rectangle2D.getX();
        double d3 = rectangle2D.getY();
        double d4 = rectangle2D.getWidth();
        double d5 = rectangle2D.getHeight();
        if (this.gradientStyle == 0) {
            double_2 = new Point2D.Double(d2, d3);
            double_ = new Point2D.Double(d2 + d4, d3);
        } else if (this.gradientStyle == 1) {
            double_2 = new Point2D.Double(d2, d3);
            double_ = new Point2D.Double(d2, d3 + d5);
        } else if (this.gradientStyle == 2) {
            double_2 = new Point2D.Double(d2, d3 + d5);
            double_ = new Point2D.Double(d2 + d4, d3);
        } else if (this.gradientStyle == 3) {
            double_2 = new Point2D.Double(d2, d3);
            double_ = new Point2D.Double(d2 + d4, d3 + d5);
        } else if (this.gradientStyle == 4) {
            double_2 = new Point2D.Double(d2, d3);
            double_ = new Point2D.Double(d2 + d4 / 2.0, d3);
        } else if (this.gradientStyle == 5) {
            double_2 = new Point2D.Double(d2, d3);
            double_ = new Point2D.Double(d2, d3 + d5 / 2.0);
        } else if (this.gradientStyle == 6) {
            double_2 = new Point2D.Double(d2, d3 + d5);
            double_ = new Point2D.Double(d2 + d4 / 2.0, d3 + d5 / 2.0);
        } else if (this.gradientStyle == 7) {
            double_2 = new Point2D.Double(d2, d3);
            double_ = new Point2D.Double(d2 + d4 / 2.0, d3 + d5 / 2.0);
        } else if (this.gradientStyle == 8) {
            double_2 = new Point2D.Double(d2, d3);
            double_ = new Point2D.Double(d2 + (double)this.ribbonSize, d3);
        } else if (this.gradientStyle == 9) {
            double_2 = new Point2D.Double(d2, d3);
            double_ = new Point2D.Double(d2, d3 + (double)this.ribbonSize);
        } else if (this.gradientStyle == 10) {
            double_2 = new Point2D.Double(d2, d3 + d5);
            double_ = new Point2D.Double(d2 + (double)this.ribbonSize, d3 + d5 - (double)this.ribbonSize);
        } else if (this.gradientStyle == 11) {
            double_2 = new Point2D.Double(d2, d3);
            double_ = new Point2D.Double(d2 + (double)this.ribbonSize, d3 + (double)this.ribbonSize);
        } else {
            String string = "Illegal Gradient Style Value";
            throw new IllegalArgumentException(LocaleBundle.string(string));
        }
        return new GradientPaint(double_2, color, double_, color2, true);
    }

    public void setGradientPaint(Color color, Color color2, int n2) {
        if (color != null) {
            this.color = color;
        }
        if (color2 != null) {
            this.backgroundColor = color2;
        }
        if (this.pattern != 11 && this.pattern != 12 && this.pattern != 13) {
            this.buffImage = this.makeBufferedImage();
            this.fillPaint = null;
            this.hiFillPaint = null;
            this.shFillPaint = null;
        }
        this.setGradientStyle(n2);
    }

    public int getRibbonSize() {
        return this.ribbonSize;
    }

    public void setRibbonSize(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("Ribbon size must be positive");
        }
        this.ribbonSize = n2;
        this.setChanged(true, 17);
    }

    public int getGradientStyle() {
        return this.gradientStyle;
    }

    public void setGradientStyle(int n2) {
        this.gradientStyle = this.checkGradientStyle(n2);
        this.setChanged(true, 17);
    }

    public boolean isCustomStackable() {
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        JCFillStyle jCFillStyle = (JCFillStyle)super.clone();
        jCFillStyle.setColor(this.color);
        jCFillStyle.setPattern(this.pattern);
        jCFillStyle.setBackground(this.backgroundColor);
        jCFillStyle.colorIndex = this.getColorIndex();
        if (this.customPaint != null) {
            jCFillStyle.setCustomPaint(this.getCustomPaint());
        }
        if (this.image != null) {
            jCFillStyle.setImage(this.image);
        }
        if (this.outputProperties != null) {
            OutputProperties outputProperties = new OutputProperties(this.outputProperties.getPropertyName(), this.outputProperties.getFileAccess());
            outputProperties.setOutputFileName(this.outputProperties.getOutputFileName());
            outputProperties.setSaveType(this.outputProperties.getSaveType());
            jCFillStyle.setOutputProperties(outputProperties);
        }
        jCFillStyle.setRibbonSize(this.ribbonSize);
        jCFillStyle.setGradientStyle(this.gradientStyle);
        jCFillStyle.setImageLayoutHint(this.imageLayoutHint);
        jCFillStyle.setFillOrientation(this.orientation);
        jCFillStyle.updateAnchorRect(this.anchorRect);
        jCFillStyle.setImagePosition(this.imagePosition);
        jCFillStyle.setFillCorrection(this.fillCorrection);
        return jCFillStyle;
    }

    protected void setChanged(boolean bl, int n2) {
        if (this.parent instanceof Changeable) {
            ((Changeable)this.parent).setChanged(bl, n2);
        }
    }

    private boolean equalColors(Color color, Color color2) {
        return color == null ? color2 == null : color.equals(color2);
    }

    private int[] getPixels(Image image) {
        int[] nArray = null;
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            nArray = bufferedImage.getRGB(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null, 0, bufferedImage.getWidth());
        }
        return nArray;
    }

    private boolean equalImages(Image image, Image image2) {
        boolean bl = false;
        if (image == null) {
            if (image2 == null) {
                bl = true;
            }
        } else if (image2 != null) {
            bl = image instanceof BufferedImage && image2 instanceof BufferedImage ? Arrays.equals(this.getPixels(image), this.getPixels(image2)) : image.equals(image2);
        }
        return bl;
    }

    public boolean equals(Object object) {
        JCFillStyle jCFillStyle;
        boolean bl = false;
        if (object != null && object.getClass().equals(this.getClass()) && (this == (jCFillStyle = (JCFillStyle)object) || jCFillStyle.getPattern() == this.pattern && jCFillStyle.getGradientStyle() == this.gradientStyle && jCFillStyle.getColorIndex() == this.colorIndex && jCFillStyle.getRibbonSize() == this.ribbonSize && jCFillStyle.getFillOrientation() == this.orientation && jCFillStyle.getFillCorrection() == this.fillCorrection && jCFillStyle.getImageLayoutHint() == this.imageLayoutHint && jCFillStyle.getImagePosition().equals(this.imagePosition) && this.equalImages(this.image, jCFillStyle.getImage()) && this.equalColors(this.color, jCFillStyle.getColor()) && this.equalColors(this.backgroundColor, jCFillStyle.getBackground()))) {
            bl = true;
        }
        return bl;
    }

    protected int imageHashCode(Image image) {
        int n2 = 0;
        if (image instanceof BufferedImage) {
            n2 = Arrays.hashCode(this.getPixels(image));
        }
        return n2;
    }

    public int hashCode() {
        int n2 = 17;
        int n3 = this.color == null ? 0 : this.color.hashCode();
        int n4 = this.backgroundColor == null ? 0 : this.backgroundColor.hashCode();
        n2 = 37 * n2 + this.pattern;
        n2 = 37 * n2 + this.gradientStyle;
        n2 = 37 * n2 + this.colorIndex;
        n2 = 37 * n2 + this.ribbonSize;
        n2 = 37 * n2 + this.orientation;
        n2 = 37 * n2 + this.fillCorrection;
        n2 = 37 * n2 + this.imageLayoutHint;
        n2 = 37 * n2 + n3;
        n2 = 37 * n2 + n4;
        n2 = 37 * n2 + this.imagePosition.hashCode();
        n2 = 37 * n2 + this.imageHashCode(this.image);
        return n2;
    }

    private void resetColorWithAlpha(Graphics graphics) {
        Color color = graphics.getColor();
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        Color color2 = new Color(n2, n3, n4, alpha);
        graphics.setColor(color2);
    }

    public static void setAlpha(int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > 255) {
            n2 = 255;
        }
        alpha = n2;
    }

    public static int getAlpha() {
        return alpha;
    }

    public static Color resetColorWithAlpha(Color color, int n2) {
        int n3 = color.getRed();
        int n4 = color.getGreen();
        int n5 = color.getBlue();
        return new Color(n3, n4, n5, n2);
    }
}

