/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.property;

import com.klg.jclass.util.property.JCBasePersistor;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public abstract class JCFilePersistor
extends JCBasePersistor {
    protected boolean outputCreated = false;
    protected DataOutputStream out = null;
    protected Writer writer = null;

    public JCFilePersistor(Object object, Object object2) throws IOException {
        super(object2);
        this.setOutputTarget(object);
    }

    public JCFilePersistor(String string, Object object) throws IOException {
        super(object);
        this.setOutputTarget(string);
    }

    public JCFilePersistor(OutputStream outputStream, Object object) throws IOException {
        super(object);
        this.setOutputTarget(outputStream);
    }

    protected void setOutputTarget(Object object) throws IOException {
        if (object instanceof String) {
            this.outputCreated = true;
            this.setOutputStream(new FileOutputStream((String)object));
        } else if (object instanceof OutputStream) {
            this.setOutputStream((OutputStream)object);
        } else if (object instanceof Writer) {
            this.setWriter((Writer)object);
        } else {
            throw new IllegalArgumentException("outputTarget must be one of String, OutputStream, or Writer");
        }
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public void setOutputStream(OutputStream outputStream) {
        if (outputStream == null) {
            throw new IllegalArgumentException("Outputstream cannot be null");
        }
        this.out = outputStream instanceof DataOutputStream ? (DataOutputStream)outputStream : new DataOutputStream(outputStream);
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setWriter(Writer writer) {
        if (writer == null) {
            throw new IllegalArgumentException("Writer cannot be null");
        }
        this.writer = writer;
    }

    public void dispose() {
        try {
            if (this.writer != null) {
                this.writer.flush();
            }
            if (this.out != null) {
                if (this.outputCreated) {
                    this.out.close();
                } else {
                    this.out.flush();
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.out = null;
        this.writer = null;
        this.outputCreated = false;
    }
}

