/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.legend;

import com.klg.jclass.util.label.JCLabel;
import com.klg.jclass.util.legend.JCGridLegend;
import com.klg.jclass.util.legend.JCLegend;
import com.klg.jclass.util.legend.JCLegendEvent;
import com.klg.jclass.util.legend.JCLegendListener;
import com.klg.jclass.util.legend.LegendComponentLayout;
import com.klg.jclass.util.legend.LegendComponentLayoutUser;
import com.klg.jclass.util.swing.JCMultiPanel;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JCLegendPanel
extends JPanel
implements LegendComponentLayoutUser,
Serializable {
    public static int componentOffset = 5;
    protected LegendComponentLayoutUser legendComponent = null;
    protected JCLegend legend = null;
    protected ArrayList<JCLegendListener> legendListenerList = null;
    protected JComponent header;
    protected JComponent footer;
    protected JCMultiPanel componentArea = null;
    protected Rectangle componentAreaLayoutHints = new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    protected Rectangle legendLayoutHints = new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    protected Rectangle headerLayoutHints = new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    protected Rectangle footerLayoutHints = new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);

    public JCLegendPanel() {
        this(JCMultiPanel.Orientation.HORIZONTAL);
    }

    public JCLegendPanel(JCMultiPanel.Orientation orientation) {
        this.setLayout(new LegendComponentLayout());
        this.componentArea = new JCMultiPanel(orientation, true);
        this.add(this.componentArea);
        this.header = new JCLabel();
        this.header.setVisible(false);
        this.add(this.header);
        this.footer = new JCLabel();
        this.footer.setVisible(false);
        this.add(this.footer);
        this.legend = new JCGridLegend();
        this.legend.setVisible(false);
        this.add(this.legend);
    }

    public void addComponent(LegendComponentLayoutUser legendComponentLayoutUser) {
        legendComponentLayoutUser.getLegend().setVisible(false);
        this.componentArea.add((JComponent)((Object)legendComponentLayoutUser));
        this.revalidate();
    }

    public void addComponent(String string, LegendComponentLayoutUser legendComponentLayoutUser) {
        legendComponentLayoutUser.getLegend().setVisible(false);
        this.componentArea.add(string, (JComponent)((Object)legendComponentLayoutUser));
        this.revalidate();
    }

    public void addComponent(LegendComponentLayoutUser legendComponentLayoutUser, int n2) {
        legendComponentLayoutUser.getLegend().setVisible(false);
        this.componentArea.add((JComponent)((Object)legendComponentLayoutUser), n2);
        this.revalidate();
    }

    public void removeComponent(int n2) {
        this.componentArea.remove(n2);
        if (this.componentArea.getComponentList().get(n2) == this.legendComponent) {
            this.legend = null;
            this.fireLegendEvent(JCLegendEvent.LegendEventType.REMOVED);
            this.legendComponent = null;
        }
        this.componentArea.invalidate();
        this.componentArea.validate();
        this.validate();
    }

    public void removeComponent(Component component) {
        this.componentArea.remove(component);
        if (component == this.legendComponent) {
            this.legend = null;
            this.fireLegendEvent(JCLegendEvent.LegendEventType.REMOVED);
            this.legendComponent = null;
        }
        this.componentArea.invalidate();
        this.componentArea.validate();
        this.validate();
    }

    public void removeAll() {
        this.componentArea.removeAll();
        super.removeAll();
        this.componentArea.invalidate();
        this.componentArea.validate();
        this.validate();
    }

    public void setShowLabels(boolean bl) {
        this.componentArea.setShowLabels(bl);
        this.revalidate();
    }

    public void setPrototypeLabel(JLabel jLabel) {
        this.componentArea.setPrototypeLabel(jLabel);
    }

    public void setLabelPosition(JCMultiPanel.LabelPosition labelPosition) {
        this.componentArea.setLabelPosition(labelPosition);
        this.revalidate();
    }

    protected void fireLegendEvent(JCLegendEvent.LegendEventType legendEventType) {
        if (this.legendListenerList != null) {
            for (JCLegendListener jCLegendListener : this.legendListenerList) {
                jCLegendListener.legendChanged(new JCLegendEvent(this, legendEventType, this.legend));
            }
        }
    }

    public void addLegendListener(JCLegendListener jCLegendListener) {
        if (this.legendListenerList == null) {
            this.legendListenerList = new ArrayList();
        }
        this.legendListenerList.add(jCLegendListener);
    }

    public void removeLegendListener(JCLegendListener jCLegendListener) {
        if (this.legendListenerList != null) {
            this.legendListenerList.remove(jCLegendListener);
        }
    }

    public int getDrawingAreaHeight() {
        int n2 = 0;
        Insets insets = this.getInsets();
        if (insets != null) {
            n2 = insets.top + insets.bottom;
        }
        return Math.max(0, this.getSize().height - n2);
    }

    public int getDrawingAreaWidth() {
        int n2 = 0;
        Insets insets = this.getInsets();
        if (insets != null) {
            n2 = insets.left + insets.right;
        }
        return Math.max(0, this.getSize().width - n2);
    }

    public JComponent getHeader() {
        return this.header;
    }

    public JComponent getFooter() {
        return this.footer;
    }

    public Rectangle getLayoutHints(JComponent jComponent) {
        if (jComponent == this.componentArea) {
            return this.componentAreaLayoutHints;
        }
        if (jComponent == this.legend) {
            return this.legendLayoutHints;
        }
        if (jComponent == this.header) {
            return this.headerLayoutHints;
        }
        if (jComponent == this.footer) {
            return this.footerLayoutHints;
        }
        return null;
    }

    public void setLayoutHints(JComponent jComponent, Rectangle rectangle) {
        if (jComponent == null) {
            return;
        }
        if (jComponent == this.componentArea) {
            this.componentAreaLayoutHints = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else if (jComponent == this.legend) {
            this.legendLayoutHints = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else if (jComponent == this.header) {
            this.headerLayoutHints = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else if (jComponent == this.footer) {
            this.footerLayoutHints = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        jComponent.invalidate();
        this.validate();
    }

    public JComponent getComponentArea() {
        return this.componentArea;
    }

    public JCLegend getLegend() {
        return this.legend;
    }

    public LegendComponentLayoutUser getLegendComponent() {
        return this.legendComponent;
    }

    public void setLegendComponent(LegendComponentLayoutUser legendComponentLayoutUser) {
        JCLegendEvent.LegendEventType legendEventType = JCLegendEvent.LegendEventType.NEW;
        if (this.legendComponent != null) {
            this.remove(this.legend);
            ((JComponent)((Object)legendComponentLayoutUser)).add(this.legend);
            this.legend.setVisible(false);
            legendEventType = JCLegendEvent.LegendEventType.CHANGED;
        }
        this.legendComponent = legendComponentLayoutUser;
        this.legend = legendComponentLayoutUser.getLegend();
        ((JComponent)((Object)legendComponentLayoutUser)).remove(this.legend);
        JCGridLegend jCGridLegend = new JCGridLegend();
        jCGridLegend.setUpLegendVariables();
        legendComponentLayoutUser.setLegend(jCGridLegend);
        this.add(this.legend);
        this.legend.setVisible(true);
        this.fireLegendEvent(legendEventType);
    }

    public void setLegend(JCLegend jCLegend) {
        this.remove(this.legend);
        this.legend = jCLegend;
        this.add(this.legend);
    }

    public void setHeader(JComponent jComponent) {
        if (jComponent == null) {
            return;
        }
        if (this.header != null) {
            this.remove(this.header);
        }
        this.header = jComponent;
        this.add(this.header);
        this.revalidate();
    }

    public void setFooter(JComponent jComponent) {
        if (jComponent == null) {
            return;
        }
        if (this.footer != null) {
            this.remove(this.footer);
        }
        this.footer = jComponent;
        this.add(this.footer);
        this.revalidate();
    }
}

